/*
 * Decompiled with CFR 0.152.
 */
package com.underlegendz.underactivity;

import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import com.underlegendz.library.R;
import com.underlegendz.underactivity.ActivityBuilder;
import com.underlegendz.underactivity.ActivityRender;
import com.underlegendz.underactivity.UnderActivityBind;
import java.util.UUID;

public abstract class UnderActivity
extends AppCompatActivity
implements UnderActivityBind {
    private final String DEFAULT_TAG = UUID.randomUUID().toString();
    private DrawerLayout mDrawerLayout;
    private Toolbar mToolbar;
    private TabLayout mTabLayout;
    private boolean goBackOnHome;

    protected void onCreate(Bundle savedInstanceState) {
        ActivityBuilder builder = new ActivityBuilder();
        builder = this.configureActivityBuilder(builder);
        ActivityRender.render(this, builder);
        super.onCreate(savedInstanceState);
    }

    protected Fragment getFragment() {
        return this.getFragment(this.DEFAULT_TAG);
    }

    protected Fragment getFragment(String tag) {
        if (this.getSupportFragmentManager() != null) {
            return this.getSupportFragmentManager().findFragmentByTag(tag);
        }
        return null;
    }

    protected void setFragment(Fragment fragment) {
        this.setFragment(fragment, this.DEFAULT_TAG, false);
    }

    protected void setFragment(Fragment fragment, boolean addToBackStack) {
        this.setFragment(fragment, this.DEFAULT_TAG, addToBackStack);
    }

    protected void setFragment(Fragment fragment, String tag) {
        this.setFragment(fragment, tag, false);
    }

    protected void setFragment(Fragment fragment, String tag, boolean addToBackStack) {
        if (fragment != null && this.getSupportFragmentManager() != null) {
            FragmentTransaction replaceTransaction = this.getSupportFragmentManager().beginTransaction();
            replaceTransaction.setTransition(0);
            replaceTransaction.replace(R.id.main_content, fragment, tag);
            if (addToBackStack) {
                replaceTransaction.addToBackStack(tag);
            }
            replaceTransaction.commit();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                if (this.goBackOnHome) {
                    this.onBackPressed();
                    return true;
                }
                if (this.mDrawerLayout == null) break;
                try {
                    this.mDrawerLayout.openDrawer(0x800003);
                }
                catch (IllegalArgumentException exceptionStart) {
                    try {
                        this.mDrawerLayout.openDrawer(0x800005);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public Toolbar getToolbar() {
        return this.mToolbar;
    }

    public DrawerLayout getDrawerLayout() {
        return this.mDrawerLayout;
    }

    public TabLayout getTabLayout() {
        return this.mTabLayout;
    }

    @Override
    public void bindDrawerLayout(DrawerLayout drawerLayout) {
        this.mDrawerLayout = drawerLayout;
    }

    @Override
    public void bindTabLayout(TabLayout tabLayout) {
        this.mTabLayout = tabLayout;
    }

    @Override
    public void bindToolbar(Toolbar toolbar) {
        this.mToolbar = toolbar;
    }

    boolean isGoBackOnHome() {
        return this.goBackOnHome;
    }

    @Override
    public void goBackOnHome(boolean back) {
        this.goBackOnHome = back;
    }

    protected abstract ActivityBuilder configureActivityBuilder(ActivityBuilder var1);
}

