/*
 * Created by Jose Fuentes on 9/12/17 17:31
 * Copyright (C) 2017
 *
 * Licensed under the Apache License, Version 2.0 (the "License"),
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.underlegendz.underactivity;

import android.support.design.widget.TabLayout;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.widget.Toolbar;

/**
 * If the activity passed to ActivityRender implement this interface it can receive the references
 * of activity components and bind then in class variables.
 */
public interface UnderActivityBind {
  void bindToolbar(Toolbar toolbar);
  void bindDrawerLayout(DrawerLayout drawerLayout);
  void bindTabLayout(TabLayout tabLayout);
  void goBackOnHome(boolean back);
}
