/*
 * Decompiled with CFR 0.152.
 */
package com.underlegendz.underactivity;

import android.os.Bundle;
import android.support.design.widget.NavigationView;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.underlegendz.library.R;

public abstract class UnderActivity
extends AppCompatActivity {
    private final String DEFAULT_TAG = "main_content";
    private NavigationView navigationView;
    private Toolbar toolbar;
    private View mainContent;
    private ViewGroup toolbarContent;
    private DrawerLayout drawerLayout;
    private boolean back;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Builder builder = new Builder();
        builder = this.configureActivityBuilder(builder);
        if (builder.enableToolbar && builder.enableDrawer) {
            this.configureToolbarDrawerActivity(builder);
        } else if (builder.enableToolbar) {
            this.configureToolbarActivity(builder);
        } else if (builder.enableDrawer) {
            this.configureDrawerActivity(builder);
        } else {
            this.configureActivity(builder);
        }
    }

    private void configureToolbarDrawerActivity(Builder builder) {
        this.setContentView(R.layout.underactivity_toolbar_drawer);
        this.bindActivity();
        this.configureDrawer(builder);
        this.configureToolbar(builder);
    }

    private void configureToolbarActivity(Builder builder) {
        this.setContentView(R.layout.underactivity_toolbar);
        this.bindActivity();
        this.configureToolbar(builder);
    }

    private void configureDrawerActivity(Builder builder) {
        this.setContentView(R.layout.underactivity_drawer);
        this.bindActivity();
        this.configureDrawer(builder);
        View customLayout = builder.contentLayoutResource != null ? this.getLayoutInflater().inflate(builder.contentLayoutResource.intValue(), (ViewGroup)this.drawerLayout, false) : builder.contentLayout;
        if (customLayout != null) {
            this.drawerLayout.removeView(this.mainContent);
            this.drawerLayout.addView(customLayout, 0);
        }
    }

    private void configureActivity(Builder builder) {
        if (builder.contentLayout != null) {
            this.setContentView(builder.contentLayout);
        } else if (builder.contentLayoutResource != null) {
            this.setContentView(builder.contentLayoutResource);
        } else {
            this.setContentView(R.layout.underactivity);
        }
    }

    private void configureDrawer(Builder builder) {
        View drawerCustomLayout = builder.drawerCustomLayoutResource != null ? this.getLayoutInflater().inflate(builder.drawerCustomLayoutResource.intValue(), (ViewGroup)this.drawerLayout, false) : builder.drawerCustomLayout;
        if (drawerCustomLayout != null) {
            this.drawerLayout.removeView((View)this.navigationView);
            this.drawerLayout.addView(drawerCustomLayout);
            DrawerLayout.LayoutParams lp = (DrawerLayout.LayoutParams)drawerCustomLayout.getLayoutParams();
            lp.gravity = 0x800003;
        } else {
            if (builder.drawerHeader != null) {
                this.navigationView.addHeaderView(builder.drawerHeader);
            } else if (builder.drawerHeaderResource != null) {
                this.navigationView.inflateHeaderView(builder.drawerHeaderResource.intValue());
            }
            if (builder.drawerMenuResource != null) {
                this.navigationView.inflateMenu(builder.drawerMenuResource.intValue());
            }
            if (builder.drawerBackgroundColor != null) {
                this.navigationView.setBackgroundColor(builder.drawerBackgroundColor.intValue());
            }
            if (builder.drawerOnNavigationItemSelectedListener != null) {
                this.navigationView.setNavigationItemSelectedListener(builder.drawerOnNavigationItemSelectedListener);
            }
        }
    }

    private void configureToolbar(Builder builder) {
        Toolbar customToolbar = builder.toolbarResource != null ? (Toolbar)this.getLayoutInflater().inflate(builder.toolbarResource.intValue(), this.toolbarContent, false) : builder.toolbar;
        if (customToolbar != null) {
            this.toolbarContent.removeView((View)this.toolbar);
            this.toolbarContent.addView((View)customToolbar, 0);
            this.toolbar = customToolbar;
        } else {
            if (builder.toolbarPopupTheme != null) {
                this.toolbar.setPopupTheme(builder.toolbarPopupTheme.intValue());
            }
            if (builder.toolbarBackgroundColor != null) {
                this.toolbar.setBackgroundColor(builder.toolbarBackgroundColor.intValue());
            }
        }
        View customLayout = builder.contentLayoutResource != null ? this.getLayoutInflater().inflate(builder.contentLayoutResource.intValue(), (ViewGroup)this.drawerLayout, false) : builder.contentLayout;
        if (customLayout != null) {
            this.toolbarContent.removeView(this.mainContent);
            this.toolbarContent.addView(customLayout);
        }
        this.setSupportActionBar(this.toolbar);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            if (builder.toolbarDrawerIcon != null) {
                ab.setHomeAsUpIndicator(builder.toolbarDrawerIcon.intValue());
                ab.setDisplayHomeAsUpEnabled(true);
            }
            if (builder.toolbarBack) {
                ab.setDisplayHomeAsUpEnabled(true);
                this.back = builder.toolbarBack;
            }
        }
    }

    protected Fragment getFragment() {
        return this.getFragment("main_content");
    }

    protected Fragment getFragment(String tag) {
        if (this.getSupportFragmentManager() != null) {
            return this.getSupportFragmentManager().findFragmentByTag(tag);
        }
        return null;
    }

    protected void setFragment(Fragment fragment) {
        this.setFragment(fragment, "main_content", false);
    }

    protected void setFragment(Fragment fragment, boolean addToBackStack) {
        this.setFragment(fragment, "main_content", addToBackStack);
    }

    protected void setFragment(Fragment fragment, String tag) {
        this.setFragment(fragment, tag, false);
    }

    protected void setFragment(Fragment fragment, String tag, boolean addToBackStack) {
        if (fragment != null && this.getSupportFragmentManager() != null) {
            FragmentTransaction replaceTransaction = this.getSupportFragmentManager().beginTransaction();
            replaceTransaction.setTransition(0);
            replaceTransaction.replace(R.id.main_content, fragment, tag);
            if (addToBackStack) {
                replaceTransaction.addToBackStack(tag);
            }
            replaceTransaction.commit();
        }
    }

    private void bindActivity() {
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.navigationView = (NavigationView)this.findViewById(R.id.nav_view);
        this.mainContent = this.findViewById(R.id.main_content);
        this.drawerLayout = (DrawerLayout)this.findViewById(R.id.drawer_content);
        this.toolbarContent = (ViewGroup)this.findViewById(R.id.toolbar_content);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                if (this.back) {
                    this.onBackPressed();
                    return true;
                }
                if (this.drawerLayout == null) break;
                this.drawerLayout.openDrawer(0x800003);
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public DrawerLayout getDrawerLayout() {
        return this.drawerLayout;
    }

    protected abstract Builder configureActivityBuilder(Builder var1);

    protected static class Builder {
        private boolean enableToolbar = false;
        private boolean enableDrawer = false;
        private View contentLayout = null;
        private Integer contentLayoutResource = null;
        private View drawerCustomLayout = null;
        private Integer drawerCustomLayoutResource = null;
        private View drawerHeader = null;
        private Integer drawerHeaderResource = null;
        private Integer drawerMenuResource = null;
        private Integer drawerBackgroundColor = null;
        private NavigationView.OnNavigationItemSelectedListener drawerOnNavigationItemSelectedListener;
        private Toolbar toolbar = null;
        private Integer toolbarResource = null;
        private Integer toolbarPopupTheme = null;
        private Integer toolbarBackgroundColor = null;
        private Integer toolbarDrawerIcon = null;
        private boolean toolbarBack = false;

        protected Builder() {
        }

        public Builder enableToolbar(boolean enableToolbar) {
            this.enableToolbar = enableToolbar;
            return this;
        }

        public Builder enableDrawer(boolean enableDrawer) {
            this.enableDrawer = enableDrawer;
            return this;
        }

        public Builder setContentLayout(View contentLayout) {
            this.contentLayout = contentLayout;
            this.contentLayoutResource = null;
            return this;
        }

        public Builder setContentLayoutResource(Integer contentLayoutResource) {
            this.contentLayoutResource = contentLayoutResource;
            this.contentLayout = null;
            return this;
        }

        public Builder setDrawerCustomLayout(View drawerCustomLayout) {
            this.drawerCustomLayout = drawerCustomLayout;
            this.drawerCustomLayoutResource = null;
            this.drawerHeader = null;
            this.drawerHeaderResource = null;
            this.drawerMenuResource = null;
            this.drawerOnNavigationItemSelectedListener = null;
            this.enableDrawer = true;
            return this;
        }

        public Builder setDrawerCustomLayoutResource(Integer drawerCustomLayoutResource) {
            this.drawerCustomLayoutResource = drawerCustomLayoutResource;
            this.drawerCustomLayout = null;
            this.drawerHeader = null;
            this.drawerHeaderResource = null;
            this.drawerMenuResource = null;
            this.drawerOnNavigationItemSelectedListener = null;
            this.enableDrawer = true;
            return this;
        }

        public Builder setDrawerHeader(View drawerHeader) {
            this.drawerHeader = drawerHeader;
            this.drawerHeaderResource = null;
            this.drawerCustomLayout = null;
            this.drawerCustomLayoutResource = null;
            this.enableDrawer = true;
            return this;
        }

        public Builder setDrawerHeaderResource(Integer drawerHeaderResource) {
            this.drawerHeaderResource = drawerHeaderResource;
            this.drawerHeader = null;
            this.drawerCustomLayout = null;
            this.drawerCustomLayoutResource = null;
            this.enableDrawer = true;
            return this;
        }

        public Builder setDrawerMenuResource(Integer drawerMenuResource) {
            this.drawerMenuResource = drawerMenuResource;
            this.drawerCustomLayout = null;
            this.drawerCustomLayoutResource = null;
            this.enableDrawer = true;
            return this;
        }

        public Builder setDrawerBackgroundColor(Integer drawerBackgroundColor) {
            this.drawerBackgroundColor = drawerBackgroundColor;
            this.drawerCustomLayout = null;
            this.drawerCustomLayoutResource = null;
            this.enableDrawer = true;
            return this;
        }

        public Builder setDrawerOnNavigationItemSelectedListener(NavigationView.OnNavigationItemSelectedListener drawerOnNavigationItemSelectedListener) {
            this.drawerOnNavigationItemSelectedListener = drawerOnNavigationItemSelectedListener;
            this.drawerCustomLayout = null;
            this.drawerCustomLayoutResource = null;
            this.enableDrawer = true;
            return this;
        }

        public Builder setToolbar(Toolbar toolbar) {
            this.toolbar = toolbar;
            this.toolbarResource = null;
            this.enableToolbar = true;
            return this;
        }

        public Builder setToolbarResource(Integer toolbarResource) {
            this.toolbarResource = toolbarResource;
            this.toolbar = null;
            this.enableToolbar = true;
            return this;
        }

        public Builder setToolbarPopupTheme(Integer toolbarPopupTheme) {
            this.toolbarPopupTheme = toolbarPopupTheme;
            this.enableToolbar = true;
            return this;
        }

        public Builder setToolbarBackgroundColor(Integer toolbarBackgroundColor) {
            this.toolbarBackgroundColor = toolbarBackgroundColor;
            this.enableToolbar = true;
            return this;
        }

        public Builder setToolbarDrawerIcon(Integer toolbarDrawerIcon) {
            this.toolbarDrawerIcon = toolbarDrawerIcon;
            this.enableDrawer = true;
            this.enableToolbar = true;
            return this;
        }

        public Builder setToolbarBack(boolean toolbarBack) {
            this.toolbarBack = toolbarBack;
            this.enableToolbar = true;
            return this;
        }
    }
}

