/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class IdentifyUniqueAttributeConflicts
extends LDAPCommandLineTool
implements SearchResultListener {
    private static final String BEHAVIOR_UNIQUE_WITHIN_ATTR = "unique-within-each-attribute";
    private static final String BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME = "unique-across-all-attributes-including-in-same-entry";
    private static final String BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME = "unique-across-all-attributes-except-in-same-entry";
    private static final long serialVersionUID = -7904414224384249176L;
    private final AtomicLong entriesExamined = new AtomicLong(0L);
    private boolean allowConflictsInSameEntry = false;
    private boolean uniqueAcrossAttributes = false;
    private DNArgument baseDNArgument = null;
    private IntegerArgument pageSizeArgument = null;
    private LDAPConnection findConflictsConnection = null;
    private final Map<String, AtomicLong> conflictCounts = new TreeMap<String, AtomicLong>();
    private String[] attributes = null;
    private String[] baseDNs = null;
    private StringArgument attributeArgument = null;
    private StringArgument multipleAttributeBehaviorArgument = null;

    public static void main(String ... args) {
        ResultCode resultCode = IdentifyUniqueAttributeConflicts.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        IdentifyUniqueAttributeConflicts tool = new IdentifyUniqueAttributeConflicts(outStream, errStream);
        return tool.runTool(args);
    }

    public IdentifyUniqueAttributeConflicts(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "identify-unique-attribute-conflicts";
    }

    @Override
    public String getToolDescription() {
        return "This tool may be used to identify unique attribute conflicts.  That is, it may identify values of one or more attributes which are supposed to exist only in a single entry but are found in multiple entries.";
    }

    @Override
    public String getToolVersion() {
        return "2.3.7";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        String description = "The search base DN(s) to use to find entries with attributes for which to find uniqueness conflicts.  At least one base DN must be specified.";
        this.baseDNArgument = new DNArgument(Character.valueOf('b'), "baseDN", true, 0, "{dn}", description);
        parser.addArgument(this.baseDNArgument);
        description = "The attribute(s) for which to find missing references.  At least one attribute must be specified, and each attribute must be indexed for equality searches and have values which are DNs.";
        this.attributeArgument = new StringArgument(Character.valueOf('A'), "attribute", true, 0, "{attr}", description);
        parser.addArgument(this.attributeArgument);
        description = "Indicates the behavior to exhibit if multiple unique attributes are provided.  Allowed values are 'unique-within-each-attribute' (indicates that each value only needs to be unique within its own attribute type), 'unique-across-all-attributes-including-in-same-entry' (indicates that each value needs to be unique across all of the specified attributes), and 'unique-across-all-attributes-except-in-same-entry' (indicates each value needs to be unique across all of the specified attributes, except that multiple attributes in the same entry are allowed to share the same value).";
        LinkedHashSet<String> allowedValues = new LinkedHashSet<String>(3);
        allowedValues.add(BEHAVIOR_UNIQUE_WITHIN_ATTR);
        allowedValues.add(BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME);
        allowedValues.add(BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME);
        this.multipleAttributeBehaviorArgument = new StringArgument(Character.valueOf('m'), "multipleAttributeBehavior", false, 1, "{behavior}", description, allowedValues, BEHAVIOR_UNIQUE_WITHIN_ATTR);
        parser.addArgument(this.multipleAttributeBehaviorArgument);
        description = "The maximum number of entries to retrieve at a time when attempting to find entries with references to other entries.  This requires that the authenticated user have permission to use the simple paged results control, but it can avoid problems with the server sending entries too quickly for the client to handle.  By default, the simple paged results control will not be used.";
        this.pageSizeArgument = new IntegerArgument(Character.valueOf('z'), "simplePageSize", false, 1, "{num}", description, 1, Integer.MAX_VALUE);
        parser.addArgument(this.pageSizeArgument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultCode doToolProcessing() {
        ResultCode resultCode;
        LDAPConnection findUniqueAttributesConnection;
        block27: {
            block26: {
                List<String> attrList;
                block25: {
                    block28: {
                        attrList = this.attributeArgument.getValues();
                        String multiAttrBehavior = this.multipleAttributeBehaviorArgument.getValue();
                        if (attrList.size() <= 1) break block28;
                        if (multiAttrBehavior.equalsIgnoreCase(BEHAVIOR_UNIQUE_ACROSS_ATTRS_INCLUDING_SAME)) {
                            this.uniqueAcrossAttributes = true;
                            this.allowConflictsInSameEntry = false;
                            break block25;
                        } else if (multiAttrBehavior.equalsIgnoreCase(BEHAVIOR_UNIQUE_ACROSS_ATTRS_EXCEPT_SAME)) {
                            this.uniqueAcrossAttributes = true;
                            this.allowConflictsInSameEntry = true;
                            break block25;
                        } else {
                            this.uniqueAcrossAttributes = false;
                            this.allowConflictsInSameEntry = true;
                        }
                        break block25;
                    }
                    this.uniqueAcrossAttributes = false;
                    this.allowConflictsInSameEntry = true;
                }
                List<DN> dnList = this.baseDNArgument.getValues();
                this.baseDNs = new String[dnList.size()];
                for (int i = 0; i < this.baseDNs.length; ++i) {
                    this.baseDNs[i] = dnList.get(i).toString();
                }
                try {
                    findUniqueAttributesConnection = this.getConnection();
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.err("Unable to establish a connection to the directory server:  ", StaticUtils.getExceptionMessage(le));
                    return le.getResultCode();
                }
                try {
                    Filter filter;
                    try {
                        this.findConflictsConnection = this.getConnection();
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.err("Unable to establish a connection to the directory server:  ", StaticUtils.getExceptionMessage(le));
                        ResultCode resultCode2 = le.getResultCode();
                        Object var17_12 = null;
                        findUniqueAttributesConnection.close();
                        if (this.findConflictsConnection == null) return resultCode2;
                        this.findConflictsConnection.close();
                        return resultCode2;
                    }
                    this.attributes = new String[attrList.size()];
                    attrList.toArray(this.attributes);
                    if (this.attributes.length == 1) {
                        filter = Filter.createPresenceFilter(this.attributes[0]);
                        this.conflictCounts.put(this.attributes[0], new AtomicLong(0L));
                    } else {
                        Filter[] orComps = new Filter[this.attributes.length];
                        for (int i = 0; i < this.attributes.length; ++i) {
                            orComps[i] = Filter.createPresenceFilter(this.attributes[i]);
                            this.conflictCounts.put(this.attributes[i], new AtomicLong(0L));
                        }
                        filter = Filter.createORFilter(orComps);
                    }
                    for (String baseDN : this.baseDNs) {
                        ASN1OctetString cookie = null;
                        do {
                            SimplePagedResultsControl pagedResultsResponse;
                            SearchResult searchResult;
                            SearchRequest searchRequest = new SearchRequest((SearchResultListener)this, baseDN, SearchScope.SUB, filter, this.attributes);
                            if (this.pageSizeArgument.isPresent()) {
                                searchRequest.addControl(new SimplePagedResultsControl(this.pageSizeArgument.getValue(), cookie, false));
                            }
                            try {
                                searchResult = findUniqueAttributesConnection.search(searchRequest);
                            }
                            catch (LDAPSearchException lse) {
                                Debug.debugException(lse);
                                searchResult = lse.getSearchResult();
                            }
                            if (searchResult.getResultCode() != ResultCode.SUCCESS) {
                                this.err("An error occurred while attempting to search for unique attributes in entries below " + baseDN + ":  " + searchResult.getDiagnosticMessage());
                                ResultCode lse = searchResult.getResultCode();
                                Object var17_13 = null;
                                findUniqueAttributesConnection.close();
                                if (this.findConflictsConnection == null) return lse;
                                this.findConflictsConnection.close();
                                return lse;
                            }
                            try {
                                pagedResultsResponse = SimplePagedResultsControl.get(searchResult);
                            }
                            catch (LDAPException le) {
                                Debug.debugException(le);
                                this.err("An error occurred while attempting to decode a simple paged results response control in the response to a search for entries below " + baseDN + ":  " + StaticUtils.getExceptionMessage(le));
                                ResultCode resultCode3 = le.getResultCode();
                                Object var17_14 = null;
                                findUniqueAttributesConnection.close();
                                if (this.findConflictsConnection == null) return resultCode3;
                                this.findConflictsConnection.close();
                                return resultCode3;
                            }
                            if (pagedResultsResponse == null) continue;
                            cookie = pagedResultsResponse.moreResultsToReturn() ? pagedResultsResponse.getCookie() : null;
                        } while (cookie != null);
                    }
                    boolean conflictFound = false;
                    for (Map.Entry<String, AtomicLong> e : this.conflictCounts.entrySet()) {
                        long numConflicts = e.getValue().get();
                        if (numConflicts <= 0L) continue;
                        if (!conflictFound) {
                            this.err(new Object[0]);
                            conflictFound = true;
                        }
                        this.err("Found " + numConflicts + " unique value conflicts in attribute " + e.getKey());
                    }
                    if (conflictFound) {
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        break block26;
                    }
                    this.out("No unique attribute conflicts were found.");
                    resultCode = ResultCode.SUCCESS;
                    break block27;
                }
                catch (Throwable throwable) {
                    Object var17_17 = null;
                    findUniqueAttributesConnection.close();
                    if (this.findConflictsConnection == null) throw throwable;
                    this.findConflictsConnection.close();
                    throw throwable;
                }
            }
            Object var17_15 = null;
            findUniqueAttributesConnection.close();
            if (this.findConflictsConnection == null) return resultCode;
            this.findConflictsConnection.close();
            return resultCode;
        }
        Object var17_16 = null;
        findUniqueAttributesConnection.close();
        if (this.findConflictsConnection == null) return resultCode;
        this.findConflictsConnection.close();
        return resultCode;
    }

    public Map<String, AtomicLong> getConflictCounts() {
        return Collections.unmodifiableMap(this.conflictCounts);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=john.doe,ou=People,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--attribute", "uid", "--simplePageSize", "100"};
        exampleMap.put(args, "Identify any values of the uid attribute that are not unique across all entries below dc=example,dc=com.");
        return exampleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        block25: {
            block22: {
                block23: {
                    block26: {
                        try {
                            if (this.allowConflictsInSameEntry) ** GOTO lbl16
                            conflictFound = false;
                            i = 0;
lbl5:
                            // 2 sources

                            while (true) {
                                if (i < this.attributes.length) {
                                    l1 = searchEntry.getAttributesWithOptions(this.attributes[i], null);
                                    if (l1 == null) break block22;
                                    break block23;
                                }
                                if (conflictFound) {
                                    var23_19 = null;
                                    count = this.entriesExamined.incrementAndGet();
                                    if (count % 1000L != 0L) return;
                                    break;
                                }
lbl16:
                                // 4 sources

                                block7: for (String attrName : this.attributes) {
                                    attrList = searchEntry.getAttributesWithOptions(attrName, null);
                                    i$ = attrList.iterator();
                                    while (true) {
                                        if (!i$.hasNext()) continue block7;
                                        a = i$.next();
                                        arr$ = a.getValues();
                                        len$ = arr$.length;
                                        i$ = 0;
                                        break block25;
                                        break;
                                    }
                                }
                                break block26;
                                break;
                            }
                        }
                        catch (Throwable var22_33) {
                            var23_21 = null;
                            count = this.entriesExamined.incrementAndGet();
                            if (count % 1000L != 0L) throw var22_33;
                            this.out(new Object[]{count, " entries examined"});
                            throw var22_33;
                        }
                        this.out(new Object[]{count, " entries examined"});
                        return;
                    }
                    var23_20 = null;
                    count = this.entriesExamined.incrementAndGet();
                    if (count % 1000L != 0L) return;
                    this.out(new Object[]{count, " entries examined"});
                    return;
                }
                for (j = i + 1; j < this.attributes.length; ++j) {
                    l2 = searchEntry.getAttributesWithOptions(this.attributes[j], null);
                    if (l2 == null) continue;
                    for (Attribute a1 : l1) {
                        for (String value : a1.getValues()) {
                            for (Attribute a2 : l2) {
                                if (!a2.hasValue(value)) continue;
                                this.err(new Object[]{"Value '", value, "' in attribute ", a1.getName(), " of entry '", searchEntry.getDN(), " is also present in attribute ", a2.getName(), " of the same entry."});
                                conflictFound = true;
                                this.conflictCounts.get(this.attributes[i]).incrementAndGet();
                            }
                        }
                    }
                }
            }
            ++i;
            ** while (true)
        }
        while (true) {
            if (i$ >= len$) ** continue;
            value = arr$[i$];
            if (this.uniqueAcrossAttributes) {
                orComps = new Filter[this.attributes.length];
                for (i = 0; i < this.attributes.length; ++i) {
                    orComps[i] = Filter.createEqualityFilter(this.attributes[i], value);
                }
                filter = Filter.createORFilter(orComps);
            } else {
                filter = Filter.createEqualityFilter(attrName, value);
            }
            block15: for (String baseDN : this.baseDNs) {
                try {
                    searchResult = this.findConflictsConnection.search(baseDN, SearchScope.SUB, DereferencePolicy.NEVER, 2, 0, false, filter, new String[]{"1.1"});
                }
                catch (LDAPSearchException lse) {
                    Debug.debugException(lse);
                    searchResult = lse.getSearchResult();
                }
                for (SearchResultEntry e : searchResult.getSearchEntries()) {
                    try {
                        if (DN.equals(searchEntry.getDN(), e.getDN())) {
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        Debug.debugException(ex);
                    }
                    this.err(new Object[]{"Value '", value, "' in attribute ", a.getName(), " of entry '" + searchEntry.getDN(), "' is also present in entry '", e.getDN(), "'."});
                    this.conflictCounts.get(attrName).incrementAndGet();
                    break block15;
                }
                if (searchResult.getResultCode() == ResultCode.SUCCESS) continue;
                this.err(new Object[]{"An error occurred while attempting to search for conflicts with " + a.getName() + " value '" + value + "' (as found in entry '" + searchEntry.getDN() + "') below '" + baseDN + "':  " + searchResult.getDiagnosticMessage()});
                this.conflictCounts.get(attrName).incrementAndGet();
                break;
            }
            ++i$;
        }
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
    }
}

