/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLHelper;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GSSAPIBindRequest
extends SASLBindRequest
implements CallbackHandler,
PrivilegedExceptionAction<Object> {
    public static final String GSSAPI_MECHANISM_NAME = "GSSAPI";
    private static final String PROPERTY_KDC_ADDRESS = "java.security.krb5.kdc";
    private static final String PROPERTY_REALM = "java.security.krb5.realm";
    private static final String PROPERTY_CONFIG_FILE = "java.security.auth.login.config";
    private static final String PROPERTY_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final String DEFAULT_CONFIG_FILE = System.getProperty("java.security.auth.login.config");
    private static final String DEFAULT_KDC_ADDRESS = System.getProperty("java.security.krb5.kdc");
    private static final String DEFAULT_REALM = System.getProperty("java.security.krb5.realm");
    private static final long serialVersionUID = 2511890818146955112L;
    private final ASN1OctetString password;
    private final AtomicReference<LDAPConnection> conn;
    private final boolean enableGSSAPIDebugging;
    private final boolean renewTGT;
    private final boolean requireCachedCredentials;
    private final boolean useSubjectCredentialsOnly;
    private final boolean useTicketCache;
    private int messageID;
    private final List<SASLQualityOfProtection> allowedQoP;
    private final List<String> unhandledCallbackMessages;
    private Set<String> suppressedSystemProperties;
    private final String authenticationID;
    private final String authorizationID;
    private final String configFilePath;
    private final String jaasClientName;
    private final String kdcAddress;
    private final String realm;
    private final String saslClientServerName;
    private final String servicePrincipalProtocol;
    private final String ticketCachePath;

    public GSSAPIBindRequest(String authenticationID, String password) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, byte[] password) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String password, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), controls);
    }

    public GSSAPIBindRequest(String authenticationID, byte[] password, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), controls);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, String password, String realm, String kdcAddress, String configFilePath) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, byte[] password, String realm, String kdcAddress, String configFilePath) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, String password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), controls);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, byte[] password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), controls);
    }

    public GSSAPIBindRequest(GSSAPIBindRequestProperties gssapiProperties, Control ... controls) throws LDAPException {
        super(controls);
        Validator.ensureNotNull(gssapiProperties);
        this.authenticationID = gssapiProperties.getAuthenticationID();
        this.password = gssapiProperties.getPassword();
        this.realm = gssapiProperties.getRealm();
        this.allowedQoP = gssapiProperties.getAllowedQoP();
        this.kdcAddress = gssapiProperties.getKDCAddress();
        this.jaasClientName = gssapiProperties.getJAASClientName();
        this.saslClientServerName = gssapiProperties.getSASLClientServerName();
        this.servicePrincipalProtocol = gssapiProperties.getServicePrincipalProtocol();
        this.enableGSSAPIDebugging = gssapiProperties.enableGSSAPIDebugging();
        this.useSubjectCredentialsOnly = gssapiProperties.useSubjectCredentialsOnly();
        this.useTicketCache = gssapiProperties.useTicketCache();
        this.requireCachedCredentials = gssapiProperties.requireCachedCredentials();
        this.renewTGT = gssapiProperties.renewTGT();
        this.ticketCachePath = gssapiProperties.getTicketCachePath();
        this.suppressedSystemProperties = gssapiProperties.getSuppressedSystemProperties();
        this.unhandledCallbackMessages = new ArrayList<String>(5);
        this.conn = new AtomicReference();
        this.messageID = -1;
        String authzID = gssapiProperties.getAuthorizationID();
        this.authorizationID = authzID == null ? null : authzID;
        String cfgPath = gssapiProperties.getConfigFilePath();
        this.configFilePath = cfgPath == null ? (DEFAULT_CONFIG_FILE == null ? GSSAPIBindRequest.getConfigFilePath(gssapiProperties) : DEFAULT_CONFIG_FILE) : cfgPath;
    }

    @Override
    public String getSASLMechanismName() {
        return GSSAPI_MECHANISM_NAME;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public String getPasswordString() {
        if (this.password == null) {
            return null;
        }
        return this.password.stringValue();
    }

    public byte[] getPasswordBytes() {
        if (this.password == null) {
            return null;
        }
        return this.password.getValue();
    }

    public String getRealm() {
        return this.realm;
    }

    public List<SASLQualityOfProtection> getAllowedQoP() {
        return this.allowedQoP;
    }

    public String getKDCAddress() {
        return this.kdcAddress;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public String getServicePrincipalProtocol() {
        return this.servicePrincipalProtocol;
    }

    public boolean useTicketCache() {
        return this.useTicketCache;
    }

    public boolean requireCachedCredentials() {
        return this.requireCachedCredentials;
    }

    public String getTicketCachePath() {
        return this.ticketCachePath;
    }

    public boolean renewTGT() {
        return this.renewTGT;
    }

    public Set<String> getSuppressedSystemProperties() {
        return this.suppressedSystemProperties;
    }

    public boolean enableGSSAPIDebugging() {
        return this.enableGSSAPIDebugging;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getConfigFilePath(GSSAPIBindRequestProperties properties) throws LDAPException {
        try {
            String string;
            File f = File.createTempFile("GSSAPIBindRequest-JAAS-Config-", ".conf");
            f.deleteOnExit();
            PrintWriter w = new PrintWriter(new FileWriter(f));
            try {
                block10: {
                    String string2;
                    try {
                        Class<?> sunModuleClass = Class.forName("com.sun.security.auth.module.Krb5LoginModule");
                        if (sunModuleClass == null) break block10;
                        GSSAPIBindRequest.writeSunJAASConfig(w, properties);
                        string2 = f.getAbsolutePath();
                    }
                    catch (ClassNotFoundException cnfe) {
                        Debug.debugException(cnfe);
                        break block10;
                    }
                    Object var6_10 = null;
                    w.close();
                    return string2;
                }
                try {
                    Class<?> ibmModuleClass = Class.forName("com.ibm.security.auth.module.Krb5LoginModule");
                    if (ibmModuleClass == null) throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(LDAPMessages.ERR_GSSAPI_NO_SUPPORTED_JAAS_MODULE.get()));
                    GSSAPIBindRequest.writeIBMJAASConfig(w, properties);
                    string = f.getAbsolutePath();
                }
                catch (ClassNotFoundException cnfe) {
                    Debug.debugException(cnfe);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(LDAPMessages.ERR_GSSAPI_NO_SUPPORTED_JAAS_MODULE.get()));
                }
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                w.close();
                throw throwable;
            }
            Object var6_11 = null;
            w.close();
            return string;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static void writeSunJAASConfig(PrintWriter w, GSSAPIBindRequestProperties p) {
        w.println(p.getJAASClientName() + " {");
        w.println("  com.sun.security.auth.module.Krb5LoginModule required");
        w.println("  client=true");
        if (p.useTicketCache()) {
            w.println("  useTicketCache=true");
            w.println("  renewTGT=" + p.renewTGT());
            w.println("  doNotPrompt=" + p.requireCachedCredentials());
            String ticketCachePath = p.getTicketCachePath();
            if (ticketCachePath != null) {
                w.println("  ticketCache=\"" + ticketCachePath + '\"');
            }
        } else {
            w.println("  useTicketCache=false");
        }
        if (p.enableGSSAPIDebugging()) {
            w.println(" debug=true");
        }
        w.println("  ;");
        w.println("};");
    }

    private static void writeIBMJAASConfig(PrintWriter w, GSSAPIBindRequestProperties p) {
        w.println(p.getJAASClientName() + " {");
        w.println("  com.ibm.security.auth.module.Krb5LoginModule required");
        w.println("  credsType=initiator");
        if (p.useTicketCache()) {
            String ticketCachePath = p.getTicketCachePath();
            if (ticketCachePath == null) {
                if (p.requireCachedCredentials()) {
                    w.println("  useDefaultCcache=true");
                }
            } else {
                File f = new File(ticketCachePath);
                String path = f.getAbsolutePath().replace('\\', '/');
                w.println("  useCcache=\"file://" + path + '\"');
            }
        } else {
            w.println("  useDefaultCcache=false");
        }
        if (p.enableGSSAPIDebugging()) {
            w.println(" debug=true");
        }
        w.println("  ;");
        w.println("};");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        Throwable throwable2;
        LoginContext context;
        if (!this.conn.compareAndSet(null, connection)) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_MULTIPLE_CONCURRENT_REQUESTS.get());
        }
        this.setProperty(PROPERTY_CONFIG_FILE, this.configFilePath);
        this.setProperty(PROPERTY_SUBJECT_CREDS_ONLY, String.valueOf(this.useSubjectCredentialsOnly));
        if (Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debug(Level.CONFIG, DebugType.LDAP, "Using config file property java.security.auth.login.config = '" + this.configFilePath + "'.");
            Debug.debug(Level.CONFIG, DebugType.LDAP, "Using subject creds only property javax.security.auth.useSubjectCredsOnly = '" + this.useSubjectCredentialsOnly + "'.");
        }
        if (this.kdcAddress == null) {
            if (DEFAULT_KDC_ADDRESS == null) {
                this.clearProperty(PROPERTY_KDC_ADDRESS);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.CONFIG, DebugType.LDAP, "Clearing kdcAddress property 'java.security.krb5.kdc'.");
                }
            } else {
                this.setProperty(PROPERTY_KDC_ADDRESS, DEFAULT_KDC_ADDRESS);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.CONFIG, DebugType.LDAP, "Using default kdcAddress property java.security.krb5.kdc = '" + DEFAULT_KDC_ADDRESS + "'.");
                }
            }
        } else {
            this.setProperty(PROPERTY_KDC_ADDRESS, this.kdcAddress);
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.CONFIG, DebugType.LDAP, "Using kdcAddress property java.security.krb5.kdc = '" + this.kdcAddress + "'.");
            }
        }
        if (this.realm == null) {
            if (DEFAULT_REALM == null) {
                this.clearProperty(PROPERTY_REALM);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.CONFIG, DebugType.LDAP, "Clearing realm property 'java.security.krb5.realm'.");
                }
            } else {
                this.setProperty(PROPERTY_REALM, DEFAULT_REALM);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.CONFIG, DebugType.LDAP, "Using default realm property java.security.krb5.realm = '" + DEFAULT_REALM + "'.");
                }
            }
        } else {
            this.setProperty(PROPERTY_REALM, this.realm);
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.CONFIG, DebugType.LDAP, "Using realm property java.security.krb5.realm = '" + this.realm + "'.");
            }
        }
        try {
            context = new LoginContext(this.jaasClientName, this);
            context.login();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_INITIALIZE_JAAS_CONTEXT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            BindResult e = (BindResult)Subject.doAs(context.getSubject(), this);
        }
        catch (Exception e) {
            try {
                Debug.debugException(e);
                if (!(e instanceof LDAPException)) throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_AUTHENTICATION_FAILED.get(StaticUtils.getExceptionMessage(e)), e);
                throw (LDAPException)e;
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                this.conn.set(null);
            }
        }
        Object var6_7 = null;
        this.conn.set(null);
        return e;
        throw throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InternalUseOnly
    public Object run() throws LDAPException {
        SaslClient saslClient;
        this.unhandledCallbackMessages.clear();
        LDAPConnection connection = this.conn.get();
        String[] mechanisms = new String[]{GSSAPI_MECHANISM_NAME};
        HashMap<String, String> saslProperties = new HashMap<String, String>(2);
        saslProperties.put("javax.security.sasl.qop", SASLQualityOfProtection.toString(this.allowedQoP));
        saslProperties.put("javax.security.sasl.server.authentication", "true");
        try {
            String serverName = this.saslClientServerName;
            if (serverName == null) {
                serverName = connection.getConnectedAddress();
            }
            saslClient = Sasl.createSaslClient(mechanisms, this.authorizationID, this.servicePrincipalProtocol, serverName, saslProperties, this);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_SASL_CLIENT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        SASLHelper helper = new SASLHelper(this, connection, GSSAPI_MECHANISM_NAME, saslClient, this.getControls(), this.getResponseTimeoutMillis(connection), this.unhandledCallbackMessages);
        try {
            BindResult bindResult = helper.processSASLBind();
            Object var8_8 = null;
            this.messageID = helper.getMessageID();
            return bindResult;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.messageID = helper.getMessageID();
            throw throwable;
        }
    }

    @Override
    public GSSAPIBindRequest getRebindRequest(String host, int port) {
        try {
            GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(this.authenticationID, this.authorizationID, this.password, this.realm, this.kdcAddress, this.configFilePath);
            gssapiProperties.setAllowedQoP(this.allowedQoP);
            gssapiProperties.setServicePrincipalProtocol(this.servicePrincipalProtocol);
            gssapiProperties.setUseTicketCache(this.useTicketCache);
            gssapiProperties.setRequireCachedCredentials(this.requireCachedCredentials);
            gssapiProperties.setRenewTGT(this.renewTGT);
            gssapiProperties.setUseSubjectCredentialsOnly(this.useSubjectCredentialsOnly);
            gssapiProperties.setTicketCachePath(this.ticketCachePath);
            gssapiProperties.setEnableGSSAPIDebugging(this.enableGSSAPIDebugging);
            gssapiProperties.setJAASClientName(this.jaasClientName);
            gssapiProperties.setSASLClientServerName(this.saslClientServerName);
            gssapiProperties.setSuppressedSystemProperties(this.suppressedSystemProperties);
            return new GSSAPIBindRequest(gssapiProperties, this.getControls());
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @InternalUseOnly
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.authenticationID);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (this.password == null) {
                    throw new UnsupportedCallbackException(callback, LDAPMessages.ERR_GSSAPI_NO_PASSWORD_AVAILABLE.get());
                }
                ((PasswordCallback)callback).setPassword(this.password.stringValue().toCharArray());
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                if (this.realm == null) {
                    this.unhandledCallbackMessages.add(LDAPMessages.ERR_GSSAPI_REALM_REQUIRED_BUT_NONE_PROVIDED.get(rc.getPrompt()));
                    continue;
                }
                rc.setText(this.realm);
                continue;
            }
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "Unexpected GSSAPI SASL callback of type " + callback.getClass().getName());
            }
            this.unhandledCallbackMessages.add(LDAPMessages.ERR_GSSAPI_UNEXPECTED_CALLBACK.get(callback.getClass().getName()));
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public GSSAPIBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public GSSAPIBindRequest duplicate(Control[] controls) {
        try {
            GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(this.authenticationID, this.authorizationID, this.password, this.realm, this.kdcAddress, this.configFilePath);
            gssapiProperties.setAllowedQoP(this.allowedQoP);
            gssapiProperties.setServicePrincipalProtocol(this.servicePrincipalProtocol);
            gssapiProperties.setUseTicketCache(this.useTicketCache);
            gssapiProperties.setRequireCachedCredentials(this.requireCachedCredentials);
            gssapiProperties.setRenewTGT(this.renewTGT);
            gssapiProperties.setUseSubjectCredentialsOnly(this.useSubjectCredentialsOnly);
            gssapiProperties.setTicketCachePath(this.ticketCachePath);
            gssapiProperties.setEnableGSSAPIDebugging(this.enableGSSAPIDebugging);
            gssapiProperties.setJAASClientName(this.jaasClientName);
            gssapiProperties.setSASLClientServerName(this.saslClientServerName);
            gssapiProperties.setSuppressedSystemProperties(this.suppressedSystemProperties);
            GSSAPIBindRequest bindRequest = new GSSAPIBindRequest(gssapiProperties, controls);
            bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
            return bindRequest;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    private void clearProperty(String name) {
        if (!this.suppressedSystemProperties.contains(name)) {
            System.clearProperty(name);
        }
    }

    private void setProperty(String name, String value) {
        if (!this.suppressedSystemProperties.contains(name)) {
            System.setProperty(name, value);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GSSAPIBindRequest(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.realm != null) {
            buffer.append(", realm='");
            buffer.append(this.realm);
            buffer.append('\'');
        }
        buffer.append(", qop='");
        buffer.append(SASLQualityOfProtection.toString(this.allowedQoP));
        buffer.append('\'');
        if (this.kdcAddress != null) {
            buffer.append(", kdcAddress='");
            buffer.append(this.kdcAddress);
            buffer.append('\'');
        }
        buffer.append(", jaasClientName='");
        buffer.append(this.jaasClientName);
        buffer.append("', configFilePath='");
        buffer.append(this.configFilePath);
        buffer.append("', servicePrincipalProtocol='");
        buffer.append(this.servicePrincipalProtocol);
        buffer.append("', enableGSSAPIDebugging=");
        buffer.append(this.enableGSSAPIDebugging);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

