/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFModifyDNChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = -2356367870035948998L;
    private final boolean deleteOldRDN;
    private volatile DN parsedNewSuperiorDN;
    private volatile RDN parsedNewRDN;
    private final String newRDN;
    private final String newSuperiorDN;

    public LDIFModifyDNChangeRecord(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN) {
        super(dn);
        Validator.ensureNotNull(newRDN);
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = newSuperiorDN;
    }

    public LDIFModifyDNChangeRecord(ModifyDNRequest modifyDNRequest) {
        super(modifyDNRequest.getDN());
        this.newRDN = modifyDNRequest.getNewRDN();
        this.deleteOldRDN = modifyDNRequest.deleteOldRDN();
        this.newSuperiorDN = modifyDNRequest.getNewSuperiorDN();
    }

    public String getNewRDN() {
        return this.newRDN;
    }

    public RDN getParsedNewRDN() throws LDAPException {
        if (this.parsedNewRDN == null) {
            this.parsedNewRDN = new RDN(this.newRDN);
        }
        return this.parsedNewRDN;
    }

    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public String getNewSuperiorDN() {
        return this.newSuperiorDN;
    }

    public DN getParsedNewSuperiorDN() throws LDAPException {
        if (this.parsedNewSuperiorDN == null && this.newSuperiorDN != null) {
            this.parsedNewSuperiorDN = new DN(this.newSuperiorDN);
        }
        return this.parsedNewSuperiorDN;
    }

    public DN getNewDN() throws LDAPException {
        if (this.newSuperiorDN == null) {
            DN parentDN = this.getParsedDN().getParent();
            if (parentDN == null) {
                return new DN(this.getParsedNewRDN());
            }
            return new DN(this.getParsedNewRDN(), parentDN);
        }
        return new DN(this.getParsedNewRDN(), this.getParsedNewSuperiorDN());
    }

    public ModifyDNRequest toModifyDNRequest() {
        return new ModifyDNRequest(this.getDN(), this.newRDN, this.deleteOldRDN, this.newSuperiorDN);
    }

    public ChangeType getChangeType() {
        return ChangeType.MODIFY_DN;
    }

    public LDAPResult processChange(LDAPInterface connection) throws LDAPException {
        return connection.modifyDN(this.toModifyDNRequest());
    }

    public String[] toLDIF(int wrapColumn) {
        List<String> ldifLines = this.newSuperiorDN == null ? Arrays.asList(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())), "changetype: moddn", LDIFWriter.encodeNameAndValue("newrdn", new ASN1OctetString(this.newRDN)), "deleteoldrdn: " + (this.deleteOldRDN ? "1" : "0")) : Arrays.asList(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())), "changetype: moddn", LDIFWriter.encodeNameAndValue("newrdn", new ASN1OctetString(this.newRDN)), "deleteoldrdn: " + (this.deleteOldRDN ? "1" : "0"), LDIFWriter.encodeNameAndValue("newsuperior", new ASN1OctetString(this.newSuperiorDN)));
        if (wrapColumn > 2) {
            ldifLines = LDIFWriter.wrapLines(wrapColumn, ldifLines);
        }
        String[] lineArray = new String[ldifLines.size()];
        return ldifLines.toArray(lineArray);
    }

    public void toLDIF(ByteStringBuffer buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("moddn"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        LDIFWriter.encodeNameAndValue("newrdn", new ASN1OctetString(this.newRDN), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        if (this.deleteOldRDN) {
            LDIFWriter.encodeNameAndValue("deleteoldrdn", new ASN1OctetString("1"), buffer, wrapColumn);
        } else {
            LDIFWriter.encodeNameAndValue("deleteoldrdn", new ASN1OctetString("0"), buffer, wrapColumn);
        }
        buffer.append(StaticUtils.EOL_BYTES);
        if (this.newSuperiorDN != null) {
            LDIFWriter.encodeNameAndValue("newsuperior", new ASN1OctetString(this.newSuperiorDN), buffer, wrapColumn);
            buffer.append(StaticUtils.EOL_BYTES);
        }
    }

    public void toLDIFString(StringBuilder buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("moddn"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        LDIFWriter.encodeNameAndValue("newrdn", new ASN1OctetString(this.newRDN), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        if (this.deleteOldRDN) {
            LDIFWriter.encodeNameAndValue("deleteoldrdn", new ASN1OctetString("1"), buffer, wrapColumn);
        } else {
            LDIFWriter.encodeNameAndValue("deleteoldrdn", new ASN1OctetString("0"), buffer, wrapColumn);
        }
        buffer.append(StaticUtils.EOL);
        if (this.newSuperiorDN != null) {
            LDIFWriter.encodeNameAndValue("newsuperior", new ASN1OctetString(this.newSuperiorDN), buffer, wrapColumn);
            buffer.append(StaticUtils.EOL);
        }
    }

    public int hashCode() {
        int hashCode;
        block4: {
            try {
                hashCode = this.getParsedDN().hashCode() + this.getParsedNewRDN().hashCode();
                if (this.newSuperiorDN != null) {
                    hashCode += this.getParsedNewSuperiorDN().hashCode();
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                hashCode = StaticUtils.toLowerCase(this.getDN()).hashCode() + StaticUtils.toLowerCase(this.newRDN).hashCode();
                if (this.newSuperiorDN == null) break block4;
                hashCode += StaticUtils.toLowerCase(this.newSuperiorDN).hashCode();
            }
        }
        if (this.deleteOldRDN) {
            ++hashCode;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        LDIFModifyDNChangeRecord r;
        block18: {
            block17: {
                block16: {
                    if (o == null) {
                        return false;
                    }
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LDIFModifyDNChangeRecord)) {
                        return false;
                    }
                    r = (LDIFModifyDNChangeRecord)o;
                    try {
                        if (!this.getParsedDN().equals(r.getParsedDN())) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        if (StaticUtils.toLowerCase(this.getDN()).equals(StaticUtils.toLowerCase(r.getDN()))) break block16;
                        return false;
                    }
                }
                try {
                    if (!this.getParsedNewRDN().equals(r.getParsedNewRDN())) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (StaticUtils.toLowerCase(this.newRDN).equals(StaticUtils.toLowerCase(r.newRDN))) break block17;
                    return false;
                }
            }
            if (this.newSuperiorDN == null) {
                if (r.newSuperiorDN != null) {
                    return false;
                }
            } else {
                if (r.newSuperiorDN == null) {
                    return false;
                }
                try {
                    if (!this.getParsedNewSuperiorDN().equals(r.getParsedNewSuperiorDN())) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (StaticUtils.toLowerCase(this.newSuperiorDN).equals(StaticUtils.toLowerCase(r.newSuperiorDN))) break block18;
                    return false;
                }
            }
        }
        return this.deleteOldRDN == r.deleteOldRDN;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDIFModifyDNChangeRecord(dn='");
        buffer.append(this.getDN());
        buffer.append("', newRDN='");
        buffer.append(this.newRDN);
        buffer.append("', deleteOldRDN=");
        buffer.append(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            buffer.append(", newSuperiorDN='");
            buffer.append(this.newSuperiorDN);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

