/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class LDIFChangeRecord
implements LDIFRecord {
    private static final long serialVersionUID = 2394617613961232499L;
    private volatile DN parsedDN;
    private final String dn;

    protected LDIFChangeRecord(String dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
    }

    public final String getDN() {
        return this.dn;
    }

    public final DN getParsedDN() throws LDAPException {
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn);
        }
        return this.parsedDN;
    }

    public abstract ChangeType getChangeType();

    public abstract LDAPResult processChange(LDAPInterface var1) throws LDAPException;

    final Entry toEntry() throws LDIFException {
        return new Entry(this.toLDIF());
    }

    public final String[] toLDIF() {
        return this.toLDIF(0);
    }

    public abstract String[] toLDIF(int var1);

    public final void toLDIF(ByteStringBuffer buffer) {
        this.toLDIF(buffer, 0);
    }

    public abstract void toLDIF(ByteStringBuffer var1, int var2);

    public final String toLDIFString() {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, 0);
        return buffer.toString();
    }

    public final String toLDIFString(int wrapColumn) {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, wrapColumn);
        return buffer.toString();
    }

    public final void toLDIFString(StringBuilder buffer) {
        this.toLDIFString(buffer, 0);
    }

    public abstract void toLDIFString(StringBuilder var1, int var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);
}

