/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class BooleanValueArgument
extends Argument {
    private static final long serialVersionUID = -3903872574065550222L;
    private final Boolean defaultValue;
    private Boolean value;

    public BooleanValueArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, valuePlaceholder, description, null);
    }

    public BooleanValueArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, String valuePlaceholder, String description, Boolean defaultValue) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, 1, valuePlaceholder, description);
        if (valuePlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MUST_TAKE_VALUE.get(this.getIdentifierString()));
        }
        this.defaultValue = defaultValue;
        this.value = null;
    }

    private BooleanValueArgument(BooleanValueArgument source) {
        super(source);
        this.defaultValue = source.defaultValue;
        this.value = null;
    }

    protected boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getValue() {
        if (this.value == null) {
            return this.defaultValue;
        }
        return this.value;
    }

    protected void addValue(String valueString) throws ArgumentException {
        if (this.value != null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        String lowerStr = StaticUtils.toLowerCase(valueString);
        if (lowerStr.equals("true") || lowerStr.equals("t") || lowerStr.equals("yes") || lowerStr.equals("y") || lowerStr.equals("on") || lowerStr.equals("1")) {
            this.value = Boolean.TRUE;
        } else if (lowerStr.equals("false") || lowerStr.equals("f") || lowerStr.equals("no") || lowerStr.equals("n") || lowerStr.equals("off") || lowerStr.equals("0")) {
            this.value = Boolean.FALSE;
        } else {
            throw new ArgumentException(ArgsMessages.ERR_ARG_VALUE_NOT_ALLOWED.get(valueString, this.getIdentifierString()));
        }
    }

    public String getDataTypeName() {
        return ArgsMessages.INFO_BOOLEAN_VALUE_TYPE_NAME.get();
    }

    public String getValueConstraints() {
        return ArgsMessages.INFO_BOOLEAN_VALUE_CONSTRAINTS.get();
    }

    public BooleanValueArgument getCleanCopy() {
        return new BooleanValueArgument(this);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("BooleanValueArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.defaultValue != null) {
            buffer.append(", defaultValue=");
            buffer.append(this.defaultValue);
        }
        buffer.append(')');
    }
}

