/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public abstract class SASLBindRequest
extends BindRequest
implements ResponseAcceptor {
    protected static final byte CRED_TYPE_SASL = -93;
    private static final long serialVersionUID = -5842126553864908312L;
    private int messageID = -1;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();

    protected SASLBindRequest(Control[] controls) {
        super(controls);
    }

    public String getBindType() {
        return this.getSASLMechanismName();
    }

    public abstract String getSASLMechanismName();

    public int getLastMessageID() {
        return this.messageID;
    }

    protected final BindResult sendBindRequest(LDAPConnection connection, String bindDN, ASN1OctetString saslCredentials, Control[] controls, long timeoutMillis) throws LDAPException {
        if (this.messageID == -1) {
            this.messageID = connection.nextMessageID();
        }
        BindRequestProtocolOp protocolOp = new BindRequestProtocolOp(bindDN, this.getSASLMechanismName(), saslCredentials);
        LDAPMessage requestMessage = new LDAPMessage(this.messageID, (ProtocolOp)protocolOp, controls);
        return this.sendMessage(connection, requestMessage, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BindResult sendMessage(LDAPConnection connection, LDAPMessage requestMessage, long timeoutMillis) throws LDAPException {
        if (connection.synchronousMode()) {
            return this.sendMessageSync(connection, requestMessage, timeoutMillis);
        }
        int msgID = requestMessage.getMessageID();
        connection.registerResponseAcceptor(msgID, this);
        try {
            LDAPResponse response;
            long requestTime = System.nanoTime();
            connection.getConnectionStatistics().incrementNumBindRequests();
            connection.sendMessage(requestMessage);
            try {
                response = timeoutMillis > 0L ? this.responseQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_BIND_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            BindResult bindResult = this.handleResponse(connection, response, requestTime);
            Object var11_9 = null;
            connection.deregisterResponseAcceptor(msgID);
            return bindResult;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            connection.deregisterResponseAcceptor(msgID);
            throw throwable;
        }
    }

    private BindResult sendMessageSync(LDAPConnection connection, LDAPMessage requestMessage, long timeoutMillis) throws LDAPException {
        LDAPResponse response;
        try {
            connection.getConnectionInternals().getSocket().setSoTimeout((int)timeoutMillis);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        int msgID = requestMessage.getMessageID();
        long requestTime = System.nanoTime();
        connection.getConnectionStatistics().incrementNumBindRequests();
        connection.sendMessage(requestMessage);
        while ((response = connection.readResponse(this.messageID)) instanceof IntermediateResponse) {
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime);
    }

    private BindResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime) throws LDAPException {
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_BIND_CLIENT_TIMEOUT.get(waitTime, connection.getHostPort()));
        }
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        connection.getConnectionStatistics().incrementNumBindResponses(System.nanoTime() - requestTime);
        return (BindResult)response;
    }

    @InternalUseOnly
    public final void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }
}

