/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AbandonRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -7824390696388231825L;
    private final int idToAbandon;

    public AbandonRequestProtocolOp(int idToAbandon) {
        this.idToAbandon = idToAbandon;
    }

    AbandonRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            this.idToAbandon = reader.readInteger();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_ABANDON_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public int getIDToAbandon() {
        return this.idToAbandon;
    }

    public byte getProtocolOpType() {
        return 80;
    }

    public void writeTo(ASN1Buffer buffer) {
        buffer.addInteger((byte)80, this.idToAbandon);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("AbandonRequestProtocolOp(idToAbandon=");
        buffer.append(this.idToAbandon);
        buffer.append(')');
    }
}

