/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.ANONYMOUSBindRequest;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.GSSAPIBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.PromptTrustManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class LDAPCommandLineTool
extends CommandLineTool {
    private static final Map<String, List<String>> REQUIRED_SASL_OPTIONS = new LinkedHashMap<String, List<String>>(6);
    private static final Map<String, List<String>> OPTIONAL_SASL_OPTIONS = new LinkedHashMap<String, List<String>>(6);
    private static final String SASL_MECH_ANONYMOUS = "anonymous";
    private static final String SASL_MECH_CRAM_MD5 = "cram-md5";
    private static final String SASL_MECH_DIGEST_MD5 = "digest-md5";
    private static final String SASL_MECH_EXTERNAL = "external";
    private static final String SASL_MECH_GSSAPI = "gssapi";
    private static final String SASL_MECH_PLAIN = "plain";
    private static final String SASL_OPTION_AUTH_ID = "authid";
    private static final String SASL_OPTION_AUTHZ_ID = "authzid";
    private static final String SASL_OPTION_CONFIG_FILE = "configfile";
    private static final String SASL_OPTION_DEBUG = "debug";
    private static final String SASL_OPTION_KDC_ADDRESS = "kdcaddress";
    private static final String SASL_OPTION_PROTOCOL = "protocol";
    private static final String SASL_OPTION_REALM = "realm";
    private static final String SASL_OPTION_REQUIRE_CACHE = "requirecache";
    private static final String SASL_OPTION_RENEW_TGT = "renewtgt";
    private static final String SASL_OPTION_TICKET_CACHE_PATH = "ticketcache";
    private static final String SASL_OPTION_TRACE = "trace";
    private static final String SASL_OPTION_USE_TICKET_CACHE = "useticketcache";
    private BooleanArgument trustAll;
    private BooleanArgument useSSL;
    private BooleanArgument useStartTLS;
    private DNArgument bindDN;
    private FileArgument bindPasswordFile;
    private FileArgument keyStorePasswordFile;
    private FileArgument trustStorePasswordFile;
    private IntegerArgument port;
    private StringArgument bindPassword;
    private StringArgument certificateNickname;
    private StringArgument host;
    private StringArgument keyStoreFormat;
    private StringArgument keyStorePath;
    private StringArgument keyStorePassword;
    private StringArgument saslOption;
    private StringArgument trustStoreFormat;
    private StringArgument trustStorePath;
    private StringArgument trustStorePassword;
    private Map<String, String> saslOptions;
    private String saslMechanism;
    private BindRequest bindRequest;
    private ServerSet serverSet;
    private SSLContext startTLSContext;
    private final AtomicReference<PromptTrustManager> promptTrustManager = new AtomicReference();

    public LDAPCommandLineTool(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    public final void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.host = new StringArgument(Character.valueOf('h'), "hostname", true, this.supportsMultipleServers() ? 0 : 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_HOST.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_HOST.get(), "localhost");
        parser.addArgument(this.host);
        this.port = new IntegerArgument(Character.valueOf('p'), "port", true, this.supportsMultipleServers() ? 0 : 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PORT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_PORT.get(), 1, 65535, 389);
        parser.addArgument(this.port);
        this.bindDN = new DNArgument(Character.valueOf('D'), "bindDN", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_DN.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_DN.get());
        parser.addArgument(this.bindDN);
        this.bindPassword = new StringArgument(Character.valueOf('w'), "bindPassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW.get());
        parser.addArgument(this.bindPassword);
        this.bindPasswordFile = new FileArgument(Character.valueOf('j'), "bindPasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW_FILE.get(), true, true, true, false);
        parser.addArgument(this.bindPasswordFile);
        this.useSSL = new BooleanArgument(Character.valueOf('Z'), "useSSL", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_SSL.get());
        parser.addArgument(this.useSSL);
        this.useStartTLS = new BooleanArgument(Character.valueOf('q'), "useStartTLS", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_START_TLS.get());
        parser.addArgument(this.useStartTLS);
        this.trustAll = new BooleanArgument(Character.valueOf('X'), "trustAll", 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_ALL.get());
        parser.addArgument(this.trustAll);
        this.keyStorePath = new StringArgument(Character.valueOf('K'), "keyStorePath", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PATH.get());
        parser.addArgument(this.keyStorePath);
        this.keyStorePassword = new StringArgument(Character.valueOf('W'), "keyStorePassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD.get());
        parser.addArgument(this.keyStorePassword);
        this.keyStorePasswordFile = new FileArgument(Character.valueOf('u'), "keyStorePasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE.get());
        parser.addArgument(this.keyStorePasswordFile);
        this.keyStoreFormat = new StringArgument(null, "keyStoreFormat", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_FORMAT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_FORMAT.get());
        parser.addArgument(this.keyStoreFormat);
        this.trustStorePath = new StringArgument(Character.valueOf('P'), "trustStorePath", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PATH.get());
        parser.addArgument(this.trustStorePath);
        this.trustStorePassword = new StringArgument(Character.valueOf('T'), "trustStorePassword", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD.get());
        parser.addArgument(this.trustStorePassword);
        this.trustStorePasswordFile = new FileArgument(Character.valueOf('U'), "trustStorePasswordFile", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE.get());
        parser.addArgument(this.trustStorePasswordFile);
        this.trustStoreFormat = new StringArgument(null, "trustStoreFormat", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_FORMAT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_FORMAT.get());
        parser.addArgument(this.trustStoreFormat);
        this.certificateNickname = new StringArgument(Character.valueOf('N'), "certNickname", false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_CERT_NICKNAME.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_CERT_NICKNAME.get());
        parser.addArgument(this.certificateNickname);
        this.saslOption = new StringArgument(Character.valueOf('o'), "saslOption", false, 0, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_SASL_OPTION.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_SASL_OPTION.get());
        parser.addArgument(this.saslOption);
        parser.addDependentArgumentSet(this.bindDN, this.bindPassword, this.bindPasswordFile);
        parser.addExclusiveArgumentSet(this.useSSL, this.useStartTLS, new Argument[0]);
        parser.addExclusiveArgumentSet(this.bindPassword, this.bindPasswordFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.keyStorePassword, this.keyStorePasswordFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.trustStorePassword, this.trustStorePasswordFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.trustAll, this.trustStorePath, new Argument[0]);
        this.addNonLDAPArguments(parser);
    }

    public abstract void addNonLDAPArguments(ArgumentParser var1) throws ArgumentException;

    public final void doExtendedArgumentValidation() throws ArgumentException {
        if ((this.host.getValues().size() > 1 || this.port.getValues().size() > 1) && this.host.getValues().size() != this.port.getValues().size()) {
            throw new ArgumentException(UtilityMessages.ERR_LDAP_TOOL_HOST_PORT_COUNT_MISMATCH.get(this.host.getLongIdentifier(), this.port.getLongIdentifier()));
        }
        this.saslMechanism = null;
        this.saslOptions = new LinkedHashMap<String, String>(10);
        if (this.saslOption.isPresent()) {
            for (String s : this.saslOption.getValues()) {
                int equalPos = s.indexOf(61);
                if (equalPos < 0) {
                    throw new ArgumentException(UtilityMessages.ERR_LDAP_TOOL_MALFORMED_SASL_OPTION.get(s));
                }
                String optionName = StaticUtils.toLowerCase(s.substring(0, equalPos));
                String optionValue = s.substring(equalPos + 1);
                this.saslOptions.put(optionName, optionValue);
            }
            LinkedHashMap<String, String> optionsCopy = new LinkedHashMap<String, String>(this.saslOptions);
            String mech = (String)optionsCopy.remove("mech");
            if (mech == null) {
                throw new ArgumentException(UtilityMessages.ERR_LDAP_TOOL_NO_SASL_MECH.get());
            }
            this.saslMechanism = StaticUtils.toLowerCase(mech);
            List<String> requiredOptions = REQUIRED_SASL_OPTIONS.get(this.saslMechanism);
            List<String> optionalOptions = OPTIONAL_SASL_OPTIONS.get(this.saslMechanism);
            if (requiredOptions == null) {
                throw new ArgumentException(UtilityMessages.ERR_LDAP_TOOL_UNSUPPORTED_SASL_MECH.get(mech));
            }
            for (String s : requiredOptions) {
                if (optionsCopy.remove(s) != null) continue;
                throw new ArgumentException(UtilityMessages.ERR_LDAP_TOOL_MISSING_REQUIRED_SASL_OPTION.get(s, mech));
            }
            for (String s : optionalOptions) {
                optionsCopy.remove(s);
            }
            if (!optionsCopy.isEmpty()) {
                String option = optionsCopy.keySet().iterator().next();
                throw new ArgumentException(UtilityMessages.ERR_LDAP_TOOL_INVALID_SASL_OPTION.get(option, mech));
            }
        }
        this.doExtendedNonLDAPArgumentValidation();
    }

    protected boolean supportsMultipleServers() {
        return false;
    }

    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return new LDAPConnectionOptions();
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final LDAPConnection getConnection() throws LDAPException {
        if (this.serverSet == null) {
            this.serverSet = this.createServerSet();
            this.bindRequest = this.createBindRequest();
        }
        LDAPConnection connection = this.serverSet.getConnection();
        if (this.useStartTLS.isPresent()) {
            try {
                ExtendedResult extendedResult = connection.processExtendedOperation(new StartTLSExtendedRequest(this.startTLSContext));
                if (!extendedResult.getResultCode().equals(ResultCode.SUCCESS)) {
                    throw new LDAPException(extendedResult.getResultCode(), UtilityMessages.ERR_LDAP_TOOL_START_TLS_FAILED.get(extendedResult.getDiagnosticMessage()));
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                connection.close();
                throw le;
            }
        }
        try {
            if (this.bindRequest != null) {
                connection.bind(this.bindRequest);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.close();
            throw le;
        }
        return connection;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final LDAPConnectionPool getConnectionPool(int initialConnections, int maxConnections) throws LDAPException {
        if (this.serverSet == null) {
            this.serverSet = this.createServerSet();
            this.bindRequest = this.createBindRequest();
        }
        StartTLSPostConnectProcessor postConnectProcessor = null;
        if (this.useStartTLS.isPresent()) {
            postConnectProcessor = new StartTLSPostConnectProcessor(this.startTLSContext);
        }
        return new LDAPConnectionPool(this.serverSet, this.bindRequest, initialConnections, maxConnections, postConnectProcessor);
    }

    public ServerSet createServerSet() throws LDAPException {
        SSLUtil sslUtil = this.createSSLUtil();
        SSLSocketFactory socketFactory = null;
        if (this.useSSL.isPresent()) {
            try {
                socketFactory = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.useStartTLS.isPresent()) {
            try {
                this.startTLSContext = sslUtil.createSSLContext();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_CONTEXT.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.host.getValues().size() == 1) {
            return new SingleServerSet(this.host.getValue(), this.port.getValue(), socketFactory, this.getConnectionOptions());
        }
        List<String> hostList = this.host.getValues();
        List<Integer> portList = this.port.getValues();
        String[] hosts = new String[hostList.size()];
        int[] ports = new int[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hostList.get(i);
            ports[i] = portList.get(i);
        }
        return new RoundRobinServerSet(hosts, ports, socketFactory, this.getConnectionOptions());
    }

    private SSLUtil createSSLUtil() throws LDAPException {
        if (this.useSSL.isPresent() || this.useStartTLS.isPresent()) {
            TrustManager trustManager;
            KeyStoreKeyManager keyManager = null;
            if (this.keyStorePath.isPresent()) {
                char[] pw = null;
                if (this.keyStorePassword.isPresent()) {
                    pw = this.keyStorePassword.getValue().toCharArray();
                } else if (this.keyStorePasswordFile.isPresent()) {
                    try {
                        pw = this.keyStorePasswordFile.getNonBlankFileLines().get(0).toCharArray();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_KEY_STORE_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                try {
                    keyManager = new KeyStoreKeyManager(this.keyStorePath.getValue(), pw, this.keyStoreFormat.getValue(), this.certificateNickname.getValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_KEY_MANAGER.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.trustAll.isPresent()) {
                trustManager = new TrustAllTrustManager(false);
            } else if (this.trustStorePath.isPresent()) {
                char[] pw = null;
                if (this.trustStorePassword.isPresent()) {
                    pw = this.trustStorePassword.getValue().toCharArray();
                } else if (this.trustStorePasswordFile.isPresent()) {
                    try {
                        pw = this.trustStorePasswordFile.getNonBlankFileLines().get(0).toCharArray();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                trustManager = new TrustStoreTrustManager(this.trustStorePath.getValue(), pw, this.trustStoreFormat.getValue(), true);
            } else {
                trustManager = this.promptTrustManager.get();
                if (trustManager == null) {
                    PromptTrustManager m = new PromptTrustManager();
                    this.promptTrustManager.compareAndSet(null, m);
                    trustManager = this.promptTrustManager.get();
                }
            }
            return new SSLUtil(keyManager, trustManager);
        }
        return null;
    }

    private BindRequest createBindRequest() throws LDAPException {
        String pw;
        if (this.bindPassword.isPresent()) {
            pw = this.bindPassword.getValue();
        } else if (this.bindPasswordFile.isPresent()) {
            try {
                pw = this.bindPasswordFile.getNonBlankFileLines().get(0);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_BIND_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
            }
        } else {
            pw = null;
        }
        if (this.bindDN.isPresent()) {
            return new SimpleBindRequest(this.bindDN.getValue(), pw);
        }
        if (this.saslMechanism != null) {
            if (this.saslMechanism.equals(SASL_MECH_ANONYMOUS)) {
                return new ANONYMOUSBindRequest(this.saslOptions.get(SASL_OPTION_TRACE));
            }
            if (this.saslMechanism.equals(SASL_MECH_CRAM_MD5)) {
                return new CRAMMD5BindRequest(this.saslOptions.get(SASL_OPTION_AUTH_ID), pw);
            }
            if (this.saslMechanism.equals(SASL_MECH_DIGEST_MD5)) {
                return new DIGESTMD5BindRequest(this.saslOptions.get(SASL_OPTION_AUTH_ID), this.saslOptions.get(SASL_OPTION_AUTHZ_ID), pw, this.saslOptions.get(SASL_OPTION_REALM), new Control[0]);
            }
            if (this.saslMechanism.equals(SASL_MECH_EXTERNAL)) {
                return new EXTERNALBindRequest();
            }
            if (this.saslMechanism.equals(SASL_MECH_GSSAPI)) {
                String debugStr;
                String renewTGTStr;
                String requireCacheStr;
                String useTicketCacheStr;
                GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(this.saslOptions.get(SASL_OPTION_AUTH_ID), pw);
                gssapiProperties.setAuthorizationID(this.saslOptions.get(SASL_OPTION_AUTHZ_ID));
                gssapiProperties.setRealm(this.saslOptions.get(SASL_OPTION_REALM));
                gssapiProperties.setKDCAddress(this.saslOptions.get(SASL_OPTION_KDC_ADDRESS));
                gssapiProperties.setConfigFilePath(this.saslOptions.get(SASL_OPTION_CONFIG_FILE));
                gssapiProperties.setTicketCachePath(this.saslOptions.get(SASL_OPTION_TICKET_CACHE_PATH));
                String protocol = this.saslOptions.get(SASL_OPTION_PROTOCOL);
                if (protocol != null) {
                    gssapiProperties.setServicePrincipalProtocol(protocol);
                }
                if ((useTicketCacheStr = this.saslOptions.get(SASL_OPTION_USE_TICKET_CACHE)) != null) {
                    gssapiProperties.setUseTicketCache(useTicketCacheStr.equalsIgnoreCase("true"));
                }
                if ((requireCacheStr = this.saslOptions.get(SASL_OPTION_REQUIRE_CACHE)) != null) {
                    gssapiProperties.setRequireCachedCredentials(requireCacheStr.equalsIgnoreCase("true"));
                }
                if ((renewTGTStr = this.saslOptions.get(SASL_OPTION_RENEW_TGT)) != null) {
                    gssapiProperties.setRenewTGT(renewTGTStr.equalsIgnoreCase("true"));
                }
                if ((debugStr = this.saslOptions.get(SASL_OPTION_DEBUG)) != null && debugStr.equalsIgnoreCase("true")) {
                    gssapiProperties.setEnableGSSAPIDebugging(true);
                }
                return new GSSAPIBindRequest(gssapiProperties, new Control[0]);
            }
            if (this.saslMechanism.equals(SASL_MECH_PLAIN)) {
                return new PLAINBindRequest(this.saslOptions.get(SASL_OPTION_AUTH_ID), this.saslOptions.get(SASL_OPTION_AUTHZ_ID), pw);
            }
            throw new LDAPException(ResultCode.NOT_SUPPORTED, UtilityMessages.ERR_LDAP_TOOL_UNSUPPORTED_SASL_MECH.get(this.saslMechanism));
        }
        return null;
    }

    static {
        REQUIRED_SASL_OPTIONS.put(SASL_MECH_ANONYMOUS, Arrays.asList(new String[0]));
        OPTIONAL_SASL_OPTIONS.put(SASL_MECH_ANONYMOUS, Arrays.asList(SASL_OPTION_TRACE));
        REQUIRED_SASL_OPTIONS.put(SASL_MECH_CRAM_MD5, Arrays.asList(SASL_OPTION_AUTH_ID));
        OPTIONAL_SASL_OPTIONS.put(SASL_MECH_CRAM_MD5, Arrays.asList(new String[0]));
        REQUIRED_SASL_OPTIONS.put(SASL_MECH_DIGEST_MD5, Arrays.asList(SASL_OPTION_AUTH_ID));
        OPTIONAL_SASL_OPTIONS.put(SASL_MECH_DIGEST_MD5, Arrays.asList(SASL_OPTION_AUTHZ_ID, SASL_OPTION_REALM));
        REQUIRED_SASL_OPTIONS.put(SASL_MECH_EXTERNAL, Arrays.asList(new String[0]));
        OPTIONAL_SASL_OPTIONS.put(SASL_MECH_EXTERNAL, Arrays.asList(new String[0]));
        REQUIRED_SASL_OPTIONS.put(SASL_MECH_GSSAPI, Arrays.asList(SASL_OPTION_AUTH_ID));
        OPTIONAL_SASL_OPTIONS.put(SASL_MECH_GSSAPI, Arrays.asList(SASL_OPTION_AUTHZ_ID, SASL_OPTION_CONFIG_FILE, SASL_OPTION_DEBUG, SASL_OPTION_PROTOCOL, SASL_OPTION_REALM, SASL_OPTION_KDC_ADDRESS, SASL_OPTION_RENEW_TGT, SASL_OPTION_REQUIRE_CACHE, SASL_OPTION_TICKET_CACHE_PATH, SASL_OPTION_USE_TICKET_CACHE));
        REQUIRED_SASL_OPTIONS.put(SASL_MECH_PLAIN, Arrays.asList(SASL_OPTION_AUTH_ID));
        OPTIONAL_SASL_OPTIONS.put(SASL_MECH_PLAIN, Arrays.asList(SASL_OPTION_AUTHZ_ID));
    }
}

