/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFAddChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = 5717427836786488295L;
    private final Attribute[] attributes;

    public LDIFAddChangeRecord(String dn, Attribute ... attributes) {
        super(dn);
        Validator.ensureNotNull(attributes);
        Validator.ensureTrue(attributes.length > 0, "LDIFAddChangeRecord.attributes must not be empty.");
        this.attributes = attributes;
    }

    public LDIFAddChangeRecord(String dn, List<Attribute> attributes) {
        super(dn);
        Validator.ensureNotNull(attributes);
        Validator.ensureFalse(attributes.isEmpty(), "LDIFAddChangeRecord.attributes must not be empty.");
        this.attributes = new Attribute[attributes.size()];
        attributes.toArray(this.attributes);
    }

    public LDIFAddChangeRecord(Entry entry) {
        super(entry.getDN());
        Collection<Attribute> attrs = entry.getAttributes();
        this.attributes = new Attribute[attrs.size()];
        Iterator<Attribute> iterator = attrs.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = iterator.next();
        }
    }

    public LDIFAddChangeRecord(AddRequest addRequest) {
        super(addRequest.getDN());
        List<Attribute> attrs = addRequest.getAttributes();
        this.attributes = new Attribute[attrs.size()];
        Iterator<Attribute> iterator = attrs.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = iterator.next();
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public AddRequest toAddRequest() {
        return new AddRequest(this.getDN(), this.attributes);
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.ADD;
    }

    @Override
    public LDAPResult processChange(LDAPInterface connection) throws LDAPException {
        return connection.add(this.toAddRequest());
    }

    @Override
    public String[] toLDIF(int wrapColumn) {
        List<String> ldifLines = new ArrayList<String>(2 * this.attributes.length);
        ldifLines.add(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())));
        ldifLines.add("changetype: add");
        for (Attribute a : this.attributes) {
            String name = a.getName();
            for (ASN1OctetString value : a.getRawValues()) {
                ldifLines.add(LDIFWriter.encodeNameAndValue(name, value));
            }
        }
        if (wrapColumn > 2) {
            ldifLines = LDIFWriter.wrapLines(wrapColumn, ldifLines);
        }
        String[] ldifArray = new String[ldifLines.size()];
        ldifLines.toArray(ldifArray);
        return ldifArray;
    }

    @Override
    public void toLDIF(ByteStringBuffer buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("add"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        for (Attribute a : this.attributes) {
            String name = a.getName();
            for (ASN1OctetString value : a.getRawValues()) {
                LDIFWriter.encodeNameAndValue(name, value, buffer, wrapColumn);
                buffer.append(StaticUtils.EOL_BYTES);
            }
        }
    }

    @Override
    public void toLDIFString(StringBuilder buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("add"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        for (Attribute a : this.attributes) {
            String name = a.getName();
            for (ASN1OctetString value : a.getRawValues()) {
                LDIFWriter.encodeNameAndValue(name, value, buffer, wrapColumn);
                buffer.append(StaticUtils.EOL);
            }
        }
    }

    @Override
    public int hashCode() {
        try {
            int hashCode = this.getParsedDN().hashCode();
            for (Attribute a : this.attributes) {
                hashCode += a.hashCode();
            }
            return hashCode;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new Entry(this.getDN(), this.attributes).hashCode();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LDIFAddChangeRecord)) {
            return false;
        }
        LDIFAddChangeRecord r = (LDIFAddChangeRecord)o;
        Entry e1 = new Entry(this.getDN(), this.attributes);
        Entry e2 = new Entry(r.getDN(), r.attributes);
        return e1.equals(e2);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDIFAddChangeRecord(dn='");
        buffer.append(this.getDN());
        buffer.append("', attrs={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.attributes[i].toString(buffer);
        }
        buffer.append("})");
    }
}

