/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class SchemaElement
implements Serializable {
    private static final long serialVersionUID = -8249972237068748580L;

    static int skipSpaces(String s, int startPos, int length) throws LDAPException {
        int pos;
        for (pos = startPos; pos < length && s.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_SKIP_SPACES_NO_CLOSE_PAREN.get(s));
        }
        return pos;
    }

    private static int readEscapedHexString(String s, int startPos, int length, StringBuilder buffer) throws LDAPException {
        int pos;
        ByteBuffer byteBuffer = ByteBuffer.allocate(length - pos);
        for (pos = startPos; pos < length; ++pos) {
            byte b;
            switch (s.charAt(pos++)) {
                case '0': {
                    b = 0;
                    break;
                }
                case '1': {
                    b = 16;
                    break;
                }
                case '2': {
                    b = 32;
                    break;
                }
                case '3': {
                    b = 48;
                    break;
                }
                case '4': {
                    b = 64;
                    break;
                }
                case '5': {
                    b = 80;
                    break;
                }
                case '6': {
                    b = 96;
                    break;
                }
                case '7': {
                    b = 112;
                    break;
                }
                case '8': {
                    b = -128;
                    break;
                }
                case '9': {
                    b = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    b = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    b = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    b = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    b = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    b = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    b = -16;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, SchemaMessages.ERR_SCHEMA_ELEM_INVALID_HEX_CHAR.get(s, Character.valueOf(s.charAt(pos - 1)), pos - 1));
                }
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, SchemaMessages.ERR_SCHEMA_ELEM_MISSING_HEX_CHAR.get(s));
            }
            switch (s.charAt(pos++)) {
                case '0': {
                    break;
                }
                case '1': {
                    b = (byte)(b | 1);
                    break;
                }
                case '2': {
                    b = (byte)(b | 2);
                    break;
                }
                case '3': {
                    b = (byte)(b | 3);
                    break;
                }
                case '4': {
                    b = (byte)(b | 4);
                    break;
                }
                case '5': {
                    b = (byte)(b | 5);
                    break;
                }
                case '6': {
                    b = (byte)(b | 6);
                    break;
                }
                case '7': {
                    b = (byte)(b | 7);
                    break;
                }
                case '8': {
                    b = (byte)(b | 8);
                    break;
                }
                case '9': {
                    b = (byte)(b | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    b = (byte)(b | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    b = (byte)(b | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    b = (byte)(b | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    b = (byte)(b | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    b = (byte)(b | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    b = (byte)(b | 0xF);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, SchemaMessages.ERR_SCHEMA_ELEM_INVALID_HEX_CHAR.get(s, Character.valueOf(s.charAt(pos - 1)), pos - 1));
                }
            }
            byteBuffer.put(b);
            if (pos + 1 >= length || s.charAt(pos) != '\\' || !StaticUtils.isHex(s.charAt(pos + 1))) break;
        }
        byteBuffer.flip();
        byte[] byteArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byteArray);
        try {
            buffer.append(StaticUtils.toUTF8String(byteArray));
        }
        catch (Exception e) {
            Debug.debugException(e);
            buffer.append(new String(byteArray));
        }
        return pos;
    }

    static int readQDString(String s, int startPos, int length, StringBuilder buffer) throws LDAPException {
        char c;
        if (s.charAt(startPos) != '\'') {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EXPECTED_SINGLE_QUOTE.get(s, startPos));
        }
        int pos = startPos + 1;
        while (pos < length && (c = s.charAt(pos++)) != '\'') {
            if (c == '\\') {
                if (pos >= length) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_ENDS_WITH_BACKSLASH.get(s));
                }
                pos = SchemaElement.readEscapedHexString(s, pos, length, buffer);
                continue;
            }
            buffer.append(c);
        }
        if (pos >= length || s.charAt(pos) != ' ' && s.charAt(pos) != ')') {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_NO_CLOSING_PAREN.get(s));
        }
        if (buffer.length() == 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EMPTY_QUOTES.get(s));
        }
        return pos;
    }

    static int readQDStrings(String s, int startPos, int length, ArrayList<String> valueList) throws LDAPException {
        char c = s.charAt(startPos);
        if (c == '\'') {
            StringBuilder buffer = new StringBuilder();
            int returnPos = SchemaElement.readQDString(s, startPos, length, buffer);
            valueList.add(buffer.toString());
            return returnPos;
        }
        if (c == '(') {
            int pos;
            block6: {
                pos = startPos + 1;
                while (true) {
                    if ((c = s.charAt(pos = SchemaElement.skipSpaces(s, pos, length))) == ')') {
                        ++pos;
                        break block6;
                    }
                    if (c != '\'') break;
                    StringBuilder buffer = new StringBuilder();
                    pos = SchemaElement.readQDString(s, pos, length, buffer);
                    valueList.add(buffer.toString());
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EXPECTED_QUOTE_OR_PAREN.get(s, startPos));
            }
            if (valueList.isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EMPTY_STRING_LIST.get(s));
            }
            if (pos >= length || s.charAt(pos) != ' ' && s.charAt(pos) != ')') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_NO_SPACE_AFTER_QUOTE.get(s));
            }
            return pos;
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EXPECTED_QUOTE_OR_PAREN.get(s, startPos));
    }

    static int readOID(String s, int startPos, int length, StringBuilder buffer) throws LDAPException {
        boolean lastWasQuote = false;
        for (int pos = startPos; pos < length; ++pos) {
            char c = s.charAt(pos);
            if (c == ' ' || c == '$' || c == ')') {
                if (buffer.length() == 0) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EMPTY_OID.get(s));
                }
                return pos;
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '{' || c == '}') {
                if (lastWasQuote) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_UNEXPECTED_CHAR_IN_OID.get(s, pos - 1));
                }
                buffer.append(c);
                continue;
            }
            if (c == '\'') {
                if (buffer.length() == 0) continue;
                lastWasQuote = true;
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_UNEXPECTED_CHAR_IN_OID.get(s, pos));
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_NO_SPACE_AFTER_OID.get(s));
    }

    static int readOIDs(String s, int startPos, int length, ArrayList<String> valueList) throws LDAPException {
        char c = s.charAt(startPos);
        if (c == '(') {
            int pos;
            block6: {
                pos = startPos + 1;
                while (true) {
                    StringBuilder buffer;
                    if ((c = s.charAt(pos = SchemaElement.skipSpaces(s, pos, length))) == ')') {
                        ++pos;
                        break block6;
                    }
                    if (c == '$') {
                        ++pos;
                        pos = SchemaElement.skipSpaces(s, pos, length);
                        buffer = new StringBuilder();
                        pos = SchemaElement.readOID(s, pos, length, buffer);
                        valueList.add(buffer.toString());
                        continue;
                    }
                    if (!valueList.isEmpty()) break;
                    buffer = new StringBuilder();
                    pos = SchemaElement.readOID(s, pos, length, buffer);
                    valueList.add(buffer.toString());
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_UNEXPECTED_CHAR_IN_OID_LIST.get(s, pos));
            }
            if (valueList.isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EMPTY_OID_LIST.get(s));
            }
            if (pos >= length) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_NO_SPACE_AFTER_OID_LIST.get(s));
            }
            return pos;
        }
        StringBuilder buffer = new StringBuilder();
        int returnPos = SchemaElement.readOID(s, startPos, length, buffer);
        valueList.add(buffer.toString());
        return returnPos;
    }

    static void encodeValue(String value, StringBuilder buffer) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c < ' ' || c > '~' || c == '\\' || c == '\'') {
                StaticUtils.hexEncode(c, buffer);
                continue;
            }
            buffer.append(c);
        }
    }

    public abstract String toString();
}

