/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.schema.AttributeSyntaxDefinition;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.DITContentRuleDefinition;
import com.unboundid.ldap.sdk.schema.DITStructureRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleUseDefinition;
import com.unboundid.ldap.sdk.schema.NameFormDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Schema
implements Serializable {
    public static final String ATTR_ATTRIBUTE_SYNTAX = "ldapSyntaxes";
    public static final String ATTR_ATTRIBUTE_TYPE = "attributeTypes";
    public static final String ATTR_DIT_CONTENT_RULE = "dITContentRules";
    public static final String ATTR_DIT_STRUCTURE_RULE = "dITStructureRules";
    public static final String ATTR_MATCHING_RULE = "matchingRules";
    public static final String ATTR_MATCHING_RULE_USE = "matchingRuleUse";
    public static final String ATTR_NAME_FORM = "nameForms";
    public static final String ATTR_OBJECT_CLASS = "objectClasses";
    public static final String ATTR_SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    private static final AtomicReference<Schema> DEFAULT_STANDARD_SCHEMA = new AtomicReference();
    private static final String[] SCHEMA_REQUEST_ATTRS = new String[]{"ldapSyntaxes", "attributeTypes", "dITContentRules", "dITStructureRules", "matchingRules", "matchingRuleUse", "nameForms", "objectClasses"};
    private static final String[] SUBSCHEMA_SUBENTRY_REQUEST_ATTRS = new String[]{"subschemaSubentry"};
    private static final String DEFAULT_SCHEMA_RESOURCE_PATH = "com/unboundid/ldap/sdk/schema/standard-schema.ldif";
    private static final long serialVersionUID = 8081839633831517925L;
    private final Map<AttributeTypeDefinition, List<AttributeTypeDefinition>> subordinateAttributeTypes;
    private final Map<String, AttributeSyntaxDefinition> asMap;
    private final Map<String, AttributeTypeDefinition> atMap;
    private final Map<String, DITContentRuleDefinition> dcrMap;
    private final Map<Integer, DITStructureRuleDefinition> dsrMapByID;
    private final Map<String, DITStructureRuleDefinition> dsrMapByName;
    private final Map<String, DITStructureRuleDefinition> dsrMapByNameForm;
    private final Map<String, MatchingRuleDefinition> mrMap;
    private final Map<String, MatchingRuleUseDefinition> mruMap;
    private final Map<String, NameFormDefinition> nfMapByName;
    private final Map<String, NameFormDefinition> nfMapByOC;
    private final Map<String, ObjectClassDefinition> ocMap;
    private final ReadOnlyEntry schemaEntry;
    private final Set<AttributeSyntaxDefinition> asSet;
    private final Set<AttributeTypeDefinition> atSet;
    private final Set<AttributeTypeDefinition> operationalATSet;
    private final Set<AttributeTypeDefinition> userATSet;
    private final Set<DITContentRuleDefinition> dcrSet;
    private final Set<DITStructureRuleDefinition> dsrSet;
    private final Set<MatchingRuleDefinition> mrSet;
    private final Set<MatchingRuleUseDefinition> mruSet;
    private final Set<NameFormDefinition> nfSet;
    private final Set<ObjectClassDefinition> ocSet;
    private final Set<ObjectClassDefinition> abstractOCSet;
    private final Set<ObjectClassDefinition> auxiliaryOCSet;
    private final Set<ObjectClassDefinition> structuralOCSet;

    public Schema(Entry schemaEntry) {
        LinkedHashSet<SchemaElement> s;
        LinkedHashMap<String, ObjectClassDefinition> m;
        this.schemaEntry = new ReadOnlyEntry(schemaEntry);
        String[] defs = schemaEntry.getAttributeValues(ATTR_ATTRIBUTE_SYNTAX);
        if (defs == null) {
            this.asMap = Collections.emptyMap();
            this.asSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap<String, ObjectClassDefinition>(defs.length);
            s = new LinkedHashSet<SchemaElement>(defs.length);
            for (String def : defs) {
                try {
                    AttributeSyntaxDefinition as = new AttributeSyntaxDefinition(def);
                    s.add(as);
                    m.put(StaticUtils.toLowerCase(as.getOID()), (ObjectClassDefinition)((Object)as));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.asMap = Collections.unmodifiableMap(m);
            this.asSet = Collections.unmodifiableSet(s);
        }
        defs = schemaEntry.getAttributeValues(ATTR_ATTRIBUTE_TYPE);
        if (defs == null) {
            this.atMap = Collections.emptyMap();
            this.atSet = Collections.emptySet();
            this.operationalATSet = Collections.emptySet();
            this.userATSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(2 * defs.length);
            s = new LinkedHashSet(defs.length);
            LinkedHashSet<AttributeTypeDefinition> sUser = new LinkedHashSet<AttributeTypeDefinition>(defs.length);
            LinkedHashSet<AttributeTypeDefinition> sOperational = new LinkedHashSet<AttributeTypeDefinition>(defs.length);
            for (String def : defs) {
                try {
                    AttributeTypeDefinition at = new AttributeTypeDefinition(def);
                    s.add(at);
                    m.put(StaticUtils.toLowerCase(at.getOID()), (ObjectClassDefinition)((Object)at));
                    String[] arr$ = at.getNames();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String name = arr$[i$];
                        m.put(StaticUtils.toLowerCase(name), (ObjectClassDefinition)((Object)at));
                    }
                    if (at.isOperational()) {
                        sOperational.add(at);
                        continue;
                    }
                    sUser.add(at);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.atMap = Collections.unmodifiableMap(m);
            this.atSet = Collections.unmodifiableSet(s);
            this.operationalATSet = Collections.unmodifiableSet(sOperational);
            this.userATSet = Collections.unmodifiableSet(sUser);
        }
        defs = schemaEntry.getAttributeValues(ATTR_DIT_CONTENT_RULE);
        if (defs == null) {
            this.dcrMap = Collections.emptyMap();
            this.dcrSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(2 * defs.length);
            s = new LinkedHashSet(defs.length);
            for (String def : defs) {
                try {
                    DITContentRuleDefinition dcr = new DITContentRuleDefinition(def);
                    s.add(dcr);
                    m.put(StaticUtils.toLowerCase(dcr.getOID()), (ObjectClassDefinition)((Object)dcr));
                    for (String name : dcr.getNames()) {
                        m.put(StaticUtils.toLowerCase(name), (ObjectClassDefinition)((Object)dcr));
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.dcrMap = Collections.unmodifiableMap(m);
            this.dcrSet = Collections.unmodifiableSet(s);
        }
        defs = schemaEntry.getAttributeValues(ATTR_DIT_STRUCTURE_RULE);
        if (defs == null) {
            this.dsrMapByID = Collections.emptyMap();
            this.dsrMapByName = Collections.emptyMap();
            this.dsrMapByNameForm = Collections.emptyMap();
            this.dsrSet = Collections.emptySet();
        } else {
            LinkedHashMap<Integer, DITStructureRuleDefinition> mID = new LinkedHashMap<Integer, DITStructureRuleDefinition>(defs.length);
            LinkedHashMap<String, DITStructureRuleDefinition> mN = new LinkedHashMap<String, DITStructureRuleDefinition>(defs.length);
            LinkedHashMap<String, DITStructureRuleDefinition> mNF = new LinkedHashMap<String, DITStructureRuleDefinition>(defs.length);
            LinkedHashSet<DITStructureRuleDefinition> s2 = new LinkedHashSet<DITStructureRuleDefinition>(defs.length);
            for (String def : defs) {
                try {
                    DITStructureRuleDefinition dsr = new DITStructureRuleDefinition(def);
                    s2.add(dsr);
                    mID.put(dsr.getRuleID(), dsr);
                    mNF.put(StaticUtils.toLowerCase(dsr.getNameFormID()), dsr);
                    for (String name : dsr.getNames()) {
                        mN.put(StaticUtils.toLowerCase(name), dsr);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.dsrMapByID = Collections.unmodifiableMap(mID);
            this.dsrMapByName = Collections.unmodifiableMap(mN);
            this.dsrMapByNameForm = Collections.unmodifiableMap(mNF);
            this.dsrSet = Collections.unmodifiableSet(s2);
        }
        defs = schemaEntry.getAttributeValues(ATTR_MATCHING_RULE);
        if (defs == null) {
            this.mrMap = Collections.emptyMap();
            this.mrSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(2 * defs.length);
            s = new LinkedHashSet(defs.length);
            for (String def : defs) {
                try {
                    MatchingRuleDefinition mr = new MatchingRuleDefinition(def);
                    s.add(mr);
                    m.put(StaticUtils.toLowerCase(mr.getOID()), (ObjectClassDefinition)((Object)mr));
                    for (String name : mr.getNames()) {
                        m.put(StaticUtils.toLowerCase(name), (ObjectClassDefinition)((Object)mr));
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.mrMap = Collections.unmodifiableMap(m);
            this.mrSet = Collections.unmodifiableSet(s);
        }
        defs = schemaEntry.getAttributeValues(ATTR_MATCHING_RULE_USE);
        if (defs == null) {
            this.mruMap = Collections.emptyMap();
            this.mruSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(2 * defs.length);
            s = new LinkedHashSet(defs.length);
            for (String def : defs) {
                try {
                    MatchingRuleUseDefinition mru = new MatchingRuleUseDefinition(def);
                    s.add(mru);
                    m.put(StaticUtils.toLowerCase(mru.getOID()), (ObjectClassDefinition)((Object)mru));
                    for (String name : mru.getNames()) {
                        m.put(StaticUtils.toLowerCase(name), (ObjectClassDefinition)((Object)mru));
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.mruMap = Collections.unmodifiableMap(m);
            this.mruSet = Collections.unmodifiableSet(s);
        }
        defs = schemaEntry.getAttributeValues(ATTR_NAME_FORM);
        if (defs == null) {
            this.nfMapByName = Collections.emptyMap();
            this.nfMapByOC = Collections.emptyMap();
            this.nfSet = Collections.emptySet();
        } else {
            LinkedHashMap<String, NameFormDefinition> mN = new LinkedHashMap<String, NameFormDefinition>(2 * defs.length);
            LinkedHashMap<String, NameFormDefinition> mOC = new LinkedHashMap<String, NameFormDefinition>(defs.length);
            LinkedHashSet<NameFormDefinition> s3 = new LinkedHashSet<NameFormDefinition>(defs.length);
            for (String def : defs) {
                try {
                    NameFormDefinition nf = new NameFormDefinition(def);
                    s3.add(nf);
                    mOC.put(StaticUtils.toLowerCase(nf.getStructuralClass()), nf);
                    mN.put(StaticUtils.toLowerCase(nf.getOID()), nf);
                    for (String name : nf.getNames()) {
                        mN.put(StaticUtils.toLowerCase(name), nf);
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.nfMapByName = Collections.unmodifiableMap(mN);
            this.nfMapByOC = Collections.unmodifiableMap(mOC);
            this.nfSet = Collections.unmodifiableSet(s3);
        }
        defs = schemaEntry.getAttributeValues(ATTR_OBJECT_CLASS);
        if (defs == null) {
            this.ocMap = Collections.emptyMap();
            this.ocSet = Collections.emptySet();
            this.abstractOCSet = Collections.emptySet();
            this.auxiliaryOCSet = Collections.emptySet();
            this.structuralOCSet = Collections.emptySet();
        } else {
            m = new LinkedHashMap(2 * defs.length);
            s = new LinkedHashSet(defs.length);
            LinkedHashSet<ObjectClassDefinition> sAbstract = new LinkedHashSet<ObjectClassDefinition>(defs.length);
            LinkedHashSet<ObjectClassDefinition> sAuxiliary = new LinkedHashSet<ObjectClassDefinition>(defs.length);
            LinkedHashSet<ObjectClassDefinition> sStructural = new LinkedHashSet<ObjectClassDefinition>(defs.length);
            for (String def : defs) {
                try {
                    ObjectClassDefinition oc = new ObjectClassDefinition(def);
                    s.add(oc);
                    m.put(StaticUtils.toLowerCase(oc.getOID()), oc);
                    for (String name : oc.getNames()) {
                        m.put(StaticUtils.toLowerCase(name), oc);
                    }
                    switch (Schema.getOCType(oc, m)) {
                        case ABSTRACT: {
                            sAbstract.add(oc);
                            break;
                        }
                        case AUXILIARY: {
                            sAuxiliary.add(oc);
                            break;
                        }
                        case STRUCTURAL: {
                            sStructural.add(oc);
                        }
                    }
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.ocMap = Collections.unmodifiableMap(m);
            this.ocSet = Collections.unmodifiableSet(s);
            this.abstractOCSet = Collections.unmodifiableSet(sAbstract);
            this.auxiliaryOCSet = Collections.unmodifiableSet(sAuxiliary);
            this.structuralOCSet = Collections.unmodifiableSet(sStructural);
        }
        LinkedHashMap<AttributeTypeDefinition, ArrayList<AttributeTypeDefinition>> subAttrTypes = new LinkedHashMap<AttributeTypeDefinition, ArrayList<AttributeTypeDefinition>>(this.atSet.size());
        for (AttributeTypeDefinition d : this.atSet) {
            for (AttributeTypeDefinition sup = d.getSuperiorType(this); sup != null; sup = sup.getSuperiorType(this)) {
                ArrayList<AttributeTypeDefinition> l = (ArrayList<AttributeTypeDefinition>)subAttrTypes.get(sup);
                if (l == null) {
                    l = new ArrayList<AttributeTypeDefinition>(1);
                    subAttrTypes.put(sup, l);
                }
                l.add(d);
            }
        }
        this.subordinateAttributeTypes = Collections.unmodifiableMap(subAttrTypes);
    }

    public static Schema getSchema(LDAPConnection connection) throws LDAPException {
        return Schema.getSchema(connection, "");
    }

    public static Schema getSchema(LDAPConnection connection, String entryDN) throws LDAPException {
        Validator.ensureNotNull(connection);
        String subschemaSubentryDN = entryDN == null ? Schema.getSubschemaSubentryDN(connection, "") : Schema.getSubschemaSubentryDN(connection, entryDN);
        if (subschemaSubentryDN == null) {
            return null;
        }
        SearchResultEntry schemaEntry = connection.getEntry(subschemaSubentryDN, SCHEMA_REQUEST_ATTRS);
        if (schemaEntry == null) {
            return null;
        }
        return new Schema(schemaEntry);
    }

    public static Schema getSchema(String ... schemaFiles) throws IOException, LDIFException {
        Validator.ensureNotNull(schemaFiles);
        Validator.ensureFalse(schemaFiles.length == 0);
        ArrayList<File> files = new ArrayList<File>(schemaFiles.length);
        for (String s : schemaFiles) {
            files.add(new File(s));
        }
        return Schema.getSchema(files);
    }

    public static Schema getSchema(File ... schemaFiles) throws IOException, LDIFException {
        Validator.ensureNotNull(schemaFiles);
        Validator.ensureFalse(schemaFiles.length == 0);
        return Schema.getSchema(Arrays.asList(schemaFiles));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema getSchema(List<File> schemaFiles) throws IOException, LDIFException {
        Validator.ensureNotNull(schemaFiles);
        Validator.ensureFalse(schemaFiles.isEmpty());
        Entry schemaEntry = null;
        for (File f : schemaFiles) {
            LDIFReader ldifReader = new LDIFReader(f);
            try {
                Entry e = ldifReader.readEntry();
                if (e == null) continue;
                if (schemaEntry == null) {
                    schemaEntry = e;
                    continue;
                }
                for (Attribute a : e.getAttributes()) {
                    schemaEntry.addAttribute(a);
                }
            }
            finally {
                ldifReader.close();
            }
        }
        if (schemaEntry == null) {
            return null;
        }
        return new Schema(schemaEntry);
    }

    public static Schema getDefaultStandardSchema() throws LDAPException {
        AtomicReference<Schema> atomicReference = DEFAULT_STANDARD_SCHEMA;
        synchronized (atomicReference) {
            Schema s = DEFAULT_STANDARD_SCHEMA.get();
            if (s != null) {
                return s;
            }
            try {
                ClassLoader classLoader = Schema.class.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(DEFAULT_SCHEMA_RESOURCE_PATH);
                LDIFReader ldifReader = new LDIFReader(inputStream);
                Entry schemaEntry = ldifReader.readEntry();
                ldifReader.close();
                Schema schema = new Schema(schemaEntry);
                DEFAULT_STANDARD_SCHEMA.set(schema);
                return schema;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, SchemaMessages.ERR_SCHEMA_CANNOT_LOAD_DEFAULT_DEFINITIONS.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    public static Schema mergeSchemas(Schema ... schemas) {
        if (schemas == null || schemas.length == 0) {
            return null;
        }
        if (schemas.length == 1) {
            return schemas[0];
        }
        LinkedHashMap<String, String> asMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> atMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> dcrMap = new LinkedHashMap<String, String>();
        LinkedHashMap<Integer, String> dsrMap = new LinkedHashMap<Integer, String>();
        LinkedHashMap<String, String> mrMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> mruMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> nfMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> ocMap = new LinkedHashMap<String, String>();
        for (Schema s : schemas) {
            for (AttributeSyntaxDefinition as : s.asSet) {
                asMap.put(StaticUtils.toLowerCase(as.getOID()), as.toString());
            }
            for (AttributeTypeDefinition at : s.atSet) {
                atMap.put(StaticUtils.toLowerCase(at.getOID()), at.toString());
            }
            for (DITContentRuleDefinition dcr : s.dcrSet) {
                dcrMap.put(StaticUtils.toLowerCase(dcr.getOID()), dcr.toString());
            }
            for (DITStructureRuleDefinition dsr : s.dsrSet) {
                dsrMap.put(dsr.getRuleID(), dsr.toString());
            }
            for (MatchingRuleDefinition mr : s.mrSet) {
                mrMap.put(StaticUtils.toLowerCase(mr.getOID()), mr.toString());
            }
            for (MatchingRuleUseDefinition mru : s.mruSet) {
                mruMap.put(StaticUtils.toLowerCase(mru.getOID()), mru.toString());
            }
            for (NameFormDefinition nf : s.nfSet) {
                nfMap.put(StaticUtils.toLowerCase(nf.getOID()), nf.toString());
            }
            for (ObjectClassDefinition oc : s.ocSet) {
                ocMap.put(StaticUtils.toLowerCase(oc.getOID()), oc.toString());
            }
        }
        Entry e = new Entry(schemas[0].getSchemaEntry().getDN());
        Attribute ocAttr = schemas[0].getSchemaEntry().getObjectClassAttribute();
        if (ocAttr == null) {
            e.addAttribute("objectClass", "top", "ldapSubEntry", "subschema");
        } else {
            e.addAttribute(ocAttr);
        }
        if (!asMap.isEmpty()) {
            String[] values = new String[asMap.size()];
            e.addAttribute(ATTR_ATTRIBUTE_SYNTAX, asMap.values().toArray(values));
        }
        if (!mrMap.isEmpty()) {
            String[] values = new String[mrMap.size()];
            e.addAttribute(ATTR_MATCHING_RULE, mrMap.values().toArray(values));
        }
        if (!atMap.isEmpty()) {
            String[] values = new String[atMap.size()];
            e.addAttribute(ATTR_ATTRIBUTE_TYPE, atMap.values().toArray(values));
        }
        if (!ocMap.isEmpty()) {
            String[] values = new String[ocMap.size()];
            e.addAttribute(ATTR_OBJECT_CLASS, ocMap.values().toArray(values));
        }
        if (!dcrMap.isEmpty()) {
            String[] values = new String[dcrMap.size()];
            e.addAttribute(ATTR_DIT_CONTENT_RULE, dcrMap.values().toArray(values));
        }
        if (!dsrMap.isEmpty()) {
            String[] values = new String[dsrMap.size()];
            e.addAttribute(ATTR_DIT_STRUCTURE_RULE, dsrMap.values().toArray(values));
        }
        if (!nfMap.isEmpty()) {
            String[] values = new String[nfMap.size()];
            e.addAttribute(ATTR_NAME_FORM, nfMap.values().toArray(values));
        }
        if (!mruMap.isEmpty()) {
            String[] values = new String[mruMap.size()];
            e.addAttribute(ATTR_MATCHING_RULE_USE, mruMap.values().toArray(values));
        }
        return new Schema(e);
    }

    public ReadOnlyEntry getSchemaEntry() {
        return this.schemaEntry;
    }

    private static ObjectClassType getOCType(ObjectClassDefinition oc, Map<String, ObjectClassDefinition> m) {
        ObjectClassType t = oc.getObjectClassType();
        if (t != null) {
            return t;
        }
        for (String s : oc.getSuperiorClasses()) {
            ObjectClassDefinition d = m.get(StaticUtils.toLowerCase(s));
            if (d == null || (t = Schema.getOCType(d, m)) == null) continue;
            return t;
        }
        return ObjectClassType.STRUCTURAL;
    }

    public static String getSubschemaSubentryDN(LDAPConnection connection, String entryDN) throws LDAPException {
        Validator.ensureNotNull(connection);
        SearchResultEntry e = entryDN == null ? connection.getEntry("", SUBSCHEMA_SUBENTRY_REQUEST_ATTRS) : connection.getEntry(entryDN, SUBSCHEMA_SUBENTRY_REQUEST_ATTRS);
        if (e == null) {
            return null;
        }
        return e.getAttributeValue(ATTR_SUBSCHEMA_SUBENTRY);
    }

    public Set<AttributeSyntaxDefinition> getAttributeSyntaxes() {
        return this.asSet;
    }

    public AttributeSyntaxDefinition getAttributeSyntax(String oid) {
        Validator.ensureNotNull(oid);
        String lowerOID = StaticUtils.toLowerCase(oid);
        int curlyPos = lowerOID.indexOf(123);
        if (curlyPos > 0) {
            return this.asMap.get(lowerOID.substring(0, curlyPos));
        }
        return this.asMap.get(lowerOID);
    }

    public Set<AttributeTypeDefinition> getAttributeTypes() {
        return this.atSet;
    }

    public Set<AttributeTypeDefinition> getOperationalAttributeTypes() {
        return this.operationalATSet;
    }

    public Set<AttributeTypeDefinition> getUserAttributeTypes() {
        return this.userATSet;
    }

    public AttributeTypeDefinition getAttributeType(String name) {
        Validator.ensureNotNull(name);
        return this.atMap.get(StaticUtils.toLowerCase(name));
    }

    public List<AttributeTypeDefinition> getSubordinateAttributeTypes(AttributeTypeDefinition d) {
        Validator.ensureNotNull(d);
        List<AttributeTypeDefinition> l = this.subordinateAttributeTypes.get(d);
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    public Set<DITContentRuleDefinition> getDITContentRules() {
        return this.dcrSet;
    }

    public DITContentRuleDefinition getDITContentRule(String name) {
        Validator.ensureNotNull(name);
        return this.dcrMap.get(StaticUtils.toLowerCase(name));
    }

    public Set<DITStructureRuleDefinition> getDITStructureRules() {
        return this.dsrSet;
    }

    public DITStructureRuleDefinition getDITStructureRuleByID(int ruleID) {
        return this.dsrMapByID.get(ruleID);
    }

    public DITStructureRuleDefinition getDITStructureRuleByName(String ruleName) {
        Validator.ensureNotNull(ruleName);
        return this.dsrMapByName.get(StaticUtils.toLowerCase(ruleName));
    }

    public DITStructureRuleDefinition getDITStructureRuleByNameForm(String nameForm) {
        Validator.ensureNotNull(nameForm);
        return this.dsrMapByNameForm.get(StaticUtils.toLowerCase(nameForm));
    }

    public Set<MatchingRuleDefinition> getMatchingRules() {
        return this.mrSet;
    }

    public MatchingRuleDefinition getMatchingRule(String name) {
        Validator.ensureNotNull(name);
        return this.mrMap.get(StaticUtils.toLowerCase(name));
    }

    public Set<MatchingRuleUseDefinition> getMatchingRuleUses() {
        return this.mruSet;
    }

    public MatchingRuleUseDefinition getMatchingRuleUse(String name) {
        Validator.ensureNotNull(name);
        return this.mruMap.get(StaticUtils.toLowerCase(name));
    }

    public Set<NameFormDefinition> getNameForms() {
        return this.nfSet;
    }

    public NameFormDefinition getNameFormByName(String name) {
        Validator.ensureNotNull(name);
        return this.nfMapByName.get(StaticUtils.toLowerCase(name));
    }

    public NameFormDefinition getNameFormByObjectClass(String objectClass) {
        Validator.ensureNotNull(objectClass);
        return this.nfMapByOC.get(StaticUtils.toLowerCase(objectClass));
    }

    public Set<ObjectClassDefinition> getObjectClasses() {
        return this.ocSet;
    }

    public Set<ObjectClassDefinition> getAbstractObjectClasses() {
        return this.abstractOCSet;
    }

    public Set<ObjectClassDefinition> getAuxiliaryObjectClasses() {
        return this.auxiliaryOCSet;
    }

    public Set<ObjectClassDefinition> getStructuralObjectClasses() {
        return this.structuralOCSet;
    }

    public ObjectClassDefinition getObjectClass(String name) {
        Validator.ensureNotNull(name);
        return this.ocMap.get(StaticUtils.toLowerCase(name));
    }
}

