/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPException;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPSocketFactory;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JavaToLDAPSocketFactory
extends SocketFactory
implements LDAPSocketFactory {
    private final SocketFactory f;

    public JavaToLDAPSocketFactory(SocketFactory f) {
        this.f = f;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.f.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.f.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.f.createSocket(address, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.f.createSocket(address, port, localAddress, localPort);
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        try {
            return this.f.createSocket(host, port);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(StaticUtils.getExceptionMessage(e), 91);
        }
    }
}

