/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncSearchHelper
implements ResponseAcceptor,
IntermediateResponseListener {
    private static final long serialVersionUID = 1006163445423767824L;
    private final AsyncRequestID asyncRequestID;
    private final AsyncSearchResultListener resultListener;
    private int numEntries;
    private int numReferences;
    private final IntermediateResponseListener intermediateResponseListener;
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncSearchHelper(LDAPConnection connection, int messageID, AsyncSearchResultListener resultListener, IntermediateResponseListener intermediateResponseListener) {
        this.connection = connection;
        this.resultListener = resultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.numEntries = 0;
        this.numReferences = 0;
        this.asyncRequestID = new AsyncRequestID(messageID, connection);
        this.createTime = System.nanoTime();
    }

    AsyncRequestID getAsyncRequestID() {
        return this.asyncRequestID;
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get());
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(message));
        }
        if (response instanceof SearchResultEntry) {
            ++this.numEntries;
            this.resultListener.searchEntryReturned((SearchResultEntry)response);
        } else if (response instanceof SearchResultReference) {
            ++this.numReferences;
            this.resultListener.searchReferenceReturned((SearchResultReference)response);
        } else {
            this.connection.getConnectionStatistics().incrementNumSearchResponses(this.numEntries, this.numReferences, System.nanoTime() - this.createTime);
            SearchResult searchResult = (SearchResult)response;
            searchResult.setCounts(this.numEntries, null, this.numReferences, null);
            this.resultListener.searchResultReceived(this.asyncRequestID, searchResult);
            this.asyncRequestID.setResult(searchResult);
        }
    }

    @InternalUseOnly
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

