/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ModifyRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -6294739625253826184L;
    private final List<Modification> modifications;
    private final String dn;

    public ModifyRequestProtocolOp(String dn, List<Modification> modifications) {
        this.dn = dn;
        this.modifications = Collections.unmodifiableList(modifications);
    }

    ModifyRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            reader.beginSequence();
            this.dn = reader.readString();
            Validator.ensureNotNull(this.dn);
            ArrayList<Modification> mods = new ArrayList<Modification>(5);
            ASN1StreamReaderSequence modSequence = reader.beginSequence();
            while (modSequence.hasMoreElements()) {
                mods.add(Modification.readFrom(reader));
            }
            this.modifications = Collections.unmodifiableList(mods);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    @Override
    public byte getProtocolOpType() {
        return 102;
    }

    @Override
    public void writeTo(ASN1Buffer writer) {
        ASN1BufferSequence opSequence = writer.beginSequence((byte)102);
        writer.addOctetString(this.dn);
        ASN1BufferSequence modSequence = writer.beginSequence();
        for (Modification m : this.modifications) {
            m.writeTo(writer);
        }
        modSequence.end();
        opSequence.end();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ModifyRequestProtocolOp(dn='");
        buffer.append(this.dn);
        buffer.append("', mods={");
        Iterator<Modification> iterator = this.modifications.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("})");
    }
}

