/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.AccessLogRequestHandler;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryDirectoryServerSnapshot;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.LDAPDebuggerRequestHandler;
import com.unboundid.ldap.listener.LDAPListener;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.ReadOnlyInMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.StartTLSRequestHandler;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InMemoryDirectoryServer
implements LDAPInterface {
    private final InMemoryRequestHandler inMemoryHandler;
    private final Map<String, LDAPListener> listeners;
    private final Map<String, LDAPListenerConfig> ldapListenerConfigs;
    private final Map<String, SocketFactory> clientSocketFactories;
    private final ReadOnlyInMemoryDirectoryServerConfig config;

    public InMemoryDirectoryServer(String ... baseDNs) throws LDAPException {
        this(new InMemoryDirectoryServerConfig(baseDNs));
    }

    public InMemoryDirectoryServer(InMemoryDirectoryServerConfig cfg) throws LDAPException {
        Validator.ensureNotNull(cfg);
        this.config = new ReadOnlyInMemoryDirectoryServerConfig(cfg);
        LDAPListenerRequestHandler requestHandler = this.inMemoryHandler = new InMemoryRequestHandler(this.config);
        if (this.config.getAccessLogHandler() != null) {
            requestHandler = new AccessLogRequestHandler(this.config.getAccessLogHandler(), requestHandler);
        }
        if (this.config.getLDAPDebugLogHandler() != null) {
            requestHandler = new LDAPDebuggerRequestHandler(this.config.getLDAPDebugLogHandler(), requestHandler);
        }
        List<InMemoryListenerConfig> listenerConfigs = this.config.getListenerConfigs();
        this.listeners = new LinkedHashMap<String, LDAPListener>(listenerConfigs.size());
        this.ldapListenerConfigs = new LinkedHashMap<String, LDAPListenerConfig>(listenerConfigs.size());
        this.clientSocketFactories = new LinkedHashMap<String, SocketFactory>(listenerConfigs.size());
        for (InMemoryListenerConfig c : listenerConfigs) {
            String name = StaticUtils.toLowerCase(c.getListenerName());
            LDAPListenerRequestHandler listenerRequestHandler = c.getStartTLSSocketFactory() == null ? requestHandler : new StartTLSRequestHandler(c.getStartTLSSocketFactory(), requestHandler);
            LDAPListenerConfig listenerCfg = new LDAPListenerConfig(c.getListenPort(), listenerRequestHandler);
            listenerCfg.setExceptionHandler(this.config.getListenerExceptionHandler());
            listenerCfg.setListenAddress(c.getListenAddress());
            listenerCfg.setServerSocketFactory(c.getServerSocketFactory());
            this.ldapListenerConfigs.put(name, listenerCfg);
            if (c.getClientSocketFactory() == null) continue;
            this.clientSocketFactories.put(name, c.getClientSocketFactory());
        }
    }

    public synchronized void startListening() throws LDAPException {
        ArrayList<String> messages = new ArrayList<String>(this.listeners.size());
        for (Map.Entry<String, LDAPListenerConfig> cfgEntry : this.ldapListenerConfigs.entrySet()) {
            String name = cfgEntry.getKey();
            if (this.listeners.containsKey(name)) continue;
            LDAPListenerConfig listenerConfig = cfgEntry.getValue();
            LDAPListener listener = new LDAPListener(listenerConfig);
            try {
                listener.startListening();
                listenerConfig.setListenPort(listener.getListenPort());
                this.listeners.put(name, listener);
            }
            catch (Exception e) {
                Debug.debugException(e);
                messages.add(ListenerMessages.ERR_MEM_DS_START_FAILED.get(name, StaticUtils.getExceptionMessage(e)));
            }
        }
        if (!messages.isEmpty()) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, StaticUtils.concatenateStrings(messages));
        }
    }

    public synchronized void startListening(String listenerName) throws LDAPException {
        String name = StaticUtils.toLowerCase(listenerName);
        if (this.listeners.containsKey(name)) {
            return;
        }
        LDAPListenerConfig listenerConfig = this.ldapListenerConfigs.get(name);
        if (listenerConfig == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_NO_SUCH_LISTENER.get(listenerName));
        }
        LDAPListener listener = new LDAPListener(listenerConfig);
        try {
            listener.startListening();
            listenerConfig.setListenPort(listener.getListenPort());
            this.listeners.put(name, listener);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_START_FAILED.get(name, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public synchronized void shutDown(boolean closeExistingConnections) {
        for (LDAPListener l : this.listeners.values()) {
            try {
                l.shutDown(closeExistingConnections);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.listeners.clear();
    }

    public synchronized void shutDown(String listenerName, boolean closeExistingConnections) {
        String name = StaticUtils.toLowerCase(listenerName);
        LDAPListener listener = this.listeners.remove(name);
        if (listener != null) {
            listener.shutDown(closeExistingConnections);
        }
    }

    public synchronized void restartServer() throws LDAPException {
        this.shutDown(true);
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.startListening();
    }

    public synchronized void restartListener(String listenerName) throws LDAPException {
        this.shutDown(listenerName, true);
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.startListening(listenerName);
    }

    public ReadOnlyInMemoryDirectoryServerConfig getConfig() {
        return this.config;
    }

    InMemoryRequestHandler getInMemoryRequestHandler() {
        return this.inMemoryHandler;
    }

    public InMemoryDirectoryServerSnapshot createSnapshot() {
        return this.inMemoryHandler.createSnapshot();
    }

    public void restoreSnapshot(InMemoryDirectoryServerSnapshot snapshot) {
        this.inMemoryHandler.restoreSnapshot(snapshot);
    }

    public List<DN> getBaseDNs() {
        return this.inMemoryHandler.getBaseDNs();
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null, null);
    }

    public LDAPConnection getConnection(LDAPConnectionOptions options) throws LDAPException {
        return this.getConnection(null, options);
    }

    public LDAPConnection getConnection(String listenerName) throws LDAPException {
        return this.getConnection(listenerName, null);
    }

    public synchronized LDAPConnection getConnection(String listenerName, LDAPConnectionOptions options) throws LDAPException {
        String hostAddress;
        SocketFactory clientSocketFactory;
        LDAPListenerConfig listenerConfig;
        String name;
        if (listenerName == null) {
            name = this.getFirstListenerName();
            if (name == null) {
                throw new LDAPException(ResultCode.CONNECT_ERROR, ListenerMessages.ERR_MEM_DS_GET_CONNECTION_NO_LISTENERS.get());
            }
            listenerConfig = this.ldapListenerConfigs.get(name);
            clientSocketFactory = this.clientSocketFactories.get(name);
        } else {
            name = StaticUtils.toLowerCase(listenerName);
            if (!this.listeners.containsKey(name)) {
                throw new LDAPException(ResultCode.CONNECT_ERROR, ListenerMessages.ERR_MEM_DS_GET_CONNECTION_LISTENER_NOT_RUNNING.get(listenerName));
            }
            listenerConfig = this.ldapListenerConfigs.get(name);
            clientSocketFactory = this.clientSocketFactories.get(name);
        }
        InetAddress listenAddress = listenerConfig.getListenAddress();
        if (listenAddress == null || listenAddress.isAnyLocalAddress()) {
            try {
                hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                Debug.debugException(e);
                hostAddress = "127.0.0.1";
            }
        } else {
            hostAddress = listenAddress.getHostAddress();
        }
        return new LDAPConnection(clientSocketFactory, options, hostAddress, listenerConfig.getListenPort());
    }

    public LDAPConnectionPool getConnectionPool(int maxConnections) throws LDAPException {
        return this.getConnectionPool(null, null, 1, maxConnections);
    }

    public LDAPConnectionPool getConnectionPool(String listenerName, LDAPConnectionOptions options, int initialConnections, int maxConnections) throws LDAPException {
        LDAPConnection conn = this.getConnection(listenerName, options);
        return new LDAPConnectionPool(conn, initialConnections, maxConnections);
    }

    public InetAddress getListenAddress() {
        return this.getListenAddress(null);
    }

    public synchronized InetAddress getListenAddress(String listenerName) {
        String name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase(listenerName);
        LDAPListenerConfig listenerCfg = this.ldapListenerConfigs.get(name);
        if (listenerCfg == null) {
            return null;
        }
        return listenerCfg.getListenAddress();
    }

    public int getListenPort() {
        return this.getListenPort(null);
    }

    public synchronized int getListenPort(String listenerName) {
        String name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase(listenerName);
        LDAPListener listener = this.listeners.get(name);
        if (listener == null) {
            return -1;
        }
        return listener.getListenPort();
    }

    public SocketFactory getClientSocketFactory() {
        return this.getClientSocketFactory(null);
    }

    public synchronized SocketFactory getClientSocketFactory(String listenerName) {
        String name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase(listenerName);
        return this.clientSocketFactories.get(name);
    }

    private String getFirstListenerName() {
        for (Map.Entry<String, LDAPListenerConfig> e : this.ldapListenerConfigs.entrySet()) {
            String name = e.getKey();
            if (!this.listeners.containsKey(name)) continue;
            return name;
        }
        return null;
    }

    public long getProcessingDelayMillis() {
        return this.inMemoryHandler.getProcessingDelayMillis();
    }

    public void setProcessingDelayMillis(long processingDelayMillis) {
        this.inMemoryHandler.setProcessingDelayMillis(processingDelayMillis);
    }

    public int countEntries() {
        return this.countEntries(false);
    }

    public int countEntries(boolean includeChangeLog) {
        return this.inMemoryHandler.countEntries(includeChangeLog);
    }

    public int countEntriesBelow(String baseDN) throws LDAPException {
        return this.inMemoryHandler.countEntriesBelow(baseDN);
    }

    public void clear() {
        this.inMemoryHandler.clear();
    }

    public int importFromLDIF(boolean clear, String path) throws LDAPException {
        LDIFReader reader;
        try {
            reader = new LDIFReader(path);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_INIT_FROM_LDIF_CANNOT_CREATE_READER.get(path, StaticUtils.getExceptionMessage(e)), e);
        }
        return this.importFromLDIF(clear, reader);
    }

    public int importFromLDIF(boolean clear, LDIFReader reader) throws LDAPException {
        return this.inMemoryHandler.importFromLDIF(clear, reader);
    }

    public int exportToLDIF(String path, boolean excludeGeneratedAttrs, boolean excludeChangeLog) throws LDAPException {
        LDIFWriter ldifWriter;
        try {
            ldifWriter = new LDIFWriter(path);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_EXPORT_TO_LDIF_CANNOT_CREATE_WRITER.get(path, StaticUtils.getExceptionMessage(e)), e);
        }
        return this.exportToLDIF(ldifWriter, excludeGeneratedAttrs, excludeChangeLog, true);
    }

    public int exportToLDIF(LDIFWriter ldifWriter, boolean excludeGeneratedAttrs, boolean excludeChangeLog, boolean closeWriter) throws LDAPException {
        return this.inMemoryHandler.exportToLDIF(ldifWriter, excludeGeneratedAttrs, excludeChangeLog, closeWriter);
    }

    @Override
    public RootDSE getRootDSE() throws LDAPException {
        return new RootDSE(this.inMemoryHandler.getEntry(""));
    }

    @Override
    public Schema getSchema() throws LDAPException {
        return this.inMemoryHandler.getSchema();
    }

    @Override
    public Schema getSchema(String entryDN) throws LDAPException {
        return this.inMemoryHandler.getSchema();
    }

    @Override
    public SearchResultEntry getEntry(String dn) throws LDAPException {
        return this.searchForEntry(dn, SearchScope.BASE, Filter.createPresenceFilter("objectClass"), new String[0]);
    }

    @Override
    public SearchResultEntry getEntry(String dn, String ... attributes) throws LDAPException {
        return this.searchForEntry(dn, SearchScope.BASE, Filter.createPresenceFilter("objectClass"), attributes);
    }

    @Override
    public LDAPResult add(String dn, Attribute ... attributes) throws LDAPException {
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    public LDAPResult add(String dn, Collection<Attribute> attributes) throws LDAPException {
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    public LDAPResult add(Entry entry) throws LDAPException {
        return this.add(new AddRequest(entry));
    }

    @Override
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.add(new AddRequest(ldifLines));
    }

    @Override
    public LDAPResult add(AddRequest addRequest) throws LDAPException {
        ArrayList<Control> requestControlList = new ArrayList<Control>(addRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processAddRequest(1, new AddRequestProtocolOp(addRequest.getDN(), addRequest.getAttributes()), requestControlList);
        AddResponseProtocolOp addResponse = responseMessage.getAddResponseProtocolOp();
        LDAPResult ldapResult = new LDAPResult(responseMessage.getMessageID(), ResultCode.valueOf(addResponse.getResultCode()), addResponse.getDiagnosticMessage(), addResponse.getMatchedDN(), addResponse.getReferralURLs(), responseMessage.getControls());
        switch (addResponse.getResultCode()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    public LDAPResult add(ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.add(addRequest.duplicate());
    }

    public void addEntries(Entry ... entries) throws LDAPException {
        this.addEntries(Arrays.asList(entries));
    }

    public void addEntries(List<? extends Entry> entries) throws LDAPException {
        this.inMemoryHandler.addEntries(entries);
    }

    public void addEntries(String ... ldifEntryLines) throws LDAPException {
        ByteStringBuffer buffer = new ByteStringBuffer();
        for (String line : ldifEntryLines) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        ArrayList<Entry> entryList = new ArrayList<Entry>(10);
        LDIFReader reader = new LDIFReader(buffer.asInputStream());
        try {
            Entry entry;
            while ((entry = reader.readEntry()) != null) {
                entryList.add(entry);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_ADD_ENTRIES_LDIF_PARSE_EXCEPTION.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.addEntries(entryList);
    }

    @Override
    public CompareResult compare(String dn, String attributeName, String assertionValue) throws LDAPException {
        return this.compare(new CompareRequest(dn, attributeName, assertionValue));
    }

    @Override
    public CompareResult compare(CompareRequest compareRequest) throws LDAPException {
        ArrayList<Control> requestControlList = new ArrayList<Control>(compareRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processCompareRequest(1, new CompareRequestProtocolOp(compareRequest.getDN(), compareRequest.getAttributeName(), compareRequest.getRawAssertionValue()), requestControlList);
        CompareResponseProtocolOp compareResponse = responseMessage.getCompareResponseProtocolOp();
        LDAPResult compareResult = new LDAPResult(responseMessage.getMessageID(), ResultCode.valueOf(compareResponse.getResultCode()), compareResponse.getDiagnosticMessage(), compareResponse.getMatchedDN(), compareResponse.getReferralURLs(), responseMessage.getControls());
        switch (compareResponse.getResultCode()) {
            case 5: 
            case 6: {
                return new CompareResult(compareResult);
            }
        }
        throw new LDAPException(compareResult);
    }

    @Override
    public CompareResult compare(ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.compare(compareRequest.duplicate());
    }

    @Override
    public LDAPResult delete(String dn) throws LDAPException {
        return this.delete(new DeleteRequest(dn));
    }

    @Override
    public LDAPResult delete(DeleteRequest deleteRequest) throws LDAPException {
        ArrayList<Control> requestControlList = new ArrayList<Control>(deleteRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processDeleteRequest(1, new DeleteRequestProtocolOp(deleteRequest.getDN()), requestControlList);
        DeleteResponseProtocolOp deleteResponse = responseMessage.getDeleteResponseProtocolOp();
        LDAPResult ldapResult = new LDAPResult(responseMessage.getMessageID(), ResultCode.valueOf(deleteResponse.getResultCode()), deleteResponse.getDiagnosticMessage(), deleteResponse.getMatchedDN(), deleteResponse.getReferralURLs(), responseMessage.getControls());
        switch (deleteResponse.getResultCode()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    public LDAPResult delete(ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.delete(deleteRequest.duplicate());
    }

    public int deleteSubtree(String baseDN) throws LDAPException {
        return this.inMemoryHandler.deleteSubtree(baseDN);
    }

    public ExtendedResult processExtendedOperation(String requestOID) throws LDAPException {
        Validator.ensureNotNull(requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID));
    }

    public ExtendedResult processExtendedOperation(String requestOID, ASN1OctetString requestValue) throws LDAPException {
        Validator.ensureNotNull(requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID, requestValue));
    }

    public ExtendedResult processExtendedOperation(ExtendedRequest extendedRequest) throws LDAPException {
        Control[] responseControls;
        String[] referralURLs;
        Validator.ensureNotNull(extendedRequest);
        ArrayList<Control> requestControlList = new ArrayList<Control>(extendedRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processExtendedRequest(1, new ExtendedRequestProtocolOp(extendedRequest.getOID(), extendedRequest.getValue()), requestControlList);
        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
        ResultCode rc = ResultCode.valueOf(extendedResponse.getResultCode());
        List<String> referralURLList = extendedResponse.getReferralURLs();
        if (referralURLList == null || referralURLList.isEmpty()) {
            referralURLs = StaticUtils.NO_STRINGS;
        } else {
            referralURLs = new String[referralURLList.size()];
            referralURLList.toArray(referralURLs);
        }
        List<Control> controlList = responseMessage.getControls();
        if (controlList == null || controlList.isEmpty()) {
            responseControls = StaticUtils.NO_CONTROLS;
        } else {
            responseControls = new Control[controlList.size()];
            controlList.toArray(responseControls);
        }
        ExtendedResult extendedResult = new ExtendedResult(responseMessage.getMessageID(), rc, extendedResponse.getDiagnosticMessage(), extendedResponse.getMatchedDN(), referralURLs, extendedResponse.getResponseOID(), extendedResponse.getResponseValue(), responseControls);
        if (extendedResult.getOID() == null && extendedResult.getValue() == null) {
            switch (rc.intValue()) {
                case 1: 
                case 2: 
                case 51: 
                case 52: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 90: 
                case 91: {
                    throw new LDAPException(extendedResult);
                }
            }
        }
        return extendedResult;
    }

    @Override
    public LDAPResult modify(String dn, Modification mod) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mod));
    }

    @Override
    public LDAPResult modify(String dn, Modification ... mods) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    public LDAPResult modify(String dn, List<Modification> mods) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        return this.modify(new ModifyRequest(ldifModificationLines));
    }

    @Override
    public LDAPResult modify(ModifyRequest modifyRequest) throws LDAPException {
        ArrayList<Control> requestControlList = new ArrayList<Control>(modifyRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processModifyRequest(1, new ModifyRequestProtocolOp(modifyRequest.getDN(), modifyRequest.getModifications()), requestControlList);
        ModifyResponseProtocolOp modifyResponse = responseMessage.getModifyResponseProtocolOp();
        LDAPResult ldapResult = new LDAPResult(responseMessage.getMessageID(), ResultCode.valueOf(modifyResponse.getResultCode()), modifyResponse.getDiagnosticMessage(), modifyResponse.getMatchedDN(), modifyResponse.getReferralURLs(), responseMessage.getControls());
        switch (modifyResponse.getResultCode()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    public LDAPResult modify(ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.modify(modifyRequest.duplicate());
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN) throws LDAPException {
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN));
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN) throws LDAPException {
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN, newSuperiorDN));
    }

    @Override
    public LDAPResult modifyDN(ModifyDNRequest modifyDNRequest) throws LDAPException {
        ArrayList<Control> requestControlList = new ArrayList<Control>(modifyDNRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processModifyDNRequest(1, new ModifyDNRequestProtocolOp(modifyDNRequest.getDN(), modifyDNRequest.getNewRDN(), modifyDNRequest.deleteOldRDN(), modifyDNRequest.getNewSuperiorDN()), requestControlList);
        ModifyDNResponseProtocolOp modifyDNResponse = responseMessage.getModifyDNResponseProtocolOp();
        LDAPResult ldapResult = new LDAPResult(responseMessage.getMessageID(), ResultCode.valueOf(modifyDNResponse.getResultCode()), modifyDNResponse.getDiagnosticMessage(), modifyDNResponse.getMatchedDN(), modifyDNResponse.getReferralURLs(), responseMessage.getControls());
        switch (modifyDNResponse.getResultCode()) {
            case 0: 
            case 16654: {
                return ldapResult;
            }
        }
        throw new LDAPException(ldapResult);
    }

    @Override
    public LDAPResult modifyDN(ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.modifyDN(modifyDNRequest.duplicate());
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, filter, attributes));
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, filter, attributes));
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    public SearchResult search(SearchRequest searchRequest) throws LDAPSearchException {
        Control[] responseControls;
        String[] referralURLs;
        List<SearchResultReference> returnReferenceList;
        List<SearchResultEntry> returnEntryList;
        ArrayList<Control> requestControlList = new ArrayList<Control>(searchRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        ArrayList<SearchResultEntry> entryList = new ArrayList<SearchResultEntry>(10);
        ArrayList<SearchResultReference> referenceList = new ArrayList<SearchResultReference>(10);
        LDAPMessage responseMessage = this.inMemoryHandler.processSearchRequest(1, new SearchRequestProtocolOp(searchRequest.getBaseDN(), searchRequest.getScope(), searchRequest.getDereferencePolicy(), searchRequest.getSizeLimit(), searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), searchRequest.getFilter(), searchRequest.getAttributeList()), requestControlList, entryList, referenceList);
        SearchResultListener searchListener = searchRequest.getSearchResultListener();
        if (searchListener == null) {
            returnEntryList = Collections.unmodifiableList(entryList);
            returnReferenceList = Collections.unmodifiableList(referenceList);
        } else {
            returnEntryList = null;
            returnReferenceList = null;
            for (SearchResultEntry e : entryList) {
                searchListener.searchEntryReturned(e);
            }
            for (SearchResultReference r : referenceList) {
                searchListener.searchReferenceReturned(r);
            }
        }
        SearchResultDoneProtocolOp searchDone = responseMessage.getSearchResultDoneProtocolOp();
        ResultCode rc = ResultCode.valueOf(searchDone.getResultCode());
        List<String> referralURLList = searchDone.getReferralURLs();
        if (referralURLList == null || referralURLList.isEmpty()) {
            referralURLs = StaticUtils.NO_STRINGS;
        } else {
            referralURLs = new String[referralURLList.size()];
            referralURLList.toArray(referralURLs);
        }
        List<Control> controlList = responseMessage.getControls();
        if (controlList == null || controlList.isEmpty()) {
            responseControls = StaticUtils.NO_CONTROLS;
        } else {
            responseControls = new Control[controlList.size()];
            controlList.toArray(responseControls);
        }
        SearchResult searchResult = new SearchResult(responseMessage.getMessageID(), rc, searchDone.getDiagnosticMessage(), searchDone.getMatchedDN(), referralURLs, returnEntryList, returnReferenceList, entryList.size(), referenceList.size(), responseControls);
        if (rc == ResultCode.SUCCESS) {
            return searchResult;
        }
        throw new LDAPSearchException(searchResult);
    }

    @Override
    public SearchResult search(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.search(searchRequest.duplicate());
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, filter, attributes));
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    public SearchResultEntry searchForEntry(SearchRequest searchRequest) throws LDAPSearchException {
        SearchResult result;
        SearchRequest r;
        ArrayList<Control> requestControlList = new ArrayList<Control>(searchRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        if (searchRequest.getSizeLimit() == 1 && searchRequest.getSearchResultListener() == null) {
            r = searchRequest;
        } else {
            r = new SearchRequest(searchRequest.getBaseDN(), searchRequest.getScope(), searchRequest.getDereferencePolicy(), 1, searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), searchRequest.getFilter(), searchRequest.getAttributes());
            r.setFollowReferrals(InternalSDKHelper.followReferralsInternal(r));
            r.setResponseTimeoutMillis(searchRequest.getResponseTimeoutMillis(null));
            r.setControls(requestControlList);
        }
        try {
            result = this.search(r);
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            if (lse.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return null;
            }
            throw lse;
        }
        if (result.getEntryCount() == 0) {
            return null;
        }
        return result.getSearchEntries().get(0);
    }

    @Override
    public SearchResultEntry searchForEntry(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.searchForEntry(searchRequest.duplicate());
    }

    private static Filter parseFilter(String s) throws LDAPSearchException {
        try {
            return Filter.create(s);
        }
        catch (LDAPException le) {
            throw new LDAPSearchException(le);
        }
    }

    public boolean entryExists(String dn) throws LDAPException {
        return this.inMemoryHandler.entryExists(dn);
    }

    public boolean entryExists(String dn, String filter) throws LDAPException {
        return this.inMemoryHandler.entryExists(dn, filter);
    }

    public boolean entryExists(Entry entry) throws LDAPException {
        return this.inMemoryHandler.entryExists(entry);
    }

    public void assertEntryExists(String dn) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(dn);
    }

    public void assertEntryExists(String dn, String filter) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(dn, filter);
    }

    public void assertEntryExists(Entry entry) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(entry);
    }

    public List<String> getMissingEntryDNs(String ... dns) throws LDAPException {
        return this.inMemoryHandler.getMissingEntryDNs(StaticUtils.toList(dns));
    }

    public List<String> getMissingEntryDNs(Collection<String> dns) throws LDAPException {
        return this.inMemoryHandler.getMissingEntryDNs(dns);
    }

    public void assertEntriesExist(String ... dns) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntriesExist(StaticUtils.toList(dns));
    }

    public void assertEntriesExist(Collection<String> dns) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntriesExist(dns);
    }

    public List<String> getMissingAttributeNames(String dn, String ... attributeNames) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeNames(dn, StaticUtils.toList(attributeNames));
    }

    public List<String> getMissingAttributeNames(String dn, Collection<String> attributeNames) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeNames(dn, attributeNames);
    }

    public void assertAttributeExists(String dn, String ... attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeExists(dn, StaticUtils.toList(attributeNames));
    }

    public void assertAttributeExists(String dn, Collection<String> attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeExists(dn, attributeNames);
    }

    public List<String> getMissingAttributeValues(String dn, String attributeName, String ... attributeValues) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeValues(dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public List<String> getMissingAttributeValues(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeValues(dn, attributeName, attributeValues);
    }

    public void assertValueExists(String dn, String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueExists(dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public void assertValueExists(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueExists(dn, attributeName, attributeValues);
    }

    public void assertEntryMissing(String dn) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryMissing(dn);
    }

    public void assertAttributeMissing(String dn, String ... attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeMissing(dn, StaticUtils.toList(attributeNames));
    }

    public void assertAttributeMissing(String dn, Collection<String> attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeMissing(dn, attributeNames);
    }

    public void assertValueMissing(String dn, String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueMissing(dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public void assertValueMissing(String dn, String attributeName, Collection<String> attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueMissing(dn, attributeName, attributeValues);
    }
}

