/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.providers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectReader;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.StaticUtils;
import com.unboundid.scim2.server.utils.ServerUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
@Priority(value=4000)
public class DotSearchFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getMethod().equals("POST") && requestContext.getUriInfo().getPath().endsWith(".search")) {
            if (requestContext.getMediaType() == null || !requestContext.getMediaType().isCompatible(ServerUtils.MEDIA_TYPE_SCIM_TYPE) && !requestContext.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                throw new NotSupportedException();
            }
            ObjectReader reader = JsonUtils.getObjectReader().forType(SearchRequest.class);
            JsonParser p = reader.getFactory().createParser(requestContext.getEntityStream());
            if (p.nextToken() == null) {
                throw new BadRequestException((Throwable)new NoContentException("Empty Entity"));
            }
            SearchRequest searchRequest = (SearchRequest)reader.readValue(p);
            UriBuilder builder = requestContext.getUriInfo().getBaseUriBuilder();
            List pathSegments = requestContext.getUriInfo().getPathSegments();
            for (int i = 0; i < pathSegments.size() - 1; ++i) {
                builder.path(((PathSegment)pathSegments.get(i)).getPath());
            }
            if (searchRequest.getAttributes() != null) {
                builder.queryParam("attributes", new Object[]{ServerUtils.encodeTemplateNames(StaticUtils.collectionToString((Collection)searchRequest.getAttributes(), (String)","))});
            }
            if (searchRequest.getExcludedAttributes() != null) {
                builder.queryParam("excludedAttributes", new Object[]{ServerUtils.encodeTemplateNames(StaticUtils.collectionToString((Collection)searchRequest.getExcludedAttributes(), (String)","))});
            }
            if (searchRequest.getFilter() != null) {
                builder.queryParam("filter", new Object[]{ServerUtils.encodeTemplateNames(searchRequest.getFilter())});
            }
            if (searchRequest.getSortBy() != null) {
                builder.queryParam("sortBy", new Object[]{ServerUtils.encodeTemplateNames(searchRequest.getSortBy())});
            }
            if (searchRequest.getSortOrder() != null) {
                builder.queryParam("sortOrder", new Object[]{ServerUtils.encodeTemplateNames(searchRequest.getSortOrder().getName())});
            }
            if (searchRequest.getStartIndex() != null) {
                builder.queryParam("startIndex", new Object[]{searchRequest.getStartIndex()});
            }
            if (searchRequest.getCount() != null) {
                builder.queryParam("count", new Object[]{searchRequest.getCount()});
            }
            requestContext.setRequestUri(builder.build(new Object[0]));
            requestContext.setMethod("GET");
        }
    }
}

