/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.resources;

import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.types.ServiceProviderConfigResource;
import com.unboundid.scim2.server.annotations.ResourceType;
import com.unboundid.scim2.server.utils.ResourcePreparer;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@ResourceType(description="SCIM 2.0 Service Provider Config", name="ServiceProviderConfig", schema=ServiceProviderConfigResource.class, discoverable=false)
@Path(value="ServiceProviderConfig")
public abstract class AbstractServiceProviderConfigEndpoint {
    private static final ResourceTypeDefinition RESOURCE_TYPE_DEFINITION = ResourceTypeDefinition.fromJaxRsResource(AbstractServiceProviderConfigEndpoint.class);

    @GET
    @Produces(value={"application/scim+json", "application/json"})
    public GenericScimResource get(@Context UriInfo uriInfo) throws ScimException {
        ServiceProviderConfigResource serviceProviderConfig = this.getServiceProviderConfig();
        ResourcePreparer<GenericScimResource> resourcePreparer = new ResourcePreparer<GenericScimResource>(RESOURCE_TYPE_DEFINITION, uriInfo);
        GenericScimResource resource = serviceProviderConfig.asGenericScimResource();
        resourcePreparer.setResourceTypeAndLocation(resource);
        return resource;
    }

    public abstract ServiceProviderConfigResource getServiceProviderConfig() throws ScimException;
}

