/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ListResponseWriter<T extends ScimResource> {
    private final JsonGenerator jsonGenerator;
    private final AtomicBoolean startedResourcesArray = new AtomicBoolean();
    private final AtomicBoolean sentTotalResults = new AtomicBoolean();
    private final AtomicInteger resultsSent = new AtomicInteger();
    private ObjectNode deferredFields;

    public ListResponseWriter(OutputStream outputStream) throws IOException {
        this.jsonGenerator = JsonUtils.getObjectReader().getFactory().createGenerator(outputStream);
        this.deferredFields = JsonUtils.getJsonNodeFactory().objectNode();
    }

    void startResponse() throws IOException {
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeArrayFieldStart("schemas");
        this.jsonGenerator.writeString("urn:ietf:params:scim:api:messages:2.0:ListResponse");
        this.jsonGenerator.writeEndArray();
    }

    void endResponse() throws IOException {
        if (!this.sentTotalResults.get() && !this.deferredFields.has("totalResults")) {
            this.totalResults(this.resultsSent.get());
        }
        if (this.startedResourcesArray.get()) {
            this.jsonGenerator.writeEndArray();
        }
        Iterator i = this.deferredFields.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            this.jsonGenerator.writeObjectField((String)field.getKey(), field.getValue());
        }
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.flush();
        this.jsonGenerator.close();
    }

    public void startIndex(int startIndex) throws IOException {
        if (this.startedResourcesArray.get()) {
            this.deferredFields.put("startIndex", startIndex);
        } else {
            this.jsonGenerator.writeNumberField("startIndex", startIndex);
        }
    }

    public void itemsPerPage(int itemsPerPage) throws IOException {
        if (this.startedResourcesArray.get()) {
            this.deferredFields.put("itemsPerPage", itemsPerPage);
        } else {
            this.jsonGenerator.writeNumberField("itemsPerPage", itemsPerPage);
        }
    }

    public void totalResults(int totalResults) throws IOException {
        if (this.startedResourcesArray.get()) {
            this.deferredFields.put("totalResults", totalResults);
        } else {
            this.jsonGenerator.writeNumberField("totalResults", totalResults);
            this.sentTotalResults.set(true);
        }
    }

    public void resource(T scimResource) throws IOException {
        if (this.startedResourcesArray.compareAndSet(false, true)) {
            this.jsonGenerator.writeArrayFieldStart("Resources");
        }
        this.jsonGenerator.writeObject(scimResource);
        this.resultsSent.incrementAndGet();
    }
}

