/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.EnterpriseUserExtension;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.types.UserResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaChecker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaCheckerTestCase {
    private SchemaResource coreSchema;
    private SchemaResource typeTestSchema;

    @BeforeClass
    public void setUp() throws Exception {
        this.coreSchema = SchemaUtils.getSchema(UserResource.class);
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        AttributeDefinition.Builder builder = new AttributeDefinition.Builder();
        builder.setName("string");
        builder.setType(AttributeDefinition.Type.STRING);
        AttributeDefinition string = builder.build();
        attributeDefinitions.add(string);
        builder = new AttributeDefinition.Builder();
        builder.setName("stringCanonical");
        builder.setType(AttributeDefinition.Type.STRING);
        builder.addCanonicalValues(new String[]{"value1", "value2"});
        AttributeDefinition stringCanonical = builder.build();
        attributeDefinitions.add(stringCanonical);
        builder = new AttributeDefinition.Builder();
        builder.setName("datetime");
        builder.setType(AttributeDefinition.Type.DATETIME);
        AttributeDefinition datetime = builder.build();
        attributeDefinitions.add(datetime);
        builder = new AttributeDefinition.Builder();
        builder.setName("binary");
        builder.setType(AttributeDefinition.Type.BINARY);
        AttributeDefinition binary = builder.build();
        attributeDefinitions.add(binary);
        builder = new AttributeDefinition.Builder();
        builder.setName("reference");
        builder.setType(AttributeDefinition.Type.REFERENCE);
        AttributeDefinition reference = builder.build();
        attributeDefinitions.add(reference);
        builder = new AttributeDefinition.Builder();
        builder.setName("boolean");
        builder.setType(AttributeDefinition.Type.BOOLEAN);
        AttributeDefinition bool = builder.build();
        attributeDefinitions.add(bool);
        builder = new AttributeDefinition.Builder();
        builder.setName("decimal");
        builder.setType(AttributeDefinition.Type.DECIMAL);
        AttributeDefinition decimal = builder.build();
        attributeDefinitions.add(decimal);
        builder = new AttributeDefinition.Builder();
        builder.setName("integer");
        builder.setType(AttributeDefinition.Type.INTEGER);
        AttributeDefinition integer = builder.build();
        attributeDefinitions.add(integer);
        builder = new AttributeDefinition.Builder();
        builder.setName("complex");
        builder.setType(AttributeDefinition.Type.COMPLEX);
        builder.addSubAttributes(new AttributeDefinition[]{string});
        builder.addSubAttributes(new AttributeDefinition[]{stringCanonical});
        builder.addSubAttributes(new AttributeDefinition[]{datetime});
        builder.addSubAttributes(new AttributeDefinition[]{binary});
        builder.addSubAttributes(new AttributeDefinition[]{reference});
        builder.addSubAttributes(new AttributeDefinition[]{bool});
        builder.addSubAttributes(new AttributeDefinition[]{decimal});
        builder.addSubAttributes(new AttributeDefinition[]{integer});
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvstring");
        builder.setType(AttributeDefinition.Type.STRING);
        builder.setMultiValued(true);
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvstringCanonical");
        builder.setType(AttributeDefinition.Type.STRING);
        builder.addCanonicalValues(new String[]{"value1", "value2"});
        builder.setMultiValued(true);
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvdatetime");
        builder.setType(AttributeDefinition.Type.DATETIME);
        builder.setMultiValued(true);
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvbinary");
        builder.setType(AttributeDefinition.Type.BINARY);
        builder.setMultiValued(true);
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvreference");
        builder.setType(AttributeDefinition.Type.REFERENCE);
        builder.setMultiValued(true);
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvboolean");
        builder.setType(AttributeDefinition.Type.BOOLEAN);
        builder.setMultiValued(true);
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvdecimal");
        builder.setType(AttributeDefinition.Type.DECIMAL);
        builder.setMultiValued(true);
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvinteger");
        builder.setType(AttributeDefinition.Type.INTEGER);
        builder.setMultiValued(true);
        attributeDefinitions.add(builder.build());
        builder = new AttributeDefinition.Builder();
        builder.setName("mvcomplex");
        builder.setType(AttributeDefinition.Type.COMPLEX);
        builder.setMultiValued(true);
        builder.addSubAttributes(new AttributeDefinition[]{string});
        builder.addSubAttributes(new AttributeDefinition[]{stringCanonical});
        builder.addSubAttributes(new AttributeDefinition[]{datetime});
        builder.addSubAttributes(new AttributeDefinition[]{binary});
        builder.addSubAttributes(new AttributeDefinition[]{reference});
        builder.addSubAttributes(new AttributeDefinition[]{bool});
        builder.addSubAttributes(new AttributeDefinition[]{decimal});
        builder.addSubAttributes(new AttributeDefinition[]{integer});
        attributeDefinitions.add(builder.build());
        this.typeTestSchema = new SchemaResource("urn:id:test", "test", "", attributeDefinitions);
    }

    @Test
    public void sanityCheck() throws Exception {
        String USER = "{  \n  \"schemas\":[  \n    \"urn:ietf:params:scim:schemas:core:2.0:User\",\n    \"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User\"\n  ],\n  \"id\":\"2819c223-7f76-453a-919d-413861904646\",\n  \"externalId\":\"701984\",\n  \"userName\":\"bjensen@example.com\",\n  \"nAme\":{  \n    \"formatted\":\"Ms. Barbara J Jensen III\",\n    \"FAMILYName\":\"Jensen\",\n    \"givenName\":\"Barbara\",\n    \"middleName\":\"Jane\",\n    \"honorificPrefix\":\"Ms.\",\n    \"honorificSuffix\":\"III\"\n  },\n  \"displayName\":\"Babs Jensen\",\n  \"nickName\":\"Babs\",\n  \"profileUrl\":\"https://login.example.com/bjensen\",\n  \"emails\":[  \n    {  \n      \"value\":\"bjensen@example.com\",\n      \"type\":\"work\",\n      \"pRIMary\":true\n    },\n    {  \n      \"value\":\"babs@jensen.org\",\n      \"type\":\"home\"\n    }\n  ],\n  \"addresses\":[  \n    {  \n      \"streetAddress\":\"100 Universal City Plaza\",\n      \"locality\":\"Hollywood\",\n      \"region\":\"CA\",\n      \"postalCode\":\"91608\",\n      \"country\":\"USA\",\n      \"formatted\":\"100 Universal City Plaza\\nHollywood, CA 91608 USA\",\n      \"type\":\"work\",\n      \"primary\":true\n    },\n    {  \n      \"streetAddress\":\"456 Hollywood Blvd\",\n      \"locality\":\"Hollywood\",\n      \"region\":\"CA\",\n      \"postalCode\":\"91608\",\n      \"country\":\"USA\",\n      \"formatted\":\"456 Hollywood Blvd\\nHollywood, CA 91608 USA\",\n      \"type\":\"home\"\n    }\n  ],\n  \"phoneNumbers\":[  \n    {  \n      \"value\":\"555-555-5555\",\n      \"type\":\"work\"\n    },\n    {  \n      \"value\":\"555-555-4444\",\n      \"type\":\"mobile\"\n    }\n  ],\n  \"ims\":[  \n    {  \n      \"value\":\"someaimhandle\",\n      \"type\":\"aim\"\n    }\n  ],\n  \"photos\":[  \n    {  \n      \"value\":\"https://photos.example.com/profilephoto/72930000000Ccne/F\",\n      \"type\":\"photo\"\n    },\n    {  \n      \"value\":\"https://photos.example.com/profilephoto/72930000000Ccne/T\",\n      \"type\":\"thumbnail\"\n    }\n  ],\n  \"userType\":\"Employee\",\n  \"title\":\"Tour Guide\",\n  \"preferredLanguage\":\"en-US\",\n  \"locale\":\"en-US\",\n  \"timezone\":\"America/Los_Angeles\",\n  \"active\":true,\n  \"password\":\"t1meMa$heen\",\n  \"groups\":[  \n    {  \n      \"value\":\"e9e30dba-f08f-4109-8486-d5c6a331660a\",\n      \"$ref\":\"../Groups/e9e30dba-f08f-4109-8486-d5c6a331660a\",\n      \"display\":\"Tour Guides\"\n    },\n    {  \n      \"value\":\"fc348aa8-3835-40eb-a20b-c726e15c55b5\",\n      \"$ref\":\"../Groups/fc348aa8-3835-40eb-a20b-c726e15c55b5\",\n      \"display\":\"Employees\"\n    },\n    {  \n      \"value\":\"71ddacd2-a8e7-49b8-a5db-ae50d0a5bfd7\",\n      \"$ref\":\"../Groups/71ddacd2-a8e7-49b8-a5db-ae50d0a5bfd7\",\n      \"display\":\"US Employees\"\n    }\n  ],\n  \"x509Certificates\":[  \n    {  \n      \"value\":\"MIIDQzCCAqygAwIBAgICEAAwDQYJKoZIhvcNAQEFBQAwTjELMAkGA1UEBhMCVVMx        EzARBgNVBAgMCkNhbGlmb3JuaWExFDASBgNVBAoMC2V4YW1wbGUuY29tMRQwEgYD        VQQDDAtleGFtcGxlLmNvbTAeFw0xMTEwMjIwNjI0MzFaFw0xMjEwMDQwNjI0MzFa        MH8xCzAJBgNVBAYTAlVTMRMwEQYDVQQIDApDYWxpZm9ybmlhMRQwEgYDVQQKDAtl        eGFtcGxlLmNvbTEhMB8GA1UEAwwYTXMuIEJhcmJhcmEgSiBKZW5zZW4gSUlJMSIw        IAYJKoZIhvcNAQkBFhNiamVuc2VuQGV4YW1wbGUuY29tMIIBIjANBgkqhkiG9w0B        AQEFAAOCAQ8AMIIBCgKCAQEA7Kr+Dcds/JQ5GwejJFcBIP682X3xpjis56AK02bc        1FLgzdLI8auoR+cC9/Vrh5t66HkQIOdA4unHh0AaZ4xL5PhVbXIPMB5vAPKpzz5i        PSi8xO8SL7I7SDhcBVJhqVqr3HgllEG6UClDdHO7nkLuwXq8HcISKkbT5WFTVfFZ        zidPl8HZ7DhXkZIRtJwBweq4bvm3hM1Os7UQH05ZS6cVDgweKNwdLLrT51ikSQG3        DYrl+ft781UQRIqxgwqCfXEuDiinPh0kkvIi5jivVu1Z9QiwlYEdRbLJ4zJQBmDr        SGTMYn4lRc2HgHO4DqB/bnMVorHB0CC6AV1QoFK4GPe1LwIDAQABo3sweTAJBgNV        HRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZp        Y2F0ZTAdBgNVHQ4EFgQU8pD0U0vsZIsaA16lL8En8bx0F/gwHwYDVR0jBBgwFoAU        dGeKitcaF7gnzsNwDx708kqaVt0wDQYJKoZIhvcNAQEFBQADgYEAA81SsFnOdYJt        Ng5Tcq+/ByEDrBgnusx0jloUhByPMEVkoMZ3J7j1ZgI8rAbOkNngX8+pKfTiDz1R        C4+dx8oU6Za+4NJXUjlL5CvV6BEYb1+QAEJwitTVvxB/A67g42/vzgAtoRUeDov1        +GFiBZ+GNF/cAYKcMtGcrs2i97ZkJMo=\"\n    }\n  ],\n  \"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User\":{\n    \"employeeNumber\":\"701984\",\n    \"costCenter\":\"4130\",\n    \"organization\":\"Universal Studios\",\n    \"division\":\"Theme Park\",\n    \"department\":\"Tour Operations\",\n    \"manager\":{  \n      \"value\":\"26118915-6090-4610-87e4-49d8ca9f808d\",\n      \"$ref\":\"../Users/26118915-6090-4610-87e4-49d8ca9f808d\",\n      \"displayName\":\"John Smith\"\n    }\n  },\n  \"meta\":{  \n    \"resourceType\":\"User\",\n    \"created\":\"2010-01-23T04:56:22Z\",\n    \"lastModified\":\"2011-05-13T04:42:34Z\",\n    \"version\":\"W\\/\\\"3694e05e9dff591\\\"\",\n    \"location\":\"https://example.com/v2/Users/2819c223-7f76-453a-919d-413861904646\"\n  }\n}";
        ObjectNode userResource = (ObjectNode)JsonUtils.getObjectReader().readTree(USER);
        SchemaResource coreSchema = SchemaUtils.getSchema(UserResource.class);
        SchemaResource enterpriseExtension = SchemaUtils.getSchema(EnterpriseUserExtension.class);
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(coreSchema).addOptionalSchemaExtension(enterpriseExtension).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        userResource = checker.removeReadOnlyAttributes(userResource);
        ObjectNode copyUserResource = userResource.deepCopy();
        SchemaChecker.Results results = checker.checkCreate(userResource);
        Assert.assertTrue((boolean)results.getMutabilityIssues().isEmpty(), (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)results.getPathIssues().isEmpty(), (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)results.getSyntaxIssues().isEmpty(), (String)results.getSyntaxIssues().toString());
        Assert.assertEquals((Object)userResource, (Object)copyUserResource);
        results = checker.checkReplace(userResource, null);
        Assert.assertTrue((boolean)results.getMutabilityIssues().isEmpty(), (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)results.getPathIssues().isEmpty(), (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)results.getSyntaxIssues().isEmpty(), (String)results.getSyntaxIssues().toString());
        Assert.assertEquals((Object)userResource, (Object)copyUserResource);
        String patchRequestStr = "{  \n  \"op\":\"add\",\n  \"value\":{  \n    \"passWORD\":\"password\",\n    \"name\":{  \n      \"givenName\":\"Barbara\",\n      \"FAMILYName\":\"Jensen\",\n      \"formatted\":\"Barbara Ann Jensen\"\n    },\n    \"emails\":[  \n      {  \n        \"VALUE\":\"bjensen@example.com\",\n        \"type\":\"work\"\n      },\n      {  \n        \"value\":\"babs@jensen.org\",\n        \"type\":\"home\"\n      }\n    ],\n    \"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User\":{  \n      \"employeeNumber\":\"701984\"\n    },\n    \"addresses\":[  \n      {  \n        \"type\":\"work\",\n        \"streetAddress\":\"13809 Research Blvd\",\n        \"locality\":\"Austin\",\n        \"region\":\"TX\",\n        \"postalCode\":\"78750\",\n        \"country\":\"USA\",\n        \"formatted\":\"13809 Research Blvd\\nAustin, TX 78750 USA\",\n        \"primary\":true\n      },\n      {  \n        \"type\":\"home\",\n        \"streetAddress\":\"456 Hollywood Blvd\",\n        \"locality\":\"Hollywood\",\n        \"region\":\"CA\",\n        \"postalCode\":\"91608\",\n        \"country\":\"USA\",\n        \"formatted\":\"456 Hollywood Blvd\\nHollywood, CA 91608 USA\"\n      }\n    ]\n  }\n}";
        PatchOperation operation = (PatchOperation)JsonUtils.getObjectReader().forType(PatchOperation.class).readValue(patchRequestStr);
        results = checker.checkModify(Collections.singleton(operation), userResource);
        Assert.assertTrue((boolean)results.getMutabilityIssues().isEmpty(), (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)results.getPathIssues().isEmpty(), (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)results.getSyntaxIssues().isEmpty(), (String)results.getSyntaxIssues().toString());
        Assert.assertEquals((Object)operation, (Object)JsonUtils.getObjectReader().forType(PatchOperation.class).readValue(patchRequestStr));
        Assert.assertEquals((Object)userResource, (Object)copyUserResource);
    }

    @DataProvider
    public Object[][] schemaExtensionProvider() {
        AttributeDefinition reqAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).setRequired(true).build();
        SchemaResource extWithReqAttr = new SchemaResource("urn:id:testExt", "testExt", "", Collections.singleton(reqAttr));
        AttributeDefinition optAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).build();
        SchemaResource extWithOptAttr = new SchemaResource("urn:id:testExt", "testExt", "", Collections.singleton(optAttr));
        ObjectNode extNotIn = JsonUtils.getJsonNodeFactory().objectNode();
        extNotIn.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User");
        extNotIn.put("userName", "test");
        ObjectNode extInSchemas = JsonUtils.getJsonNodeFactory().objectNode();
        extInSchemas.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:id:testExt");
        extInSchemas.put("userName", "test");
        ObjectNode extNotInSchemas = JsonUtils.getJsonNodeFactory().objectNode();
        extNotInSchemas.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User");
        extNotInSchemas.put("userName", "test");
        extNotInSchemas.putObject("urn:id:testExt").put("test", "test");
        ObjectNode extIn = JsonUtils.getJsonNodeFactory().objectNode();
        extIn.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:id:testExt");
        extIn.put("userName", "test");
        extIn.putObject("urn:id:testExt").put("test", "test");
        ObjectNode undefinedInSchemas = JsonUtils.getJsonNodeFactory().objectNode();
        undefinedInSchemas.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:id:undefined");
        undefinedInSchemas.put("userName", "test");
        ObjectNode undefinedNotInSchemas = JsonUtils.getJsonNodeFactory().objectNode();
        undefinedNotInSchemas.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User");
        undefinedNotInSchemas.put("userName", "test");
        undefinedNotInSchemas.putObject("urn:id:undefined").put("test", "test");
        ObjectNode undefinedIn = JsonUtils.getJsonNodeFactory().objectNode();
        undefinedIn.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:id:undefined");
        undefinedIn.put("userName", "test");
        undefinedIn.putObject("urn:id:undefined").put("test", "test");
        ObjectNode notObject = JsonUtils.getJsonNodeFactory().objectNode();
        notObject.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:id:testExt");
        notObject.put("userName", "test");
        notObject.putArray("urn:id:testExt").addObject().put("test", "test");
        return new Object[][]{{extWithReqAttr, true, extNotIn, 1, 0}, {extWithReqAttr, true, extInSchemas, 1, 0}, {extWithReqAttr, true, extNotInSchemas, 2, 0}, {extWithReqAttr, true, extIn, 0, 0}, {extWithReqAttr, false, extNotIn, 0, 0}, {extWithReqAttr, false, extInSchemas, 1, 0}, {extWithReqAttr, false, extNotInSchemas, 1, 0}, {extWithReqAttr, false, extIn, 0, 0}, {extWithReqAttr, false, undefinedInSchemas, 1, 1}, {extWithReqAttr, false, undefinedNotInSchemas, 1, 1}, {extWithReqAttr, false, undefinedIn, 1, 2}, {extWithReqAttr, false, notObject, 1, 1}, {extWithOptAttr, true, extNotIn, 1, 0}, {extWithOptAttr, true, extInSchemas, 0, 0}, {extWithOptAttr, true, extNotInSchemas, 2, 0}, {extWithOptAttr, true, extIn, 0, 0}, {extWithOptAttr, false, extNotIn, 0, 0}, {extWithOptAttr, false, extInSchemas, 0, 0}, {extWithOptAttr, false, extNotInSchemas, 1, 0}, {extWithOptAttr, false, extIn, 0, 0}, {extWithOptAttr, false, undefinedInSchemas, 1, 1}, {extWithOptAttr, false, undefinedNotInSchemas, 1, 1}, {extWithOptAttr, false, undefinedIn, 1, 2}, {extWithOptAttr, false, notObject, 1, 1}};
    }

    @Test(dataProvider="schemaExtensionProvider")
    public void testSchemaExtension(SchemaResource extension, boolean required, ObjectNode node, int expectedErrorOnCreate, int expectedErrorOnPatch) throws Exception {
        ResourceTypeDefinition resourceTypeDefinition = required ? new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(this.coreSchema).addRequiredSchemaExtension(extension).build() : new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(this.coreSchema).addOptionalSchemaExtension(extension).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        SchemaChecker.Results results = checker.checkCreate(node);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)expectedErrorOnCreate, (String)results.getSyntaxIssues().toString());
        results = checker.checkModify(Collections.singleton(PatchOperation.add((JsonNode)node)), null);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)expectedErrorOnPatch, (String)results.getSyntaxIssues().toString());
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((ObjectNode)node)), null);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)expectedErrorOnPatch, (String)results.getSyntaxIssues().toString());
    }

    @Test
    public void testCoreSchema() throws Exception {
        AttributeDefinition reqAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).setRequired(true).build();
        SchemaResource extWithReqAttr = new SchemaResource("urn:id:testExt", "testExt", "", Collections.singleton(reqAttr));
        ObjectNode resource = JsonUtils.getJsonNodeFactory().objectNode();
        resource.putArray("schemas").add("urn:id:testExt");
        resource.put("userName", "test");
        resource.putObject("urn:id:testExt").put("test", "test");
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(this.coreSchema).addRequiredSchemaExtension(extWithReqAttr).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        SchemaChecker.Results results = checker.checkCreate(resource);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
    }

    @Test
    public void testSchemasModify() throws Exception {
        AttributeDefinition reqAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).setRequired(true).build();
        SchemaResource extWithReqAttr = new SchemaResource("urn:id:extWithReqAttr", "extWithReqAttr", "", Collections.singleton(reqAttr));
        AttributeDefinition optAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).build();
        SchemaResource extWithOptAttr = new SchemaResource("urn:id:extWithOptAttr", "extWithOptAttr", "", Collections.singleton(optAttr));
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(this.coreSchema).addRequiredSchemaExtension(extWithReqAttr).addOptionalSchemaExtension(extWithOptAttr).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        ObjectNode resource = JsonUtils.getJsonNodeFactory().objectNode();
        resource.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:id:extWithReqAttr");
        resource.put("userName", "test");
        resource.putObject("urn:id:extWithReqAttr").put("test", "test");
        LinkedList<PatchOperation> patchOps = new LinkedList<PatchOperation>();
        patchOps.add(PatchOperation.remove((Path)Path.root().attribute("schemas", Filter.eq((String)"value", (String)"urn:ietf:params:scim:schemas:core:2.0:User"))));
        SchemaChecker.Results results = checker.checkModify(patchOps, resource);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)2, (String)results.getSyntaxIssues().toString());
        patchOps = new LinkedList();
        patchOps.add(PatchOperation.remove((Path)Path.root().attribute("schemas", Filter.eq((String)"value", (String)"urn:id:extWithReqAttr"))));
        results = checker.checkModify(patchOps, resource);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)3, (String)results.getSyntaxIssues().toString());
        patchOps = new LinkedList();
        patchOps.add(PatchOperation.replace((Path)Path.root().attribute("schemas", Filter.eq((String)"value", (String)"urn:ietf:params:scim:schemas:core:2.0:User")), (JsonNode)TextNode.valueOf((String)"urn:id:extWithOptAttr")));
        results = checker.checkModify(patchOps, resource);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)2, (String)results.getSyntaxIssues().toString());
        patchOps = new LinkedList();
        patchOps.add(PatchOperation.replace((Path)Path.root().attribute("schemas", Filter.eq((String)"value", (String)"urn:id:extWithReqAttr")), (JsonNode)TextNode.valueOf((String)"urn:id:extWithOptAttr")));
        results = checker.checkModify(patchOps, resource);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)3, (String)results.getSyntaxIssues().toString());
        patchOps = new LinkedList();
        patchOps.add(PatchOperation.add((Path)Path.root().attribute("schemas"), (JsonNode)JsonUtils.getJsonNodeFactory().arrayNode().add("urn:id:undefined")));
        results = checker.checkModify(patchOps, resource);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)2, (String)results.getSyntaxIssues().toString());
    }

    @DataProvider
    public Object[][] requiredAttributesProvider() {
        AttributeDefinition optAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).setRequired(false).build();
        AttributeDefinition reqAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).setRequired(true).build();
        AttributeDefinition optAttrOptSub = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.COMPLEX).setRequired(false).addSubAttributes(new AttributeDefinition[]{optAttr}).build();
        AttributeDefinition optAttrReqSub = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.COMPLEX).setRequired(false).addSubAttributes(new AttributeDefinition[]{reqAttr}).build();
        AttributeDefinition reqAttrReqSub = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.COMPLEX).setRequired(true).addSubAttributes(new AttributeDefinition[]{reqAttr}).build();
        AttributeDefinition optMVAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).setRequired(false).setMultiValued(true).build();
        AttributeDefinition reqMVAttr = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.STRING).setRequired(true).setMultiValued(true).build();
        AttributeDefinition optMVAttrOptSub = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.COMPLEX).setRequired(false).addSubAttributes(new AttributeDefinition[]{optAttr}).setMultiValued(true).build();
        AttributeDefinition optMVAttrReqSub = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.COMPLEX).setRequired(false).addSubAttributes(new AttributeDefinition[]{reqAttr}).setMultiValued(true).build();
        AttributeDefinition reqMVAttrReqSub = new AttributeDefinition.Builder().setName("test").setType(AttributeDefinition.Type.COMPLEX).setRequired(true).addSubAttributes(new AttributeDefinition[]{reqAttr}).setMultiValued(true).build();
        ObjectNode notPresent = JsonUtils.getJsonNodeFactory().objectNode();
        notPresent.putArray("schemas").add("urn:id:test");
        ObjectNode nullValue = JsonUtils.getJsonNodeFactory().objectNode();
        nullValue.putArray("schemas").add("urn:id:test");
        nullValue.putNull("test");
        ObjectNode subNotPresent = JsonUtils.getJsonNodeFactory().objectNode();
        subNotPresent.putArray("schemas").add("urn:id:test");
        subNotPresent.putObject("test");
        ObjectNode subNullValue = JsonUtils.getJsonNodeFactory().objectNode();
        subNullValue.putArray("schemas").add("urn:id:test");
        subNullValue.putObject("test").putNull("test");
        ObjectNode emptyArray = JsonUtils.getJsonNodeFactory().objectNode();
        emptyArray.putArray("schemas").add("urn:id:test");
        emptyArray.putArray("test");
        ObjectNode arrayNotPresent = JsonUtils.getJsonNodeFactory().objectNode();
        arrayNotPresent.putArray("schemas").add("urn:id:test");
        arrayNotPresent.putArray("test").addObject();
        ObjectNode arrayNullValue = JsonUtils.getJsonNodeFactory().objectNode();
        arrayNullValue.putArray("schemas").add("urn:id:test");
        arrayNullValue.putArray("test").addObject().putNull("test");
        return new Object[][]{{optAttr, notPresent, 0}, {optAttr, nullValue, 0}, {reqAttr, notPresent, 1}, {reqAttr, nullValue, 1}, {optAttrOptSub, notPresent, 0}, {optAttrOptSub, nullValue, 0}, {optAttrOptSub, subNotPresent, 0}, {optAttrOptSub, subNullValue, 0}, {optAttrReqSub, notPresent, 0}, {optAttrReqSub, nullValue, 0}, {optAttrReqSub, subNotPresent, 1}, {optAttrReqSub, subNullValue, 1}, {reqAttrReqSub, notPresent, 1}, {reqAttrReqSub, nullValue, 1}, {reqAttrReqSub, subNotPresent, 1}, {reqAttrReqSub, subNullValue, 1}, {optMVAttr, notPresent, 0}, {optMVAttr, emptyArray, 0}, {reqMVAttr, notPresent, 1}, {reqMVAttr, emptyArray, 1}, {optMVAttrOptSub, notPresent, 0}, {optMVAttrOptSub, emptyArray, 0}, {optMVAttrOptSub, arrayNotPresent, 0}, {optMVAttrOptSub, arrayNullValue, 0}, {optMVAttrReqSub, notPresent, 0}, {optMVAttrReqSub, emptyArray, 0}, {optMVAttrReqSub, arrayNotPresent, 1}, {optMVAttrReqSub, arrayNullValue, 1}, {reqMVAttrReqSub, notPresent, 1}, {reqMVAttrReqSub, emptyArray, 1}, {reqMVAttrReqSub, arrayNotPresent, 1}, {reqMVAttrReqSub, arrayNullValue, 1}};
    }

    @Test(dataProvider="requiredAttributesProvider")
    public void testRequiredAttributes(AttributeDefinition attributeDefinition, ObjectNode node, int expectError) throws Exception {
        SchemaResource schema = new SchemaResource("urn:id:test", "test", "", Collections.singleton(attributeDefinition));
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(schema).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        SchemaChecker.Results results = checker.checkCreate(node);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)expectError, (String)results.getSyntaxIssues().toString());
        if (attributeDefinition.isRequired()) {
            results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.fromString((String)"TEST"))), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        }
        if (attributeDefinition.getSubAttributes() != null && ((AttributeDefinition)attributeDefinition.getSubAttributes().iterator().next()).isRequired()) {
            results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("test").attribute("test"))), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        }
    }

    @Test
    public void testSimpleMultiValuedAttribute() throws Exception {
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(this.typeTestSchema).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        ArrayNode values = JsonUtils.getJsonNodeFactory().arrayNode();
        values.add((JsonNode)JsonUtils.getJsonNodeFactory().textNode("value1"));
        values.add((JsonNode)JsonUtils.getJsonNodeFactory().textNode("value2"));
        values.add((JsonNode)JsonUtils.getJsonNodeFactory().textNode("value3"));
        ObjectNode o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.set("mvstring", (JsonNode)values);
        SchemaChecker.Results results = checker.checkCreate(o);
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("mvstring", Filter.eq((String)"value", (String)"value3")), (String)"replacedValue4")), null);
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)0, (String)Arrays.toString(results.getFilterIssues().toArray(new String[0])));
        results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("mvstring", Filter.eq((String)"value", (String)"value1")))), null);
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)0, (String)Arrays.toString(results.getFilterIssues().toArray(new String[0])));
    }

    @Test
    public void testUndefinedAttributes() throws Exception {
        SchemaResource coreSchema = SchemaUtils.getSchema(UserResource.class);
        SchemaResource enterpriseExtension = SchemaUtils.getSchema(EnterpriseUserExtension.class);
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(coreSchema).addOptionalSchemaExtension(enterpriseExtension).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        ObjectNode coreUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        coreUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        coreUndefined.put("userName", "test");
        coreUndefined.put("undefined", "value");
        SchemaChecker.Results results = checker.checkCreate(coreUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined for schema"));
        results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkSearch(Filter.fromString((String)"undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
        ObjectNode coreSubUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        coreSubUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        coreSubUndefined.put("userName", "test");
        coreSubUndefined.putObject("name").put("undefined", "value");
        results = checker.checkCreate(coreSubUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined for attribute"));
        results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("name").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("name").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("name").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkSearch(Filter.fromString((String)"name.undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
        ObjectNode extendedUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        extendedUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        extendedUndefined.put("userName", "test");
        extendedUndefined.putObject("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").put("undefined", "value");
        results = checker.checkCreate(extendedUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined for schema"));
        results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkSearch(Filter.fromString((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
        ObjectNode extendedSubUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        extendedSubUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        extendedSubUndefined.put("userName", "test");
        extendedSubUndefined.putObject("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").putObject("manager").put("$ref", "https://value").put("value", "value").put("undefined", "value");
        results = checker.checkCreate(extendedSubUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined for attribute"));
        results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = checker.checkSearch(Filter.fromString((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager.undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
    }

    @Test
    public void testAllowUndefinedAttributeOptions() throws Exception {
        SchemaResource coreSchema = SchemaUtils.getSchema(UserResource.class);
        SchemaResource enterpriseExtension = SchemaUtils.getSchema(EnterpriseUserExtension.class);
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(coreSchema).addOptionalSchemaExtension(enterpriseExtension).build();
        SchemaChecker undefinedAttributesChecker = new SchemaChecker(resourceTypeDefinition);
        undefinedAttributesChecker.enable(SchemaChecker.Option.ALLOW_UNDEFINED_ATTRIBUTES);
        SchemaChecker undefinedSubAttributesChecker = new SchemaChecker(resourceTypeDefinition);
        undefinedSubAttributesChecker.enable(SchemaChecker.Option.ALLOW_UNDEFINED_SUB_ATTRIBUTES);
        ObjectNode coreUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        coreUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        coreUndefined.put("userName", "test");
        coreUndefined.put("undefined", "value");
        SchemaChecker.Results results = undefinedAttributesChecker.checkCreate(coreUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)0, (String)results.getSyntaxIssues().toString());
        results = undefinedSubAttributesChecker.checkCreate(coreUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined for schema"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkSearch(Filter.fromString((String)"undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)0, (String)results.getFilterIssues().toString());
        results = undefinedSubAttributesChecker.checkSearch(Filter.fromString((String)"undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
        ObjectNode coreSubUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        coreSubUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        coreSubUndefined.put("userName", "test");
        coreSubUndefined.putObject("name").put("undefined", "value");
        results = undefinedAttributesChecker.checkCreate(coreSubUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined for attribute"));
        results = undefinedSubAttributesChecker.checkCreate(coreSubUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)0, (String)results.getSyntaxIssues().toString());
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("name").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("name").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("name").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("name").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("name").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("name").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedAttributesChecker.checkSearch(Filter.fromString((String)"name.undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
        results = undefinedSubAttributesChecker.checkSearch(Filter.fromString((String)"name.undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)0, (String)results.getFilterIssues().toString());
        ObjectNode extendedUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        extendedUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User");
        extendedUndefined.put("userName", "test");
        extendedUndefined.putObject("urn:undefined").put("undefined", "value");
        results = undefinedAttributesChecker.checkCreate(extendedUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        extendedUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        extendedUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:undefined");
        extendedUndefined.put("userName", "test");
        extendedUndefined.putObject("urn:undefined").put("undefined", "value");
        results = undefinedSubAttributesChecker.checkCreate(extendedUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root((String)"urn:undefined").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root((String)"urn:undefined").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root((String)"urn:undefined").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root((String)"urn:undefined").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root((String)"urn:undefined").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root((String)"urn:undefined").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkSearch(Filter.fromString((String)"urn:undefined:undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)0, (String)results.getFilterIssues().toString());
        results = undefinedSubAttributesChecker.checkSearch(Filter.fromString((String)"urn:undefined:undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
        extendedUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        extendedUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        extendedUndefined.put("userName", "test");
        extendedUndefined.putObject("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").put("undefined", "value");
        results = undefinedAttributesChecker.checkCreate(extendedUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)0, (String)results.getSyntaxIssues().toString());
        results = undefinedSubAttributesChecker.checkCreate(extendedUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined for schema"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedAttributesChecker.checkSearch(Filter.fromString((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)0, (String)results.getFilterIssues().toString());
        results = undefinedSubAttributesChecker.checkSearch(Filter.fromString((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
        ObjectNode extendedSubUndefined = JsonUtils.getJsonNodeFactory().objectNode();
        extendedSubUndefined.putArray("schemas").add("urn:ietf:params:scim:schemas:core:2.0:User").add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        extendedSubUndefined.put("userName", "test");
        extendedSubUndefined.putObject("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").putObject("manager").put("$ref", "https://value").put("value", "value").put("undefined", "value");
        results = undefinedAttributesChecker.checkCreate(extendedSubUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "is undefined for attribute"));
        results = undefinedSubAttributesChecker.checkCreate(extendedSubUndefined);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)0, (String)results.getSyntaxIssues().toString());
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)1, (String)results.getPathIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "is undefined"));
        results = undefinedSubAttributesChecker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").attribute("manager").attribute("undefined"))), null);
        Assert.assertEquals((int)results.getPathIssues().size(), (int)0, (String)results.getPathIssues().toString());
        results = undefinedAttributesChecker.checkSearch(Filter.fromString((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager.undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)1, (String)results.getFilterIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getFilterIssues(), "is undefined"));
        results = undefinedSubAttributesChecker.checkSearch(Filter.fromString((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager.undefined eq \"value\""));
        Assert.assertEquals((int)results.getFilterIssues().size(), (int)0, (String)results.getFilterIssues().toString());
    }

    @DataProvider
    public Object[][] attributeValueTypeProvider() {
        return new Object[][]{{"string", JsonUtils.getJsonNodeFactory().numberNode(1)}, {"string", JsonUtils.getJsonNodeFactory().booleanNode(true)}, {"string", JsonUtils.getJsonNodeFactory().objectNode()}, {"string", JsonUtils.getJsonNodeFactory().arrayNode()}, {"stringCanonical", JsonUtils.getJsonNodeFactory().textNode("value3")}, {"datetime", JsonUtils.getJsonNodeFactory().textNode("notdatetime")}, {"datetime", JsonUtils.getJsonNodeFactory().numberNode(1)}, {"datetime", JsonUtils.getJsonNodeFactory().booleanNode(true)}, {"datetime", JsonUtils.getJsonNodeFactory().objectNode()}, {"datetime", JsonUtils.getJsonNodeFactory().arrayNode()}, {"binary", JsonUtils.getJsonNodeFactory().textNode("()$#@_@")}, {"binary", JsonUtils.getJsonNodeFactory().numberNode(1)}, {"binary", JsonUtils.getJsonNodeFactory().booleanNode(true)}, {"binary", JsonUtils.getJsonNodeFactory().objectNode()}, {"binary", JsonUtils.getJsonNodeFactory().arrayNode()}, {"reference", JsonUtils.getJsonNodeFactory().textNode("rtp:\\")}, {"reference", JsonUtils.getJsonNodeFactory().numberNode(1)}, {"reference", JsonUtils.getJsonNodeFactory().booleanNode(true)}, {"reference", JsonUtils.getJsonNodeFactory().objectNode()}, {"reference", JsonUtils.getJsonNodeFactory().arrayNode()}, {"boolean", JsonUtils.getJsonNodeFactory().textNode("string")}, {"boolean", JsonUtils.getJsonNodeFactory().numberNode(1)}, {"boolean", JsonUtils.getJsonNodeFactory().objectNode()}, {"boolean", JsonUtils.getJsonNodeFactory().arrayNode()}, {"decimal", JsonUtils.getJsonNodeFactory().textNode("string")}, {"decimal", JsonUtils.getJsonNodeFactory().booleanNode(true)}, {"decimal", JsonUtils.getJsonNodeFactory().objectNode()}, {"decimal", JsonUtils.getJsonNodeFactory().arrayNode()}, {"integer", JsonUtils.getJsonNodeFactory().textNode("string")}, {"integer", JsonUtils.getJsonNodeFactory().booleanNode(true)}, {"integer", JsonUtils.getJsonNodeFactory().objectNode()}, {"integer", JsonUtils.getJsonNodeFactory().arrayNode()}, {"integer", JsonUtils.getJsonNodeFactory().numberNode(1.1)}, {"complex", JsonUtils.getJsonNodeFactory().textNode("string")}, {"complex", JsonUtils.getJsonNodeFactory().numberNode(1)}, {"complex", JsonUtils.getJsonNodeFactory().booleanNode(true)}};
    }

    @Test(dataProvider="attributeValueTypeProvider")
    public void testAttributeValueType(String field, JsonNode node) throws Exception {
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(this.typeTestSchema).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        ObjectNode o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.set(field, node);
        SchemaChecker.Results results = checker.checkCreate(o);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
        if (!node.isArray() && !node.isObject() || node.size() != 0) {
            results = checker.checkModify(Collections.singleton(PatchOperation.add((JsonNode)o)), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            results = checker.checkModify(Collections.singleton(PatchOperation.replace((ObjectNode)o)), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute(field), (JsonNode)node)), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute(field), (JsonNode)node)), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute(field, Filter.eq((String)"test", (String)"test")), (JsonNode)node)), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getPathIssues(), "not multi-valued"));
        }
        if (!field.equals("complex")) {
            o = JsonUtils.getJsonNodeFactory().objectNode();
            o.putArray("schemas").add("urn:id:test");
            o.putObject("complex").set(field, node);
            results = checker.checkCreate(o);
            Assert.assertFalse((boolean)results.getSyntaxIssues().isEmpty(), (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            if (!node.isArray() && !node.isObject() || node.size() != 0) {
                results = checker.checkModify(Collections.singleton(PatchOperation.add((JsonNode)o)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.replace((ObjectNode)o)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("complex").attribute(field), (JsonNode)node)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("complex").attribute(field), (JsonNode)node)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            }
        }
        if (!node.isArray()) {
            o = JsonUtils.getJsonNodeFactory().objectNode();
            o.putArray("schemas").add("urn:id:test");
            o.set("mv" + field, node);
            results = checker.checkCreate(o);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            if (!node.isArray() && !node.isObject() || node.size() != 0) {
                results = checker.checkModify(Collections.singleton(PatchOperation.add((JsonNode)o)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.replace((ObjectNode)o)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("mv" + field), (JsonNode)node)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("mv" + field), (JsonNode)node)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            }
        }
        o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.putArray("mv" + field).add(node);
        results = checker.checkCreate(o);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
        if (!node.isArray() && !node.isObject() || node.size() != 0) {
            results = checker.checkModify(Collections.singleton(PatchOperation.add((JsonNode)o)), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            results = checker.checkModify(Collections.singleton(PatchOperation.replace((ObjectNode)o)), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("mv" + field), (JsonNode)JsonUtils.getJsonNodeFactory().arrayNode().add(node))), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("mv" + field), (JsonNode)JsonUtils.getJsonNodeFactory().arrayNode().add(node))), null);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
        }
        if (!field.equals("complex")) {
            o = JsonUtils.getJsonNodeFactory().objectNode();
            o.putArray("schemas").add("urn:id:test");
            o.putArray("mvcomplex").addObject().set(field, node);
            results = checker.checkCreate(o);
            Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
            Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            if (!node.isArray() && !node.isObject() || node.size() != 0) {
                results = checker.checkModify(Collections.singleton(PatchOperation.add((JsonNode)o)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.replace((ObjectNode)o)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("mvcomplex").attribute(field), (JsonNode)node)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
                results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("mvcomplex").attribute(field), (JsonNode)node)), null);
                Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)1, (String)results.getSyntaxIssues().toString());
                Assert.assertTrue((boolean)this.containsIssueWith(results.getSyntaxIssues(), "Value"));
            }
        }
    }

    @Test
    public void testBinaryAttributeValueType() throws Exception {
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(this.typeTestSchema).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        ObjectNode o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.set("binary", (JsonNode)JsonUtils.getJsonNodeFactory().textNode(Base64Variants.getDefaultVariant().encode(new byte[]{0})));
        SchemaChecker.Results results = checker.checkCreate(o);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)0, (String)results.getSyntaxIssues().toString());
        o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.set("binary", (JsonNode)JsonUtils.getJsonNodeFactory().binaryNode(new byte[]{0}));
        results = checker.checkCreate(o);
        Assert.assertEquals((int)results.getSyntaxIssues().size(), (int)0, (String)results.getSyntaxIssues().toString());
    }

    @Test
    public void testAttributeMutability() throws Exception {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        AttributeDefinition readOnly = new AttributeDefinition.Builder().setName("readOnly").setType(AttributeDefinition.Type.STRING).setMutability(AttributeDefinition.Mutability.READ_ONLY).build();
        AttributeDefinition immutable = new AttributeDefinition.Builder().setName("immutable").setType(AttributeDefinition.Type.STRING).setMutability(AttributeDefinition.Mutability.IMMUTABLE).build();
        attributeDefinitions.add(readOnly);
        attributeDefinitions.add(immutable);
        SchemaResource schema = new SchemaResource("urn:id:test", "test", "", attributeDefinitions);
        ResourceTypeDefinition resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "/test").setCoreSchema(schema).build();
        SchemaChecker checker = new SchemaChecker(resourceTypeDefinition);
        ObjectNode o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.put("readOnly", "value");
        SchemaChecker.Results results = checker.checkCreate(o);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "read-only"));
        results = checker.checkReplace(o, null);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "read-only"));
        results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("readOnly"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "read-only"));
        results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("readOnly"))), null);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "read-only"));
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("readOnly"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "read-only"));
        o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.put("immutable", "value");
        results = checker.checkCreate(o);
        Assert.assertTrue((boolean)results.getMutabilityIssues().isEmpty(), (String)results.getMutabilityIssues().toString());
        o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.put("immutable", "value");
        results = checker.checkReplace(o, null);
        Assert.assertTrue((boolean)results.getMutabilityIssues().isEmpty(), (String)results.getMutabilityIssues().toString());
        o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.put("immutable", "value");
        results = checker.checkReplace(o, o);
        Assert.assertTrue((boolean)results.getMutabilityIssues().isEmpty(), (String)results.getMutabilityIssues().toString());
        o = JsonUtils.getJsonNodeFactory().objectNode();
        o.putArray("schemas").add("urn:id:test");
        o.put("immutable", "value");
        results = checker.checkReplace(o.deepCopy().put("immutable", "newValue"), o);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "immutable"));
        results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("immutable"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertTrue((boolean)results.getMutabilityIssues().isEmpty(), (String)results.getMutabilityIssues().toString());
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("immutable"), (JsonNode)TextNode.valueOf((String)"value"))), null);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "immutable"));
        results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("immutable"), (JsonNode)TextNode.valueOf((String)"value"))), o);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "immutable"));
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("immutable"), (JsonNode)TextNode.valueOf((String)"value"))), o);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "immutable"));
        results = checker.checkModify(Collections.singleton(PatchOperation.add((Path)Path.root().attribute("immutable"), (JsonNode)TextNode.valueOf((String)"newValue"))), o);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)2, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "immutable"));
        results = checker.checkModify(Collections.singleton(PatchOperation.replace((Path)Path.root().attribute("immutable"), (JsonNode)TextNode.valueOf((String)"newValue"))), o);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)2, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "immutable"));
        results = checker.checkModify(Collections.singleton(PatchOperation.remove((Path)Path.root().attribute("immutable"))), null);
        Assert.assertEquals((int)results.getMutabilityIssues().size(), (int)1, (String)results.getMutabilityIssues().toString());
        Assert.assertTrue((boolean)this.containsIssueWith(results.getMutabilityIssues(), "immutable"));
    }

    @Test(dataProvider="schemaResultsProvider")
    public void testSchemaResultExceptions(String expectedMsg, List<String> syntaxIssues, List<String> mutabilityIssues, List<String> pathIssues) throws Exception {
        BadRequestException caughtException = null;
        SchemaChecker.Results results = this.getResults(syntaxIssues, mutabilityIssues, pathIssues);
        try {
            results.throwSchemaExceptions();
        }
        catch (BadRequestException ex) {
            caughtException = ex;
            Assert.assertEquals((String)caughtException.getMessage(), (String)expectedMsg);
        }
        if (!syntaxIssues.isEmpty()) {
            Assert.assertNotNull((Object)((Object)caughtException));
            Assert.assertEquals((String)caughtException.getScimError().getScimType(), (String)"invalidSyntax");
        } else if (!mutabilityIssues.isEmpty()) {
            Assert.assertNotNull((Object)((Object)caughtException));
            Assert.assertEquals((String)caughtException.getScimError().getScimType(), (String)"mutability");
        } else if (!pathIssues.isEmpty()) {
            Assert.assertNotNull((Object)((Object)caughtException));
            Assert.assertEquals((String)caughtException.getScimError().getScimType(), (String)"invalidPath");
        } else {
            Assert.assertNull((Object)((Object)caughtException), (String)"Bad exception thrown");
        }
    }

    @DataProvider(name="schemaResultsProvider")
    private Object[][] getResultData() {
        return new Object[][]{{"syntaxIssueOne, syntaxIssueTwo", Arrays.asList("syntaxIssueOne", "syntaxIssueTwo"), Collections.emptyList(), Collections.emptyList()}, {"mutabilityIssueOne, mutabilityIssueTwo", Collections.emptyList(), Arrays.asList("mutabilityIssueOne", "mutabilityIssueTwo"), Collections.emptyList()}, {"pathIssueOne, pathIssueTwo", Collections.emptyList(), Collections.emptyList(), Arrays.asList("pathIssueOne", "pathIssueTwo")}, {"syntaxIssueOne, syntaxIssueTwo", Arrays.asList("syntaxIssueOne", "syntaxIssueTwo"), Arrays.asList("mutabilityIssueOne", "mutabilityIssueTwo"), Arrays.asList("pathIssueOne", "pathIssueTwo")}, {"mutabilityIssueOne", Collections.emptyList(), Arrays.asList("mutabilityIssueOne"), Arrays.asList("pathIssueOne", "pathIssueTwo")}, {null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()}};
    }

    private SchemaChecker.Results getResults(List<String> syntaxIssues, List<String> mutabilityIssues, List<String> pathIssues) throws Exception {
        SchemaChecker.Results results = new SchemaChecker.Results();
        Field syntaxField = SchemaChecker.Results.class.getDeclaredField("syntaxIssues");
        syntaxField.setAccessible(true);
        syntaxField.set(results, syntaxIssues);
        Field pathField = SchemaChecker.Results.class.getDeclaredField("pathIssues");
        pathField.setAccessible(true);
        pathField.set(results, pathIssues);
        Field mutabilityField = SchemaChecker.Results.class.getDeclaredField("mutabilityIssues");
        mutabilityField.setAccessible(true);
        mutabilityField.set(results, mutabilityIssues);
        return results;
    }

    private boolean containsIssueWith(Collection<String> issues, String issueText) {
        for (String issue : issues) {
            if (!issue.contains(issueText)) continue;
            return true;
        }
        return false;
    }
}

