/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server;

import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.types.UserResource;
import com.unboundid.scim2.server.annotations.ResourceType;
import com.unboundid.scim2.server.utils.ResourcePreparer;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SimpleSearchResults;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceType(description="User Account", name="User", schema=UserResource.class)
@Path(value="/Users")
public class TestResourceEndpoint {
    private static final ResourceTypeDefinition RESOURCE_TYPE_DEFINITION = ResourceTypeDefinition.fromJaxRsResource(TestResourceEndpoint.class);

    @POST
    @Path(value="badException")
    @Produces(value={"application/scim+json", "application/json"})
    public Response getBadException() {
        return Response.status((Response.Status)Response.Status.CONFLICT).type("application/json").entity((Object)"{\n    \"Errors\": [\n        {\n            \"code\": 409, \n            \"description\": \"Insert failed. First exception on row 0; first error: FIELD_INTEGRITY_EXCEPTION, Salesforce CRM Content User is not allowed for this License Type.: __MISSING_LABEL_FOR_common.udd.impl.UddInfoImpl@4d7b688d: [UserPermissions]\"\n        }\n    ]\n}").build();
    }

    @GET
    @Produces(value={"application/scim+json", "application/json"})
    public SimpleSearchResults<UserResource> search(@Context UriInfo uriInfo) throws ScimException {
        UserResource resource = new UserResource().setUserName("test");
        resource.setId("123");
        SimpleSearchResults results = new SimpleSearchResults(RESOURCE_TYPE_DEFINITION, uriInfo);
        results.add((ScimResource)resource);
        return results;
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/scim+json", "application/json"})
    public ScimResource retrieve(@PathParam(value="id") String id, @Context UriInfo uriInfo) throws ScimException {
        if (id.equals("123")) {
            UserResource resource = new UserResource().setUserName("test");
            resource.setId("123");
            resource.setDisplayName("UserDisplayName");
            resource.setNickName("UserNickName");
            ResourcePreparer resourcePreparer = new ResourcePreparer(RESOURCE_TYPE_DEFINITION, uriInfo);
            return resourcePreparer.trimRetrievedResource((ScimResource)resource);
        }
        throw new ResourceNotFoundException("No resource with ID " + id);
    }
}

