/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.AndFilter;
import com.unboundid.scim2.common.filters.ComparisonFilter;
import com.unboundid.scim2.common.filters.ComplexValueFilter;
import com.unboundid.scim2.common.filters.ContainsFilter;
import com.unboundid.scim2.common.filters.EndsWithFilter;
import com.unboundid.scim2.common.filters.EqualFilter;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.filters.GreaterThanFilter;
import com.unboundid.scim2.common.filters.GreaterThanOrEqualFilter;
import com.unboundid.scim2.common.filters.LessThanFilter;
import com.unboundid.scim2.common.filters.LessThanOrEqualFilter;
import com.unboundid.scim2.common.filters.NotEqualFilter;
import com.unboundid.scim2.common.filters.NotFilter;
import com.unboundid.scim2.common.filters.OrFilter;
import com.unboundid.scim2.common.filters.PresentFilter;
import com.unboundid.scim2.common.filters.StartsWithFilter;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaChecker;
import java.util.ArrayList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaCheckFilterVisitor
implements FilterVisitor<Filter, Object> {
    private final Path parentPath;
    private final ResourceTypeDefinition resourceType;
    private final SchemaChecker schemaChecker;
    private final SchemaChecker.Results results;

    private SchemaCheckFilterVisitor(Path parentPath, ResourceTypeDefinition resourceType, SchemaChecker schemaChecker, SchemaChecker.Results results) {
        this.parentPath = parentPath;
        this.resourceType = resourceType;
        this.schemaChecker = schemaChecker;
        this.results = results;
    }

    static void checkFilter(Filter filter, ResourceTypeDefinition resourceTypeDefinition, SchemaChecker schemaChecker, Set<SchemaChecker.Option> enabledOptions, SchemaChecker.Results results) throws ScimException {
        if (enabledOptions.contains((Object)SchemaChecker.Option.ALLOW_UNDEFINED_ATTRIBUTES) && enabledOptions.contains((Object)SchemaChecker.Option.ALLOW_UNDEFINED_SUB_ATTRIBUTES)) {
            return;
        }
        SchemaCheckFilterVisitor visitor = new SchemaCheckFilterVisitor(null, resourceTypeDefinition, schemaChecker, results);
        filter.visit((FilterVisitor)visitor, null);
    }

    static void checkValueFilter(Path parentPath, Filter filter, ResourceTypeDefinition resourceTypeDefinition, SchemaChecker schemaChecker, Set<SchemaChecker.Option> enabledOptions, SchemaChecker.Results results) throws ScimException {
        if (enabledOptions.contains((Object)SchemaChecker.Option.ALLOW_UNDEFINED_SUB_ATTRIBUTES)) {
            return;
        }
        SchemaCheckFilterVisitor visitor = new SchemaCheckFilterVisitor(parentPath, resourceTypeDefinition, schemaChecker, results);
        filter.visit((FilterVisitor)visitor, null);
    }

    public Filter visit(EqualFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(NotEqualFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(ContainsFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(StartsWithFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(EndsWithFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(PresentFilter filter, Object param) throws ScimException {
        this.checkAttributePath(filter.getAttributePath());
        return filter;
    }

    public Filter visit(GreaterThanFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(GreaterThanOrEqualFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(LessThanFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(LessThanOrEqualFilter filter, Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    public Filter visit(AndFilter filter, Object param) throws ScimException {
        for (Filter f : filter.getCombinedFilters()) {
            f.visit((FilterVisitor)this, param);
        }
        return filter;
    }

    public Filter visit(OrFilter filter, Object param) throws ScimException {
        for (Filter f : filter.getCombinedFilters()) {
            f.visit((FilterVisitor)this, param);
        }
        return filter;
    }

    public Filter visit(NotFilter filter, Object param) throws ScimException {
        filter.getInvertedFilter().visit((FilterVisitor)this, param);
        return filter;
    }

    public Filter visit(ComplexValueFilter filter, Object param) throws ScimException {
        this.checkAttributePath(filter.getAttributePath());
        return filter;
    }

    private Filter visitComparisonFilter(ComparisonFilter filter, Object param) {
        this.checkAttributePath(filter.getAttributePath());
        return filter;
    }

    private void checkAttributePath(Path path) {
        if (this.parentPath != null) {
            Path fullPath = this.parentPath.attribute(path);
            AttributeDefinition attribute = this.resourceType.getAttributeDefinition(fullPath);
            if (attribute == null) {
                this.results.addFilterIssue("Sub-attribute " + path.getElement(0) + " in value filter for path " + this.parentPath.toString() + " is undefined");
            }
        } else {
            AttributeDefinition attribute = this.resourceType.getAttributeDefinition(path);
            if (attribute == null) {
                ArrayList<String> messages = new ArrayList<String>();
                this.schemaChecker.addMessageForUndefinedAttr(path, "", messages);
                if (!messages.isEmpty()) {
                    for (String m : messages) {
                        this.results.addFilterIssue(m);
                    }
                }
            }
        }
    }
}

