/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.providers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.messages.ErrorResponse;
import com.unboundid.scim2.server.utils.ServerUtils;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    @Context
    private Request request;
    @Context
    private HttpHeaders headers;

    public Response toResponse(JsonProcessingException exception) {
        ErrorResponse errorResponse;
        if (exception instanceof JsonParseException || exception instanceof JsonMappingException) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unable to parse request: ");
            builder.append(exception.getOriginalMessage());
            if (exception.getLocation() != null) {
                builder.append(" at line: ");
                builder.append(exception.getLocation().getLineNr());
                builder.append(", column: ");
                builder.append(exception.getLocation().getColumnNr());
            }
            errorResponse = BadRequestException.invalidSyntax((String)builder.toString()).getScimError();
        } else {
            errorResponse = exception.getCause() != null && exception.getCause() instanceof ScimException ? ((ScimException)exception.getCause()).getScimError() : new ServerErrorException(exception.getMessage()).getScimError();
        }
        return ServerUtils.setAcceptableType(Response.status((int)errorResponse.getStatus()).entity((Object)errorResponse), this.headers.getAcceptableMediaTypes()).build();
    }
}

