/*
 * Copyright 2015-2016 UnboundID Corp.
 */

package com.unboundid.scim2.common.utils;



import java.util.ArrayList;
import java.util.Collections;
import java.util.List;



/**
 * This class provides information about the current set of version definitions.
 */
public final class Version
{
  //
  // NOTE -- This file is dynamically generated.  Do not edit it.  If you need
  //         to add something to it, then add it to the
  //         Version.java.stub file below src/main/stubs directory.
  //



  /**
   * The official full product name for the scim2-sdk-server library.  For this
   * build, the value is "UnboundID SCIM2 SDK Server".
   */
  public static final String PRODUCT_NAME = "UnboundID SCIM2 SDK Server";



  /**
   * The short product name for the scim2-sdk-server library.  This will not have
   * any spaces. For this build, the value is "scim2-sdk-server".
   */
  public static final String SHORT_NAME = "scim2-sdk-server";



  /**
   * The version string for the scim2-sdk-server library.
   * For this build, the value is "2.0.4".
   */
  public static final String VERSION = "2.0.4";


  /**
   * The timestamp string for the scim2-sdk-server library compilation.
   * For this build, the value is "2016-09-27T16:14:10Z".
   */
  public static final String BUILD_TIMESTAMP = "2016-09-27T16:14:10Z";


  /**
   * The Subversion path associated with the build root directory from which
   * this build of the scim2-sdk-server was generated.  It may be an absolute local
   * filesystem path if the Subversion path isn't available at build time.
   * For this build, the value is "master".
   */
  public static final String REPOSITORY_PATH = "master";


  /**
   * The source revision number from which this build of the scim2-sdk-server was
   * generated.  It may be -1 if the Subversion revision isn't available at
   * build time.  For this build, the value is f666b2aa5d453a62c8d1f83fa7c8f678202cd84d.
   */
  public static final String REVISION_NUMBER = "f666b2aa5d453a62c8d1f83fa7c8f678202cd84d";


  /**
   * The full version string for the scim2-sdk-server library.  For this build,
   * the value is "UnboundID SCIM2 SDK Server 2.0.4".
   */
  public static final String FULL_VERSION_STRING =
       PRODUCT_NAME + ' ' + VERSION;



  /**
   * The short version string for the scim2-sdk-server library.  This will not
   * have any spaces. For this build, the value is "scim2-sdk-server-2.0.4".
   */
  public static final String SHORT_VERSION_STRING =
       SHORT_NAME + '-' + VERSION;



  /**
   * Prevent this class from being instantiated.
   */
  private Version()
  {
    // No implementation is required.
  }



  /**
   * Prints version information from this class to standard output.
   *
   * @param  args  The command-line arguments provided to this program.
   */
  public static void main(final String... args)
  {
    for (final String line : getVersionLines())
    {
      System.out.println(line);
    }
  }



  /**
   * Retrieves a list of lines containing information about the scim2-sdk-server
   * library version.
   *
   * @return  A list of lines containing information about the scim2-sdk-server
   *          library version.
   */
  public static List<String> getVersionLines()
  {
    final ArrayList<String> versionLines = new ArrayList<String>(11);

    versionLines.add("Full Version String:   " + FULL_VERSION_STRING);
    versionLines.add("Short Version String:  " + SHORT_VERSION_STRING);
    versionLines.add("Product Name:          " + PRODUCT_NAME);
    versionLines.add("Short Name:            " + SHORT_NAME);
    versionLines.add("Version:               " + VERSION);
    versionLines.add("Timestamp:             " + BUILD_TIMESTAMP);
    versionLines.add("Repository Path:       " + REPOSITORY_PATH);
    versionLines.add("Revision Number:       " + REVISION_NUMBER);

    return Collections.unmodifiableList(versionLines);
  }
}
