/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.utils.StaticUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.ScimResourceTrimmer;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePreparer<T extends ScimResource> {
    private final ResourceTypeDefinition resourceType;
    private final URI baseUri;
    private final Set<Path> queryAttributes;
    private final boolean excluded;

    public ResourcePreparer(ResourceTypeDefinition resourceType, UriInfo requestUriInfo) throws BadRequestException {
        this(resourceType, (String)requestUriInfo.getQueryParameters().getFirst((Object)"attributes"), (String)requestUriInfo.getQueryParameters().getFirst((Object)"excludedAttributes"), requestUriInfo.getBaseUriBuilder().path(resourceType.getEndpoint()).buildFromMap(ResourcePreparer.singleValuedMapFromMultivaluedMap((MultivaluedMap<String, String>)requestUriInfo.getPathParameters())));
    }

    private static Map<String, String> singleValuedMapFromMultivaluedMap(MultivaluedMap<String, String> multivaluedMap) {
        LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
        for (String k : multivaluedMap.keySet()) {
            returnMap.put(k, (String)multivaluedMap.getFirst((Object)k));
        }
        return returnMap;
    }

    ResourcePreparer(ResourceTypeDefinition resourceType, String attributesString, String excludedAttributesString, URI baseUri) throws BadRequestException {
        if (attributesString != null && !attributesString.isEmpty()) {
            Set attributeSet = StaticUtils.arrayToSet((Object[])StaticUtils.splitCommaSeparatedString((String)attributesString));
            this.queryAttributes = new LinkedHashSet<Path>(attributeSet.size());
            for (String attribute : attributeSet) {
                Path normalizedPath;
                try {
                    normalizedPath = resourceType.normalizePath(Path.fromString((String)attribute)).withoutFilters();
                }
                catch (BadRequestException e) {
                    throw BadRequestException.invalidValue((String)("'" + attribute + "' is not a valid value for the attributes parameter: " + e.getMessage()));
                }
                this.queryAttributes.add(normalizedPath);
            }
            this.excluded = false;
        } else if (excludedAttributesString != null && !excludedAttributesString.isEmpty()) {
            Set attributeSet = StaticUtils.arrayToSet((Object[])StaticUtils.splitCommaSeparatedString((String)excludedAttributesString));
            this.queryAttributes = new LinkedHashSet<Path>(attributeSet.size());
            for (String attribute : attributeSet) {
                Path normalizedPath;
                try {
                    normalizedPath = resourceType.normalizePath(Path.fromString((String)attribute)).withoutFilters();
                }
                catch (BadRequestException e) {
                    throw BadRequestException.invalidValue((String)("'" + attribute + "' is not a valid value for the excludedAttributes parameter: " + e.getMessage()));
                }
                this.queryAttributes.add(normalizedPath);
            }
            this.excluded = true;
        } else {
            this.queryAttributes = Collections.emptySet();
            this.excluded = true;
        }
        this.resourceType = resourceType;
        this.baseUri = baseUri;
    }

    public GenericScimResource trimRetrievedResource(T returnedResource) {
        return this.trimReturned(returnedResource, null, null);
    }

    public GenericScimResource trimCreatedResource(T returnedResource, T requestResource) {
        return this.trimReturned(returnedResource, requestResource, null);
    }

    public GenericScimResource trimReplacedResource(T returnedResource, T requestResource) {
        return this.trimReturned(returnedResource, requestResource, null);
    }

    public GenericScimResource trimModifiedResource(T returnedResource, Iterable<PatchOperation> patchOperations) {
        return this.trimReturned(returnedResource, null, patchOperations);
    }

    public void setResourceTypeAndLocation(T returnedResource) {
        Meta meta = returnedResource.getMeta();
        boolean metaUpdated = false;
        if (meta == null) {
            meta = new Meta();
        }
        if (meta.getResourceType() == null) {
            meta.setResourceType(this.resourceType.getName());
            metaUpdated = true;
        }
        if (meta.getLocation() == null) {
            String id = returnedResource.getId();
            if (id != null) {
                UriBuilder locationBuilder = UriBuilder.fromUri((URI)this.baseUri);
                locationBuilder.segment(new String[]{id});
                meta.setLocation(locationBuilder.build(new Object[0]));
            } else {
                meta.setLocation(this.baseUri);
            }
            metaUpdated = true;
        }
        if (metaUpdated) {
            returnedResource.setMeta(meta);
        }
    }

    private GenericScimResource trimReturned(T returnedResource, T requestResource, Iterable<PatchOperation> patchOperations) {
        Set<Path> requestAttributes = Collections.emptySet();
        if (requestResource != null) {
            ObjectNode requestObject = requestResource.asGenericScimResource().getObjectNode();
            requestAttributes = new LinkedHashSet();
            this.collectAttributes(Path.root(), requestAttributes, requestObject);
        }
        if (patchOperations != null) {
            requestAttributes = new LinkedHashSet();
            this.collectAttributes(requestAttributes, patchOperations);
        }
        this.setResourceTypeAndLocation(returnedResource);
        GenericScimResource genericReturnedResource = returnedResource.asGenericScimResource();
        ScimResourceTrimmer trimmer = new ScimResourceTrimmer(this.resourceType, requestAttributes, this.queryAttributes, this.excluded);
        GenericScimResource preparedResource = new GenericScimResource(trimmer.trimObjectNode(genericReturnedResource.getObjectNode()));
        return preparedResource;
    }

    private void collectAttributes(Path parentPath, Set<Path> paths, ObjectNode objectNode) {
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            Path path = parentPath.attribute((String)field.getKey());
            if (path.size() > 1 || path.getSchemaUrn() == null) {
                paths.add(path);
            }
            if (((JsonNode)field.getValue()).isArray()) {
                this.collectAttributes(path, paths, (ArrayNode)field.getValue());
                continue;
            }
            if (!((JsonNode)field.getValue()).isObject()) continue;
            this.collectAttributes(path, paths, (ObjectNode)field.getValue());
        }
    }

    private void collectAttributes(Path parentPath, Set<Path> paths, ArrayNode arrayNode) {
        for (JsonNode value : arrayNode) {
            if (value.isArray()) {
                this.collectAttributes(parentPath, paths, (ArrayNode)value);
                continue;
            }
            if (!value.isObject()) continue;
            this.collectAttributes(parentPath, paths, (ObjectNode)value);
        }
    }

    private void collectAttributes(Set<Path> paths, Iterable<PatchOperation> patchOperations) {
        for (PatchOperation patchOperation : patchOperations) {
            Path path = Path.root();
            if (patchOperation.getPath() != null) {
                path = this.resourceType.normalizePath(patchOperation.getPath()).withoutFilters();
                paths.add(path);
            }
            if (patchOperation.getJsonNode() == null) continue;
            if (patchOperation.getJsonNode().isArray()) {
                this.collectAttributes(path, paths, (ArrayNode)patchOperation.getJsonNode());
                continue;
            }
            if (!patchOperation.getJsonNode().isObject()) continue;
            this.collectAttributes(path, paths, (ObjectNode)patchOperation.getJsonNode());
        }
    }
}

