/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.providers;

import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.StaticUtils;
import com.unboundid.scim2.server.utils.ServerUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
public class DotSearchFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getMethod().equals("POST") && requestContext.getUriInfo().getPath().endsWith(".search") && (requestContext.getMediaType().isCompatible(ServerUtils.MEDIA_TYPE_SCIM_TYPE) || requestContext.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE))) {
            SearchRequest searchRequest = (SearchRequest)JsonUtils.getObjectReader().forType(SearchRequest.class).readValue(requestContext.getEntityStream());
            UriBuilder builder = requestContext.getUriInfo().getBaseUriBuilder();
            List pathSegments = requestContext.getUriInfo().getPathSegments();
            for (int i = 0; i < pathSegments.size() - 1; ++i) {
                builder.path(((PathSegment)pathSegments.get(i)).getPath());
            }
            if (searchRequest.getAttributes() != null) {
                builder.queryParam("attributes", new Object[]{StaticUtils.collectionToString((Collection)searchRequest.getAttributes(), (String)",")});
            }
            if (searchRequest.getExcludedAttributes() != null) {
                builder.queryParam("excludedAttributes", new Object[]{StaticUtils.collectionToString((Collection)searchRequest.getExcludedAttributes(), (String)",")});
            }
            if (searchRequest.getFilter() != null) {
                builder.queryParam("filter", new Object[]{searchRequest.getFilter()});
            }
            if (searchRequest.getSortBy() != null) {
                builder.queryParam("sortBy", new Object[]{searchRequest.getSortBy()});
            }
            if (searchRequest.getSortOrder() != null) {
                builder.queryParam("sortOrder", new Object[]{searchRequest.getSortOrder().getName()});
            }
            if (searchRequest.getStartIndex() != null) {
                builder.queryParam("startIndex", new Object[]{searchRequest.getStartIndex()});
            }
            if (searchRequest.getCount() != null) {
                builder.queryParam("count", new Object[]{searchRequest.getCount()});
            }
            requestContext.setRequestUri(builder.build(new Object[0]));
            requestContext.setMethod("GET");
        }
    }
}

