/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.utils.Debug;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.common.utils.ScimJsonFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Stack;

public class Parser {
    public static Filter parseFilter(String filterString) throws BadRequestException {
        return Parser.readFilter(new StringReader(filterString.trim()), false);
    }

    public static Path parsePath(String pathString) throws BadRequestException {
        String token;
        if (pathString == null) {
            return Path.root();
        }
        String trimmedPathString = pathString.trim();
        if (trimmedPathString.isEmpty()) {
            return Path.root();
        }
        Path path = Path.root();
        StringReader reader = new StringReader(trimmedPathString);
        if (SchemaUtils.isUrn(trimmedPathString)) {
            int j = trimmedPathString.indexOf(91);
            int i = j >= 0 ? trimmedPathString.substring(0, j).lastIndexOf(58) : trimmedPathString.lastIndexOf(58);
            String schemaUrn = trimmedPathString.substring(0, i++);
            String attributeName = trimmedPathString.substring(i, trimmedPathString.length());
            try {
                path = Path.root(schemaUrn);
            }
            catch (IllegalArgumentException e) {
                throw BadRequestException.invalidPath(e.getMessage());
            }
            if (attributeName.isEmpty()) {
                return path;
            }
            reader = new StringReader(attributeName);
        }
        while ((token = Parser.readPathToken(reader)) != null) {
            if (token.isEmpty()) {
                if (!path.isRoot() && path.getElement(path.size() - 1).getValueFilter() != null) continue;
                String msg = String.format("Attribute name expected at position %d", reader.mark);
                throw BadRequestException.invalidPath(msg);
            }
            String attributeName = token;
            Filter valueFilter = null;
            try {
                if (attributeName.endsWith("[")) {
                    attributeName = attributeName.substring(0, attributeName.length() - 1);
                    valueFilter = Parser.readFilter(reader, true);
                }
                path = path.attribute(attributeName, valueFilter);
            }
            catch (BadRequestException be) {
                Debug.debugException(be);
                String msg = String.format("Invalid value filter: %s", be.getMessage());
                throw BadRequestException.invalidPath(msg);
            }
            catch (Exception e) {
                Debug.debugException(e);
                String msg = String.format("Invalid attribute name starting at position %d: %s", reader.mark, e.getMessage());
                throw BadRequestException.invalidPath(msg);
            }
        }
        return path;
    }

    private static String readPathToken(StringReader reader) throws BadRequestException {
        reader.mark(0);
        int c = reader.read();
        StringBuilder b = new StringBuilder();
        while (c > 0) {
            if (c == 46) {
                if (reader.pos >= reader.string.length()) {
                    throw BadRequestException.invalidPath("Unexpected end of path string");
                }
                return b.toString();
            }
            if (c == 91) {
                b.append((char)c);
                return b.toString();
            }
            if (c != 45 && c != 95 && c != 36 && !Character.isLetterOrDigit(c)) {
                String msg = String.format("Unexpected character '%s' at position %d for token starting at %d", Character.valueOf((char)c), reader.pos - 1, reader.mark);
                throw BadRequestException.invalidPath(msg);
            }
            b.append((char)c);
            c = reader.read();
        }
        if (b.length() > 0) {
            return b.toString();
        }
        return null;
    }

    private static String readFilterToken(StringReader reader, boolean isValueFilter) throws BadRequestException {
        int c;
        do {
            reader.mark(0);
        } while ((c = reader.read()) == 32);
        StringBuilder b = new StringBuilder();
        while (c > 0) {
            if (c == 32) {
                return b.toString();
            }
            if (c == 40 || c == 41) {
                if (b.length() > 0) {
                    reader.unread();
                } else {
                    b.append((char)c);
                }
                return b.toString();
            }
            if (!isValueFilter && c == 91) {
                b.append((char)c);
                return b.toString();
            }
            if (isValueFilter && c == 93) {
                if (b.length() > 0) {
                    reader.unread();
                } else {
                    b.append((char)c);
                }
                return b.toString();
            }
            if (c != 45 && c != 95 && c != 46 && c != 58 && c != 36 && !Character.isLetterOrDigit(c)) {
                String msg = String.format("Unexpected character '%s' at position %d for token starting at %d", Character.valueOf((char)c), reader.pos - 1, reader.mark);
                throw BadRequestException.invalidFilter(msg);
            }
            b.append((char)c);
            c = reader.read();
        }
        if (b.length() > 0) {
            return b.toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Filter readFilter(StringReader reader, boolean isValueFilter) throws BadRequestException {
        String token;
        Stack<Filter> outputStack = new Stack<Filter>();
        Stack<String> precedenceStack = new Stack<String>();
        String previousToken = null;
        while ((token = Parser.readFilterToken(reader, isValueFilter)) != null) {
            String msg;
            Path filterAttribute;
            String msg2;
            if (token.equals("(") && Parser.expectsNewFilter(previousToken)) {
                precedenceStack.push(token);
            } else if (token.equalsIgnoreCase(FilterType.NOT.getStringValue()) && Parser.expectsNewFilter(previousToken)) {
                String nextToken = Parser.readFilterToken(reader, isValueFilter);
                if (nextToken == null) {
                    throw BadRequestException.invalidFilter("Unexpected end of filter string");
                }
                if (!nextToken.equals("(")) {
                    msg2 = String.format("Expected '(' at position %d", reader.mark);
                    throw BadRequestException.invalidFilter(msg2);
                }
                precedenceStack.push(token);
            } else if (token.equals(")") && !Parser.expectsNewFilter(previousToken)) {
                String operator = Parser.closeGrouping(precedenceStack, outputStack, false);
                if (operator == null) {
                    msg2 = String.format("No opening parenthesis matching closing parenthesis at position %d", reader.mark);
                    throw BadRequestException.invalidFilter(msg2);
                }
                if (operator.equalsIgnoreCase(FilterType.NOT.getStringValue())) {
                    outputStack.push(Filter.not(outputStack.pop()));
                }
            } else if (token.equalsIgnoreCase(FilterType.AND.getStringValue()) && !Parser.expectsNewFilter(previousToken)) {
                precedenceStack.push(token);
            } else if (token.equalsIgnoreCase(FilterType.OR.getStringValue()) && !Parser.expectsNewFilter(previousToken)) {
                LinkedList<Filter> andComponents = new LinkedList<Filter>();
                while (!precedenceStack.isEmpty() && precedenceStack.peek().equalsIgnoreCase(FilterType.AND.getStringValue())) {
                    precedenceStack.pop();
                    andComponents.addFirst(outputStack.pop());
                    if (andComponents.isEmpty()) continue;
                    andComponents.addFirst(outputStack.pop());
                    outputStack.push(Filter.and(andComponents));
                }
                precedenceStack.push(token);
            } else if (token.endsWith("[") && Parser.expectsNewFilter(previousToken)) {
                try {
                    filterAttribute = Parser.parsePath(token.substring(0, token.length() - 1));
                }
                catch (BadRequestException e) {
                    Debug.debugException(e);
                    msg = String.format("Invalid attribute path at position %d: %s", reader.mark, e.getMessage());
                    throw BadRequestException.invalidFilter(msg);
                }
                if (filterAttribute.isRoot()) {
                    msg2 = String.format("Attribute path expected at position %d", reader.mark);
                    throw BadRequestException.invalidFilter(msg2);
                }
                outputStack.push(Filter.hasComplexValue(filterAttribute, Parser.readFilter(reader, true)));
            } else {
                if (isValueFilter && token.equals("]") && !Parser.expectsNewFilter(previousToken)) break;
                if (!Parser.expectsNewFilter(previousToken)) {
                    String msg3 = String.format("Unexpected character '%s' at position %d", token, reader.mark);
                    throw BadRequestException.invalidFilter(msg3);
                }
                try {
                    filterAttribute = Parser.parsePath(token);
                }
                catch (BadRequestException e) {
                    Debug.debugException(e);
                    msg = String.format("Invalid attribute path at position %d: %s", reader.mark, e.getMessage());
                    throw BadRequestException.invalidFilter(msg);
                }
                if (filterAttribute.isRoot()) {
                    msg2 = String.format("Attribute path expected at position %d", reader.mark);
                    throw BadRequestException.invalidFilter(msg2);
                }
                String op = Parser.readFilterToken(reader, isValueFilter);
                if (op == null) {
                    throw BadRequestException.invalidFilter("Unexpected end of filter string");
                }
                if (op.equalsIgnoreCase(FilterType.PRESENT.getStringValue())) {
                    outputStack.push(Filter.pr(filterAttribute));
                } else {
                    ValueNode valueNode;
                    try {
                        reader.mark(0);
                        ScimJsonFactory scimJsonFactory = (ScimJsonFactory)JsonUtils.getObjectReader().getFactory();
                        JsonParser parser = scimJsonFactory.createScimFilterParser(reader);
                        if (parser.getCurrentToken() == null && parser.nextToken() == null) {
                            valueNode = null;
                        } else {
                            valueNode = (ValueNode)parser.readValueAsTree();
                            if (valueNode == null) {
                                valueNode = JsonUtils.getJsonNodeFactory().nullNode();
                            }
                        }
                        reader.reset();
                        reader.skip(parser.getCurrentLocation().getCharOffset());
                    }
                    catch (IOException e) {
                        String msg4 = String.format("Invalid comparison value at position %d: %s", reader.mark, e.getMessage());
                        throw BadRequestException.invalidFilter(msg4);
                    }
                    if (valueNode == null) {
                        throw BadRequestException.invalidFilter("Unexpected end of filter string");
                    }
                    if (op.equalsIgnoreCase(FilterType.EQUAL.getStringValue())) {
                        outputStack.push(Filter.eq(filterAttribute, valueNode));
                    } else if (op.equalsIgnoreCase(FilterType.NOT_EQUAL.getStringValue())) {
                        outputStack.push(Filter.ne(filterAttribute, valueNode));
                    } else if (op.equalsIgnoreCase(FilterType.CONTAINS.getStringValue())) {
                        outputStack.push(Filter.co(filterAttribute, valueNode));
                    } else if (op.equalsIgnoreCase(FilterType.STARTS_WITH.getStringValue())) {
                        outputStack.push(Filter.sw(filterAttribute, valueNode));
                    } else if (op.equalsIgnoreCase(FilterType.ENDS_WITH.getStringValue())) {
                        outputStack.push(Filter.ew(filterAttribute, valueNode));
                    } else if (op.equalsIgnoreCase(FilterType.GREATER_THAN.getStringValue())) {
                        outputStack.push(Filter.gt(filterAttribute, valueNode));
                    } else if (op.equalsIgnoreCase(FilterType.GREATER_OR_EQUAL.getStringValue())) {
                        outputStack.push(Filter.ge(filterAttribute, valueNode));
                    } else if (op.equalsIgnoreCase(FilterType.LESS_THAN.getStringValue())) {
                        outputStack.push(Filter.lt(filterAttribute, valueNode));
                    } else {
                        if (!op.equalsIgnoreCase(FilterType.LESS_OR_EQUAL.getStringValue())) {
                            String msg5 = String.format("Unrecognized attribute operator '%s' at position %d. Expected: eq,ne,co,sw,ew,pr,gt,ge,lt,le", op, reader.mark);
                            throw BadRequestException.invalidFilter(msg5);
                        }
                        outputStack.push(Filter.le(filterAttribute, valueNode));
                    }
                }
            }
            previousToken = token;
        }
        Parser.closeGrouping(precedenceStack, outputStack, true);
        if (outputStack.isEmpty()) {
            throw BadRequestException.invalidFilter("Unexpected end of filter string");
        }
        return outputStack.pop();
    }

    private static String closeGrouping(Stack<String> operators, Stack<Filter> output, boolean isAtTheEnd) throws BadRequestException {
        String operator = null;
        String repeatingOperator = null;
        LinkedList<Filter> components = new LinkedList<Filter>();
        while (!operators.isEmpty()) {
            operator = operators.pop();
            if (operator.equals("(") || operator.equalsIgnoreCase(FilterType.NOT.getStringValue())) {
                if (!isAtTheEnd) break;
                throw BadRequestException.invalidFilter("Unexpected end of filter string");
            }
            if (repeatingOperator == null) {
                repeatingOperator = operator;
            }
            if (!operator.equals(repeatingOperator)) {
                if (output.isEmpty()) {
                    throw BadRequestException.invalidFilter("Unexpected end of filter string");
                }
                components.addFirst(output.pop());
                if (repeatingOperator.equalsIgnoreCase(FilterType.AND.getStringValue())) {
                    output.push(Filter.and(components));
                } else {
                    output.push(Filter.or(components));
                }
                components.clear();
                repeatingOperator = operator;
            }
            if (output.isEmpty()) {
                throw BadRequestException.invalidFilter("Unexpected end of filter string");
            }
            components.addFirst(output.pop());
        }
        if (repeatingOperator != null && !components.isEmpty()) {
            if (output.isEmpty()) {
                throw BadRequestException.invalidFilter("Unexpected end of filter string");
            }
            components.addFirst(output.pop());
            if (repeatingOperator.equalsIgnoreCase(FilterType.AND.getStringValue())) {
                output.push(Filter.and(components));
            } else {
                output.push(Filter.or(components));
            }
        }
        return operator;
    }

    private static boolean expectsNewFilter(String previousToken) {
        return previousToken == null || previousToken.equals("(") || previousToken.equalsIgnoreCase(FilterType.NOT.getStringValue()) || previousToken.equalsIgnoreCase(FilterType.AND.getStringValue()) || previousToken.equalsIgnoreCase(FilterType.OR.getStringValue());
    }

    private static final class StringReader
    extends Reader {
        private final String string;
        private int pos;
        private int mark;

        private StringReader(String string) {
            this.string = string;
        }

        @Override
        public int read() {
            if (this.pos >= this.string.length()) {
                return -1;
            }
            return this.string.charAt(this.pos++);
        }

        public void unread() {
            --this.pos;
        }

        @Override
        public boolean ready() {
            return true;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.pos;
        }

        @Override
        public void reset() {
            this.pos = this.mark;
        }

        @Override
        public long skip(long n) {
            long chars = Math.min((long)(this.string.length() - this.pos), n);
            this.pos = (int)((long)this.pos + chars);
            return chars;
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            if (this.pos >= this.string.length()) {
                return -1;
            }
            int chars = Math.min(this.string.length() - this.pos, len);
            System.arraycopy(this.string.toCharArray(), this.pos, cbuf, off, chars);
            this.pos += chars;
            return chars;
        }

        @Override
        public void close() {
        }
    }
}

