/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.Manager;

@Schema(id="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", name="EnterpriseUser", description="Enterprise User")
public class EnterpriseUserExtension {
    @Attribute(description="Numeric or alphanumeric identifier assigned to a person, typically based on order of hire or association with an organization.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String employeeNumber;
    @Attribute(description="Identifies the name of a cost center.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String costCenter;
    @Attribute(description="Identifies the name of an organization.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String organization;
    @Attribute(description="Identifies the name of a division.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String division;
    @Attribute(description="Identifies the name of a department.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String department;
    @Attribute(description="The User's manager.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Manager manager;

    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public EnterpriseUserExtension setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
        return this;
    }

    public String getCostCenter() {
        return this.costCenter;
    }

    public EnterpriseUserExtension setCostCenter(String costCenter) {
        this.costCenter = costCenter;
        return this;
    }

    public String getOrganization() {
        return this.organization;
    }

    public EnterpriseUserExtension setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String getDivision() {
        return this.division;
    }

    public EnterpriseUserExtension setDivision(String division) {
        this.division = division;
        return this;
    }

    public String getDepartment() {
        return this.department;
    }

    public EnterpriseUserExtension setDepartment(String department) {
        this.department = department;
        return this;
    }

    public Manager getManager() {
        return this.manager;
    }

    public EnterpriseUserExtension setManager(Manager manager) {
        this.manager = manager;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnterpriseUserExtension that = (EnterpriseUserExtension)o;
        if (this.employeeNumber != null ? !this.employeeNumber.equals(that.employeeNumber) : that.employeeNumber != null) {
            return false;
        }
        if (this.costCenter != null ? !this.costCenter.equals(that.costCenter) : that.costCenter != null) {
            return false;
        }
        if (this.organization != null ? !this.organization.equals(that.organization) : that.organization != null) {
            return false;
        }
        if (this.division != null ? !this.division.equals(that.division) : that.division != null) {
            return false;
        }
        if (this.department != null ? !this.department.equals(that.department) : that.department != null) {
            return false;
        }
        return !(this.manager == null ? that.manager != null : !this.manager.equals(that.manager));
    }

    public int hashCode() {
        int result = this.employeeNumber != null ? this.employeeNumber.hashCode() : 0;
        result = 31 * result + (this.costCenter != null ? this.costCenter.hashCode() : 0);
        result = 31 * result + (this.organization != null ? this.organization.hashCode() : 0);
        result = 31 * result + (this.division != null ? this.division.hashCode() : 0);
        result = 31 * result + (this.department != null ? this.department.hashCode() : 0);
        result = 31 * result + (this.manager != null ? this.manager.hashCode() : 0);
        return result;
    }
}

