/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.utils.DateTimeUtils;
import com.unboundid.scim2.common.utils.FilterEvaluator;
import com.unboundid.scim2.common.utils.JsonDiff;
import com.unboundid.scim2.common.utils.MapperFactory;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static MapperFactory mapperFactory = new MapperFactory();
    private static ObjectMapper SDK_OBJECT_MAPPER = JsonUtils.createObjectMapper();

    public static JsonNode getValue(Path path, ObjectNode node) throws ScimException {
        GatheringNodeVisitor visitor = new GatheringNodeVisitor(false);
        JsonUtils.traverseValues(visitor, node, 0, path);
        if (visitor.values.isEmpty()) {
            return NullNode.getInstance();
        }
        return visitor.values.get(0);
    }

    public static List<JsonNode> findMatchingPaths(Path path, ObjectNode node) throws ScimException {
        GatheringNodeVisitor visitor = new GatheringNodeVisitor(false);
        JsonUtils.traverseValues(visitor, node, 0, path);
        return visitor.values;
    }

    public static void addValue(Path path, ObjectNode node, JsonNode value) throws ScimException {
        UpdatingNodeVisitor visitor = new UpdatingNodeVisitor(value, true);
        JsonUtils.traverseValues(visitor, node, 0, path);
    }

    public static List<JsonNode> removeValues(Path path, ObjectNode node) throws ScimException {
        GatheringNodeVisitor visitor = new GatheringNodeVisitor(true);
        JsonUtils.traverseValues(visitor, node, 0, path);
        return visitor.values;
    }

    public static void replaceValue(Path path, ObjectNode node, JsonNode value) throws ScimException {
        UpdatingNodeVisitor visitor = new UpdatingNodeVisitor(value, false);
        JsonUtils.traverseValues(visitor, node, 0, path);
    }

    public static boolean pathExists(Path path, ObjectNode node) throws ScimException {
        PathExistsVisitor pathExistsVisitor = new PathExistsVisitor();
        JsonUtils.traverseValues(pathExistsVisitor, node, 0, path);
        return pathExistsVisitor.isPathPresent();
    }

    public static int compareTo(JsonNode n1, JsonNode n2, AttributeDefinition attributeDefinition) {
        if (n1.isTextual() && n2.isTextual()) {
            Date d1 = JsonUtils.dateValue(n1);
            Date d2 = JsonUtils.dateValue(n2);
            if (d1 != null && d2 != null) {
                return d1.compareTo(d2);
            }
            if (attributeDefinition != null && attributeDefinition.getType() == AttributeDefinition.Type.STRING && attributeDefinition.isCaseExact()) {
                return n1.textValue().compareTo(n2.textValue());
            }
            return StaticUtils.toLowerCase(n1.textValue()).compareTo(StaticUtils.toLowerCase(n2.textValue()));
        }
        if (n1.isNumber() && n2.isNumber()) {
            if (n1.isBigDecimal() || n2.isBigDecimal()) {
                return n1.decimalValue().compareTo(n2.decimalValue());
            }
            if (n1.isFloatingPointNumber() || n2.isFloatingPointNumber()) {
                return Double.compare(n1.doubleValue(), n2.doubleValue());
            }
            if (n1.isBigInteger() || n2.isBigInteger()) {
                return n1.bigIntegerValue().compareTo(n2.bigIntegerValue());
            }
            return Long.compare(n1.longValue(), n2.longValue());
        }
        return n1.asText().compareTo(n2.asText());
    }

    public static List<PatchOperation> diff(ObjectNode source, ObjectNode target, boolean removeMissing) {
        return new JsonDiff().diff(source, target, removeMissing);
    }

    private static Date dateValue(JsonNode node) {
        try {
            return JsonUtils.nodeToDateValue(node);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void traverseValues(NodeVisitor nodeVisitor, ObjectNode node, Path path) throws ScimException {
        JsonUtils.traverseValues(nodeVisitor, node, 0, path);
    }

    private static void traverseValues(NodeVisitor nodeVisitor, ObjectNode node, int index, Path path) throws ScimException {
        Path.Element element;
        String field = null;
        Filter valueFilter = null;
        int pathDepth = path.size();
        if (path.getSchemaUrn() != null) {
            if (index > 0) {
                element = path.getElement(index - 1);
                field = element.getAttribute();
                valueFilter = element.getValueFilter();
            } else {
                field = path.getSchemaUrn();
            }
            ++pathDepth;
        } else if (path.size() > 0) {
            element = path.getElement(index);
            field = element.getAttribute();
            valueFilter = element.getValueFilter();
        }
        if (index < pathDepth - 1) {
            JsonNode child = nodeVisitor.visitInnerNode(node, field, valueFilter);
            if (child.isArray()) {
                for (JsonNode value : child) {
                    if (!value.isObject()) continue;
                    JsonUtils.traverseValues(nodeVisitor, (ObjectNode)value, index + 1, path);
                }
            } else if (child.isObject()) {
                JsonUtils.traverseValues(nodeVisitor, (ObjectNode)child, index + 1, path);
            }
        } else {
            nodeVisitor.visitLeafNode(node, field, valueFilter);
        }
    }

    public static ObjectReader getObjectReader() {
        return SDK_OBJECT_MAPPER.reader();
    }

    public static ObjectWriter getObjectWriter() {
        return SDK_OBJECT_MAPPER.writer();
    }

    public static JsonNodeFactory getJsonNodeFactory() {
        return SDK_OBJECT_MAPPER.getNodeFactory();
    }

    public static <T extends JsonNode> T valueToNode(Object fromValue) {
        return (T)SDK_OBJECT_MAPPER.valueToTree(fromValue);
    }

    public static <T> T nodeToValue(JsonNode fromNode, Class<T> valueType) throws JsonProcessingException {
        return (T)SDK_OBJECT_MAPPER.treeToValue((TreeNode)fromNode, valueType);
    }

    public static <T> List<T> nodeToValues(ArrayNode fromNode, Class<T> valueType) throws JsonProcessingException {
        CollectionType collectionType = SDK_OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, valueType);
        try {
            return (List)SDK_OBJECT_MAPPER.readValue(SDK_OBJECT_MAPPER.treeAsTokens((TreeNode)fromNode), (JavaType)collectionType);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static Date nodeToDateValue(JsonNode node) throws IllegalArgumentException {
        if (!node.isTextual()) {
            throw new IllegalArgumentException("non-textual node cannot be parsed as DateTime type");
        }
        String text = node.textValue().trim();
        return DateTimeUtils.parse(text).getTime();
    }

    public static ObjectMapper createObjectMapper() {
        return mapperFactory.createObjectMapper();
    }

    public static void setCustomMapperFactory(MapperFactory customMapperFactory) {
        mapperFactory = customMapperFactory;
        SDK_OBJECT_MAPPER = customMapperFactory.createObjectMapper();
    }

    private static class PathExistsVisitor
    extends NodeVisitor {
        private boolean pathPresent = false;

        private PathExistsVisitor() {
        }

        @Override
        JsonNode visitInnerNode(ObjectNode parent, String field, Filter valueFilter) throws ScimException {
            JsonNode node = parent.path(field);
            if (node.isArray() && valueFilter != null) {
                return this.filterArray((ArrayNode)node, valueFilter, false);
            }
            return node;
        }

        @Override
        void visitLeafNode(ObjectNode parent, String field, Filter valueFilter) throws ScimException {
            JsonNode node = parent.path(field);
            if (node.isArray() && valueFilter != null) {
                node = this.filterArray((ArrayNode)node, valueFilter, false);
            }
            if (node.isArray()) {
                if (node.size() > 0) {
                    this.setPathPresent(true);
                }
            } else if (!node.isMissingNode()) {
                this.setPathPresent(true);
            }
        }

        public boolean isPathPresent() {
            return this.pathPresent;
        }

        private void setPathPresent(boolean pathPresent) {
            this.pathPresent = pathPresent;
        }
    }

    public static class UpdatingNodeVisitor
    extends NodeVisitor {
        protected final JsonNode value;
        protected final boolean appendValues;

        protected UpdatingNodeVisitor(JsonNode value, boolean appendValues) {
            this.value = value.deepCopy();
            this.appendValues = appendValues;
        }

        @Override
        protected JsonNode visitInnerNode(ObjectNode parent, String field, Filter valueFilter) throws ScimException {
            JsonNode node = parent.path(field);
            if (node.isValueNode() || (node.isMissingNode() || node.isNull()) && valueFilter != null) {
                throw BadRequestException.noTarget("Attribute " + field + " does not have a multi-valued or complex value");
            }
            if (node.isMissingNode() || node.isNull()) {
                ObjectNode newObjectNode = JsonUtils.getJsonNodeFactory().objectNode();
                parent.set(field, (JsonNode)newObjectNode);
                return newObjectNode;
            }
            if (node.isArray()) {
                ArrayNode arrayNode = (ArrayNode)node;
                if (valueFilter != null && (arrayNode = this.filterArray((ArrayNode)node, valueFilter, false)).size() == 0) {
                    throw BadRequestException.noTarget("Attribute " + field + " does not have a value matching the filter " + valueFilter);
                }
                return arrayNode;
            }
            return node;
        }

        @Override
        protected void visitLeafNode(ObjectNode parent, String field, Filter valueFilter) throws ScimException {
            if (field != null) {
                JsonNode node = parent.path(field);
                if (!this.appendValues && valueFilter != null) {
                    boolean matchesFound = false;
                    if (node.isArray()) {
                        for (int i = 0; i < node.size(); ++i) {
                            if (!FilterEvaluator.evaluate(valueFilter, node.get(i))) continue;
                            matchesFound = true;
                            if (node.get(i).isObject() && this.value.isObject()) {
                                this.updateNode((ObjectNode)node.get(i), null, this.value);
                                continue;
                            }
                            ((ArrayNode)node).set(i, this.value);
                        }
                    } else if (FilterEvaluator.evaluate(valueFilter, node)) {
                        matchesFound = true;
                        this.updateNode(parent, field, this.value);
                    }
                    if (!matchesFound) {
                        throw BadRequestException.noTarget("Attribute " + field + " does not have a value matching the filter " + valueFilter.toString());
                    }
                    return;
                }
            }
            this.updateNode(parent, field, this.value);
        }

        protected void updateNode(ObjectNode parent, String key, JsonNode value) {
            ObjectNode node;
            if (value.isNull() || value.isArray() && value.size() == 0) {
                return;
            }
            Object object = node = key == null ? parent : parent.path(key);
            if (node.isObject()) {
                if (value.isObject()) {
                    ObjectNode targetObject = node;
                    ObjectNode valueObject = (ObjectNode)value;
                    Iterator i = valueObject.fields();
                    while (i.hasNext()) {
                        Map.Entry field = (Map.Entry)i.next();
                        this.updateNode(targetObject, (String)field.getKey(), (JsonNode)field.getValue());
                    }
                } else {
                    parent.set(key, value);
                }
            } else if (node.isArray()) {
                if (value.isArray() && this.appendValues) {
                    ArrayNode targetArray = (ArrayNode)node;
                    ArrayNode valueArray = (ArrayNode)value;
                    for (JsonNode valueNode : valueArray) {
                        boolean valueFound = false;
                        for (JsonNode targetNode : targetArray) {
                            if (!valueNode.equals((Object)targetNode)) continue;
                            valueFound = true;
                            break;
                        }
                        if (valueFound) continue;
                        targetArray.add(valueNode);
                    }
                } else {
                    parent.set(key, value);
                }
            } else {
                parent.set(key, value);
            }
        }
    }

    private static final class GatheringNodeVisitor
    extends NodeVisitor {
        final List<JsonNode> values = new LinkedList<JsonNode>();
        final boolean removeValues;

        private GatheringNodeVisitor(boolean removeValues) {
            this.removeValues = removeValues;
        }

        @Override
        JsonNode visitInnerNode(ObjectNode parent, String field, Filter valueFilter) throws ScimException {
            JsonNode node = parent.path(field);
            if (node.isArray() && valueFilter != null) {
                return this.filterArray((ArrayNode)node, valueFilter, false);
            }
            return node;
        }

        @Override
        void visitLeafNode(ObjectNode parent, String field, Filter valueFilter) throws ScimException {
            JsonNode node = parent.path(field);
            if (node.isArray()) {
                ArrayNode arrayNode = (ArrayNode)node;
                if (valueFilter != null) {
                    arrayNode = this.filterArray((ArrayNode)node, valueFilter, this.removeValues);
                }
                if (arrayNode.size() > 0) {
                    this.values.add((JsonNode)arrayNode);
                }
                if (this.removeValues && (valueFilter == null || node.size() == 0)) {
                    parent.remove(field);
                }
            } else if (node.isObject() || node.isValueNode()) {
                this.values.add(node);
                if (this.removeValues) {
                    parent.remove(field);
                }
            }
        }
    }

    public static abstract class NodeVisitor {
        abstract JsonNode visitInnerNode(ObjectNode var1, String var2, Filter var3) throws ScimException;

        abstract void visitLeafNode(ObjectNode var1, String var2, Filter var3) throws ScimException;

        ArrayNode filterArray(ArrayNode array, Filter valueFilter, boolean removeMatching) throws ScimException {
            ArrayNode matchingArray = JsonUtils.getJsonNodeFactory().arrayNode();
            Iterator i = array.elements();
            while (i.hasNext()) {
                JsonNode node = (JsonNode)i.next();
                if (!FilterEvaluator.evaluate(valueFilter, node)) continue;
                matchingArray.add(node);
                if (!removeMatching) continue;
                i.remove();
            }
            return matchingArray;
        }
    }
}

