/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.types.AttributeDefinition;
import java.net.URI;

public class Photo {
    @Attribute(description="URI of a photo of the User.", isRequired=false, referenceTypes={"external"}, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private URI value;
    @Attribute(description="A human readable name, primarily used for display purposes.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String display;
    @Attribute(description="A label indicating the attribute's function; e.g., 'photo' or 'thumbnail'.", isRequired=false, isCaseExact=false, canonicalValues={"photo", "thumbnail"}, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String type;
    @Attribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred messenger or primary messenger. The primary attribute value 'true' MUST appear no more than once.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Boolean primary;

    public URI getValue() {
        return this.value;
    }

    public Photo setValue(URI value) {
        this.value = value;
        return this;
    }

    public String getDisplay() {
        return this.display;
    }

    public Photo setDisplay(String display) {
        this.display = display;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Photo setType(String type) {
        this.type = type;
        return this;
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public Photo setPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Photo photo = (Photo)o;
        if (this.value != null ? !this.value.equals(photo.value) : photo.value != null) {
            return false;
        }
        if (this.display != null ? !this.display.equals(photo.display) : photo.display != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(photo.type) : photo.type != null) {
            return false;
        }
        return !(this.primary == null ? photo.primary != null : !this.primary.equals(photo.primary));
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
        return result;
    }
}

