/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.types.AttributeDefinition;
import java.net.URI;
import java.util.Objects;

public class Member {
    @Attribute(description="The identifier of a group member.", isRequired=true, isCaseExact=false, mutability=AttributeDefinition.Mutability.IMMUTABLE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String value;
    @Attribute(description="The URI of the member resource.", isRequired=true, referenceTypes={"User", "Group"}, mutability=AttributeDefinition.Mutability.IMMUTABLE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    @JsonProperty(value="$ref")
    private URI ref;
    @Attribute(description="A human readable name, primarily used for display purposes.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.IMMUTABLE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String display;

    public String getValue() {
        return this.value;
    }

    public Member setValue(String value) {
        this.value = value;
        return this;
    }

    public URI getRef() {
        return this.ref;
    }

    public Member setRef(URI ref) {
        this.ref = ref;
        return this;
    }

    public String getDisplay() {
        return this.display;
    }

    public Member setDisplay(String display) {
        this.display = display;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        return this.value.equals(member.value) && this.ref.equals(member.ref) && Objects.equals(this.display, member.display);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.ref, this.display);
    }
}

