/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.types.AttributeDefinition;
import java.net.URI;

public class Group {
    @Attribute(description="The identifier of the User's group.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String value;
    @Attribute(description="The URI of the corresponding Group resource to which the user belongs", isRequired=false, referenceTypes={"User", "Group"}, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    @JsonProperty(value="$ref")
    private URI ref;
    @Attribute(description="A human readable name, primarily used for display purposes.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String display;
    @Attribute(description="A label indicating the attribute's function; e.g., 'direct' or 'indirect'.", isRequired=false, isCaseExact=false, canonicalValues={"direct", "indirect"}, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String type;

    public String getValue() {
        return this.value;
    }

    public Group setValue(String value) {
        this.value = value;
        return this;
    }

    public URI getRef() {
        return this.ref;
    }

    public Group setRef(URI ref) {
        this.ref = ref;
        return this;
    }

    public String getDisplay() {
        return this.display;
    }

    public Group setDisplay(String display) {
        this.display = display;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Group setType(String type) {
        this.type = type;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        if (this.value != null ? !this.value.equals(group.value) : group.value != null) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(group.ref) : group.ref != null) {
            return false;
        }
        if (this.display != null ? !this.display.equals(group.display) : group.display != null) {
            return false;
        }
        return !(this.type == null ? group.type != null : !this.type.equals(group.type));
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
        result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

