/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.messages.PatchOpType;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="op")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AddOperation.class, name="add"), @JsonSubTypes.Type(value=RemoveOperation.class, name="remove"), @JsonSubTypes.Type(value=ReplaceOperation.class, name="replace")})
public abstract class PatchOperation {
    private final Path path;

    PatchOperation(Path path) throws ScimException {
        if (path != null) {
            Filter valueFilter;
            if (path.size() > 2) {
                throw BadRequestException.invalidPath("Path can not target sub-attributes more than one level deep");
            }
            if (path.size() == 2 && (valueFilter = path.getElement(1).getValueFilter()) != null && !valueFilter.getAttributePath().getElement(0).getAttribute().equals("value")) {
                throw BadRequestException.invalidPath("Path can not include a value filter on sub-attributes");
            }
        }
        this.path = path;
    }

    @JsonIgnore
    public abstract PatchOpType getOpType();

    public Path getPath() {
        return this.path;
    }

    @JsonIgnore
    public JsonNode getJsonNode() {
        return null;
    }

    public <T> T getValue(Class<T> cls) throws JsonProcessingException, ScimException, IllegalArgumentException {
        return null;
    }

    public <T> List<T> getValues(Class<T> cls) throws JsonProcessingException, ScimException {
        return null;
    }

    public abstract void apply(ObjectNode var1) throws ScimException;

    public String toString() {
        try {
            return JsonUtils.getObjectWriter().withDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addMissingSchemaUrns(ObjectNode node) {
        JsonNode schemasNode = node.path(SchemaUtils.SCHEMAS_ATTRIBUTE_DEFINITION.getName());
        if (schemasNode.isArray()) {
            ArrayNode schemas = (ArrayNode)schemasNode;
            if (this.getPath() == null) {
                Iterator i = this.getJsonNode().fieldNames();
                while (i.hasNext()) {
                    String field = (String)i.next();
                    if (!SchemaUtils.isUrn(field)) continue;
                    this.addSchemaUrnIfMissing(schemas, field);
                }
            } else if (this.getPath().getSchemaUrn() != null) {
                this.addSchemaUrnIfMissing(schemas, this.getPath().getSchemaUrn());
            }
        }
    }

    private void addSchemaUrnIfMissing(ArrayNode schemas, String schemaUrn) {
        for (JsonNode node : schemas) {
            if (!node.isTextual() || !node.textValue().equalsIgnoreCase(schemaUrn)) continue;
            return;
        }
        schemas.add(schemaUrn);
    }

    public static PatchOperation add(JsonNode value) {
        return PatchOperation.add((Path)null, value);
    }

    public static PatchOperation add(String path, JsonNode value) throws ScimException {
        return PatchOperation.add(Path.fromString(path), value);
    }

    public static PatchOperation add(Path path, JsonNode value) {
        try {
            return new AddOperation(path, value);
        }
        catch (ScimException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PatchOperation addStringValues(String path, List<String> values) throws ScimException {
        return PatchOperation.addStringValues(Path.fromString(path), values);
    }

    public static PatchOperation addStringValues(Path path, List<String> values) {
        ArrayNode arrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (String value : values) {
            arrayNode.add(value);
        }
        return PatchOperation.add(path, (JsonNode)arrayNode);
    }

    public static PatchOperation replace(String path, String value) throws ScimException {
        return PatchOperation.replace(path, (JsonNode)TextNode.valueOf((String)value));
    }

    public static PatchOperation replace(Path path, String value) {
        return PatchOperation.replace(path, (JsonNode)TextNode.valueOf((String)value));
    }

    public static PatchOperation addBooleanValues(String path, List<Boolean> values) throws ScimException {
        return PatchOperation.addBooleanValues(Path.fromString(path), values);
    }

    public static PatchOperation addBooleanValues(Path path, List<Boolean> values) {
        ArrayNode arrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Boolean value : values) {
            arrayNode.add(value);
        }
        return PatchOperation.add(path, (JsonNode)arrayNode);
    }

    public static PatchOperation replace(String path, Boolean value) throws ScimException {
        return PatchOperation.replace(path, (JsonNode)BooleanNode.valueOf((boolean)value));
    }

    public static PatchOperation replace(Path path, Boolean value) {
        return PatchOperation.replace(path, (JsonNode)BooleanNode.valueOf((boolean)value));
    }

    public static PatchOperation addDoubleValues(String path, List<Double> values) throws ScimException {
        return PatchOperation.addDoubleValues(Path.fromString(path), values);
    }

    public static PatchOperation addDoubleValues(Path path, List<Double> values) {
        ArrayNode arrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Double value : values) {
            arrayNode.add(value);
        }
        return PatchOperation.add(path, (JsonNode)arrayNode);
    }

    public static PatchOperation replace(String path, Double value) throws ScimException {
        return PatchOperation.replace(path, (JsonNode)DoubleNode.valueOf((double)value));
    }

    public static PatchOperation replace(Path path, Double value) {
        return PatchOperation.replace(path, (JsonNode)DoubleNode.valueOf((double)value));
    }

    public static PatchOperation addIntegerValues(String path, List<Integer> values) throws ScimException {
        return PatchOperation.addIntegerValues(Path.fromString(path), values);
    }

    public static PatchOperation addIntegerValues(Path path, List<Integer> values) {
        ArrayNode arrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Integer value : values) {
            arrayNode.add(value);
        }
        return PatchOperation.add(path, (JsonNode)arrayNode);
    }

    public static PatchOperation replace(String path, Integer value) throws ScimException {
        return PatchOperation.replace(path, (JsonNode)IntNode.valueOf((int)value));
    }

    public static PatchOperation replace(Path path, Integer value) {
        return PatchOperation.replace(path, (JsonNode)IntNode.valueOf((int)value));
    }

    public static PatchOperation addLongValues(String path, List<Long> values) throws ScimException {
        return PatchOperation.addLongValues(Path.fromString(path), values);
    }

    public static PatchOperation addLongValues(Path path, List<Long> values) {
        ArrayNode arrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Long value : values) {
            arrayNode.add(value);
        }
        return PatchOperation.add(path, (JsonNode)arrayNode);
    }

    public static PatchOperation replace(String path, Long value) throws ScimException {
        return PatchOperation.replace(path, (JsonNode)LongNode.valueOf((long)value));
    }

    public static PatchOperation replace(Path path, Long value) {
        return PatchOperation.replace(path, (JsonNode)LongNode.valueOf((long)value));
    }

    public static PatchOperation addDateValues(String path, List<Date> values) throws ScimException {
        return PatchOperation.addDateValues(Path.fromString(path), values);
    }

    public static PatchOperation addDateValues(Path path, List<Date> values) throws ScimException {
        ArrayNode arrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (Date value : values) {
            arrayNode.add(GenericScimResource.getDateJsonNode(value).textValue());
        }
        return PatchOperation.add(path, (JsonNode)arrayNode);
    }

    public static PatchOperation replace(String path, Date value) throws ScimException {
        String valueString = GenericScimResource.getDateJsonNode(value).textValue();
        return PatchOperation.replace(path, valueString);
    }

    public static PatchOperation replace(Path path, Date value) throws ScimException {
        String valueString = GenericScimResource.getDateJsonNode(value).textValue();
        return PatchOperation.replace(path, valueString);
    }

    public static PatchOperation addBinaryValues(String path, List<byte[]> values) throws ScimException {
        return PatchOperation.addBinaryValues(Path.fromString(path), values);
    }

    public static PatchOperation addBinaryValues(Path path, List<byte[]> values) {
        ArrayNode arrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (byte[] value : values) {
            arrayNode.add(Base64Variants.getDefaultVariant().encode(value));
        }
        return PatchOperation.add(path, (JsonNode)arrayNode);
    }

    public static PatchOperation replace(String path, byte[] value) throws ScimException {
        String valueString = Base64Variants.getDefaultVariant().encode(value);
        return PatchOperation.replace(path, valueString);
    }

    public static PatchOperation replace(Path path, byte[] value) {
        String valueString = Base64Variants.getDefaultVariant().encode(value);
        return PatchOperation.replace(path, valueString);
    }

    public static PatchOperation addURIValues(String path, List<URI> values) throws ScimException {
        return PatchOperation.addURIValues(Path.fromString(path), values);
    }

    public static PatchOperation addURIValues(Path path, List<URI> values) {
        ArrayNode arrayNode = JsonUtils.getJsonNodeFactory().arrayNode();
        for (URI value : values) {
            arrayNode.add(value.toString());
        }
        return PatchOperation.add(path, (JsonNode)arrayNode);
    }

    public static PatchOperation replace(String path, URI value) throws ScimException {
        return PatchOperation.replace(path, value.toString());
    }

    public static PatchOperation replace(Path path, URI value) {
        return PatchOperation.replace(path, value.toString());
    }

    public static PatchOperation replace(ObjectNode value) {
        return PatchOperation.replace((Path)null, (JsonNode)value);
    }

    public static PatchOperation replace(String path, JsonNode value) throws ScimException {
        return PatchOperation.replace(Path.fromString(path), value);
    }

    public static PatchOperation replace(Path path, JsonNode value) {
        try {
            return new ReplaceOperation(path, value);
        }
        catch (ScimException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PatchOperation remove(String path) throws ScimException {
        return PatchOperation.remove(Path.fromString(path));
    }

    public static PatchOperation remove(Path path) {
        try {
            return new RemoveOperation(path);
        }
        catch (ScimException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PatchOperation create(PatchOpType opType, String path, JsonNode value) throws ScimException {
        return PatchOperation.create(opType, Path.fromString(path), value);
    }

    public static PatchOperation create(PatchOpType opType, Path path, JsonNode value) {
        switch (opType) {
            case ADD: {
                return PatchOperation.add(path, value);
            }
            case REPLACE: {
                return PatchOperation.replace(path, value);
            }
            case REMOVE: {
                return PatchOperation.remove(path);
            }
        }
        throw new IllegalArgumentException("Unknown patch op type " + (Object)((Object)opType));
    }

    static final class ReplaceOperation
    extends PatchOperation {
        @JsonProperty
        private final JsonNode value;

        @JsonCreator
        private ReplaceOperation(@JsonProperty(value="path") Path path, @JsonProperty(value="value", required=true) JsonNode value) throws ScimException {
            super(path);
            if (value == null || value.isNull() || (value.isArray() || value.isObject()) && value.size() == 0) {
                throw BadRequestException.invalidSyntax("value field must not be null or an empty container");
            }
            if (path == null && !value.isObject()) {
                throw BadRequestException.invalidSyntax("value field must be a JSON object containing the attributes to replace");
            }
            this.value = value;
        }

        @Override
        public PatchOpType getOpType() {
            return PatchOpType.REPLACE;
        }

        @Override
        public JsonNode getJsonNode() {
            return this.value.deepCopy();
        }

        @Override
        public <T> T getValue(Class<T> cls) throws JsonProcessingException, ScimException, IllegalArgumentException {
            if (this.value.isArray()) {
                throw new IllegalArgumentException("Patch operation contains multiple values");
            }
            return (T)JsonUtils.getObjectReader().treeToValue((TreeNode)this.value, cls);
        }

        @Override
        public <T> List<T> getValues(Class<T> cls) throws JsonProcessingException, ScimException {
            ArrayList<Object> objects = new ArrayList<Object>(this.value.size());
            for (JsonNode node : this.value) {
                objects.add(JsonUtils.getObjectReader().treeToValue((TreeNode)node, cls));
            }
            return objects;
        }

        @Override
        public void apply(ObjectNode node) throws ScimException {
            JsonUtils.replaceValue(this.getPath() == null ? Path.root() : this.getPath(), node, this.value);
            this.addMissingSchemaUrns(node);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplaceOperation that = (ReplaceOperation)o;
            if (this.getPath() != null ? !this.getPath().equals(that.getPath()) : that.getPath() != null) {
                return false;
            }
            return this.value.equals((Object)that.value);
        }

        public int hashCode() {
            int result = this.getPath() != null ? this.getPath().hashCode() : 0;
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    static final class RemoveOperation
    extends PatchOperation {
        @JsonCreator
        private RemoveOperation(@JsonProperty(value="path", required=true) Path path) throws ScimException {
            super(path);
            if (path == null) {
                throw BadRequestException.noTarget("path field must not be null for remove operations");
            }
        }

        @Override
        public PatchOpType getOpType() {
            return PatchOpType.REMOVE;
        }

        @Override
        public void apply(ObjectNode node) throws ScimException {
            JsonUtils.removeValues(this.getPath(), node);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveOperation that = (RemoveOperation)o;
            return !(this.getPath() != null ? !this.getPath().equals(that.getPath()) : that.getPath() != null);
        }

        public int hashCode() {
            return this.getPath() != null ? this.getPath().hashCode() : 0;
        }
    }

    static final class AddOperation
    extends PatchOperation {
        @JsonProperty
        private final JsonNode value;

        @JsonCreator
        private AddOperation(@JsonProperty(value="path") Path path, @JsonProperty(value="value", required=true) JsonNode value) throws ScimException {
            super(path);
            if (value == null || value.isNull() || (value.isArray() || value.isObject()) && value.size() == 0) {
                throw BadRequestException.invalidSyntax("value field must not be null or an empty container");
            }
            if (path == null && !value.isObject()) {
                throw BadRequestException.invalidSyntax("value field must be a JSON object containing the attributes to add");
            }
            if (path != null) {
                for (Path.Element element : path) {
                    if (element.getValueFilter() == null) continue;
                    throw BadRequestException.invalidPath("path field for add operations must not include any value selection filters");
                }
            }
            this.value = value;
        }

        @Override
        public PatchOpType getOpType() {
            return PatchOpType.ADD;
        }

        @Override
        public JsonNode getJsonNode() {
            return this.value.deepCopy();
        }

        @Override
        public <T> T getValue(Class<T> cls) throws JsonProcessingException, ScimException, IllegalArgumentException {
            if (this.value.isArray()) {
                throw new IllegalArgumentException("Patch operation contains multiple values");
            }
            return (T)JsonUtils.getObjectReader().treeToValue((TreeNode)this.value, cls);
        }

        @Override
        public <T> List<T> getValues(Class<T> cls) throws JsonProcessingException, ScimException {
            ArrayList<Object> objects = new ArrayList<Object>(this.value.size());
            for (JsonNode node : this.value) {
                objects.add(JsonUtils.getObjectReader().treeToValue((TreeNode)node, cls));
            }
            return objects;
        }

        @Override
        public void apply(ObjectNode node) throws ScimException {
            JsonUtils.addValue(this.getPath() == null ? Path.root() : this.getPath(), node, this.value);
            this.addMissingSchemaUrns(node);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddOperation that = (AddOperation)o;
            if (this.getPath() != null ? !this.getPath().equals(that.getPath()) : that.getPath() != null) {
                return false;
            }
            return this.value.equals((Object)that.value);
        }

        public int hashCode() {
            int result = this.getPath() != null ? this.getPath().hashCode() : 0;
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }
}

