/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.unboundid.scim2.client.ScimInterface;
import com.unboundid.scim2.client.requests.CreateRequestBuilder;
import com.unboundid.scim2.client.requests.DeleteRequestBuilder;
import com.unboundid.scim2.client.requests.ModifyRequestBuilder;
import com.unboundid.scim2.client.requests.ReplaceRequestBuilder;
import com.unboundid.scim2.client.requests.RetrieveRequestBuilder;
import com.unboundid.scim2.client.requests.SearchRequestBuilder;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.types.ResourceTypeResource;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.types.ServiceProviderConfigResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import java.net.URI;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public class ScimService
implements ScimInterface {
    public static final URI ME_URI = URI.create("Me");
    public static final MediaType MEDIA_TYPE_SCIM_TYPE = MediaType.valueOf((String)"application/scim+json");
    private final WebTarget baseTarget;
    private volatile ServiceProviderConfigResource serviceProviderConfig;

    public ScimService(WebTarget baseTarget) {
        this.baseTarget = (WebTarget)baseTarget.register((Object)new JacksonJaxbJsonProvider(JsonUtils.createObjectMapper(), JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS));
    }

    @Override
    public ServiceProviderConfigResource getServiceProviderConfig() throws ScimException {
        if (this.serviceProviderConfig == null) {
            this.serviceProviderConfig = this.retrieve(this.baseTarget.path("ServiceProviderConfig").getUri(), ServiceProviderConfigResource.class);
        }
        return this.serviceProviderConfig;
    }

    @Override
    public ListResponse<ResourceTypeResource> getResourceTypes() throws ScimException {
        return this.searchRequest("ResourceTypes").invoke(ResourceTypeResource.class);
    }

    @Override
    public ResourceTypeResource getResourceType(String name) throws ScimException {
        return this.retrieve("ResourceTypes", name, ResourceTypeResource.class);
    }

    @Override
    public ListResponse<SchemaResource> getSchemas() throws ScimException {
        return this.searchRequest("Schemas").invoke(SchemaResource.class);
    }

    @Override
    public SchemaResource getSchema(String id) throws ScimException {
        return this.retrieve("Schemas", id, SchemaResource.class);
    }

    @Override
    public <T extends ScimResource> T create(String endpoint, T resource) throws ScimException {
        return this.createRequest(endpoint, resource).invoke();
    }

    @Override
    public <T extends ScimResource> T retrieve(String endpoint, String id, Class<T> cls) throws ScimException {
        return (T)((ScimResource)this.retrieveRequest(endpoint, id).invoke(cls));
    }

    public <T extends ScimResource> T retrieve(URI url, Class<T> cls) throws ScimException {
        return (T)((ScimResource)this.retrieveRequest(url).invoke(cls));
    }

    @Override
    public <T extends ScimResource> T retrieve(T resource) throws ScimException {
        RetrieveRequestBuilder.Generic<T> builder = this.retrieveRequest(resource);
        return builder.invoke();
    }

    @Override
    public <T extends ScimResource> T replace(T resource) throws ScimException {
        ReplaceRequestBuilder<T> builder = this.replaceRequest(resource);
        return builder.invoke();
    }

    @Override
    public void delete(String endpoint, String id) throws ScimException {
        this.deleteRequest(endpoint, id).invoke();
    }

    public void delete(URI url) throws ScimException {
        this.deleteRequest(url).invoke();
    }

    @Override
    public <T extends ScimResource> void delete(T resource) throws ScimException {
        DeleteRequestBuilder builder = this.deleteRequest(resource);
        builder.invoke();
    }

    public <T extends ScimResource> CreateRequestBuilder<T> createRequest(String endpoint, T resource) {
        return new CreateRequestBuilder<T>(this.baseTarget.path(endpoint), resource);
    }

    public RetrieveRequestBuilder.Typed retrieveRequest(String endpoint, String id) {
        return new RetrieveRequestBuilder.Typed(this.baseTarget.path(endpoint).path(id));
    }

    public RetrieveRequestBuilder.Typed retrieveRequest(URI url) {
        return new RetrieveRequestBuilder.Typed(this.resolveWebTarget(url));
    }

    public <T extends ScimResource> RetrieveRequestBuilder.Generic<T> retrieveRequest(T resource) {
        return new RetrieveRequestBuilder.Generic<T>(this.resolveWebTarget(this.checkAndGetLocation(resource)), resource);
    }

    public SearchRequestBuilder searchRequest(String endpoint) {
        return new SearchRequestBuilder(this.baseTarget.path(endpoint));
    }

    public <T extends ScimResource> ReplaceRequestBuilder<T> replaceRequest(URI uri, T resource) {
        return new ReplaceRequestBuilder<T>(this.resolveWebTarget(uri), resource);
    }

    public <T extends ScimResource> ReplaceRequestBuilder<T> replaceRequest(T resource) {
        return new ReplaceRequestBuilder<T>(this.resolveWebTarget(this.checkAndGetLocation(resource)), resource);
    }

    @Override
    public <T extends ScimResource> T modify(String endpoint, String id, PatchRequest patchRequest, Class<T> clazz) throws ScimException {
        ModifyRequestBuilder.Typed requestBuilder = new ModifyRequestBuilder.Typed(this.baseTarget.path(endpoint).path(id));
        for (PatchOperation op : patchRequest.getOperations()) {
            requestBuilder.addOperation(op);
        }
        return (T)((ScimResource)requestBuilder.invoke(clazz));
    }

    public ModifyRequestBuilder.Typed modifyRequest(String endpoint, String id) {
        return new ModifyRequestBuilder.Typed(this.baseTarget.path(endpoint).path(id));
    }

    public ModifyRequestBuilder.Typed modifyRequest(URI url) {
        return new ModifyRequestBuilder.Typed(this.resolveWebTarget(url));
    }

    @Override
    public <T extends ScimResource> T modify(T resource, PatchRequest patchRequest) throws ScimException {
        ModifyRequestBuilder.Generic<T> requestBuilder = new ModifyRequestBuilder.Generic<T>(this.resolveWebTarget(this.checkAndGetLocation(resource)), resource);
        for (PatchOperation op : patchRequest.getOperations()) {
            requestBuilder.addOperation(op);
        }
        return requestBuilder.invoke();
    }

    public <T extends ScimResource> ModifyRequestBuilder.Generic<T> modifyRequest(T resource) {
        return new ModifyRequestBuilder.Generic<T>(this.resolveWebTarget(this.checkAndGetLocation(resource)), resource);
    }

    public DeleteRequestBuilder deleteRequest(String endpoint, String id) throws ScimException {
        return new DeleteRequestBuilder(this.baseTarget.path(endpoint).path(id));
    }

    public DeleteRequestBuilder deleteRequest(URI url) throws ScimException {
        return new DeleteRequestBuilder(this.resolveWebTarget(url));
    }

    public <T extends ScimResource> DeleteRequestBuilder deleteRequest(T resource) throws ScimException {
        return this.deleteRequest(this.checkAndGetLocation(resource));
    }

    private WebTarget resolveWebTarget(URI url) {
        URI relativePath;
        if (url.isAbsolute()) {
            relativePath = this.baseTarget.getUri().relativize(url);
            if (relativePath.equals(url)) {
                throw new IllegalArgumentException("Given resource's location " + url + " is not under this service's base path " + this.baseTarget.getUri());
            }
        } else {
            relativePath = url;
        }
        return this.baseTarget.path(relativePath.getRawPath());
    }

    private URI checkAndGetLocation(ScimResource resource) throws IllegalArgumentException {
        Meta meta = resource.getMeta();
        if (meta == null || meta.getLocation() == null) {
            throw new IllegalArgumentException("Resource URI must be specified by meta.location");
        }
        return meta.getLocation();
    }

    @Override
    public <T extends ScimResource> ListResponse<T> search(String endpoint, String filter, Class<T> clazz) throws ScimException {
        return this.searchRequest(endpoint).filter(filter).invoke(clazz);
    }
}

