/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ScimException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public final class ReplaceRequestBuilder<T extends ScimResource>
extends ResourceReturningRequestBuilder<ReplaceRequestBuilder<T>> {
    private final T resource;
    private String version;

    public ReplaceRequestBuilder(WebTarget target, T resource) {
        super(target);
        this.resource = resource;
    }

    public ReplaceRequestBuilder<T> ifMatch() {
        this.version = ReplaceRequestBuilder.getResourceVersion(this.resource);
        return this;
    }

    @Override
    Invocation.Builder buildRequest() {
        Invocation.Builder request = super.buildRequest();
        if (this.version != null) {
            request.header("If-Match", (Object)this.version);
        }
        return request;
    }

    public T invoke() throws ScimException {
        return (T)((ScimResource)this.invoke(this.resource.getClass()));
    }

    public <C> C invoke(Class<C> cls) throws ScimException {
        try (Response response = this.buildRequest().put(Entity.entity(this.resource, (String)this.getContentType()));){
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                Object object = response.readEntity(cls);
                return (C)object;
            }
            throw ReplaceRequestBuilder.toScimException(response);
        }
    }
}

