/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.android.dingtalk.share.ddsharemodule.DDShareApiFactory;
import com.android.dingtalk.share.ddsharemodule.IDDAPIEventHandler;
import com.android.dingtalk.share.ddsharemodule.IDDShareApi;
import com.android.dingtalk.share.ddsharemodule.message.BaseReq;
import com.android.dingtalk.share.ddsharemodule.message.BaseResp;
import com.android.dingtalk.share.ddsharemodule.message.SendMessageToDD;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.DDShareContent;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;

public class UMDingSSoHandler
extends UMSSOHandler {
    private IDDShareApi iddShareApi;
    private PlatformConfig.APPIDPlatform config;
    private UMShareListener listener;
    protected String VERSION = "7.1.9";
    private String mFileProvider = "";
    private Context mAppContext;

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.mAppContext = context.getApplicationContext();
        this.config = (PlatformConfig.APPIDPlatform)p;
        if (TextUtils.isEmpty((CharSequence)this.config.fileProvider)) {
            SLog.E((String)UmengText.DING.Ding_FILE_PROVIDER_ERROR);
        } else {
            this.mFileProvider = this.config.fileProvider;
        }
        if (this.mWeakAct != null && this.config != null) {
            this.iddShareApi = DDShareApiFactory.createDDShareApi((Context)((Context)this.mWeakAct.get()), (String)this.config.appId, (boolean)true);
        }
    }

    public boolean isInstall() {
        return this.iddShareApi != null && this.iddShareApi.isDDAppInstalled();
    }

    public String getVersion() {
        return this.VERSION;
    }

    public void release() {
        this.iddShareApi = null;
    }

    public boolean isSupport() {
        try {
            return this.iddShareApi != null && this.iddShareApi.isDDSupportAPI();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean share(ShareContent content, final UMShareListener listener) {
        boolean useFileProvider = false;
        if (!this.mFileProvider.equals("") && this.checkAndroidNotBelowN()) {
            useFileProvider = true;
        }
        if (!this.isInstall() && !this.isSupport()) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.DINGTALK, new Throwable(UmengErrorCode.NotInstall.getMessage()));
                }
            });
            return false;
        }
        if (!this.isSupport()) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.DINGTALK, new Throwable(UmengErrorCode.ShareFailed + UmengText.SHARE.VERSION_NOT_SUPPORT));
                }
            });
            return false;
        }
        this.listener = listener;
        DDShareContent shareContent = new DDShareContent(content);
        SendMessageToDD.Req req = new SendMessageToDD.Req();
        req.mMediaMessage = shareContent.getMessage(this.mAppContext, useFileProvider, this.mFileProvider);
        boolean result = this.sendReq(req);
        if (!result) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.DINGTALK, new Throwable(UmengErrorCode.UnKnowCode.getMessage() + UmengText.SHARE.SHARE_CONTENT_FAIL));
                }
            });
        }
        return false;
    }

    public boolean sendReq(SendMessageToDD.Req req) {
        try {
            return this.iddShareApi != null && this.iddShareApi.sendReq((BaseReq)req);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkAndroidNotBelowN() {
        return Build.VERSION.SDK_INT >= 30;
    }

    public IDDShareApi getApi() {
        return this.iddShareApi;
    }

    public IDDAPIEventHandler getIDDAPIEventHandler() {
        return new IDDAPIEventHandler(){

            public void onReq(BaseReq baseReq) {
            }

            public void onResp(BaseResp baseResp) {
                int errCode = baseResp.mErrCode;
                switch (errCode) {
                    case 0: {
                        UMDingSSoHandler.this.listener.onResult(SHARE_MEDIA.DINGTALK);
                        break;
                    }
                    case -2: {
                        UMDingSSoHandler.this.listener.onCancel(SHARE_MEDIA.DINGTALK);
                        break;
                    }
                    default: {
                        UMDingSSoHandler.this.listener.onError(SHARE_MEDIA.DINGTALK, new Throwable(UmengErrorCode.ShareFailed.getMessage() + baseResp.mErrStr));
                    }
                }
            }
        };
    }
}

