/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.widgets;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.os.Build;
import android.view.WindowInsets;

class WindowInsetsCompat {
    private static final WindowInsetsCompatImpl IMPL;
    private final Object mInsets;

    WindowInsetsCompat(Object object) {
        this.mInsets = object;
    }

    public WindowInsetsCompat(WindowInsetsCompat windowInsetsCompat) {
        this.mInsets = windowInsetsCompat == null ? null : IMPL.getSourceWindowInsets(windowInsetsCompat.mInsets);
    }

    public int getSystemWindowInsetLeft() {
        return IMPL.getSystemWindowInsetLeft(this.mInsets);
    }

    public int getSystemWindowInsetTop() {
        return IMPL.getSystemWindowInsetTop(this.mInsets);
    }

    public int getSystemWindowInsetRight() {
        return IMPL.getSystemWindowInsetRight(this.mInsets);
    }

    public int getSystemWindowInsetBottom() {
        return IMPL.getSystemWindowInsetBottom(this.mInsets);
    }

    public boolean hasSystemWindowInsets() {
        return IMPL.hasSystemWindowInsets(this.mInsets);
    }

    public boolean hasInsets() {
        return IMPL.hasInsets(this.mInsets);
    }

    public boolean isConsumed() {
        return IMPL.isConsumed(this.mInsets);
    }

    public boolean isRound() {
        return IMPL.isRound(this.mInsets);
    }

    public WindowInsetsCompat consumeSystemWindowInsets() {
        return IMPL.consumeSystemWindowInsets(this.mInsets);
    }

    public WindowInsetsCompat replaceSystemWindowInsets(int n, int n2, int n3, int n4) {
        return IMPL.replaceSystemWindowInsets(this.mInsets, n, n2, n3, n4);
    }

    public WindowInsetsCompat replaceSystemWindowInsets(Rect rect) {
        return IMPL.replaceSystemWindowInsets(this.mInsets, rect);
    }

    public int getStableInsetTop() {
        return IMPL.getStableInsetTop(this.mInsets);
    }

    public int getStableInsetLeft() {
        return IMPL.getStableInsetLeft(this.mInsets);
    }

    public int getStableInsetRight() {
        return IMPL.getStableInsetRight(this.mInsets);
    }

    public int getStableInsetBottom() {
        return IMPL.getStableInsetBottom(this.mInsets);
    }

    public boolean hasStableInsets() {
        return IMPL.hasStableInsets(this.mInsets);
    }

    public WindowInsetsCompat consumeStableInsets() {
        return IMPL.consumeStableInsets(this.mInsets);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WindowInsetsCompat windowInsetsCompat = (WindowInsetsCompat)object;
        return this.mInsets == null ? windowInsetsCompat.mInsets == null : this.mInsets.equals(windowInsetsCompat.mInsets);
    }

    public int hashCode() {
        return this.mInsets == null ? 0 : this.mInsets.hashCode();
    }

    static WindowInsetsCompat wrap(Object object) {
        return object == null ? null : new WindowInsetsCompat(object);
    }

    static Object unwrap(WindowInsetsCompat windowInsetsCompat) {
        return windowInsetsCompat == null ? null : windowInsetsCompat.mInsets;
    }

    static {
        int n = Build.VERSION.SDK_INT;
        IMPL = n >= 21 ? new WindowInsetsCompatApi21Impl() : (n >= 20 ? new WindowInsetsCompatApi20Impl() : new WindowInsetsCompatBaseImpl());
    }

    @TargetApi(value=21)
    private static class WindowInsetsCompatApi21Impl
    extends WindowInsetsCompatApi20Impl {
        WindowInsetsCompatApi21Impl() {
        }

        @Override
        public WindowInsetsCompat consumeStableInsets(Object object) {
            return new WindowInsetsCompat(((WindowInsets)object).consumeStableInsets());
        }

        @Override
        public int getStableInsetBottom(Object object) {
            return ((WindowInsets)object).getStableInsetBottom();
        }

        @Override
        public int getStableInsetLeft(Object object) {
            return ((WindowInsets)object).getStableInsetLeft();
        }

        @Override
        public int getStableInsetRight(Object object) {
            return ((WindowInsets)object).getStableInsetRight();
        }

        @Override
        public int getStableInsetTop(Object object) {
            return ((WindowInsets)object).getStableInsetTop();
        }

        @Override
        public boolean hasStableInsets(Object object) {
            return ((WindowInsets)object).hasStableInsets();
        }

        @Override
        public boolean isConsumed(Object object) {
            return ((WindowInsets)object).isConsumed();
        }

        @Override
        public WindowInsetsCompat replaceSystemWindowInsets(Object object, Rect rect) {
            return new WindowInsetsCompat(((WindowInsets)object).replaceSystemWindowInsets(rect));
        }
    }

    @TargetApi(value=20)
    private static class WindowInsetsCompatApi20Impl
    extends WindowInsetsCompatBaseImpl {
        WindowInsetsCompatApi20Impl() {
        }

        @Override
        public WindowInsetsCompat consumeSystemWindowInsets(Object object) {
            return new WindowInsetsCompat(((WindowInsets)object).consumeSystemWindowInsets());
        }

        @Override
        public int getSystemWindowInsetBottom(Object object) {
            return ((WindowInsets)object).getSystemWindowInsetBottom();
        }

        @Override
        public int getSystemWindowInsetLeft(Object object) {
            return ((WindowInsets)object).getSystemWindowInsetLeft();
        }

        @Override
        public int getSystemWindowInsetRight(Object object) {
            return ((WindowInsets)object).getSystemWindowInsetRight();
        }

        @Override
        public int getSystemWindowInsetTop(Object object) {
            return ((WindowInsets)object).getSystemWindowInsetTop();
        }

        @Override
        public boolean hasInsets(Object object) {
            return ((WindowInsets)object).hasInsets();
        }

        @Override
        public boolean hasSystemWindowInsets(Object object) {
            return ((WindowInsets)object).hasSystemWindowInsets();
        }

        @Override
        public boolean isRound(Object object) {
            return ((WindowInsets)object).isRound();
        }

        @Override
        public WindowInsetsCompat replaceSystemWindowInsets(Object object, int n, int n2, int n3, int n4) {
            return new WindowInsetsCompat(((WindowInsets)object).replaceSystemWindowInsets(n, n2, n3, n4));
        }

        @Override
        public Object getSourceWindowInsets(Object object) {
            return new WindowInsets((WindowInsets)object);
        }
    }

    private static class WindowInsetsCompatBaseImpl
    implements WindowInsetsCompatImpl {
        WindowInsetsCompatBaseImpl() {
        }

        @Override
        public int getSystemWindowInsetLeft(Object object) {
            return 0;
        }

        @Override
        public int getSystemWindowInsetTop(Object object) {
            return 0;
        }

        @Override
        public int getSystemWindowInsetRight(Object object) {
            return 0;
        }

        @Override
        public int getSystemWindowInsetBottom(Object object) {
            return 0;
        }

        @Override
        public boolean hasSystemWindowInsets(Object object) {
            return false;
        }

        @Override
        public boolean hasInsets(Object object) {
            return false;
        }

        @Override
        public boolean isConsumed(Object object) {
            return false;
        }

        @Override
        public boolean isRound(Object object) {
            return false;
        }

        @Override
        public WindowInsetsCompat consumeSystemWindowInsets(Object object) {
            return null;
        }

        @Override
        public WindowInsetsCompat replaceSystemWindowInsets(Object object, int n, int n2, int n3, int n4) {
            return null;
        }

        @Override
        public WindowInsetsCompat replaceSystemWindowInsets(Object object, Rect rect) {
            return null;
        }

        @Override
        public int getStableInsetTop(Object object) {
            return 0;
        }

        @Override
        public int getStableInsetLeft(Object object) {
            return 0;
        }

        @Override
        public int getStableInsetRight(Object object) {
            return 0;
        }

        @Override
        public int getStableInsetBottom(Object object) {
            return 0;
        }

        @Override
        public boolean hasStableInsets(Object object) {
            return false;
        }

        @Override
        public WindowInsetsCompat consumeStableInsets(Object object) {
            return null;
        }

        @Override
        public Object getSourceWindowInsets(Object object) {
            return null;
        }
    }

    private static interface WindowInsetsCompatImpl {
        public int getSystemWindowInsetLeft(Object var1);

        public int getSystemWindowInsetTop(Object var1);

        public int getSystemWindowInsetRight(Object var1);

        public int getSystemWindowInsetBottom(Object var1);

        public boolean hasSystemWindowInsets(Object var1);

        public boolean hasInsets(Object var1);

        public boolean isConsumed(Object var1);

        public boolean isRound(Object var1);

        public WindowInsetsCompat consumeSystemWindowInsets(Object var1);

        public WindowInsetsCompat replaceSystemWindowInsets(Object var1, int var2, int var3, int var4, int var5);

        public WindowInsetsCompat replaceSystemWindowInsets(Object var1, Rect var2);

        public int getStableInsetTop(Object var1);

        public int getStableInsetLeft(Object var1);

        public int getStableInsetRight(Object var1);

        public int getStableInsetBottom(Object var1);

        public boolean hasStableInsets(Object var1);

        public WindowInsetsCompat consumeStableInsets(Object var1);

        public Object getSourceWindowInsets(Object var1);
    }
}

