/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.widgets;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.umeng.socialize.shareboard.widgets.KeyEventCompat;
import com.umeng.socialize.shareboard.widgets.MotionEventCompat;
import com.umeng.socialize.shareboard.widgets.SocializePagerAdapter;
import com.umeng.socialize.shareboard.widgets.VelocityTrackerCompat;
import com.umeng.socialize.shareboard.widgets.ViewCompat;
import com.umeng.socialize.shareboard.widgets.WindowInsetsCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SocializeViewPager
extends ViewGroup {
    private static final String TAG = "ViewPager";
    private float mLastMotionX;
    private float mLastMotionY;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mCloseEnough;
    private static final int CLOSE_ENOUGH = 2;
    private int mTouchSlop;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private int mFlingDistance;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int DEFAULT_WIDTH_FACTOR = 1;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private int mOffscreenPageLimit = 1;
    private List<ItemInfo> mItems = new ArrayList<ItemInfo>();
    private final ItemInfo mTempItem = new ItemInfo();
    private int mCurPosition;
    private SocializePagerAdapter mAdapter;
    private PagerObserver mObserver;
    private int mExpectedAdapterCount;
    private boolean mPopulatePending;
    private boolean mFirstLayout;
    private int mRestoredCurItem = -1;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private int mDefaultGutterSize;
    private int mGutterSize;
    private float mFirstOffset;
    private float mLastOffset;
    private boolean mInLayout;
    private List<OnPageChangeListener> mOnPageChangeListeners;
    private boolean mCalledSuper;
    private boolean mIsScrollStarted;
    private Scroller mScroller;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private final Rect mTempRect = new Rect();
    private final Runnable mEndScrollRunnable = new Runnable(){

        @Override
        public void run() {
            SocializeViewPager.this.setScrollState(0);
            SocializeViewPager.this.populate();
        }
    };
    private int mScrollState = 0;
    private static final Comparator<ItemInfo> COMPARATOR = new Comparator<ItemInfo>(){

        @Override
        public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
            return itemInfo.position - itemInfo2.position;
        }
    };
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float f2) {
            return (f2 -= 1.0f) * f2 * f2 * f2 * f2 + 1.0f;
        }
    };
    static final int[] LAYOUT_ATTRS = new int[]{16842931};

    public SocializeViewPager(Context context) {
        super(context);
        this.init();
    }

    public SocializeViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public SocializeViewPager(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    @TargetApi(value=21)
    public SocializeViewPager(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        float f2 = context.getResources().getDisplayMetrics().density;
        this.mTouchSlop = viewConfiguration.getScaledPagingTouchSlop();
        this.mMinimumVelocity = (int)(400.0f * f2);
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mCloseEnough = (int)(2.0f * f2);
        this.mFlingDistance = (int)(25.0f * f2);
        this.mDefaultGutterSize = (int)(16.0f * f2);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, new ViewCompat.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
                WindowInsetsCompat windowInsetsCompat2 = ViewCompat.onApplyWindowInsets(view, windowInsetsCompat);
                if (windowInsetsCompat2.isConsumed()) {
                    return windowInsetsCompat2;
                }
                Rect rect = SocializeViewPager.this.mTempRect;
                rect.left = windowInsetsCompat2.getSystemWindowInsetLeft();
                rect.top = windowInsetsCompat2.getSystemWindowInsetTop();
                rect.right = windowInsetsCompat2.getSystemWindowInsetRight();
                rect.bottom = windowInsetsCompat2.getSystemWindowInsetBottom();
                int n = SocializeViewPager.this.getChildCount();
                for (int i2 = 0; i2 < n; ++i2) {
                    WindowInsetsCompat windowInsetsCompat3 = ViewCompat.dispatchApplyWindowInsets(SocializeViewPager.this.getChildAt(i2), windowInsetsCompat2);
                    rect.left = Math.min(windowInsetsCompat3.getSystemWindowInsetLeft(), rect.left);
                    rect.top = Math.min(windowInsetsCompat3.getSystemWindowInsetTop(), rect.top);
                    rect.right = Math.min(windowInsetsCompat3.getSystemWindowInsetRight(), rect.right);
                    rect.bottom = Math.min(windowInsetsCompat3.getSystemWindowInsetBottom(), rect.bottom);
                }
                return windowInsetsCompat2.replaceSystemWindowInsets(rect.left, rect.top, rect.right, rect.bottom);
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction() & 0xFF;
        if (n == 3 || n == 1) {
            this.resetTouch();
            return false;
        }
        if (n != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (n) {
            case 2: {
                int n2 = this.mActivePointerId;
                if (n2 == -1) break;
                int n3 = motionEvent.findPointerIndex(n2);
                float f2 = motionEvent.getX(n3);
                float f3 = f2 - this.mLastMotionX;
                float f4 = Math.abs(f3);
                float f5 = motionEvent.getY(n3);
                float f6 = Math.abs(f5 - this.mInitialMotionY);
                if (f3 != 0.0f && !this.isGutterDrag(this.mLastMotionX, f3) && this.canScroll((View)this, false, (int)f3, (int)f2, (int)f5)) {
                    this.mLastMotionX = f2;
                    this.mLastMotionY = f5;
                    this.mIsUnableToDrag = true;
                    return false;
                }
                if (f4 > (float)this.mTouchSlop && f4 * 0.5f > f6) {
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    this.mLastMotionX = f3 > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                    this.mLastMotionY = f5;
                } else if (f6 > (float)this.mTouchSlop) {
                    this.mIsUnableToDrag = true;
                }
                if (!this.mIsBeingDragged || !this.performDrag(f2)) break;
                ViewCompat.postInvalidateOnAnimation((View)this);
                break;
            }
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = motionEvent.getX();
                this.mLastMotionY = this.mInitialMotionY = motionEvent.getY();
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.mIsUnableToDrag = false;
                this.mIsScrollStarted = true;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll(false);
                this.mIsBeingDragged = false;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n = motionEvent.getAction();
        boolean bl = false;
        switch (n & 0xFF) {
            case 0: {
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mLastMotionX = this.mInitialMotionX = motionEvent.getX();
                this.mLastMotionY = this.mInitialMotionY = motionEvent.getY();
                this.mActivePointerId = motionEvent.getPointerId(0);
                break;
            }
            case 2: {
                float f2;
                int n2;
                if (!this.mIsBeingDragged) {
                    n2 = motionEvent.findPointerIndex(this.mActivePointerId);
                    if (n2 == -1) {
                        bl = this.resetTouch();
                        break;
                    }
                    f2 = motionEvent.getX(n2);
                    float f3 = Math.abs(f2 - this.mLastMotionX);
                    float f4 = motionEvent.getY(n2);
                    float f5 = Math.abs(f4 - this.mLastMotionY);
                    if (f3 > (float)this.mTouchSlop && f3 > f5) {
                        this.mIsBeingDragged = true;
                        this.requestParentDisallowInterceptTouchEvent(true);
                        this.mLastMotionX = f2 - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                        this.mLastMotionY = f4;
                        this.setScrollState(1);
                        ViewParent viewParent = this.getParent();
                        if (viewParent != null) {
                            viewParent.requestDisallowInterceptTouchEvent(true);
                        }
                    }
                }
                if (!this.mIsBeingDragged) break;
                n2 = motionEvent.findPointerIndex(this.mActivePointerId);
                f2 = motionEvent.getX(n2);
                bl |= this.performDrag(f2);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n3 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
                this.mPopulatePending = true;
                int n4 = this.getClientWidth();
                int n5 = this.getScrollX();
                ItemInfo itemInfo = this.infoForCurrentScrollPosition();
                float f6 = 0.0f;
                int n6 = itemInfo.position;
                float f7 = ((float)n5 / (float)n4 - itemInfo.offset) / 1.0f;
                int n7 = motionEvent.findPointerIndex(this.mActivePointerId);
                float f8 = motionEvent.getX(n7);
                int n8 = (int)(f8 - this.mInitialMotionX);
                int n9 = this.determineTargetPage(n6, f7, n3, n8);
                this.setCurrentItemInternal(n9, true, true, n3);
                bl = this.resetTouch();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.scrollToItem(this.mCurPosition, true, 0, false);
                bl = this.resetTouch();
                break;
            }
            case 5: {
                float f9;
                int n10 = MotionEventCompat.getActionIndex(motionEvent);
                this.mLastMotionX = f9 = motionEvent.getX(n10);
                this.mActivePointerId = motionEvent.getPointerId(n10);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                this.mLastMotionX = motionEvent.getX(motionEvent.findPointerIndex(this.mActivePointerId));
            }
        }
        if (bl) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        return true;
    }

    private boolean resetTouch() {
        this.mActivePointerId = -1;
        this.endDrag();
        boolean bl = true;
        return bl;
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private boolean isGutterDrag(float f2, float f3) {
        return f2 < (float)this.mGutterSize && f3 > 0.0f || f2 > (float)(this.getWidth() - this.mGutterSize) && f3 < 0.0f;
    }

    protected boolean canScroll(View view, boolean bl, int n, int n2, int n3) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n4 = view.getScrollX();
            int n5 = view.getScrollY();
            int n6 = viewGroup.getChildCount();
            for (int i2 = n6 - 1; i2 >= 0; --i2) {
                View view2 = viewGroup.getChildAt(i2);
                if (n2 + n4 < view2.getLeft() || n2 + n4 >= view2.getRight() || n3 + n5 < view2.getTop() || n3 + n5 >= view2.getBottom() || !this.canScroll(view2, true, n, n2 + n4 - view2.getLeft(), n3 + n5 - view2.getTop())) continue;
                return true;
            }
        }
        return bl && ViewCompat.canScrollHorizontally(view, -n);
    }

    private void requestParentDisallowInterceptTouchEvent(boolean bl) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(bl);
        }
    }

    private boolean performDrag(float f2) {
        boolean bl = false;
        float f3 = this.mLastMotionX - f2;
        this.mLastMotionX = f2;
        float f4 = this.getScrollX();
        float f5 = f4 + f3;
        int n = this.getClientWidth();
        float f6 = (float)n * this.mFirstOffset;
        float f7 = (float)n * this.mLastOffset;
        boolean bl2 = true;
        boolean bl3 = true;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(this.mItems.size() - 1);
        if (itemInfo.position != 0) {
            bl2 = false;
            f6 = itemInfo.offset * (float)n;
        }
        if (itemInfo2.position != this.mAdapter.getCount() - 1) {
            bl3 = false;
            f7 = itemInfo2.offset * (float)n;
        }
        if (f5 < f6) {
            if (bl2) {
                bl = true;
            }
            f5 = f6;
        } else if (f5 > f7) {
            if (bl3) {
                bl = true;
            }
            f5 = f7;
        }
        this.mLastMotionX += f5 - (float)((int)f5);
        this.scrollTo((int)f5, this.getScrollY());
        this.pageScrolled((int)f5);
        return bl;
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n = MotionEventCompat.getActionIndex(motionEvent);
        int n2 = motionEvent.getPointerId(n);
        if (n2 == this.mActivePointerId) {
            int n3 = n == 0 ? 1 : 0;
            this.mLastMotionX = motionEvent.getX(n3);
            this.mActivePointerId = motionEvent.getPointerId(n3);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private int determineTargetPage(int n, float f2, int n2, int n3) {
        int n4;
        if (Math.abs(n3) > this.mFlingDistance && Math.abs(n2) > this.mMinimumVelocity) {
            n4 = n2 > 0 ? n : n + 1;
        } else {
            float f3 = n >= this.mCurPosition ? 0.4f : 0.6f;
            n4 = n + (int)(f2 + f3);
        }
        if (this.mItems.size() > 0) {
            ItemInfo itemInfo = this.mItems.get(0);
            ItemInfo itemInfo2 = this.mItems.get(this.mItems.size() - 1);
            n4 = Math.max(itemInfo.position, Math.min(n4, itemInfo2.position));
        }
        return n4;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(SocializeViewPager.getDefaultSize((int)0, (int)n), SocializeViewPager.getDefaultSize((int)0, (int)n2));
        int n3 = this.getMeasuredWidth();
        int n4 = n3 / 10;
        this.mGutterSize = Math.min(n4, this.mDefaultGutterSize);
        int n5 = n3 - this.getPaddingLeft() - this.getPaddingRight();
        int n6 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int n7 = View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000);
        int n8 = View.MeasureSpec.makeMeasureSpec((int)n6, (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int n9 = this.getChildCount();
        for (int i2 = 0; i2 < n9; ++i2) {
            LayoutParams layoutParams;
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8 || (layoutParams = (LayoutParams)view.getLayoutParams()) != null && layoutParams.isDecor) continue;
            int n10 = View.MeasureSpec.makeMeasureSpec((int)(n5 * 1), (int)0x40000000);
            view.measure(n10, n8);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n != n3) {
            this.recomputeScrollPosition(n, n3, 0, 0);
        }
    }

    private void recomputeScrollPosition(int n, int n2, int n3, int n4) {
        if (n2 > 0 && !this.mItems.isEmpty()) {
            if (!this.mScroller.isFinished()) {
                this.mScroller.setFinalX(this.getCurrentItem() * this.getClientWidth());
            } else {
                int n5 = n - this.getPaddingLeft() - this.getPaddingRight() + n3;
                int n6 = n2 - this.getPaddingLeft() - this.getPaddingRight() + n4;
                int n7 = this.getScrollX();
                float f2 = (float)n7 / (float)n6;
                int n8 = (int)(f2 * (float)n5);
                this.scrollTo(n8, this.getScrollY());
            }
        } else {
            ItemInfo itemInfo = this.infoForPosition(this.mCurPosition);
            float f3 = itemInfo != null ? Math.min(itemInfo.offset, this.mLastOffset) : 0.0f;
            int n9 = (int)(f3 * (float)(n - this.getPaddingLeft() - this.getPaddingRight()));
            if (n9 != this.getScrollX()) {
                this.completeScroll(false);
                this.scrollTo(n9, this.getScrollY());
            }
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        int n6 = n3 - n;
        int n7 = n4 - n2;
        int n8 = this.getPaddingLeft();
        int n9 = this.getPaddingTop();
        int n10 = this.getPaddingRight();
        int n11 = this.getPaddingBottom();
        int n12 = n6 - n8 - n10;
        for (int i2 = 0; i2 < n5; ++i2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.isDecor || (itemInfo = this.infoForChild(view)) == null) continue;
            int n13 = (int)((float)n12 * itemInfo.offset);
            int n14 = n8 + n13;
            int n15 = n9;
            if (layoutParams.needsMeasure) {
                layoutParams.needsMeasure = false;
                int n16 = View.MeasureSpec.makeMeasureSpec((int)((int)((float)n12 * layoutParams.widthFactor)), (int)0x40000000);
                int n17 = View.MeasureSpec.makeMeasureSpec((int)(n7 - n9 - n11), (int)0x40000000);
                view.measure(n16, n17);
            }
            view.layout(n14, n15, n14 + view.getMeasuredWidth(), n15 + view.getMeasuredHeight());
        }
        if (this.mFirstLayout) {
            this.scrollToItem(this.mCurPosition, false, 0, false);
        }
        this.mFirstLayout = false;
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams = this.generateLayoutParams(layoutParams);
        }
        LayoutParams layoutParams2 = (LayoutParams)layoutParams;
        layoutParams2.isDecor |= false;
        if (this.mInLayout) {
            if (layoutParams2 != null && layoutParams2.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            layoutParams2.needsMeasure = true;
            this.addViewInLayout(view, n, layoutParams);
        } else {
            super.addView(view, n, layoutParams);
        }
    }

    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    private void populate() {
        this.populate(this.mCurPosition);
    }

    private void populate(int n) {
        int n2;
        ItemInfo itemInfo;
        int n3;
        ItemInfo itemInfo2 = null;
        if (this.mCurPosition != n) {
            itemInfo2 = this.infoForPosition(this.mCurPosition);
            this.mCurPosition = n;
        }
        if (this.mAdapter == null) {
            return;
        }
        if (this.mPopulatePending) {
            return;
        }
        if (this.getWindowToken() == null) {
            return;
        }
        this.mAdapter.startUpdate(this);
        int n4 = this.mOffscreenPageLimit;
        int n5 = Math.max(0, this.mCurPosition - n4);
        int n6 = this.mAdapter.getCount();
        int n7 = Math.min(n6 - 1, this.mCurPosition + n4);
        if (n6 != this.mExpectedAdapterCount) {
            String string;
            try {
                string = this.getResources().getResourceName(this.getId());
            }
            catch (Resources.NotFoundException notFoundException) {
                string = Integer.toHexString(this.getId());
            }
            throw new IllegalStateException("The application's SocializePagerAdapter changed the adapter's contents without calling SocializePagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + n6 + " Pager id: " + string + " Pager class: " + ((Object)((Object)this)).getClass() + " Problematic adapter: " + this.mAdapter.getClass());
        }
        int n8 = -1;
        ItemInfo itemInfo3 = null;
        for (n8 = 0; n8 < this.mItems.size(); ++n8) {
            ItemInfo itemInfo4 = this.mItems.get(n8);
            if (itemInfo4.position < this.mCurPosition) continue;
            if (itemInfo4.position != this.mCurPosition) break;
            itemInfo3 = itemInfo4;
            break;
        }
        if (itemInfo3 == null && n6 > 0) {
            itemInfo3 = this.addNewItem(this.mCurPosition, n8);
        }
        if (itemInfo3 != null) {
            float f2 = 0.0f;
            n3 = n8 - 1;
            itemInfo = n3 >= 0 ? this.mItems.get(n3) : null;
            n2 = this.getClientWidth();
            float f3 = n2 <= 0 ? 0.0f : 1.0f + (float)this.getPaddingLeft() / (float)n2;
            Log.d((String)TAG, (String)("populate leftWidthNeeded:" + f3));
            for (int i2 = this.mCurPosition - 1; i2 >= 0; --i2) {
                if (f2 >= f3 && i2 < n5) {
                    if (itemInfo == null) break;
                    if (i2 != itemInfo.position || itemInfo.scrolling) continue;
                    this.mItems.remove(n3);
                    this.mAdapter.destroyItem(this, i2, itemInfo.object);
                    --n8;
                    itemInfo = --n3 >= 0 ? this.mItems.get(n3) : null;
                    continue;
                }
                if (itemInfo != null && i2 == itemInfo.position) {
                    f2 += 1.0f;
                    itemInfo = --n3 >= 0 ? this.mItems.get(n3) : null;
                    continue;
                }
                this.addNewItem(i2, n3 + 1);
                f2 += 1.0f;
                ++n8;
                itemInfo = n3 >= 0 ? this.mItems.get(n3) : null;
            }
            float f4 = 1.0f;
            n3 = n8 + 1;
            if (f4 < 2.0f) {
                itemInfo = n3 < this.mItems.size() ? this.mItems.get(n3) : null;
                float f5 = n2 <= 0 ? 0.0f : (float)this.getPaddingRight() / (float)n2 + 2.0f;
                for (int i3 = this.mCurPosition + 1; i3 < n6; ++i3) {
                    if (f4 >= f5 && i3 > n7) {
                        if (itemInfo == null) break;
                        if (i3 != itemInfo.position || itemInfo.scrolling) continue;
                        this.mItems.remove(n3);
                        this.mAdapter.destroyItem(this, i3, itemInfo.object);
                        itemInfo = n3 < this.mItems.size() ? this.mItems.get(n3) : null;
                        continue;
                    }
                    if (itemInfo != null && i3 == itemInfo.position) {
                        f4 += 1.0f;
                        itemInfo = ++n3 < this.mItems.size() ? this.mItems.get(n3) : null;
                        continue;
                    }
                    this.addNewItem(i3, n3);
                    f4 += 1.0f;
                    itemInfo = ++n3 < this.mItems.size() ? this.mItems.get(n3) : null;
                }
            }
            this.calculatePageOffsets(itemInfo3, n8, itemInfo2);
        }
        this.mAdapter.setPrimaryItem(this, this.mCurPosition, itemInfo3 != null ? itemInfo3.object : null);
        this.mAdapter.finishUpdate(this);
        int n9 = this.getChildCount();
        for (n3 = 0; n3 < n9; ++n3) {
            ItemInfo itemInfo5;
            itemInfo = this.getChildAt(n3);
            LayoutParams layoutParams = (LayoutParams)itemInfo.getLayoutParams();
            layoutParams.childIndex = n3;
            if (layoutParams.isDecor || layoutParams.widthFactor != 0.0f || (itemInfo5 = this.infoForChild((View)itemInfo)) == null) continue;
            layoutParams.widthFactor = 1.0f;
            layoutParams.position = itemInfo5.position;
        }
        if (this.hasFocus()) {
            View view = this.findFocus();
            ItemInfo itemInfo6 = itemInfo = view != null ? this.infoForAnyChild(view) : null;
            if (itemInfo == null || itemInfo.position != this.mCurPosition) {
                View view2;
                for (n2 = 0; !(n2 >= this.getChildCount() || (itemInfo = this.infoForChild(view2 = this.getChildAt(n2))) != null && itemInfo.position == this.mCurPosition && view2.requestFocus(2)); ++n2) {
                }
            }
        }
    }

    private void calculatePageOffsets(ItemInfo itemInfo, int n, ItemInfo itemInfo2) {
        int n2;
        int n3 = this.mAdapter.getCount();
        float f2 = 0.0f;
        if (itemInfo2 != null) {
            int n4;
            float f3;
            ItemInfo itemInfo3;
            int n5;
            n2 = itemInfo2.position;
            if (n2 < itemInfo.position) {
                n5 = 0;
                itemInfo3 = null;
                f3 = itemInfo2.offset + 1.0f + 0.0f;
                for (n4 = n2 + 1; n4 <= itemInfo.position && n5 < this.mItems.size(); ++n4) {
                    itemInfo3 = this.mItems.get(n5);
                    while (n4 > itemInfo3.position && n5 < this.mItems.size() - 1) {
                        itemInfo3 = this.mItems.get(++n5);
                    }
                    while (n4 < itemInfo3.position) {
                        f3 += this.mAdapter.getPageWidth(n4) + 0.0f;
                        ++n4;
                    }
                    itemInfo3.offset = f3;
                    f3 += 1.0f;
                }
            } else if (n2 > itemInfo.position) {
                n5 = this.mItems.size() - 1;
                itemInfo3 = null;
                f3 = itemInfo2.offset;
                for (n4 = n2 - 1; n4 >= itemInfo.position && n5 >= 0; --n4) {
                    itemInfo3 = this.mItems.get(n5);
                    while (n4 < itemInfo3.position && n5 > 0) {
                        itemInfo3 = this.mItems.get(--n5);
                    }
                    while (n4 > itemInfo3.position) {
                        f3 -= this.mAdapter.getPageWidth(n4) + 0.0f;
                        --n4;
                    }
                    itemInfo3.offset = f3 -= 1.0f;
                }
            }
        }
        n2 = this.mItems.size();
        float f4 = itemInfo.offset;
        int n6 = itemInfo.position - 1;
        this.mFirstOffset = itemInfo.position == 0 ? itemInfo.offset : -3.4028235E38f;
        this.mLastOffset = itemInfo.position == n3 - 1 ? itemInfo.offset + 1.0f - 1.0f : Float.MAX_VALUE;
        int n7 = n - 1;
        while (n7 >= 0) {
            ItemInfo itemInfo4 = this.mItems.get(n7);
            while (n6 > itemInfo4.position) {
                f4 -= this.mAdapter.getPageWidth(n6--) + 0.0f;
            }
            itemInfo4.offset = f4 -= 1.0f;
            if (itemInfo4.position == 0) {
                this.mFirstOffset = f4;
            }
            --n7;
            --n6;
        }
        f4 = itemInfo.offset + 1.0f + 0.0f;
        n6 = itemInfo.position + 1;
        n7 = n + 1;
        while (n7 < n2) {
            ItemInfo itemInfo5 = this.mItems.get(n7);
            while (n6 < itemInfo5.position) {
                f4 += this.mAdapter.getPageWidth(n6++) + 0.0f;
            }
            if (itemInfo5.position == n3 - 1) {
                this.mLastOffset = f4 + 1.0f - 1.0f;
            }
            itemInfo5.offset = f4;
            f4 += 1.0f;
            ++n7;
            ++n6;
        }
    }

    public void setAdapter(SocializePagerAdapter socializePagerAdapter) {
        int n;
        if (this.mAdapter != null) {
            this.mAdapter.setViewPagerObserver(null);
            this.mAdapter.startUpdate(this);
            for (n = 0; n < this.mItems.size(); ++n) {
                ItemInfo itemInfo = this.mItems.get(n);
                this.mAdapter.destroyItem(this, itemInfo.position, itemInfo.object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeAllViews();
            this.mCurPosition = 0;
            this.scrollTo(0, 0);
        }
        this.mAdapter = socializePagerAdapter;
        this.mExpectedAdapterCount = 0;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.setViewPagerObserver(this.mObserver);
            this.mPopulatePending = false;
            n = this.mFirstLayout ? 1 : 0;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else if (n == 0) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
    }

    void dataSetChanged() {
        int n;
        this.mExpectedAdapterCount = n = this.mAdapter.getCount();
        boolean bl = this.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < n;
        int n2 = this.mCurPosition;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            int n3 = this.mAdapter.getItemPosition(itemInfo.object);
            if (n3 == -1) continue;
            if (n3 == -2) {
                this.mItems.remove(i2);
                --i2;
                if (!bl2) {
                    this.mAdapter.startUpdate(this);
                    bl2 = true;
                }
                this.mAdapter.destroyItem(this, itemInfo.position, itemInfo.object);
                bl = true;
                if (this.mCurPosition != itemInfo.position) continue;
                n2 = Math.max(0, Math.min(this.mCurPosition, n - 1));
                bl = true;
                continue;
            }
            if (itemInfo.position == n3) continue;
            if (itemInfo.position == this.mCurPosition) {
                n2 = n3;
            }
            itemInfo.position = n3;
            bl = true;
        }
        if (bl2) {
            this.mAdapter.finishUpdate(this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (bl) {
            this.setCurrentItemInternal(n2, false, true);
            this.requestLayout();
        }
    }

    public void setCurrentItem(int n) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n, !this.mFirstLayout, false);
    }

    public void setCurrentItem(int n, boolean bl) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n, bl, false);
    }

    public int getCurrentItem() {
        return this.mCurPosition;
    }

    void setCurrentItemInternal(int n, boolean bl, boolean bl2) {
        this.setCurrentItemInternal(n, bl, bl2, 0);
    }

    void setCurrentItemInternal(int n, boolean bl, boolean bl2, int n2) {
        int n3;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            return;
        }
        if (!bl2 && this.mCurPosition == n && this.mItems.size() != 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= this.mAdapter.getCount()) {
            n = this.mAdapter.getCount() - 1;
        }
        int n4 = this.mOffscreenPageLimit;
        if (n > this.mCurPosition + n4 || n < this.mCurPosition - n4) {
            for (n3 = 0; n3 < this.mItems.size(); n3 += 1) {
                this.mItems.get((int)n3).scrolling = true;
            }
        }
        int n5 = n3 = this.mCurPosition != n ? 1 : 0;
        if (this.mFirstLayout) {
            this.mCurPosition = n;
            if (n3) {
                this.dispatchOnPageSelected(n);
            }
            this.requestLayout();
        } else {
            this.populate(n);
            this.scrollToItem(n, bl, n2, n3 != 0);
        }
    }

    private void scrollToItem(int n, boolean bl, int n2, boolean bl2) {
        ItemInfo itemInfo = this.infoForPosition(n);
        int n3 = 0;
        if (itemInfo != null) {
            int n4 = this.getClientWidth();
            n3 = (int)((float)n4 * Math.max(this.mFirstOffset, Math.min(itemInfo.offset, this.mLastOffset)));
        }
        if (bl) {
            this.smoothScrollTo(n3, 0, n2);
            if (bl2) {
                this.dispatchOnPageSelected(n);
            }
        } else {
            if (bl2) {
                this.dispatchOnPageSelected(n);
            }
            this.completeScroll(false);
            this.scrollTo(n3, 0);
            this.pageScrolled(n3);
        }
    }

    void smoothScrollTo(int n, int n2) {
        this.smoothScrollTo(n, n2, 0);
    }

    void smoothScrollTo(int n, int n2, int n3) {
        int n4;
        int n5;
        boolean bl;
        if (this.getChildCount() == 0) {
            return;
        }
        boolean bl2 = bl = this.mScroller != null && !this.mScroller.isFinished();
        if (bl) {
            n5 = this.mIsScrollStarted ? this.mScroller.getCurrX() : this.mScroller.getStartX();
            this.mScroller.abortAnimation();
        } else {
            n5 = this.getScrollX();
        }
        int n6 = this.getScrollY();
        int n7 = n - n5;
        int n8 = n2 - n6;
        if (n7 == 0 && n8 == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollState(2);
        int n9 = this.getClientWidth();
        int n10 = n9 / 2;
        float f2 = Math.min(1.0f, 1.0f * (float)Math.abs(n7) / (float)n9);
        float f3 = (float)n10 + (float)n10 * this.distanceInfluenceForSnapDuration(f2);
        n3 = Math.abs(n3);
        if (n3 > 0) {
            n4 = 4 * Math.round(1000.0f * Math.abs(f3 / (float)n3));
        } else {
            float f4 = (float)n9 * this.mAdapter.getPageWidth(this.mCurPosition);
            float f5 = (float)Math.abs(n7) / f4;
            n4 = (int)((f5 + 1.0f) * 100.0f);
        }
        n4 = Math.min(n4, 600);
        this.mIsScrollStarted = false;
        this.mScroller.startScroll(n5, n6, n7, n8, n4);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void computeScroll() {
        this.mIsScrollStarted = true;
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int n = this.getScrollX();
            int n2 = this.getScrollY();
            int n3 = this.mScroller.getCurrX();
            int n4 = this.mScroller.getCurrY();
            if (n != n3 || n2 != n4) {
                this.scrollTo(n3, n4);
                if (!this.pageScrolled(n3)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, n4);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    private void completeScroll(boolean bl) {
        int n;
        boolean bl2;
        boolean bl3 = bl2 = this.mScrollState == 2;
        if (bl2) {
            int n2 = n = !this.mScroller.isFinished() ? 1 : 0;
            if (n != 0) {
                this.mScroller.abortAnimation();
                int n3 = this.getScrollX();
                int n4 = this.getScrollY();
                int n5 = this.mScroller.getCurrX();
                int n6 = this.mScroller.getCurrY();
                if (n3 != n5 || n4 != n6) {
                    this.scrollTo(n5, n6);
                    if (n5 != n3) {
                        this.pageScrolled(n5);
                    }
                }
            }
        }
        this.mPopulatePending = false;
        for (n = 0; n < this.mItems.size(); ++n) {
            ItemInfo itemInfo = this.mItems.get(n);
            if (!itemInfo.scrolling) continue;
            bl2 = true;
            itemInfo.scrolling = false;
        }
        if (bl2) {
            if (bl) {
                ViewCompat.postOnAnimation((View)this, this.mEndScrollRunnable);
            } else {
                this.mEndScrollRunnable.run();
            }
        }
    }

    private boolean pageScrolled(int n) {
        int n2;
        if (this.mItems.size() == 0) {
            if (this.mFirstLayout) {
                return false;
            }
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
            return false;
        }
        ItemInfo itemInfo = this.infoForCurrentScrollPosition();
        int n3 = n2 = this.getClientWidth();
        int n4 = itemInfo.position;
        float f2 = ((float)n / (float)n2 - itemInfo.offset) / 1.0f;
        int n5 = (int)(f2 * (float)n3);
        this.mCalledSuper = false;
        this.onPageScrolled(n4, f2, n5);
        if (!this.mCalledSuper) {
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        return true;
    }

    protected void onPageScrolled(int n, float f2, int n2) {
        this.dispatchOnPageScrolled(n, f2, n2);
        this.mCalledSuper = true;
    }

    float distanceInfluenceForSnapDuration(float f2) {
        f2 -= 0.5f;
        f2 = (float)((double)f2 * 0.4712389167638204);
        return (float)Math.sin(f2);
    }

    void setScrollState(int n) {
        if (this.mScrollState == n) {
            return;
        }
        this.mScrollState = n;
        this.dispatchOnScrollStateChanged(n);
    }

    private void dispatchOnPageScrolled(int n, float f2, int n2) {
        if (this.mOnPageChangeListeners != null) {
            int n3 = this.mOnPageChangeListeners.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                OnPageChangeListener onPageChangeListener = this.mOnPageChangeListeners.get(i2);
                if (onPageChangeListener == null) continue;
                onPageChangeListener.onPageScrolled(n, f2, n2);
            }
        }
    }

    private void dispatchOnPageSelected(int n) {
        if (this.mOnPageChangeListeners != null) {
            int n2 = this.mOnPageChangeListeners.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                OnPageChangeListener onPageChangeListener = this.mOnPageChangeListeners.get(i2);
                if (onPageChangeListener == null) continue;
                onPageChangeListener.onPageSelected(n);
            }
        }
    }

    private void dispatchOnScrollStateChanged(int n) {
        if (this.mOnPageChangeListeners != null) {
            int n2 = this.mOnPageChangeListeners.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                OnPageChangeListener onPageChangeListener = this.mOnPageChangeListeners.get(i2);
                if (onPageChangeListener == null) continue;
                onPageChangeListener.onPageScrollStateChanged(n);
            }
        }
    }

    public void addOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList<OnPageChangeListener>();
        }
        this.mOnPageChangeListeners.add(onPageChangeListener);
    }

    public void removeOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.remove(onPageChangeListener);
        }
    }

    public void clearOnPageChangeListeners() {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.clear();
        }
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int n = this.getChildCount();
        for (int i2 = 0; i2 < n; ++i2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurPosition || !view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
    }

    public boolean executeKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getAction() == 0) {
            switch (keyEvent.getKeyCode()) {
                case 21: {
                    bl = this.arrowScroll(17);
                    break;
                }
                case 22: {
                    bl = this.arrowScroll(66);
                    break;
                }
                case 61: {
                    if (Build.VERSION.SDK_INT < 11) break;
                    if (KeyEventCompat.hasNoModifiers(keyEvent)) {
                        bl = this.arrowScroll(2);
                        break;
                    }
                    if (!KeyEventCompat.hasModifiers(keyEvent, 1)) break;
                    bl = this.arrowScroll(1);
                }
            }
        }
        return bl;
    }

    public boolean arrowScroll(int n) {
        Object object;
        boolean bl;
        View view = this.findFocus();
        if (view == this) {
            view = null;
        } else if (view != null) {
            bl = false;
            object = view.getParent();
            while (object instanceof ViewGroup) {
                if (object == this) {
                    bl = true;
                    break;
                }
                object = object.getParent();
            }
            if (!bl) {
                object = new StringBuilder();
                ((StringBuilder)object).append(view.getClass().getSimpleName());
                ViewParent viewParent = view.getParent();
                while (viewParent instanceof ViewGroup) {
                    ((StringBuilder)object).append(" => ").append(viewParent.getClass().getSimpleName());
                    viewParent = viewParent.getParent();
                }
                Log.e((String)TAG, (String)("arrowScroll tried to find focus based on non-child current focused view " + ((StringBuilder)object).toString()));
                view = null;
            }
        }
        bl = false;
        object = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view, n);
        if (object != null && object != view) {
            if (n == 17) {
                int n2 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)object).left;
                int n3 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)view).left;
                bl = view != null && n2 >= n3 ? this.pageLeft() : object.requestFocus();
            } else if (n == 66) {
                int n4 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)object).left;
                int n5 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)view).left;
                bl = view != null && n4 <= n5 ? this.pageRight() : object.requestFocus();
            }
        } else if (n == 17 || n == 1) {
            bl = this.pageLeft();
        } else if (n == 66 || n == 2) {
            bl = this.pageRight();
        }
        if (bl) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)n));
        }
        return bl;
    }

    private Rect getChildRectInPagerCoordinates(Rect rect, View view) {
        if (rect == null) {
            rect = new Rect();
        }
        if (view == null) {
            rect.set(0, 0, 0, 0);
            return rect;
        }
        rect.left = view.getLeft();
        rect.right = view.getRight();
        rect.top = view.getTop();
        rect.bottom = view.getBottom();
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof ViewGroup && viewParent != this) {
            ViewGroup viewGroup = (ViewGroup)viewParent;
            rect.left += viewGroup.getLeft();
            rect.right += viewGroup.getRight();
            rect.top += viewGroup.getTop();
            rect.bottom += viewGroup.getBottom();
            viewParent = viewGroup.getParent();
        }
        return rect;
    }

    boolean pageLeft() {
        if (this.mCurPosition > 0) {
            this.setCurrentItem(this.mCurPosition - 1, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        if (this.mAdapter != null && this.mCurPosition < this.mAdapter.getCount() - 1) {
            this.setCurrentItem(this.mCurPosition + 1, true);
            return true;
        }
        return false;
    }

    ItemInfo addNewItem(int n, int n2) {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.position = n;
        itemInfo.object = this.mAdapter.instantiateItem(this, n);
        if (n2 < 0 || n2 >= this.mItems.size()) {
            this.mItems.add(itemInfo);
        } else {
            this.mItems.add(n2, itemInfo);
        }
        return itemInfo;
    }

    ItemInfo infoForChild(View view) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            if (!this.mAdapter.isViewFromObject(view, itemInfo.object)) continue;
            return itemInfo;
        }
        return null;
    }

    ItemInfo infoForAnyChild(View view) {
        ViewParent viewParent;
        while ((viewParent = view.getParent()) != this) {
            if (viewParent == null || !(viewParent instanceof View)) {
                return null;
            }
            view = (View)viewParent;
        }
        return this.infoForChild(view);
    }

    ItemInfo infoForPosition(int n) {
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            ItemInfo itemInfo = this.mItems.get(i2);
            if (itemInfo.position != n) continue;
            return itemInfo;
        }
        return null;
    }

    private ItemInfo infoForCurrentScrollPosition() {
        int n = this.getClientWidth();
        float f2 = n > 0 ? (float)this.getScrollX() / (float)n : 0.0f;
        float f3 = 0.0f;
        int n2 = -1;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = true;
        ItemInfo itemInfo = null;
        for (int i2 = 0; i2 < this.mItems.size(); ++i2) {
            float f6;
            ItemInfo itemInfo2 = this.mItems.get(i2);
            if (!bl && itemInfo2.position != n2 + 1) {
                itemInfo2 = this.mTempItem;
                itemInfo2.offset = f4 + f5 + 0.0f;
                itemInfo2.position = n2 + 1;
                --i2;
            }
            float f7 = f6 = itemInfo2.offset;
            float f8 = f6 + 1.0f + 0.0f;
            if (bl || f2 >= f7) {
                if (f2 < f8 || i2 == this.mItems.size() - 1) {
                    return itemInfo2;
                }
            } else {
                return itemInfo;
            }
            bl = false;
            n2 = itemInfo2.position;
            f4 = f6;
            itemInfo = itemInfo2;
        }
        return itemInfo;
    }

    public void addFocusables(ArrayList<View> arrayList, int n, int n2) {
        int n3 = arrayList.size();
        int n4 = this.getDescendantFocusability();
        if (n4 != 393216) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                ItemInfo itemInfo;
                View view = this.getChildAt(i2);
                if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurPosition) continue;
                view.addFocusables(arrayList, n, n2);
            }
        }
        if (n4 != 262144 || n3 == arrayList.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((n2 & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (arrayList != null) {
                arrayList.add((View)this);
            }
        }
    }

    public void addTouchables(ArrayList<View> arrayList) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurPosition) continue;
            view.addTouchables(arrayList);
        }
    }

    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        int n2;
        int n3;
        int n4;
        int n5 = this.getChildCount();
        if ((n & 2) != 0) {
            n4 = 0;
            n3 = 1;
            n2 = n5;
        } else {
            n4 = n5 - 1;
            n3 = -1;
            n2 = -1;
        }
        for (int i2 = n4; i2 != n2; i2 += n3) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i2);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurPosition || !view.requestFocus(n, rect)) continue;
            return true;
        }
        return false;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public boolean isDecor;
        public int gravity;
        float widthFactor = 0.0f;
        boolean needsMeasure;
        int position;
        int childIndex;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.gravity = typedArray.getInteger(0, 48);
            typedArray.recycle();
        }
    }

    private class PagerObserver
    extends DataSetObserver {
        PagerObserver() {
        }

        public void onChanged() {
            SocializeViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            SocializeViewPager.this.dataSetChanged();
        }
    }

    static class ItemInfo {
        Object object;
        int position;
        boolean scrolling;
        float offset;

        ItemInfo() {
        }
    }

    public static interface OnPageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }
}

