/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.shareboard.ShareBoardConfig;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.shareboard.SocializeImageView;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;
import java.util.ArrayList;
import java.util.List;

class ShareBoardMenuHelper {
    private static String TAG = ShareBoardMenuHelper.class.getSimpleName();
    private ShareBoardConfig mShareBoardConfig;

    public ShareBoardMenuHelper(ShareBoardConfig shareBoardConfig) {
        this.mShareBoardConfig = shareBoardConfig;
    }

    public List<SnsPlatform[][]> formatPageData(List<SnsPlatform> list) {
        int n;
        int n2 = this.mShareBoardConfig.mMenuColumnNum * 2;
        int n3 = list.size();
        ArrayList<SnsPlatform[][]> arrayList = new ArrayList<SnsPlatform[][]>();
        if (n3 < this.mShareBoardConfig.mMenuColumnNum) {
            SnsPlatform[][] snsPlatformArray = new SnsPlatform[1][n3];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                snsPlatformArray[0][i2] = list.get(i2);
            }
            arrayList.add(snsPlatformArray);
            return arrayList;
        }
        int n4 = n3 / n2;
        int n5 = -1;
        int n6 = n3 % n2;
        if (n6 != 0) {
            n5 = n6 / this.mShareBoardConfig.mMenuColumnNum + (n6 % this.mShareBoardConfig.mMenuColumnNum != 0 ? 1 : 0);
            ++n4;
        }
        for (n = 0; n < n4; ++n) {
            int n7 = n == n4 - 1 && n5 != -1 ? n5 : 2;
            SnsPlatform[][] snsPlatformArray = new SnsPlatform[n7][this.mShareBoardConfig.mMenuColumnNum];
            arrayList.add(snsPlatformArray);
        }
        n = 0;
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            for (SnsPlatform[] snsPlatformArray : (SnsPlatform[][])arrayList.get(i3)) {
                for (int i4 = 0; i4 < snsPlatformArray.length; ++i4) {
                    if (n < n3) {
                        snsPlatformArray[i4] = list.get(n);
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public View createPageLayout(Context context, SnsPlatform[][] snsPlatformArray) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setGravity(48);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        for (int i2 = 0; i2 < snsPlatformArray.length; ++i2) {
            SnsPlatform[] snsPlatformArray2 = snsPlatformArray[i2];
            View view = this.createRowLayout(context, snsPlatformArray2, i2 != 0);
            linearLayout.addView(view);
        }
        return linearLayout;
    }

    private View createRowLayout(Context context, SnsPlatform[] snsPlatformArray, boolean bl) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(0);
        linearLayout.setGravity(1);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        if (bl) {
            layoutParams.topMargin = this.dip2px(context, 20.0f);
        }
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        for (int i2 = 0; i2 < snsPlatformArray.length; ++i2) {
            View view = this.createBtnView(context, snsPlatformArray[i2]);
            linearLayout.addView(view);
        }
        return linearLayout;
    }

    private View createBtnView(Context context, final SnsPlatform snsPlatform) {
        LinearLayout linearLayout = new LinearLayout(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2);
        layoutParams.weight = 1.0f;
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.setGravity(17);
        if (snsPlatform != null) {
            Object object;
            ResContainer resContainer = ResContainer.get(context);
            View view = LayoutInflater.from((Context)context).inflate(resContainer.layout("socialize_share_menu_item"), null);
            SocializeImageView socializeImageView = (SocializeImageView)view.findViewById(resContainer.id("socialize_image_view"));
            TextView textView = (TextView)view.findViewById(resContainer.id("socialize_text_view"));
            if (this.mShareBoardConfig.mMenuBgColor != 0 && this.mShareBoardConfig.mMenuBgShape != ShareBoardConfig.BG_SHAPE_NONE) {
                socializeImageView.setBackgroundColor(this.mShareBoardConfig.mMenuBgColor, this.mShareBoardConfig.mMenuBgPressedColor);
                socializeImageView.setBackgroundShape(this.mShareBoardConfig.mMenuBgShape, this.mShareBoardConfig.mMenuBgShapeAngle);
            } else {
                socializeImageView.setPadding(0, 0, 0, 0);
            }
            if (this.mShareBoardConfig.mMenuIconPressedColor != 0) {
                socializeImageView.setPressedColor(this.mShareBoardConfig.mMenuIconPressedColor);
            }
            String string = "";
            try {
                string = snsPlatform.mShowWord;
            }
            catch (Exception exception) {
                SHARE_MEDIA sHARE_MEDIA = snsPlatform.mPlatform;
                object = sHARE_MEDIA == null ? "" : sHARE_MEDIA.toString();
                SLog.error(UmengText.SHAREBOARD.NULLNAME + (String)object, exception);
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                textView.setText((CharSequence)snsPlatform.mShowWord);
            }
            textView.setGravity(17);
            int n = 0;
            try {
                n = ResContainer.getResourceId(context, "drawable", snsPlatform.mIcon);
            }
            catch (Exception exception) {
                object = snsPlatform.mPlatform;
                String string2 = object == null ? "" : ((SHARE_MEDIA)((Object)object)).toString();
                SLog.error(UmengText.SHAREBOARD.NULLNAME + string2, exception);
            }
            if (n != 0) {
                socializeImageView.setImageResource(n);
            }
            if (this.mShareBoardConfig.mMenuTextColor != 0) {
                textView.setTextColor(this.mShareBoardConfig.mMenuTextColor);
            }
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SHARE_MEDIA sHARE_MEDIA = snsPlatform.mPlatform;
                    if (ShareBoardMenuHelper.this.mShareBoardConfig != null && ShareBoardMenuHelper.this.mShareBoardConfig.getShareBoardlistener() != null) {
                        ShareBoardMenuHelper.this.mShareBoardConfig.getShareBoardlistener().onclick(snsPlatform, sHARE_MEDIA);
                    }
                }
            });
            linearLayout.addView(view);
        }
        return linearLayout;
    }

    private int dip2px(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 * f3 + 0.5f);
    }
}

