/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.shareboard.ShareBoardConfig;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.shareboard.UMActionFrame;
import com.umeng.socialize.utils.ShareBoardlistener;
import com.umeng.socialize.utils.SocializeSpUtils;
import java.util.List;

public class ShareBoard
extends PopupWindow {
    private ShareBoardConfig mShareBoardConfig;

    public ShareBoard(Context context, List<SnsPlatform> list) {
        this(context, list, null);
    }

    public ShareBoard(Context context, List<SnsPlatform> list, ShareBoardConfig shareBoardConfig) {
        super(context);
        this.setWindowLayoutMode(-1, -1);
        boolean bl = false;
        if (context.getResources().getConfiguration().orientation == 2) {
            bl = true;
        }
        if (shareBoardConfig == null) {
            shareBoardConfig = new ShareBoardConfig();
        }
        this.mShareBoardConfig = shareBoardConfig;
        shareBoardConfig.setOrientation(bl);
        UMActionFrame uMActionFrame = new UMActionFrame(context);
        uMActionFrame.setSnsPlatformData(list, shareBoardConfig);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        uMActionFrame.setLayoutParams(layoutParams);
        uMActionFrame.setDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                ShareBoard.this.dismiss();
            }
        });
        this.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                PopupWindow.OnDismissListener onDismissListener;
                PopupWindow.OnDismissListener onDismissListener2 = onDismissListener = ShareBoard.this.mShareBoardConfig != null ? ShareBoard.this.mShareBoardConfig.getOnDismissListener() : null;
                if (onDismissListener != null) {
                    onDismissListener.onDismiss();
                }
            }
        });
        this.setContentView((View)uMActionFrame);
        this.setFocusable(true);
        this.saveShareboardConfig(context, shareBoardConfig);
    }

    private void saveShareboardConfig(Context context, ShareBoardConfig shareBoardConfig) {
        if (context == null || shareBoardConfig == null) {
            return;
        }
        String string = shareBoardConfig.mShareboardPosition == ShareBoardConfig.SHAREBOARD_POSITION_BOTTOM ? "0" : "1";
        String string2 = null;
        if (shareBoardConfig.mMenuBgShape == ShareBoardConfig.BG_SHAPE_NONE) {
            string2 = "0";
        } else if (shareBoardConfig.mMenuBgShape == ShareBoardConfig.BG_SHAPE_CIRCULAR) {
            string2 = "1";
        } else if (shareBoardConfig.mMenuBgShape == ShareBoardConfig.BG_SHAPE_ROUNDED_SQUARE) {
            string2 = shareBoardConfig.mMenuBgShapeAngle != 0 ? "2" : "3";
        }
        if (!TextUtils.isEmpty((CharSequence)string) || !TextUtils.isEmpty((CharSequence)string2)) {
            SocializeSpUtils.putShareBoardConfig(context, string2 + ";" + string);
        }
    }

    public void setShareBoardlistener(final ShareBoardlistener shareBoardlistener) {
        if (this.mShareBoardConfig == null) {
            return;
        }
        ShareBoardlistener shareBoardlistener2 = new ShareBoardlistener(){

            @Override
            public void onclick(SnsPlatform snsPlatform, SHARE_MEDIA sHARE_MEDIA) {
                ShareBoard.this.setOnDismissListener(null);
                ShareBoard.this.dismiss();
                if (shareBoardlistener != null) {
                    shareBoardlistener.onclick(snsPlatform, sHARE_MEDIA);
                }
            }
        };
        this.mShareBoardConfig.setShareBoardlistener(shareBoardlistener2);
    }
}

