/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.social.tool;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Log;

class UMWaterMark {
    private static final String TAG = UMWaterMark.class.getSimpleName();
    private float mScale = 0.3f;
    private int mRightMargin;
    private int mLeftMargin;
    private int mTopMargin;
    private int mBottomMargin;
    private Rect mAnchorMarkRect = new Rect();
    private int mVerticalRelativePosition = -1;
    private int mHorizontalRelativePosition = -1;
    static final int RELATIVE_POSITION_VERTICAL_BOTTOM = 1;
    static final int RELATIVE_POSITION_VERTICAL_TOP = 2;
    static final int RELATIVE_POSITION_HORIZONTAL_RIGHT = 3;
    static final int RELATIVE_POSITION_HORIZONTAL_LEFT = 4;
    private int mGravity = 51;
    private boolean mIsTransparent = false;
    private boolean mIsBringToFront = false;
    private float mAlpha = -1.0f;
    private int mDegree = -1;
    private Context mContext;
    private Rect mMeasureRect = new Rect();

    UMWaterMark() {
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.mLeftMargin = n;
        this.mTopMargin = n2;
        this.mRightMargin = n3;
        this.mBottomMargin = n4;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setGravity(int n) {
        if (n <= 0) {
            return;
        }
        if (this.mGravity != n) {
            this.mGravity = n;
        }
    }

    public void setScale(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            return;
        }
        this.mScale = f2;
    }

    public void setRotate(int n) {
        if (n < 0 || n > 360) {
            return;
        }
        this.mDegree = n;
    }

    public void bringToFront() {
        this.mIsBringToFront = true;
    }

    public void setAlpha(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            return;
        }
        this.mAlpha = f2;
    }

    public void setTransparent() {
        this.mIsTransparent = true;
    }

    public Bitmap compound(Bitmap bitmap) {
        try {
            Canvas canvas;
            Bitmap bitmap2;
            if (bitmap == null) {
                Log.e((String)TAG, (String)"scr bitmap is null");
                return null;
            }
            Bitmap bitmap3 = this.getMarkBitmap();
            if (bitmap3 == null) {
                Log.e((String)TAG, (String)"mark bitmap is null");
                return bitmap;
            }
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            if (n <= 0 || n2 <= 0) {
                Log.e((String)TAG, (String)("mark bitmap is error, markWidth:" + n + ", markHeight:" + n2));
                return bitmap;
            }
            int n3 = this.getMarkWidth();
            int n4 = this.getMarkHeight();
            if (n3 <= 0 || n4 <= 0) {
                Log.e((String)TAG, (String)("mark bitmap is error, markWidth:" + n3 + ", markHeight:" + n4));
                return bitmap;
            }
            if (this.mIsTransparent) {
                bitmap2 = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                canvas = new Canvas(bitmap2);
                canvas.drawColor(0);
            } else {
                bitmap2 = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.RGB_565);
                canvas = new Canvas(bitmap2);
            }
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            Matrix matrix = new Matrix();
            int n5 = Math.min(bitmap.getWidth(), bitmap.getHeight());
            int n6 = Math.max(n3, n4);
            float f2 = this.mScale * (float)n5 / (float)n6;
            matrix.postScale(f2, f2, this.getScaleAnchorX(n3), this.getScaleAnchorY(n4));
            if (this.mDegree != -1) {
                matrix.postRotate((float)this.mDegree, (float)(n3 / 2), (float)(n4 / 2));
            }
            float f3 = this.isHorizontalRelativePosition() ? this.getRelativeDx(n) : this.getDx(n);
            float f4 = this.isVerticalRelativePosition() ? this.getRelativeDy(n2) : this.getDy(n2);
            matrix.postTranslate(f3, f4);
            if (this.mAlpha != -1.0f) {
                Paint paint = new Paint();
                paint.setAlpha((int)(255.0f * this.mAlpha));
                canvas.drawBitmap(bitmap3, matrix, paint);
            } else {
                canvas.drawBitmap(bitmap3, matrix, null);
            }
            this.safelyRecycleBitmap(bitmap);
            this.safelyRecycleBitmap(bitmap3);
            this.releaseResource();
            return bitmap2;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private float getScaleAnchorY(int n) {
        float f2;
        int n2 = this.mGravity & 0x70;
        switch (n2) {
            case 80: {
                f2 = n;
                break;
            }
            case 16: {
                f2 = n / 2;
                break;
            }
            default: {
                f2 = 0.0f;
            }
        }
        return f2;
    }

    private float getScaleAnchorX(int n) {
        float f2;
        int n2 = this.mGravity & 7;
        switch (n2) {
            case 1: {
                f2 = n / 2;
                break;
            }
            case 5: {
                f2 = n;
                break;
            }
            default: {
                f2 = 0.0f;
            }
        }
        return f2;
    }

    private void safelyRecycleBitmap(Bitmap bitmap) {
        try {
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Bitmap getMarkBitmap() {
        return null;
    }

    private float getRelativeDy(int n) {
        float f2;
        float f3 = this.mAnchorMarkRect.top;
        float f4 = this.mAnchorMarkRect.bottom;
        switch (this.mVerticalRelativePosition) {
            case 1: {
                int n2 = this.dip2px(this.mTopMargin);
                f2 = f4 + (float)n2;
                break;
            }
            case 2: {
                int n3 = -this.dip2px(this.mBottomMargin);
                f2 = f3 - (float)this.getMarkHeight() + (float)n3;
                break;
            }
            default: {
                f2 = this.getDy(n);
            }
        }
        return f2;
    }

    private float getRelativeDx(int n) {
        float f2;
        float f3 = this.mAnchorMarkRect.left;
        float f4 = this.mAnchorMarkRect.right;
        switch (this.mHorizontalRelativePosition) {
            case 4: {
                int n2 = -this.dip2px(this.mRightMargin);
                f2 = f3 - (float)this.getMarkWidth() + (float)n2;
                break;
            }
            case 3: {
                int n3 = this.dip2px(this.mLeftMargin);
                f2 = f4 + (float)n3;
                break;
            }
            default: {
                f2 = this.getDx(n);
            }
        }
        return f2;
    }

    private float getDy(int n) {
        float f2;
        int n2 = -this.dip2px(this.mBottomMargin);
        int n3 = this.dip2px(this.mTopMargin);
        int n4 = this.mGravity & 0x70;
        switch (n4) {
            case 80: {
                f2 = n - this.getMarkHeight() + n2;
                break;
            }
            case 16: {
                int n5 = n3 != 0 ? n3 : n2;
                f2 = (float)(n - this.getMarkHeight()) * 1.0f / 2.0f + (float)n5;
                break;
            }
            default: {
                f2 = n3;
            }
        }
        return f2;
    }

    private float getDx(int n) {
        float f2;
        int n2 = this.dip2px(this.mLeftMargin);
        int n3 = -this.dip2px(this.mRightMargin);
        int n4 = this.mGravity & 7;
        switch (n4) {
            case 1: {
                int n5 = n2 != 0 ? n2 : n3;
                f2 = (float)(n - this.getMarkWidth()) * 1.0f / 2.0f + (float)n5;
                break;
            }
            case 5: {
                f2 = n - this.getMarkWidth() + n3;
                break;
            }
            default: {
                f2 = n2;
            }
        }
        return f2;
    }

    private int getMarkWidth() {
        if (this.getMarkBitmap() == null) {
            return -1;
        }
        return this.getMarkBitmap().getWidth();
    }

    private int getMarkHeight() {
        if (this.getMarkBitmap() == null) {
            return -1;
        }
        return this.getMarkBitmap().getHeight();
    }

    void setAnchorMarkHorizontalRect(Rect rect) {
        int n = this.mAnchorMarkRect.top;
        int n2 = this.mAnchorMarkRect.bottom;
        this.mAnchorMarkRect.set(rect.left, n, rect.right, n2);
    }

    void setAnchorMarkVerticalRect(Rect rect) {
        this.mAnchorMarkRect = rect;
        int n = this.mAnchorMarkRect.left;
        int n2 = this.mAnchorMarkRect.right;
        this.mAnchorMarkRect.set(n, rect.top, n2, rect.bottom);
    }

    Rect onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (!this.isHorizontalRelativePosition()) {
            n3 = (int)this.getDx(n);
            n4 = n3 + this.getMarkWidth();
        }
        if (!this.isVerticalRelativePosition()) {
            n5 = (int)this.getDy(n2);
            n6 = n5 + this.getMarkHeight();
        }
        this.mMeasureRect.set(n3, n5, n4, n6);
        return this.mMeasureRect;
    }

    void setHorizontalRelativePosition(int n) {
        this.mHorizontalRelativePosition = n;
    }

    void setVerticalRelativePosition(int n) {
        this.mVerticalRelativePosition = n;
    }

    void clearRelativePosition() {
        this.mHorizontalRelativePosition = -1;
        this.mVerticalRelativePosition = -1;
    }

    boolean isVerticalRelativePosition() {
        return this.mVerticalRelativePosition != -1;
    }

    boolean isHorizontalRelativePosition() {
        return this.mHorizontalRelativePosition != -1;
    }

    boolean isBringToFront() {
        return this.mIsBringToFront;
    }

    int dip2px(float f2) {
        float f3 = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(f2 * f3 + 0.5f);
    }

    void releaseResource() {
    }
}

