/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.utils;

import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;

public class SocializeNetUtils {
    private static final String TAG = "SocializeNetUtils";

    public static boolean isConSpeCharacters(String string) {
        return string.replaceAll("[\u4e00-\u9fa5]*[a-z]*[A-Z]*\\d*-*_*\\s*", "").length() != 0;
    }

    public static boolean isSelfAppkey(String string) {
        return string.equals("5126ff896c738f2bfa000438") && !ContextUtil.getPackageName().equals("com.umeng.soexample");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getNetData(String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setInstanceFollowRedirects(true);
            httpURLConnection.setConnectTimeout(Config.connectionTimeOut);
            httpURLConnection.setReadTimeout(Config.readSocketTimeOut);
            if (httpURLConnection.getResponseCode() == 301) {
                string2 = httpURLConnection.getHeaderField("Location");
                if (string2.equals(string)) {
                    SLog.E(UmengText.NET.NET_AGAIN_ERROR);
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = SocializeNetUtils.getNetData(string2);
                return byArray;
            }
            inputStream = httpURLConnection.getInputStream();
            SLog.I(UmengText.IMAGE.IMAGEURL + string);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (Exception exception) {
            SLog.error(UmengText.NET.IMAGEDOWN, exception);
            string2 = null;
            return string2;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    SLog.error(UmengText.NET.TOOL, iOException);
                }
                finally {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {
                            SLog.error(UmengText.NET.CLOSE, iOException);
                        }
                    }
                }
            }
        }
    }

    public static boolean startWithHttp(String string) {
        return string.startsWith("http://") || string.startsWith("https://");
    }

    public static Bundle parseUrl(String string) {
        try {
            URL uRL = new URL(string);
            Bundle bundle = SocializeNetUtils.decodeUrl(uRL.getQuery());
            bundle.putAll(SocializeNetUtils.decodeUrl(uRL.getRef()));
            return bundle;
        }
        catch (MalformedURLException malformedURLException) {
            SLog.error(UmengText.NET.TOOL, malformedURLException);
            return new Bundle();
        }
    }

    public static Bundle parseUri(String string) {
        try {
            URI uRI = new URI(string);
            Bundle bundle = SocializeNetUtils.decodeUrl(uRI.getQuery());
            return bundle;
        }
        catch (Exception exception) {
            SLog.error(UmengText.NET.TOOL, exception);
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String string) {
        Bundle bundle = new Bundle();
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split("&");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                String[] stringArray3 = string2.split("=");
                try {
                    bundle.putString(URLDecoder.decode(stringArray3[0], "UTF-8"), URLDecoder.decode(stringArray3[1], "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SLog.error(UmengText.NET.TOOL, unsupportedEncodingException);
                }
            }
        }
        return bundle;
    }

    public static String request(String string) {
        String string2 = "";
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection == null) {
                return string2;
            }
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            if (inputStream == null) {
                return string2;
            }
            return SocializeNetUtils.convertStreamToString(inputStream);
        }
        catch (Exception exception) {
            SLog.error(UmengText.NET.TOOL, exception);
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "/n");
            }
        }
        catch (IOException iOException) {
            SLog.error(UmengText.NET.TOOL, iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                SLog.error(UmengText.NET.TOOL, iOException);
            }
        }
        return stringBuilder.toString();
    }
}

