/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.base;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.umeng.commonsdk.utils.UMUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.b.a.a;
import com.umeng.socialize.common.SocializeConstants;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.net.base.SocializeReseponse;
import com.umeng.socialize.net.utils.SocializeProtocolConstants;
import com.umeng.socialize.net.utils.URequest;
import com.umeng.socialize.utils.DefaultClass;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UmengText;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public abstract class SocializeRequest
extends URequest {
    public static final int REQUEST_SOCIAL = 0;
    public static final int REQUEST_ANALYTIC = 1;
    public static final int REQUEST_API = 2;
    private static final String BASE_URL = "https://log.umsns.com/";
    private Map<String, URequest.FilePair> mFileMap = new HashMap<String, URequest.FilePair>();
    public int mOpId;
    private int mReqType = 1;
    private static final String TAG = "SocializeRequest";

    public SocializeRequest(Context context, String string, Class<? extends SocializeReseponse> clazz, int n, URequest.RequestMethod requestMethod) {
        super("");
        this.mResponseClz = clazz;
        this.mOpId = n;
        this.mContext = context;
        this.mMethod = requestMethod;
        this.setBaseUrl(BASE_URL);
    }

    public void setReqType(int n) {
        this.mReqType = n;
    }

    public void addFileParams(byte[] byArray, FILE_TYPE fILE_TYPE, String string) {
        if (FILE_TYPE.IMAGE == fILE_TYPE) {
            String string2 = a.c(byArray);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = "png";
            }
            URequest.FilePair filePair = new URequest.FilePair(SocializeUtils.md5(byArray) + "." + string2, byArray);
            this.mFileMap.put(SocializeProtocolConstants.PROTOCOL_KEY_IMAGE, filePair);
        }
    }

    public void addMediaParams(UMediaObject uMediaObject) {
        Object object;
        if (uMediaObject == null) {
            return;
        }
        if (uMediaObject instanceof BaseMediaObject) {
            object = (BaseMediaObject)uMediaObject;
            this.addStringParams(SocializeProtocolConstants.PROTOCOL_KEY_TITLE, ((BaseMediaObject)object).getTitle());
        }
        if (uMediaObject.isUrlMedia()) {
            object = uMediaObject.toUrlExtraParams();
            for (Map.Entry entry : object.entrySet()) {
                this.addStringParams((String)entry.getKey(), entry.getValue().toString());
            }
        } else {
            object = uMediaObject.toByte();
            if (object != null) {
                this.addFileParams((byte[])object, FILE_TYPE.IMAGE, null);
            }
        }
    }

    @Override
    public Map<String, Object> getBodyPair() {
        Map<String, Object> map = this.buildParams();
        return map;
    }

    @Override
    public Map<String, URequest.FilePair> getFilePair() {
        return this.mFileMap;
    }

    @Override
    public JSONObject toJson() {
        return null;
    }

    @Override
    public String toGetUrl() {
        Map<String, Object> map = this.buildParams();
        return this.generateGetURL(this.getBaseUrl(), map);
    }

    @Override
    public Map<String, Object> buildParams() {
        Map<String, Object> map = SocializeRequest.getBaseQuery(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)Config.EntityKey)) {
            map.put("ek", Config.EntityKey);
        }
        if (!TextUtils.isEmpty((CharSequence)Config.SessionId)) {
            map.put("sid", Config.SessionId);
        }
        map.put("tp", this.mReqType);
        map.put("opid", this.mOpId);
        map.put("uid", UMUtils.getUMId((Context)this.mContext));
        map.putAll(this.mParams);
        return map;
    }

    @Override
    public void setBaseUrl(String string) {
        String string2 = "";
        try {
            if (!TextUtils.isEmpty((CharSequence)this.getPath())) {
                URL uRL = new URL(string);
                string2 = new URL(uRL, this.getPath()).toString();
            }
        }
        catch (Exception exception) {
            SLog.error(UmengText.NET.getURLERROR(string), exception);
        }
        super.setBaseUrl(string2);
    }

    protected abstract String getPath();

    @Override
    public void onPrepareRequest() {
        this.addStringParams("pcv", "3.0");
        this.addStringParams("u_sharetype", Config.shareType);
        String string = DeviceConfig.getDeviceId(this.mContext);
        this.addStringParams("imei", string);
        this.addStringParams("de", Build.MODEL);
        this.addStringParams("mac", DeviceConfig.getMac(this.mContext));
        this.addStringParams("os", "Android");
        this.addStringParams("en", DeviceConfig.getNetworkAccessMode(this.mContext)[0]);
        this.addStringParams("uid", null);
        this.addStringParams("sdkv", "7.1.9");
        this.addStringParams("dt", String.valueOf(System.currentTimeMillis()));
    }

    private String mapTostring(Map<String, Object> map) {
        if (this.mParams.isEmpty()) {
            return null;
        }
        try {
            return new JSONObject(map).toString();
        }
        catch (Exception exception) {
            SLog.error(exception);
            return null;
        }
    }

    @Override
    protected String getHttpMethod() {
        switch (this.mMethod) {
            case POST: {
                return POST;
            }
        }
        return GET;
    }

    public static Map<String, Object> getBaseQuery(Context context) {
        Object object;
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = DeviceConfig.getDeviceId(context);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            hashMap.put("imei", string2);
        }
        if (TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getMac(context)))) {
            string = DefaultClass.getMac();
            SLog.I(UmengText.NET.MACNULL);
        }
        hashMap.put("mac", string);
        if (!TextUtils.isEmpty((CharSequence)SocializeConstants.UID)) {
            hashMap.put("uid", SocializeConstants.UID);
        }
        try {
            object = DeviceConfig.getNetworkAccessMode(context);
            hashMap.put("en", object[0]);
        }
        catch (Exception exception) {
            hashMap.put("en", "Unknown");
        }
        hashMap.put("de", Build.MODEL);
        hashMap.put("sdkv", "7.1.9");
        hashMap.put("os", "Android");
        hashMap.put("android_id", DeviceConfig.getAndroidID(context));
        hashMap.put("sn", DeviceConfig.getDeviceSN());
        hashMap.put("os_version", DeviceConfig.getOsVersion());
        hashMap.put("dt", System.currentTimeMillis());
        object = SocializeUtils.getAppkey(context);
        hashMap.put("ak", object);
        hashMap.put(SocializeProtocolConstants.PROTOCOL_VERSION, "3.0");
        hashMap.put("u_sharetype", Config.shareType);
        if (!TextUtils.isEmpty((CharSequence)Config.EntityKey)) {
            hashMap.put("ek", Config.EntityKey);
        }
        if (!TextUtils.isEmpty((CharSequence)Config.SessionId)) {
            hashMap.put("sid", Config.SessionId);
        }
        try {
            hashMap.put("tp", 0);
        }
        catch (Exception exception) {
            SLog.error(exception);
        }
        return hashMap;
    }

    public static enum FILE_TYPE {
        IMAGE,
        VEDIO;

    }
}

