/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.pushagent;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.huawei.android.pushagent.a.a.d;
import com.huawei.android.pushagent.a.a.e;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class PushReceiver
extends BroadcastReceiver {
    private static int a = -1;

    public abstract void onToken(Context var1, String var2);

    public abstract void onPushMsg(Context var1, byte[] var2, String var3);

    public void onNotifyClickMsg(Context context, String string) {
    }

    public void onNotifyBtnClick(Context context, int n, String string, Bundle bundle) {
    }

    public void onPluginRsp(Context context, int n, boolean bl, Bundle bundle) {
    }

    public boolean canExit() {
        return true;
    }

    public void onPushState(Context context, boolean bl) {
    }

    public void onToken(Context context, String string, Bundle bundle) {
        this.onToken(context, string);
    }

    public static void getPushState(Context context) {
        Log.d((String)"PushLogLightSC2816", (String)("enter PushEntity:getPushState() pkgName" + context.getPackageName()));
        Intent intent = new Intent("com.huawei.android.push.intent.GET_PUSH_STATE");
        intent.putExtra("pkg_name", context.getPackageName());
        intent.setFlags(32);
        if (PushReceiver.isFrameworkPushExist(context)) {
            intent.setPackage("android");
            Log.d((String)"PushLogLightSC2816", (String)"send register broadcast to frameworkPush");
        }
        context.sendOrderedBroadcast(intent, null);
    }

    public static final void getToken(Context context) {
        Log.d((String)"PushLogLightSC2816", (String)("enter PushEntity:getToken() pkgName" + context.getPackageName()));
        Intent intent = new Intent("com.huawei.android.push.intent.REGISTER");
        intent.putExtra("pkg_name", context.getPackageName());
        int n = PushReceiver.a();
        if (-999 != n) {
            intent.putExtra("userid", String.valueOf(n));
        }
        intent.setFlags(32);
        if (PushReceiver.isFrameworkPushExist(context)) {
            intent.setPackage("android");
            Log.d((String)"PushLogLightSC2816", (String)"send register broadcast to frameworkPush");
        }
        context.sendBroadcast(intent);
        e e2 = new e(context, "push_client_self_info");
        e2.a("hasRequestToken", true);
    }

    public final void onReceive(Context context, Intent intent) {
        try {
            Bundle bundle = new Bundle();
            Log.d((String)"PushLogLightSC2816", (String)("enter PushMsgReceiver:onReceive(Intent:" + intent.getAction() + " pkgName:" + context.getPackageName() + ")"));
            String string = intent.getAction();
            if ("com.huawei.android.push.intent.REGISTRATION".equals(string) && intent.hasExtra("device_token")) {
                String string2 = new String(intent.getByteArrayExtra("device_token"), "UTF-8");
                Log.d((String)"PushLogLightSC2816", (String)"get a deviceToken");
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    Log.w((String)"PushLogLightSC2816", (String)"get a deviceToken, but it is null");
                    return;
                }
                e e2 = new e(context, "push_client_self_info");
                boolean bl = e2.a("hasRequestToken");
                String string3 = d.a(context, "push_client_self_info", "token_info");
                if (bl || !string2.equals(string3)) {
                    Log.i((String)"PushLogLightSC2816", (String)"push client begin to receive the token");
                    new HandlePushTokenThread(context, string2).start();
                    bundle.putString("deviceToken", string2);
                    bundle.putByteArray("pushMsg", null);
                    bundle.putInt("receiveType", ReceiveType.ReceiveType_Token.ordinal());
                    if (null != intent.getExtras()) {
                        bundle.putAll(intent.getExtras());
                    }
                    new EventThread(context, bundle).start();
                } else {
                    Log.w((String)"PushLogLightSC2816", (String)"get a deviceToken, but do not requested token, and new token is equals old token");
                }
            } else if ("com.huawei.android.push.intent.RECEIVE".equals(string) && intent.hasExtra("msg_data")) {
                this.b(context, intent);
                e e3 = new e(context, "push_switch");
                boolean bl = e3.a("normal_msg_enable");
                Log.d((String)"PushLogLightSC2816", (String)("closePush_Normal:" + bl));
                if (bl) {
                    return;
                }
                byte[] byArray = intent.getByteArrayExtra("msg_data");
                String string4 = new String(intent.getByteArrayExtra("device_token"), "UTF-8");
                Log.d((String)"PushLogLightSC2816", (String)"PushReceiver receive a message success");
                bundle.putString("deviceToken", string4);
                bundle.putByteArray("pushMsg", byArray);
                bundle.putInt("receiveType", ReceiveType.ReceiveType_Msg.ordinal());
                new EventThread(context, bundle).start();
            } else if ("com.huawei.android.push.intent.CLICK".equals(string) && intent.hasExtra("click")) {
                String string5 = intent.getStringExtra("click");
                bundle.putString("pushMsg", string5);
                bundle.putInt("receiveType", ReceiveType.ReceiveType_NotifyClick.ordinal());
                new EventThread(context, bundle).start();
            } else if ("com.huawei.android.push.intent.CLICK".equals(string) && intent.hasExtra("clickBtn")) {
                String string6 = intent.getStringExtra("clickBtn");
                int n = intent.getIntExtra("notifyId", 0);
                bundle.putString("pushMsg", string6);
                bundle.putInt("pushNotifyId", n);
                bundle.putInt("receiveType", ReceiveType.ReceiveType_ClickBtn.ordinal());
                new EventThread(context, bundle).start();
            } else if ("com.huawei.intent.action.PUSH_STATE".equals(string)) {
                boolean bl = intent.getBooleanExtra("push_state", false);
                bundle.putBoolean("pushState", bl);
                bundle.putInt("receiveType", ReceiveType.ReceiveType_PushState.ordinal());
                new EventThread(context, bundle).start();
            } else if ("com.huawei.intent.action.PUSH".equals(string) && intent.hasExtra("selfshow_info")) {
                this.a(context, intent);
            } else {
                Log.w((String)"PushLogLightSC2816", (String)"unknowned message");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"PushLogLightSC2816", (String)("call onReceive(intent:" + intent + ") cause:" + unsupportedEncodingException.toString()), (Throwable)unsupportedEncodingException);
        }
        catch (Exception exception) {
            Log.e((String)"PushLogLightSC2816", (String)("call onReceive(intent:" + intent + ") cause:" + exception.toString()), (Throwable)exception);
        }
    }

    private void a(Context context, Intent intent) {
        e e2 = new e(context, "push_switch");
        boolean bl = e2.a("notify_msg_enable");
        Log.d((String)"PushLogLightSC2816", (String)("closePush_Notify:" + bl));
        if (bl) {
            return;
        }
        try {
            Log.i((String)"PushLogLightSC2816", (String)"run push selfshow");
            Class<?> clazz = Class.forName("com.huawei.android.pushselfshow.SelfShowReceiver");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Method method = clazz.getDeclaredMethod("onReceive", Context.class, Intent.class);
            method.invoke(obj, context, intent);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)"PushLogLightSC2816", (String)("SelfShowReceiver class not found:" + classNotFoundException.getMessage()), (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)"PushLogLightSC2816", (String)("onReceive method not found:" + noSuchMethodException.getMessage()), (Throwable)noSuchMethodException);
        }
        catch (Exception exception) {
            Log.e((String)"PushLogLightSC2816", (String)("invokeSelfShow error:" + exception.getMessage()), (Throwable)exception);
        }
    }

    public static final void enableReceiveNormalMsg(Context context, boolean bl) {
        if (null == context) {
            Log.d((String)"PushLogLightSC2816", (String)"context is null");
            return;
        }
        e e2 = new e(context, "push_switch");
        e2.a("normal_msg_enable", !bl);
    }

    public static final void enableReceiveNotifyMsg(Context context, boolean bl) {
        if (null == context) {
            Log.d((String)"PushLogLightSC2816", (String)"context is null");
            return;
        }
        e e2 = new e(context, "push_switch");
        e2.a("notify_msg_enable", !bl);
    }

    private static boolean a(Context context, boolean bl) {
        Log.d((String)"PushLogLightSC2816", (String)("existFrameworkPush:" + a + ",realCheck:" + bl));
        if (!bl) {
            return 1 == a;
        }
        try {
            String string = "/system/framework/";
            String string2 = "hwpush.jar";
            File file = new File(string + string2);
            if (file.isFile()) {
                Log.d((String)"PushLogLightSC2816", (String)"push jarFile is exist");
            } else {
                Log.i((String)"PushLogLightSC2816", (String)"push jarFile is not exist");
                boolean bl2 = "CN".equals(SystemProperties.get((String)"ro.product.locale.region"));
                boolean bl3 = SystemProperties.getBoolean((String)"ro.config.push_enable", (boolean)bl2);
                if (!bl3) {
                    Log.d((String)"PushLogLightSC2816", (String)"framework not support push");
                    return false;
                }
                String string3 = SystemProperties.get((String)"ro.build.version.emui", (String)"-1");
                if (!TextUtils.isEmpty((CharSequence)string3) && (string3.contains("2.0") || string3.contains("2.3"))) {
                    Log.d((String)"PushLogLightSC2816", (String)"emui is 2.0 or 2.3");
                } else {
                    Log.d((String)"PushLogLightSC2816", (String)"can not use framework push");
                    return false;
                }
            }
            List list = context.getPackageManager().queryIntentServices(new Intent().setClassName("android", "com.huawei.android.pushagentproxy.PushService"), 128);
            if (null == list || list.size() == 0) {
                Log.i((String)"PushLogLightSC2816", (String)"framework push not exist, need vote apk or sdk to support pushservice");
                return false;
            }
            Log.i((String)"PushLogLightSC2816", (String)"framework push exist, use framework push first");
            return true;
        }
        catch (Exception exception) {
            Log.e((String)"PushLogLightSC2816", (String)("get Apk version faild ,Exception e= " + exception.toString()));
            return false;
        }
    }

    public static synchronized boolean isFrameworkPushExist(Context context) {
        Log.d((String)"PushLogLightSC2816", (String)("existFrameworkPush:" + a));
        if (-1 != a) {
            return 1 == a;
        }
        a = PushReceiver.a(context, true) ? 1 : 0;
        return 1 == a;
    }

    private static int a() {
        int n = -999;
        try {
            Class<?> clazz = Class.forName("android.os.UserHandle");
            Method method = clazz.getDeclaredMethod("myUserId", new Class[0]);
            n = (Integer)method.invoke(clazz, new Object[0]);
            Log.d((String)"PushLogLightSC2816", (String)("getUserId:" + n));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.d((String)"PushLogLightSC2816", (String)" getUserId wrong");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.d((String)"PushLogLightSC2816", (String)" getUserId wrong");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.d((String)"PushLogLightSC2816", (String)" getUserId wrong");
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.d((String)"PushLogLightSC2816", (String)" getUserId wrong");
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.d((String)"PushLogLightSC2816", (String)" getUserId wrong");
        }
        return n;
    }

    private void b(Context context, Intent intent) {
        if (null == context || null == intent) {
            return;
        }
        String string = intent.getStringExtra("msgIdStr");
        if (!TextUtils.isEmpty((CharSequence)string) && PushReceiver.isFrameworkPushExist(context)) {
            Intent intent2 = new Intent("com.huawei.android.push.intent.MSG_RESPONSE");
            intent2.putExtra("msgIdStr", string);
            intent2.setPackage("android");
            intent2.setFlags(32);
            Log.d((String)"PushLogLightSC2816", (String)"send msg response broadcast to frameworkPush");
            context.sendBroadcast(intent2);
        }
    }

    static class HandlePushTokenThread
    extends Thread {
        Context a;
        String b;

        public HandlePushTokenThread(Context context, String string) {
            this.a = context;
            this.b = string;
        }

        @Override
        public void run() {
            e e2 = new e(this.a, "push_client_self_info");
            e2.a("hasRequestToken", false);
            e2.d("token_info");
            d.a(this.a, "push_client_self_info", "token_info", this.b);
        }
    }

    class EventThread
    extends Thread {
        Context a;
        Bundle b;

        public EventThread(Context context, Bundle bundle) {
            super("EventRunable");
            this.a = context;
            this.b = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (null == this.b) {
                    return;
                }
                int n = this.b.getInt("receiveType");
                if (n < 0 || n >= ReceiveType.values().length) {
                    Log.e((String)"PushLogLightSC2816", (String)("invalid receiverType:" + n));
                    return;
                }
                switch (ReceiveType.values()[n]) {
                    case ReceiveType_Token: {
                        PushReceiver.this.onToken(this.a, this.b.getString("deviceToken"), this.b);
                        break;
                    }
                    case ReceiveType_Msg: {
                        PushReceiver.this.onPushMsg(this.a, this.b.getByteArray("pushMsg"), this.b.getString("deviceToken"));
                        break;
                    }
                    case ReceiveType_PushState: {
                        PushReceiver.this.onPushState(this.a, this.b.getBoolean("pushState"));
                        break;
                    }
                    case ReceiveType_NotifyClick: {
                        PushReceiver.this.onNotifyClickMsg(this.a, this.b.getString("pushMsg"));
                        break;
                    }
                    case ReceiveType_ClickBtn: {
                        PushReceiver.this.onNotifyBtnClick(this.a, this.b.getInt("pushNotifyId"), this.b.getString("pushMsg"), new Bundle());
                        break;
                    }
                    case ReceiveType_PluginRsp: {
                        int n2 = this.b.getInt("reportType", -1);
                        boolean bl = this.b.getBoolean("isReportSuccess", false);
                        Bundle bundle = this.b.getBundle("reportExtra");
                        PushReceiver.this.onPluginRsp(this.a, n2, bl, bundle);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                Log.e((String)"PushLogLightSC2816", (String)("call EventThread(ReceiveType cause:" + exception.toString()), (Throwable)exception);
            }
        }
    }

    static enum ReceiveType {
        ReceiveType_Init,
        ReceiveType_Token,
        ReceiveType_Msg,
        ReceiveType_PushState,
        ReceiveType_NotifyClick,
        ReceiveType_PluginRsp,
        ReceiveType_ClickBtn;

    }

    public static class SERVER {
        public static final String DEVICETOKEN = "device_token";
    }

    public static class ACTION {
        public static final String ACTION_PUSH_MESSAGE = "com.huawei.android.push.intent.RECEIVE";
        public static final String ACTION_CLIENT_DEREGISTER = "com.huawei.android.push.intent.DEREGISTER";
        public static final String ACTION_NOTIFICATION_MSG_CLICK = "com.huawei.android.push.intent.CLICK";
    }

    public static class KEY_TYPE {
        public static final String PUSH_KEY_DEVICE_TOKEN = "device_token";
        public static final String PUSH_BROADCAST_MESSAGE = "msg_data";
        public static final String PKGNAME = "pkg_name";
        public static final String PUSHSTATE = "push_state";
        public static final String PUSH_KEY_CLICK = "click";
        public static final String PLUGINREPORTRESULT = "isReportSuccess";
        public static final String PLUGINREPORTTYPE = "reportType";
        public static final String PLUGINREPORTEXTRA = "reportExtra";
        public static final String PUSH_KEY_CLICK_BTN = "clickBtn";
        public static final String PUSH_KEY_NOTIFY_ID = "notifyId";
        public static final String USERID = "userid";
    }

    public static class BOUND_KEY {
        public static final String deviceTokenKey = "deviceToken";
        public static final String pushMsgKey = "pushMsg";
        public static final String receiveTypeKey = "receiveType";
        public static final String pushStateKey = "pushState";
        public static final String pushNotifyId = "pushNotifyId";
    }
}

