/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.commonsdk.debug;

import android.util.Log;
import com.umeng.commonsdk.utils.UMUtils;

public class UMRTLog {
    private static final String RTLOG_PROP = "debug.umeng.rtlog";
    private static final String RTLOG_ENABLE = "1";
    public static final String RTLOG_TAG = "MobclickRT";

    private UMRTLog() {
    }

    private static boolean shouldOutput() {
        return RTLOG_ENABLE.equals(UMUtils.getSystemProperty(RTLOG_PROP, "0"));
    }

    public static void e(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.e((String)string, (String)UMRTLog.warpperMsg(string2, false));
        }
    }

    public static void w(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.w((String)string, (String)UMRTLog.warpperMsg(string2, false));
        }
    }

    public static void i(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.i((String)string, (String)UMRTLog.warpperMsg(string2, false));
        }
    }

    public static void d(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.d((String)string, (String)UMRTLog.warpperMsg(string2, false));
        }
    }

    public static void v(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.v((String)string, (String)UMRTLog.warpperMsg(string2, false));
        }
    }

    public static void se(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.e((String)string, (String)UMRTLog.warpperMsg(string2, true));
        }
    }

    public static void sw(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.w((String)string, (String)UMRTLog.warpperMsg(string2, true));
        }
    }

    public static void si(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.i((String)string, (String)UMRTLog.warpperMsg(string2, true));
        }
    }

    public static void sd(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.d((String)string, (String)UMRTLog.warpperMsg(string2, true));
        }
    }

    public static void sv(String string, String string2) {
        if (UMRTLog.shouldOutput()) {
            Log.v((String)string, (String)UMRTLog.warpperMsg(string2, true));
        }
    }

    private static String warpperMsg(String string, boolean bl2) {
        if (!bl2) {
            return string;
        }
        StringBuffer stringBuffer = null;
        try {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            if (stackTraceElementArray.length >= 3) {
                String string2 = stackTraceElementArray[2].getFileName();
                String string3 = stackTraceElementArray[2].getMethodName();
                int n2 = stackTraceElementArray[2].getLineNumber();
                stringBuffer = new StringBuffer();
                stringBuffer.append("<");
                stringBuffer.append(string2);
                stringBuffer.append(":");
                stringBuffer.append(string3);
                stringBuffer.append(":");
                stringBuffer.append(n2);
                stringBuffer.append("> ");
                stringBuffer.append(string);
            }
        }
        catch (Throwable throwable) {
            return string;
        }
        return stringBuffer.toString();
    }
}

