/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.base.core.util;

import com.efs.sdk.base.core.a.a;
import com.efs.sdk.base.core.model.LogDto;
import com.efs.sdk.base.core.util.Log;
import com.efs.sdk.base.core.util.ProcessUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class FileUtil {
    private static final Random a = new Random();

    public static boolean write(String string, byte[] byArray) {
        return FileUtil.write(new File(string), byArray);
    }

    public static boolean write(File file, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                Log.e("efs.util.file", "write file error, filename is " + file.getName(), throwable);
            }
            catch (Throwable throwable2) {
                FileUtil.safeClose(fileOutputStream);
                throw throwable2;
            }
            FileUtil.safeClose(fileOutputStream);
        }
        FileUtil.safeClose(fileOutputStream);
        return bl;
    }

    public static boolean write(File file, String string) {
        return FileUtil.write(file, string.getBytes());
    }

    public static String read(File file) {
        return FileUtil.read(file, 1024);
    }

    public static String read(File object, int n) {
        String string = "";
        if (!((File)object).exists()) {
            return string;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream((File)object);
            object = new byte[n];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = fileInputStream.read((byte[])object)) > 0) {
                stringBuilder.append(new String((byte[])object, 0, n));
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            try {
                Log.e("efs.util.file", "read file error", throwable);
            }
            catch (Throwable throwable2) {
                FileUtil.safeClose(fileInputStream);
                throw throwable2;
            }
            FileUtil.safeClose(fileInputStream);
        }
        FileUtil.safeClose(fileInputStream);
        return string;
    }

    public static byte[] read(String string) {
        byte[] byArray = new byte[]{};
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            byArray = new byte[((InputStream)fileInputStream).available()];
            ((InputStream)fileInputStream).read(byArray);
        }
        catch (Exception exception) {
            try {
                Log.e("efs.util.file", "read data error", exception);
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(fileInputStream);
                throw throwable;
            }
            FileUtil.safeClose(fileInputStream);
        }
        FileUtil.safeClose(fileInputStream);
        return byArray;
    }

    public static void delete(File file) {
        File[] fileArray;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                FileUtil.delete(fileArray[i]);
            }
        }
        file.delete();
    }

    public static void copy(File file, File file2) {
        byte[] byArray = new byte[524288];
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            try {
                Log.e("efs.util.file", "error when copy", exception);
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(fileInputStream);
                FileUtil.safeClose(fileOutputStream);
                throw throwable;
            }
            FileUtil.safeClose(fileInputStream);
            FileUtil.safeClose(fileOutputStream);
            return;
        }
        FileUtil.safeClose(fileInputStream);
        FileUtil.safeClose(fileOutputStream);
        return;
    }

    public static void move(File file, File file2) {
        FileUtil.copy(file, file2);
        FileUtil.delete(file);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (Throwable throwable) {
                Log.e("efs.util.file", "safe close error", throwable);
            }
        }
    }

    public static long getFolderSize(File fileArray) {
        long l = 0L;
        if (fileArray.isDirectory()) {
            if ((fileArray = fileArray.listFiles()) == null) {
                return 0L;
            }
            for (File file : fileArray) {
                l += FileUtil.getFolderSize(file);
            }
        } else {
            l = 0L + fileArray.length();
        }
        return l;
    }

    public static List<File> listFiles(File fileArray) {
        if (fileArray.isFile()) {
            return Collections.emptyList();
        }
        if ((fileArray = fileArray.listFiles()) == null || fileArray.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            if (file.isFile()) {
                arrayList.add(file);
                Log.i("efs.util.file", "file is " + file.getName());
                continue;
            }
            arrayList.addAll(FileUtil.listFiles(file));
        }
        return arrayList;
    }

    public static String getFileName(LogDto logDto) {
        StringBuilder stringBuilder = new StringBuilder().append(logDto.getLogType()).append("_").append(logDto.getCp()).append("_").append(logDto.getDe()).append("_").append(logDto.getLogProtocol()).append("_").append(ProcessUtil.myPid()).append("_").append(a.nextInt(10000)).append("_");
        com.efs.sdk.base.core.a.a.a();
        return stringBuilder.append(com.efs.sdk.base.core.a.a.b()).toString();
    }

    public static String getCodelogFileName(LogDto logDto) {
        StringBuilder stringBuilder = new StringBuilder().append(logDto.getLogType()).append("_").append(logDto.getCp()).append("_").append(logDto.getDe()).append("_").append(logDto.getLogProtocol()).append("_").append(ProcessUtil.myPid()).append("_").append(a.nextInt(10000)).append("_");
        com.efs.sdk.base.core.a.a.a();
        return stringBuilder.append(com.efs.sdk.base.core.a.a.b()).append("_").append(logDto.getUid()).append("_").append(logDto.getDid()).append("_").append(logDto.getBeginTime()).append("_").append(logDto.getEndTime()).toString();
    }

    public static LogDto createLogDtoByName(String object) {
        String[] stringArray = ((String)object).split("_");
        if (stringArray.length != 7) {
            Log.w("efs.util.file", "File name error, name is ".concat(String.valueOf(object)));
            return null;
        }
        object = stringArray[0];
        String string = stringArray[1];
        byte by = Byte.valueOf(stringArray[2]);
        byte by2 = Byte.valueOf(stringArray[3]);
        object = new LogDto((String)object, by2);
        ((LogDto)object).setCp(string);
        ((LogDto)object).setDe(by);
        return object;
    }

    public static LogDto createCodeLogDtoByName(String object) {
        String[] stringArray = ((String)object).split("_");
        if (stringArray.length != 11) {
            Log.w("efs.util.file", "[code log]File name error, name is ".concat(String.valueOf(object)));
            return null;
        }
        object = stringArray[0];
        String string = stringArray[1];
        byte by = Byte.valueOf(stringArray[2]);
        byte by2 = Byte.valueOf(stringArray[3]);
        String string2 = stringArray[7];
        String string3 = stringArray[8];
        long l = Long.valueOf(stringArray[9]);
        long l2 = Long.valueOf(stringArray[10]);
        object = new LogDto((String)object, by2);
        ((LogDto)object).setCp(string);
        ((LogDto)object).setDe(by);
        ((LogDto)object).setUid(string2);
        ((LogDto)object).setDid(string3);
        ((LogDto)object).setBeginTime(l);
        ((LogDto)object).setEndTime(l2);
        return object;
    }
}

