/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.base;

import android.app.Application;
import android.content.Context;
import android.os.Message;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import android.webkit.ValueCallback;
import com.efs.sdk.base.IConfigRefreshAction;
import com.efs.sdk.base.core.b.e;
import com.efs.sdk.base.core.cache.CacheManager;
import com.efs.sdk.base.core.cache.IFileFilter;
import com.efs.sdk.base.core.config.GlobalEnvStruct;
import com.efs.sdk.base.core.config.remote.b;
import com.efs.sdk.base.core.controller.ControllerCenter;
import com.efs.sdk.base.core.util.Log;
import com.efs.sdk.base.core.util.a;
import com.efs.sdk.base.custommapping.IUMPerfCallback;
import com.efs.sdk.base.custommapping.InnerCustomMappingManager;
import com.efs.sdk.base.http.HttpResponse;
import com.efs.sdk.base.observer.IConfigCallback;
import com.efs.sdk.base.observer.IEfsReporterObserver;
import com.efs.sdk.base.processor.action.ILogEncryptAction;
import com.efs.sdk.base.protocol.ILogProtocol;
import com.efs.sdk.base.protocol.record.EfsJSONLog;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EfsReporter {
    private final String TAG = "efs.reporter";
    private static ControllerCenter sControllerCenter = null;
    private static IUMPerfCallback sUMPerfCallback = null;

    private EfsReporter(Builder builder) {
        sControllerCenter = new ControllerCenter(builder);
    }

    @NonNull
    private GlobalEnvStruct getGlobalEnvStruct() {
        return ControllerCenter.getGlobalEnvStruct();
    }

    public void send(ILogProtocol iLogProtocol) {
        try {
            if (iLogProtocol instanceof EfsJSONLog) {
                switch (iLogProtocol.getLogType()) {
                    case "powerperf": {
                        if (sUMPerfCallback != null) {
                            sUMPerfCallback.onCallback(IUMPerfCallback.PerfType.PERF_TYPE_POWER);
                        }
                        ((EfsJSONLog)iLogProtocol).put("um_custom_mapping", InnerCustomMappingManager.getCustomMappingJsonStr());
                        break;
                    }
                    case "startperf": {
                        if (sUMPerfCallback != null) {
                            sUMPerfCallback.onCallback(IUMPerfCallback.PerfType.PERF_TYPE_START);
                        }
                        ((EfsJSONLog)iLogProtocol).put("um_custom_mapping", InnerCustomMappingManager.getCustomMappingJsonStr());
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        sControllerCenter.send(iLogProtocol);
    }

    public HttpResponse sendSyncImediatelly(String string, int n, String string2, File file) {
        return this.sendSyncImediatelly(string, n, string2, true, file);
    }

    public HttpResponse sendSyncImediatelly(String string, int n, String string2, boolean bl, File file) {
        return sControllerCenter.sendSyncImmediately(string, n, string2, bl, file);
    }

    public void getAllSdkConfig(String[] object, IConfigCallback stringArray) {
        String[] stringArray2 = stringArray;
        stringArray = object;
        object = b.a();
        ((b)object).e.put((IConfigCallback)stringArray2, stringArray);
        if (!((b)object).d.mSDKConfigMap.isEmpty()) {
            ((b)object).d();
        }
    }

    public void getAllSdkConfigFromServer(String[] stringArray, IConfigCallback stringArray2) {
        String[] stringArray3 = stringArray;
        stringArray = stringArray2;
        stringArray2 = stringArray3;
        b.a().f.put((IConfigCallback)stringArray, stringArray2);
    }

    public Map<String, String> getAllConfig() {
        return b.a().c();
    }

    public Map<String, Object> getAllSdkConfig() {
        b b2 = b.a();
        return new HashMap<String, Object>(b2.d.mSDKConfigMap);
    }

    public Map<String, Object> getStrategyMap() {
        b b2 = b.a();
        return new HashMap<String, Object>(b2.d.mStrategyMap);
    }

    public void flushRecordLogImmediately(String string) {
        CacheManager.getInstance().flushImmediately((byte)1, string);
    }

    public void refreshConfig(String string) {
        b.a().a(string);
    }

    public void setEnableRefreshConfigFromRemote(boolean bl) {
        b.a().c = bl;
    }

    public void addPublicParams(@NonNull Map<String, String> map) {
        if (map.size() > 0) {
            this.getGlobalEnvStruct().addPublicParams(map);
        }
    }

    public void registerCallback(int n, ValueCallback<Pair<Message, Message>> valueCallback) {
        this.getGlobalEnvStruct().registerCallback(n, valueCallback);
    }

    public static void registerPerfCallback(IUMPerfCallback iUMPerfCallback) {
        sUMPerfCallback = iUMPerfCallback;
    }

    public void setFileFilterCodeLog(IFileFilter iFileFilter) {
        e.a().d = iFileFilter;
    }

    public static class Builder {
        private final String TAG = "efs.reporter.builder";
        private GlobalEnvStruct mGlobalEnvStruct;
        private static Map<String, EfsReporter> sInstanceMap = new ConcurrentHashMap<String, EfsReporter>();
        private static boolean sUseAppContext = true;

        public Builder(@NonNull Application application, @NonNull String string, @NonNull String string2) {
            this(application.getApplicationContext(), string, string2);
        }

        public Builder(@NonNull Context context, @NonNull String string, @NonNull String string2) {
            context = Builder.checkContext(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new RuntimeException("EfsReporter init, appid is empty");
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new RuntimeException("EfsReporter init, secret is empty");
            }
            this.mGlobalEnvStruct = new GlobalEnvStruct();
            this.mGlobalEnvStruct.mAppContext = context;
            this.mGlobalEnvStruct.setAppid(string);
            this.mGlobalEnvStruct.setSecret(string2);
        }

        public Builder uid(String string) {
            this.mGlobalEnvStruct.setUid(string);
            return this;
        }

        public Builder logUid(String string) {
            this.mGlobalEnvStruct.setLogUid(string);
            return this;
        }

        public Builder logDid(String string) {
            this.mGlobalEnvStruct.setLogDid(string);
            return this;
        }

        public Builder setOpenCodeLog(boolean bl) {
            this.mGlobalEnvStruct.setOpenCodeLog(bl);
            return this;
        }

        public Builder debug(boolean bl) {
            this.mGlobalEnvStruct.setDebug(bl);
            return this;
        }

        public Builder enablePaBackup(boolean bl) {
            this.mGlobalEnvStruct.setEnablePaBackup(bl);
            return this;
        }

        public Builder enableWaStat(boolean bl) {
            this.mGlobalEnvStruct.setEnableWaStat(bl);
            return this;
        }

        public Builder printLogDetail(boolean bl) {
            this.mGlobalEnvStruct.setPrintLogDetail(bl);
            return this;
        }

        public Builder publicParams(@NonNull IPublicParams iPublicParams) {
            if (iPublicParams.getRecordHeaders() != null && iPublicParams.getRecordHeaders().size() > 0) {
                this.mGlobalEnvStruct.addPublicParams(iPublicParams.getRecordHeaders());
            }
            return this;
        }

        public Builder publicParams(@NonNull Map<String, String> map) {
            if (map.size() > 0) {
                this.mGlobalEnvStruct.addPublicParams(map);
            }
            return this;
        }

        public Builder logEncryptAction(ILogEncryptAction iLogEncryptAction) {
            this.mGlobalEnvStruct.setLogEncryptAction(iLogEncryptAction);
            return this;
        }

        public Builder configRefreshDelayMills(long l) {
            this.mGlobalEnvStruct.configRefreshDelayMills = l;
            return this;
        }

        public Builder configRefreshAction(@NonNull IConfigRefreshAction iConfigRefreshAction) {
            b.a().b = iConfigRefreshAction;
            return this;
        }

        public Builder maxConcurrentUploadCnt(int n) {
            e.a().a = n;
            return this;
        }

        public Builder maxConcurrentUploadCntCodeLog(int n) {
            e.a().b = n;
            return this;
        }

        public Builder addEfsReporterObserver(IEfsReporterObserver iEfsReporterObserver) {
            this.mGlobalEnvStruct.addConfigObserver(iEfsReporterObserver);
            return this;
        }

        public Builder intl(boolean bl) {
            this.mGlobalEnvStruct.setIsIntl(bl);
            return this;
        }

        public Builder efsDirRootName(String string) {
            a.a(string);
            return this;
        }

        public Builder enableSendLog(boolean bl) {
            this.mGlobalEnvStruct.setEnableSendLog(bl);
            return this;
        }

        public GlobalEnvStruct getGlobalEnvStruct() {
            return this.mGlobalEnvStruct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public EfsReporter build() {
            String string = this.getGlobalEnvStruct().getAppid();
            if (!sInstanceMap.containsKey(string)) {
                Class<EfsReporter> clazz = EfsReporter.class;
                // MONITORENTER : com.efs.sdk.base.EfsReporter.class
                if (!sInstanceMap.containsKey(string)) {
                    EfsReporter efsReporter = new EfsReporter(this);
                    sInstanceMap.put(string, efsReporter);
                    // MONITOREXIT : clazz
                    return efsReporter;
                }
                // MONITOREXIT : clazz
            }
            Log.w("efs.reporter.builder", "efs-core: duplicate init");
            this.checkParam(string);
            return sInstanceMap.get(string);
        }

        private void checkParam(String object) {
            object = Builder.sInstanceMap.get(object).getGlobalEnvStruct();
            String string = "efs-core: duplicate init, but ";
            if (!((GlobalEnvStruct)object).mAppContext.equals(this.getGlobalEnvStruct().mAppContext)) {
                throw new RuntimeException(string + "application context is different");
            }
            if (!TextUtils.isEmpty((CharSequence)((GlobalEnvStruct)object).getSecret()) && !((GlobalEnvStruct)object).getSecret().equals(this.getGlobalEnvStruct().getSecret())) {
                throw new RuntimeException(string + "secret is different");
            }
            if (((GlobalEnvStruct)object).isIntl() != this.getGlobalEnvStruct().isIntl()) {
                throw new RuntimeException(string + "intl setting is different");
            }
            if (!TextUtils.isEmpty((CharSequence)this.getGlobalEnvStruct().getUid()) && !this.getGlobalEnvStruct().getUid().equals(((GlobalEnvStruct)object).getUid())) {
                Log.w("efs.reporter.builder", string + " uid is different");
            }
            if (this.getGlobalEnvStruct().getPublicParamMap() != null && this.getGlobalEnvStruct().getPublicParamMap().size() > 0) {
                ((GlobalEnvStruct)object).addPublicParams(this.getGlobalEnvStruct().getPublicParamMap());
            }
        }

        private static Context checkContext(Context context) {
            if (context == null) {
                Log.e("context can not be null!");
                throw new NullPointerException();
            }
            if (!(!sUseAppContext || context instanceof Application || (context = context.getApplicationContext()) != null && context instanceof Application)) {
                Log.e("Can not get Application context from given context!");
                throw new IllegalArgumentException("Can not get Application context from given context!");
            }
            return context;
        }

        public static interface IPublicParams {
            public Map<String, String> getRecordHeaders();
        }
    }
}

