/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.base.newsharedpreferences;

import android.content.SharedPreferences;
import android.os.FileObserver;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class SharedPreferencesNewImpl
implements SharedPreferences {
    private final LinkedHashMap<String, Object> mMap = new LinkedHashMap();
    private final ArrayList<SharedPreferences.OnSharedPreferenceChangeListener> mListeners = new ArrayList();
    private FileMonitor mFileMonitor;
    private static final Object mFileMonitorSyncObj = new Object();
    private boolean mLoaded = true;
    private File mFile;
    private String mBackupFilePath;
    private static final String BACKUP_FILE_SUFFIX = ".bak";
    private int mModifyID;
    private FileChannel mFileChannel;
    private MappedByteBuffer mMappedByteBuffer;
    private static final int MAX_HANDLERTHREAD = 3;
    private static HandlerThread[] mHandlerThreadPool = new HandlerThread[3];
    private static ExecutorService sCachedThreadPool;
    private Handler mHandler;
    private static final int ID_LENGTH = 4;
    private static final int MIN_INCREASE_LENGTH = 1024;
    private final Object mSyncObj = new Object();
    private final Object mSyncSaveObj = new Object();
    private static final String TAG = "SharedPreferencesNew";
    private static final byte FINISH_MARK = 18;
    private static final int FINISH_MARK_LENGTH = 1;
    private static final int MAX_NUM = Integer.MAX_VALUE;
    private static final long DELAY_TIME_TO_SAVE = 1000L;
    private static final int MAX_TRY_TIME = 6;
    private static final int TRY_SAVE_TIME_DELAY = 2000;
    private int mCurTryTime;
    private static final long MAX_LOCK_FILE_TIME = 10000L;
    private static final int CONTENT_LENGTH_LOST = 1;
    private static final int MODIFY_ID_LOST = 2;
    private static final int VALUE_LOST = 3;
    private static final int MAPPED_BUFFER_ERROR = 4;
    private static final int CONTENT_OVER_SIZE = 7;
    private static final int DATA_TYPE_ERROR = 8;
    private static final int DATA_TYPE_INVALID = 9;
    private static final int INIT_EXCEPTION = 10;
    private static final int OTHER_EXCEPTION = 11;
    private static final int LOAD_BAK_FILE = 12;
    private static final int TYPE_CAST_EXCEPTION = 13;
    private Vector<SharedPreferences.Editor> mEditorList = new Vector();
    private OnSharedPreferenceErrorListener mErrorListener;
    private boolean mIsSaving = false;
    private long mTryReloadStartTime;
    private static final long TRY_RELOAD_INTERVAL = 60L;
    private final Runnable mTryReloadRunnable = new Runnable(){

        @Override
        public void run() {
            int n = SharedPreferencesNewImpl.this.getModifyID();
            if (n > 0 && n != SharedPreferencesNewImpl.this.mModifyID) {
                SharedPreferencesNewImpl.this.saveInner(false);
            }
        }
    };
    private static final int mSaveMessageID = 21310;
    private RunnableEx mSaveRunnable = new RunnableEx(){

        @Override
        public void run() {
            SharedPreferencesNewImpl.this.saveInner((Boolean)this.getArg());
        }
    };
    private int mModifyErrorCnt;

    public SharedPreferencesNewImpl(File file) {
        this(file, 0, null, false);
    }

    public SharedPreferencesNewImpl(File file, boolean bl) {
        this(file, 0, null, bl);
    }

    public SharedPreferencesNewImpl(File file, OnSharedPreferenceErrorListener onSharedPreferenceErrorListener) {
        this(file, 0, onSharedPreferenceErrorListener, false);
    }

    public SharedPreferencesNewImpl(File file, int n, OnSharedPreferenceErrorListener onSharedPreferenceErrorListener) {
        this(file, n, onSharedPreferenceErrorListener, false);
    }

    public SharedPreferencesNewImpl(File file, int n, OnSharedPreferenceErrorListener onSharedPreferenceErrorListener, boolean bl) {
        this.mErrorListener = onSharedPreferenceErrorListener;
        this.mHandler = new Handler(this.getHandlerThread().getLooper());
        this.mFile = file;
        this.mBackupFilePath = file.getAbsolutePath() + BACKUP_FILE_SUFFIX;
        if (this.initBuffer()) {
            this.startLoadFromDisk(bl);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(SharedPreferencesNewImpl.this.mBackupFilePath);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, ?> getAll() {
        this.awaitLoadedLocked();
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            return new HashMap<String, Object>(this.mMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(String string, String string2) {
        this.awaitLoadedLocked();
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            try {
                String string3 = (String)this.mMap.get(string);
                return string3 != null ? string3 : string2;
            }
            catch (ClassCastException classCastException) {
                if (this.mErrorListener != null) {
                    this.mErrorListener.onError((this.mFile != null ? this.mFile.getAbsolutePath() : null) + "#" + string + classCastException, 13, this.mFile != null ? this.mFile.length() : 0L);
                }
                return string2;
            }
        }
    }

    public final Set<String> getStringSet(String string, Set<String> set) {
        throw new RuntimeException("putStringSet is not supported!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getInt(String string, int n) {
        this.awaitLoadedLocked();
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            try {
                Integer n2 = (Integer)this.mMap.get(string);
                return n2 != null ? n2 : n;
            }
            catch (ClassCastException classCastException) {
                if (this.mErrorListener != null) {
                    this.mErrorListener.onError((this.mFile != null ? this.mFile.getAbsolutePath() : null) + "#" + string + classCastException, 13, this.mFile != null ? this.mFile.length() : 0L);
                }
                return n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLong(String string, long l) {
        this.awaitLoadedLocked();
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            try {
                Long l2 = (Long)this.mMap.get(string);
                return l2 != null ? l2 : l;
            }
            catch (ClassCastException classCastException) {
                if (this.mErrorListener != null) {
                    this.mErrorListener.onError((this.mFile != null ? this.mFile.getAbsolutePath() : null) + "#" + string + classCastException, 13, this.mFile != null ? this.mFile.length() : 0L);
                }
                return l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getFloat(String string, float f2) {
        this.awaitLoadedLocked();
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            try {
                Float f3 = (Float)this.mMap.get(string);
                return f3 != null ? f3.floatValue() : f2;
            }
            catch (ClassCastException classCastException) {
                if (this.mErrorListener != null) {
                    this.mErrorListener.onError((this.mFile != null ? this.mFile.getAbsolutePath() : null) + "#" + string + classCastException, 13, this.mFile != null ? this.mFile.length() : 0L);
                }
                return f2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getBoolean(String string, boolean bl) {
        this.awaitLoadedLocked();
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            try {
                Boolean bl2 = (Boolean)this.mMap.get(string);
                return bl2 != null ? bl2 : bl;
            }
            catch (ClassCastException classCastException) {
                if (this.mErrorListener != null) {
                    this.mErrorListener.onError((this.mFile != null ? this.mFile.getAbsolutePath() : null) + "#" + string + classCastException, 13, this.mFile != null ? this.mFile.length() : 0L);
                }
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contains(String string) {
        this.awaitLoadedLocked();
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            return this.mMap.containsKey(string);
        }
    }

    public final SharedPreferences.Editor edit() {
        this.awaitLoadedLocked();
        return new EditorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener object) {
        if (object != null) {
            Object object2 = this.mListeners;
            synchronized (object2) {
                this.mListeners.add((SharedPreferences.OnSharedPreferenceChangeListener)object);
                if (this.mFileMonitor == null) {
                    try {
                        object = new File(this.mBackupFilePath);
                        if (!((File)object).exists()) {
                            ((File)object).createNewFile();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    SharedPreferencesNewImpl sharedPreferencesNewImpl = this;
                    this.mFileMonitor = sharedPreferencesNewImpl.new FileMonitor(sharedPreferencesNewImpl.mBackupFilePath, 2);
                }
            }
            object2 = mFileMonitorSyncObj;
            synchronized (object2) {
                this.mFileMonitor.startWatching();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        if (onSharedPreferenceChangeListener != null) {
            ArrayList<SharedPreferences.OnSharedPreferenceChangeListener> arrayList = this.mListeners;
            synchronized (arrayList) {
                this.mListeners.remove(onSharedPreferenceChangeListener);
                if (this.mFileMonitor != null && this.mListeners.size() <= 0) {
                    this.mFileMonitor.stopWatching();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean merge(SharedPreferences.Editor editor, Map map, boolean bl) {
        HashMap<String, Object> object2;
        if (editor == null) {
            return false;
        }
        boolean bl2 = ((EditorImpl)editor).doClear();
        if (bl2) {
            map.clear();
            this.mEditorList.clear();
        }
        if ((object2 = ((EditorImpl)editor).getAll()).size() == 0) {
            return bl2;
        }
        synchronized (editor) {
            for (Map.Entry<String, Object> entry : object2.entrySet()) {
                String string = entry.getKey();
                Object object = entry.getValue();
                if (object == null) {
                    map.remove(string);
                } else {
                    if (map.containsKey(string)) {
                        map.remove(string);
                    }
                    map.put(string, object);
                }
                if (bl) continue;
                this.notifyDataChanged(string);
            }
        }
        return true;
    }

    private void notifyDataChanged(String string) {
        if (this.mListeners.size() > 0) {
            for (int i = 0; i < this.mListeners.size(); ++i) {
                SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener = this.mListeners.get(i);
                if (onSharedPreferenceChangeListener == null) continue;
                onSharedPreferenceChangeListener.onSharedPreferenceChanged((SharedPreferences)this, string);
            }
        }
    }

    private void tryReload() {
        if (SystemClock.uptimeMillis() - this.mTryReloadStartTime > 60L) {
            this.mTryReloadStartTime = SystemClock.uptimeMillis();
            this.mHandler.removeCallbacks(this.mTryReloadRunnable);
            this.mHandler.post(this.mTryReloadRunnable);
        }
    }

    private boolean tryReloadWhenSave() {
        int n = this.getModifyID();
        if (n > 0 && n != this.mModifyID) {
            this.load(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void saveInner(final boolean bl) {
        Object object = this.mSyncSaveObj;
        // MONITORENTER : object
        FileLock fileLock = this.lockFile(false);
        if (fileLock != null) {
            Object object2;
            block21: {
                this.mIsSaving = true;
                if (this.tryReloadWhenSave()) {
                    this.mergeWhenReload();
                    this.notifyDataChanged(null);
                }
                object2 = this.mMap;
                // MONITORENTER : object2
                if (this.mEditorList.size() > 0) break block21;
                // MONITOREXIT : object2
                try {
                    fileLock.release();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.mIsSaving = false;
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : object2
            object2 = this.obtainTotalBytes();
            this.saveToMappedBuffer((byte[])object2, bl);
            this.backup();
            try {
                fileLock.release();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.mIsSaving = false;
            return;
            catch (Throwable throwable) {
                block22: {
                    try {
                        object2 = throwable;
                        throwable.printStackTrace();
                        if (this.mErrorListener == null) break block22;
                        this.mErrorListener.onError(((Throwable)object2).getMessage(), 11, -1L);
                    }
                    catch (Throwable throwable2) {
                        try {
                            fileLock.release();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        this.mIsSaving = false;
                        throw throwable2;
                    }
                }
                try {
                    fileLock.release();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.mIsSaving = false;
                return;
            }
        }
        if (this.mCurTryTime++ < 6) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SharedPreferencesNewImpl.this.saveInner(bl);
                }
            }, 2000L);
        }
        // MONITOREXIT : object
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(SharedPreferences.Editor editor, boolean bl, boolean bl2, boolean bl3) {
        if (editor == null) {
            return;
        }
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            this.mCurTryTime = 0;
            boolean bl4 = true;
            if (!this.merge(editor, this.mMap, false)) {
                bl4 = false;
                if (this.mEditorList.size() == 0) {
                    return;
                }
            }
            if (bl4) {
                this.mEditorList.add(editor);
            }
        }
        if (bl2) {
            this.saveInner(bl);
            return;
        }
        long l = bl3 ? 1000L : 0L;
        this.mSaveRunnable.setArg(bl);
        editor = Message.obtain((Handler)this.mHandler, (Runnable)this.mSaveRunnable);
        Message.obtain((Handler)this.mHandler, (Runnable)this.mSaveRunnable).what = 21310;
        this.mHandler.sendMessageDelayed((Message)editor, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Integer, byte[][]> getDataBytes() {
        ArrayList<Map.Entry<String, Object>> arrayList;
        byte[][] byArrayArray;
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            byArrayArray = new byte[this.mMap.size() * 5][];
            arrayList = new ArrayList<Map.Entry<String, Object>>(this.mMap.entrySet());
            this.mEditorList.clear();
        }
        int n = 0;
        int n2 = 0;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object object = arrayList.get(i);
            Object object2 = object.getKey();
            object = object.getValue();
            if (object2 == null || ((String)object2).trim().length() <= 0 || object == null) continue;
            byte[] byArray = ((String)object2).getBytes();
            object2 = byArray;
            byte[] byArray2 = ByteIntUtils.intToBytes(byArray.length);
            byArrayArray[n2] = byArray2;
            byArrayArray[n2 + 1] = (byte[])object2;
            n += byArray2.length + ((Object)object2).length;
            byte[] byArray3 = this.getBytes(object);
            object2 = byArray3;
            byArray2 = ByteIntUtils.intToBytes(byArray3.length);
            byArrayArray[n2 + 2] = byArray2;
            byArrayArray[n2 + 3] = (byte[])object2;
            n += byArray2.length + ((Object)object2).length;
            byte[] byArray4 = new byte[1];
            object2 = byArray4;
            byArray4[0] = (byte)this.getObjectType(object);
            byArrayArray[n2 + 4] = (byte[])object2;
            ++n;
            n2 += 5;
        }
        return new Pair((Object)n, (Object)byArrayArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToMappedBuffer(byte[] byArray, boolean bl) {
        Object object = this.mSyncObj;
        synchronized (object) {
            this.mMappedByteBuffer.position(0);
            SharedPreferencesNewImpl sharedPreferencesNewImpl = this;
            sharedPreferencesNewImpl.safeBufferPut(sharedPreferencesNewImpl.mMappedByteBuffer, byArray);
            if (bl) {
                this.mMappedByteBuffer.force();
            }
            return;
        }
    }

    private int increaseModifyID() {
        this.mModifyID = (this.mModifyID + 1) % Integer.MAX_VALUE;
        return this.mModifyID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getContentLength() {
        if (this.mMappedByteBuffer == null || this.mFileChannel == null) {
            return -1;
        }
        Object object = this.mSyncObj;
        synchronized (object) {
            this.mMappedByteBuffer.position(0);
            byte[] byArray = new byte[4];
            SharedPreferencesNewImpl sharedPreferencesNewImpl = this;
            sharedPreferencesNewImpl.safeBufferGet(sharedPreferencesNewImpl.mMappedByteBuffer, byArray);
            int n = ByteIntUtils.bytesToInt(byArray);
            this.mMappedByteBuffer.position(4);
            byte by = this.mMappedByteBuffer.get();
            if (by != 18 && by != this.getMaskByte(byArray) || n < 0) {
                if (this.mErrorListener != null) {
                    this.mErrorListener.onError(this.mFile != null ? this.mFile.getAbsolutePath() : null, 1, this.mFile != null ? this.mFile.length() : 0L);
                }
                return -1;
            }
            if (n > Integer.MAX_VALUE) {
                n = Integer.MAX_VALUE;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallocBuffer() {
        if (this.mMappedByteBuffer == null) {
            return;
        }
        Object object = this.mSyncObj;
        synchronized (object) {
            try {
                int n = this.getContentLength();
                int n2 = this.mMappedByteBuffer.capacity();
                if (n > n2) {
                    this.allocBuffer(n + 1024);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(boolean bl) {
        FileLock fileLock = bl ? null : this.lockFile(true);
        if (fileLock != null || bl) {
            long l;
            byte[] byArray;
            block35: {
                block34: {
                    boolean bl2;
                    byArray = null;
                    try {
                        this.reallocBuffer();
                        if (this.mMappedByteBuffer != null && this.mMappedByteBuffer.capacity() != 0) break block34;
                        bl2 = false;
                    }
                    catch (Throwable throwable) {
                        boolean bl3 = false;
                        try {
                            bl3 = this.parseBytesIntoMap(byArray, true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (!bl3 || byArray == null && this.mModifyID < 0) {
                            this.loadFromBakFile();
                        }
                        try {
                            if (fileLock != null) {
                                fileLock.release();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        bl2 = this.parseBytesIntoMap(null, true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (!bl2 || this.mModifyID < 0) {
                        this.loadFromBakFile();
                    }
                    try {
                        if (fileLock != null) {
                            fileLock.release();
                        }
                        return;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
                l = this.getContentLength();
                if (l > 10L) break block35;
                boolean bl4 = false;
                try {
                    bl4 = this.parseBytesIntoMap(null, true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!bl4 || this.mModifyID < 0) {
                    this.loadFromBakFile();
                }
                try {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            this.mModifyID = this.getModifyID();
            if (this.mModifyID > 0) {
                Object object = this.mSyncObj;
                synchronized (object) {
                    this.mMappedByteBuffer.position(10);
                    byArray = new byte[(int)l - 10];
                    SharedPreferencesNewImpl sharedPreferencesNewImpl = this;
                    sharedPreferencesNewImpl.safeBufferGet(sharedPreferencesNewImpl.mMappedByteBuffer, byArray);
                }
            }
            boolean bl5 = false;
            try {
                bl5 = this.parseBytesIntoMap(byArray, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!bl5 || byArray == null && this.mModifyID < 0) {
                this.loadFromBakFile();
            }
            try {
                if (fileLock != null) {
                    fileLock.release();
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if (!bl) {
            this.loadFromBakFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getModifyID() {
        if (this.mMappedByteBuffer == null) {
            return -1;
        }
        Object object = this.mSyncObj;
        synchronized (object) {
            this.mMappedByteBuffer.position(5);
            byte[] byArray = new byte[4];
            SharedPreferencesNewImpl sharedPreferencesNewImpl = this;
            sharedPreferencesNewImpl.safeBufferGet(sharedPreferencesNewImpl.mMappedByteBuffer, byArray);
            int n = ByteIntUtils.bytesToInt(byArray);
            this.mMappedByteBuffer.position(9);
            byte by = this.mMappedByteBuffer.get();
            if (by != 18 && by != this.getMaskByte(byArray) || n < 0) {
                ++this.mModifyErrorCnt;
                if (this.mModifyErrorCnt < 3 && this.mErrorListener != null) {
                    this.mErrorListener.onError(this.mFile != null ? this.mFile.getAbsolutePath() : null, 2, this.mFile != null ? this.mFile.length() : 0L);
                }
                return -1;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadFromDisk(boolean bl) {
        Object object = this;
        synchronized (object) {
            this.mLoaded = false;
        }
        object = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SharedPreferencesNewImpl sharedPreferencesNewImpl = SharedPreferencesNewImpl.this;
                synchronized (sharedPreferencesNewImpl) {
                    SharedPreferencesNewImpl.this.loadFromDiskLocked();
                    return;
                }
            }
        };
        if (bl) {
            object.run();
            return;
        }
        sCachedThreadPool.execute((Runnable)object);
    }

    private void loadFromDiskLocked() {
        if (this.mLoaded) {
            return;
        }
        this.load(false);
        this.mLoaded = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitLoadedLocked() {
        if (!this.mLoaded) {
            SharedPreferencesNewImpl sharedPreferencesNewImpl = this;
            synchronized (sharedPreferencesNewImpl) {
                while (!this.mLoaded) {
                    try {
                        this.wait();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        this.tryReload();
    }

    private boolean safeBufferGet(MappedByteBuffer mappedByteBuffer, byte[] byArray) {
        if (mappedByteBuffer == null || byArray == null || byArray.length == 0) {
            return false;
        }
        Arrays.fill(byArray, (byte)0);
        int n = mappedByteBuffer.position();
        int n2 = mappedByteBuffer.capacity();
        if (n + byArray.length > n2) {
            return false;
        }
        mappedByteBuffer.get(byArray);
        return true;
    }

    private MappedByteBuffer allocBuffer(int n) {
        int n2 = 0;
        if (this.mMappedByteBuffer != null) {
            n2 = this.mMappedByteBuffer.position();
        }
        try {
            this.mMappedByteBuffer = this.mFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.mMappedByteBuffer != null) {
            this.mMappedByteBuffer.position(n2);
        }
        return this.mMappedByteBuffer;
    }

    private boolean initBuffer() {
        boolean bl;
        block9: {
            bl = true;
            if (this.mMappedByteBuffer == null) {
                try {
                    if (!this.mFile.exists()) {
                        this.mFile.getParentFile().mkdirs();
                        this.mFile.createNewFile();
                        if (!new File(this.mBackupFilePath).exists()) {
                            bl = false;
                        }
                    } else if (this.mFile.length() == 0L) {
                        bl = false;
                        if (this.mErrorListener != null) {
                            this.mErrorListener.onError(this.mFile.getAbsolutePath(), 4, this.mFile.length());
                        }
                    }
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.mFile, "rw");
                    this.mFileChannel = randomAccessFile.getChannel();
                    this.allocBuffer(10);
                    if (!bl) {
                        this.initFileHeader();
                    }
                }
                catch (Exception exception) {
                    bl = false;
                    exception.printStackTrace();
                    if (this.mErrorListener == null) break block9;
                    this.mErrorListener.onError(this.mFile.getAbsolutePath() + " " + exception.getCause(), 10, -1L);
                }
            }
        }
        return bl;
    }

    private FileLock lockFile(boolean bl) {
        if (this.mFileChannel == null) {
            return null;
        }
        FileLock fileLock = null;
        if (bl) {
            long l = SystemClock.uptimeMillis();
            while (fileLock == null) {
                try {
                    fileLock = this.mFileChannel.tryLock();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (fileLock == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (SystemClock.uptimeMillis() - l <= 10000L) continue;
                break;
            }
        } else {
            try {
                fileLock = this.mFileChannel.tryLock();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return fileLock;
    }

    public final void setSharedPreferenceErrorListener(OnSharedPreferenceErrorListener onSharedPreferenceErrorListener) {
        this.mErrorListener = onSharedPreferenceErrorListener;
    }

    private void safeBufferPut(MappedByteBuffer mappedByteBuffer, byte[] byArray) {
        if (mappedByteBuffer == null || byArray == null || byArray.length == 0) {
            return;
        }
        int n = mappedByteBuffer.capacity();
        if (mappedByteBuffer.position() + byArray.length >= n) {
            mappedByteBuffer = this.allocBuffer(mappedByteBuffer.position() + byArray.length + 1024);
        }
        mappedByteBuffer.put(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeWhenReload() {
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            if (this.mEditorList.size() > 0) {
                for (SharedPreferences.Editor editor : this.mEditorList) {
                    this.merge(editor, this.mMap, true);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseBytesIntoMap(byte[] byArray, boolean bl) {
        boolean bl2 = true;
        LinkedHashMap<String, Object> linkedHashMap = this.mMap;
        synchronized (linkedHashMap) {
            LinkedHashMap<String, Object> linkedHashMap2 = null;
            if (bl) {
                linkedHashMap2 = new LinkedHashMap<String, Object>(this.mMap);
            }
            if (bl && this.mModifyID > 0) {
                this.mMap.clear();
            }
            if (byArray == null || byArray.length == 0) {
                return true;
            }
            int n = 0;
            while (n < byArray.length) {
                Object object;
                try {
                    object = this.getOneString(byArray, n);
                    n = (Integer)object.second;
                    Object object2 = this.getOneString(byArray, n);
                    n = (Integer)object2.second;
                    byte by = byArray[n];
                    byte by2 = byArray[++n];
                    ++n;
                    if (by2 != 18 && by2 != this.getMaskByte(new byte[]{by})) {
                        if (this.mErrorListener != null) {
                            this.mErrorListener.onError(this.mFile != null ? this.mFile.getAbsolutePath() : null, 8, byArray.length);
                        }
                        bl2 = false;
                        break;
                    }
                    if (!this.checkTypeValid(by)) {
                        if (this.mErrorListener != null) {
                            this.mErrorListener.onError(this.mFile != null ? this.mFile.getAbsolutePath() : null, 9, byArray.length);
                        }
                        bl2 = false;
                        continue;
                    }
                    object2 = this.getObjectByType((byte[])object2.first, by);
                    if (object.first == null || ((byte[])object.first).length <= 0 || object2 == null) continue;
                    object = new String((byte[])object.first);
                    if (!bl && this.mMap.containsKey(object)) continue;
                    this.mMap.put((String)object, object2);
                }
                catch (Exception pair) {
                    object = pair;
                    pair.printStackTrace();
                    if (this.mErrorListener != null) {
                        this.mErrorListener.onError((this.mFile != null ? this.mFile.getAbsolutePath() : null) + "#" + object.getCause(), 3, byArray.length);
                    }
                    bl2 = false;
                    break;
                }
            }
            if (!bl2 && bl) {
                this.mMap.putAll(linkedHashMap2);
            }
        }
        return bl2;
    }

    private Pair<byte[], Integer> getOneString(byte[] byArray, int n) {
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n, byArray2, 0, 4);
        if (byArray[n += 4] != 18 && byArray[n] != this.getMaskByte(byArray2)) {
            throw new Exception("length string's finish mark missing");
        }
        int n2 = ByteIntUtils.bytesToInt(byArray2);
        if (n2 < 0 || ++n + n2 >= byArray.length || n2 > Integer.MAX_VALUE) {
            throw new Exception("length string is invalid");
        }
        byte[] byArray3 = null;
        if (n2 != 0) {
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            if (byArray[n += n2] != 18 && byArray[n] != this.getMaskByte(byArray3)) {
                throw new Exception("Stored bytes' finish mark missing");
            }
        }
        byArray = byArray3;
        return new Pair((Object)byArray, (Object)(++n));
    }

    private byte[] obtainTotalBytes() {
        Object object = this.getDataBytes();
        int n = ((byte[][])object.second).length;
        n = (Integer)object.first + 10 + n * 1;
        if (n > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        byte[] byArray = new byte[n];
        byte[] byArray2 = ByteIntUtils.intToBytes(n);
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        n = 0 + byArray2.length;
        byArray[n] = this.getMaskByte(byArray2);
        byArray2 = ByteIntUtils.intToBytes(this.increaseModifyID());
        System.arraycopy(byArray2, 0, byArray, ++n, byArray2.length);
        byArray[n += byArray2.length] = this.getMaskByte(byArray2);
        ++n;
        byte[][] byArray3 = (byte[][])object.second;
        object = byArray3;
        int n2 = byArray3.length;
        for (int i = 0; i < n2; ++i) {
            Pair<Integer, byte[][]> pair = object[i];
            if (pair == null) continue;
            if (n + ((Pair<Integer, byte[][]>)pair).length + 1 <= Integer.MAX_VALUE) {
                System.arraycopy(pair, 0, byArray, n, ((Pair<Integer, byte[][]>)pair).length);
                byArray[n += ((Pair<Integer, byte[][]>)pair).length] = this.getMaskByte((byte[])pair);
                ++n;
                continue;
            }
            Log.e((String)TAG, (String)("Write too much data in " + (this.mFile != null ? this.mFile.getAbsolutePath() : null)));
            if (this.mErrorListener == null) break;
            this.mErrorListener.onError(this.mFile != null ? this.mFile.getAbsolutePath() : null, 7, -1L);
            break;
        }
        return byArray;
    }

    final boolean checkTypeValid(byte by) {
        return by == 4 || by == 2 || by == 1 || by == 3 || by == 5;
    }

    private void initFileHeader() {
        if (this.mMappedByteBuffer != null) {
            byte[] byArray = new byte[10];
            byte[] byArray2 = ByteIntUtils.intToBytes(0);
            System.arraycopy(byArray2, 0, byArray, 0, 4);
            byArray[4] = this.getMaskByte(byArray2);
            byArray2 = ByteIntUtils.intToBytes(0);
            System.arraycopy(byArray2, 0, byArray, 5, 4);
            byArray[9] = this.getMaskByte(byArray2);
            this.mMappedByteBuffer.position(0);
            this.mMappedByteBuffer.put(byArray);
        }
    }

    private int getObjectType(Object object) {
        if (object instanceof String) {
            return 5;
        }
        if (object instanceof Boolean) {
            return 4;
        }
        if (object instanceof Float) {
            return 2;
        }
        if (object instanceof Integer) {
            return 1;
        }
        if (object instanceof Long) {
            return 3;
        }
        return 0;
    }

    private Object getObjectByType(byte[] byArray, int n) {
        if (byArray != null && byArray.length > 0) {
            try {
                if (n == 5) {
                    return new String(byArray);
                }
                if (n == 4) {
                    return byArray[0] == 1;
                }
                if (n == 2) {
                    return Float.valueOf(ByteFloatUtils.bytesToFloat(byArray));
                }
                if (n == 1) {
                    return ByteIntUtils.bytesToInt(byArray);
                }
                if (n == 3) {
                    return ByteLongUtils.bytesToLong(byArray);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private byte[] getBytes(Object object) {
        if (object != null) {
            try {
                if (object instanceof String) {
                    return ((String)object).getBytes();
                }
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    return new byte[]{(byte)(bl ? 1 : 0)};
                }
                if (object instanceof Float) {
                    return ByteFloatUtils.floatToBytes(((Float)object).floatValue());
                }
                if (object instanceof Integer) {
                    return ByteIntUtils.intToBytes((Integer)object);
                }
                if (object instanceof Long) {
                    return ByteLongUtils.longToBytes((Long)object);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private void backup() {
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            File file = new File(this.mBackupFilePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            fileChannel = fileOutputStream.getChannel();
            this.mFileChannel.transferTo(0L, this.mMappedByteBuffer.capacity(), fileChannel);
            this.safeClose(fileOutputStream);
            this.safeClose(fileChannel);
            return;
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                return;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                this.safeClose(fileOutputStream);
                this.safeClose(fileChannel);
            }
        }
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     */
    private boolean loadFromBakFile() {
        boolean bl;
        block19: {
            int n;
            Throwable throwable;
            RandomAccessFile randomAccessFile;
            byte[] byArray;
            block18: {
                bl = true;
                byArray = null;
                randomAccessFile = null;
                throwable = null;
                randomAccessFile = new RandomAccessFile(this.mBackupFilePath, "r");
                byte[] byArray2 = new byte[4];
                randomAccessFile.read(byArray2, 0, 4);
                n = ByteIntUtils.bytesToInt(byArray2);
                if (n > 10) break block18;
                this.safeClose(randomAccessFile);
                try {
                    this.parseBytesIntoMap(null, false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return false;
            }
            if (n > Integer.MAX_VALUE) {
                n = Integer.MAX_VALUE;
            }
            if ((long)n > randomAccessFile.length()) {
                n = (int)randomAccessFile.length();
            }
            byArray = new byte[n - 10];
            randomAccessFile.seek(10L);
            randomAccessFile.read(byArray);
            this.safeClose(randomAccessFile);
            try {
                bl = this.parseBytesIntoMap(byArray, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.mErrorListener != null) {
                this.mErrorListener.onError(this.mBackupFilePath + "#" + "" + "#" + bl, 12, byArray.length);
            }
            break block19;
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throwable3.printStackTrace();
                    this.safeClose(randomAccessFile);
                }
                catch (Throwable throwable4) {
                    this.safeClose(randomAccessFile);
                    try {
                        bl = this.parseBytesIntoMap(byArray, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if ((byArray != null || throwable != null) && this.mErrorListener != null) {
                        this.mErrorListener.onError(this.mBackupFilePath + "#" + (throwable == null ? "" : throwable.getCause()) + "#" + bl, 12, byArray == null ? 0 : byArray.length);
                    }
                    throw throwable4;
                }
                try {
                    bl = this.parseBytesIntoMap(byArray, false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.mErrorListener != null) {
                    this.mErrorListener.onError(this.mBackupFilePath + "#" + throwable.getCause() + "#" + bl, 12, byArray == null ? 0 : byArray.length);
                }
            }
        }
        return bl;
    }

    private byte getBCCCode(byte[] byArray) {
        byte by = 0;
        for (byte by2 : byArray) {
            by = (byte)(by ^ by2);
        }
        return by;
    }

    private byte getMaskByte(byte[] byArray) {
        return this.getBCCCode(byArray);
    }

    final void onDestroy() {
        if (this.mIsSaving || this.mHandler.hasMessages(21310)) {
            this.saveInner(false);
        }
    }

    private HandlerThread getHandlerThread() {
        int n = new Random().nextInt();
        n = (n < 0 ? -n : n) % 3;
        return mHandlerThreadPool[n];
    }

    static {
        for (int i = 0; i < 3; ++i) {
            SharedPreferencesNewImpl.mHandlerThreadPool[i] = new HandlerThread("newsp".concat(String.valueOf(i)));
            mHandlerThreadPool[i].start();
        }
        sCachedThreadPool = Executors.newCachedThreadPool();
    }

    public static abstract class RunnableEx
    implements Runnable {
        private Object mArg;

        public void setArg(Object object) {
            this.mArg = object;
        }

        public Object getArg() {
            return this.mArg;
        }
    }

    final class FileMonitor
    extends FileObserver {
        public FileMonitor(String string, int n) {
            super(string, n);
        }

        public final void onEvent(int n, String string) {
            if (SharedPreferencesNewImpl.this.mListeners.size() > 0) {
                SharedPreferencesNewImpl.this.tryReload();
                return;
            }
            this.stopWatching();
        }
    }

    static class ByteFloatUtils {
        private ByteFloatUtils() {
        }

        public static byte[] floatToBytes(float f2) {
            return ByteBuffer.allocate(4).putFloat(f2).array();
        }

        public static float bytesToFloat(byte[] byArray) {
            return ByteBuffer.wrap(byArray).getFloat();
        }
    }

    static class ByteIntUtils {
        private ByteIntUtils() {
        }

        public static byte[] intToBytes(int n) {
            return ByteBuffer.allocate(4).putInt(n).array();
        }

        public static int bytesToInt(byte[] byArray) {
            return ByteBuffer.wrap(byArray).getInt();
        }
    }

    static class ByteLongUtils {
        private ByteLongUtils() {
        }

        public static byte[] longToBytes(long l) {
            return ByteBuffer.allocate(8).putLong(l).array();
        }

        public static long bytesToLong(byte[] byArray) {
            return ByteBuffer.wrap(byArray).getLong();
        }
    }

    public static interface OnSharedPreferenceErrorListener {
        public void onError(String var1, int var2, long var3);
    }

    public final class EditorImpl
    implements SharedPreferences.Editor {
        private HashMap<String, Object> mModified = new HashMap();
        private boolean mClear;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedPreferences.Editor putString(String string, String string2) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(string, string2);
                return this;
            }
        }

        public final SharedPreferences.Editor putStringSet(String string, Set<String> set) {
            throw new RuntimeException("putStringSet is not supported!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedPreferences.Editor putInt(String string, int n) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(string, n);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedPreferences.Editor putLong(String string, long l) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(string, l);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedPreferences.Editor putFloat(String string, float f2) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(string, Float.valueOf(f2));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedPreferences.Editor putBoolean(String string, boolean bl) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(string, bl);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedPreferences.Editor remove(String string) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(string, null);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedPreferences.Editor clear() {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mClear = true;
                return this;
            }
        }

        public final boolean commit() {
            SharedPreferencesNewImpl.this.save(this, false, true, false);
            return true;
        }

        public final void apply() {
            SharedPreferencesNewImpl.this.save(this, false, false, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean doClear() {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                boolean bl = this.mClear;
                this.mClear = false;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final HashMap<String, Object> getAll() {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                return this.mModified;
            }
        }
    }

    class SUPPORTED_TYPE {
        static final byte TYPE_INT = 1;
        static final byte TYPE_FLOAT = 2;
        static final byte TYPE_LONG = 3;
        static final byte TYPE_BOOLEAN = 4;
        static final byte TYPE_STRING = 5;

        private SUPPORTED_TYPE() {
        }
    }
}

